/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.base.manager.BizAccessoryManager;
import com.artfess.gyl.base.model.BizAccessory;
import com.artfess.gyl.base.vo.Chunk;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/BizAccessory/v1/"})
@Api(tags={"\u5408\u540c\u9644\u4ef6\u7ba1\u7406\u63a5\u53e3"})
@ApiGroup(group={"group_biz_gyl"})
public class BizAccessoryController
extends BaseController<BizAccessoryManager, BizAccessory> {
    private static final Logger log = LoggerFactory.getLogger(BizAccessoryController.class);

    @PostMapping(value={"/getBySourceId/{sourceId}"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90Id\u4e0d\u5206\u9875\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<List<BizAccessory>> getBySourceId(@ApiParam(name="sourceId", value="\u8d44\u6e90Id") @PathVariable String sourceId) {
        List<BizAccessory> result = ((BizAccessoryManager)this.baseService).getAccessoryBySourceId(sourceId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u6279\u91cf\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> saveBizAccessory(@ApiParam(name="BizAccessory", value="\u9644\u4ef6\u5bf9\u8c61") @RequestBody List<BizAccessory> list) {
        boolean status = ((BizAccessoryManager)this.baseService).saveAccessory(list);
        String msg = status ? "\u4fdd\u5b58\u6210\u529f" : "\u4fdd\u5b58\u5931\u8d25";
        return new CommonResult(status, msg);
    }

    @PostMapping(value={"/minIoAllDownFile"})
    @ApiOperation(value="S-\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3")
    public void downTest(@ApiParam(name="ids", value="ids", required=true) @RequestParam(value="ids", required=true) String ids, @ApiParam(name="bizPath", value="bizPath", required=true) @RequestParam(value="bizPath", required=true) String bizPath, HttpServletResponse response) throws Exception {
        ((BizAccessoryManager)this.baseService).minIoDownFile(ids, bizPath, response);
    }

    @PostMapping(value={"/downFile/source"})
    @ApiOperation(value="S-\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u6839\u636e\u8d44\u6e90id\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3")
    public void downFileBySourceIds(@ApiParam(name="ids", value="ids", required=true) @RequestParam(value="ids", required=true) String ids, @ApiParam(name="bizPath", value="bizPath", required=true) @RequestParam(value="bizPath", required=true) String bizPath, HttpServletResponse response) throws Exception {
        ((BizAccessoryManager)this.baseService).minIoDownFileBySourceId(ids, bizPath, response);
    }

    @GetMapping(value={"/minIoDown"})
    @ApiOperation(value="S-\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3")
    public void minIoDown(@ApiParam(name="name", value="name", required=true) @RequestParam(value="name", required=true) String name, @ApiParam(name="bizPath", value="bizPath", required=true) @RequestParam(value="bizPath", required=true) String bizPath, HttpServletResponse response) throws Exception {
        ((BizAccessoryManager)this.baseService).minIoDown(name, bizPath, response);
    }

    @GetMapping(value={"/minIoDownPub"})
    @ApiOperation(value="M-\u516c\u5f00\u6587\u4ef6\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3")
    public void minIoDownPub(@ApiParam(name="name", value="name", required=true) @RequestParam(value="name", required=true) String name, @ApiParam(name="bizPath", value="bizPath", required=true) @RequestParam(value="bizPath", required=true) String bizPath, HttpServletResponse response) throws Exception {
        ((BizAccessoryManager)this.baseService).minIoDown(name, bizPath, "cgptpub", response);
    }

    @PostMapping(value={"/ShardUpload"})
    @ApiOperation(value="S-\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u63a5\u53e3\uff08\u4e0a\u4f20\u5b8c\u6bd5\u9700\u8c03\u7528\u5408\u5e76\u63a5\u53e3\uff09")
    public CommonResult<String> shardUpload(@RequestBody MultipartFile upFile, @ApiParam(name="chunk", value="\u5206\u7247\u6587\u4ef6\u5bf9\u8c61", required=true) Chunk chunk, HttpServletResponse response) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)chunk, (Object)response);
        chunk.setFile(upFile);
        String result = ((BizAccessoryManager)this.baseService).fileUploadPost(chunk, response);
        boolean status = result.equals("over") || result.equals("ok");
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(status, status ? "\u4e0a\u4f20\u6210\u529f" : "\u4e0a\u4f20\u5931\u8d25", (Object)result);
    }

    @PostMapping(value={"/mergeFileToMinIO"})
    @ApiOperation(value="S-\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u5408\u5e76\u63a5\u53e3", httpMethod="POST", notes="\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO")
    public CommonResult<BizAccessory> mergeFileToMinIO(@ApiParam(name="bizPath", value="MinIO\u4e2d\u7684\u4e1a\u52a1\u6587\u4ef6\u5939", required=true) @RequestParam String bizPath, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d", required=true) @RequestParam String fileName, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d", required=false) @RequestParam String bucketName) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)bizPath, (Object)fileName);
        BizAccessory BizAccessory2 = ((BizAccessoryManager)this.baseService).minioUpload(bizPath, fileName, bucketName);
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)BizAccessory2);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)BizAccessory2);
    }

    @RequestMapping(value={"/minioUpload"})
    @ApiOperation(value="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<BizAccessory> minioUpload(MultipartFile file, String bizPath, HttpServletResponse response) throws Exception {
        BizAccessory BizAccessory2 = ((BizAccessoryManager)this.baseService).minioUpload(file, bizPath, response);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)BizAccessory2);
    }

    @RequestMapping(value={"/minioUploadBuc"})
    @ApiOperation(value="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\uff08\u4f20\u5165\u6876\u540d\uff09", httpMethod="POST", notes="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<BizAccessory> minioUploadBuc(MultipartFile file, String bizPath, String bucketName, HttpServletResponse response) throws Exception {
        BizAccessory BizAccessory2 = ((BizAccessoryManager)this.baseService).minioUpload(file, bizPath, bucketName, response);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)BizAccessory2);
    }

    @RequestMapping(value={"/minioBatchUpload"})
    @ApiOperation(value="\u666e\u901a\u9644\u4ef6\u6279\u91cf\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<List<BizAccessory>> minioBatchUpload(List<MultipartFile> fileList, String bizPath, HttpServletResponse response) throws Exception {
        List<BizAccessory> BizAccessoryList = ((BizAccessoryManager)this.baseService).minioBatchUpload(fileList, bizPath, response);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", BizAccessoryList);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) throws Exception {
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((BizAccessoryManager)this.baseService).removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/removeBySourceId/{sourceId}"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90ID\u5220\u9664\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> removeBySourceId(@ApiParam(name="sourceId", value="\u8d44\u6e90ID") @PathVariable String sourceId) throws Exception {
        boolean status = ((BizAccessoryManager)this.baseService).removeBySourceId(sourceId);
        String msg = status ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        return new CommonResult(true, msg);
    }

    @PostMapping(value={"/getPageBySourceId"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90ID\u5206\u9875\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", notes="\u5fc5\u987b\u4f20\u5165SOURCE_ID_", httpMethod="POST")
    public CommonResult<PageList<BizAccessory>> getPageBySourceId(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizAccessory> queryFilter) {
        PageList<BizAccessory> result = ((BizAccessoryManager)this.baseService).getAccessoryPageBySourceId(queryFilter);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }
}

