/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationNotificationDao;
import com.artfess.gyl.supplierEva.dto.ProcessDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationAcknowledgementManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationCorrectionReportManager;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationAcknowledgement;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierPerformanceEvaluationNotificationManagerImpl
extends BaseManagerImpl<BizSupplierPerformanceEvaluationNotificationDao, BizSupplierPerformanceEvaluationNotification>
implements BizSupplierPerformanceEvaluationNotificationManager {
    @Resource
    private BizSupplierPerformanceEvaluationAcknowledgementManager acknowledgementManager;
    @Resource
    private BizSupplierPerformanceEvaluationCorrectionReportManager reportManager;
    @Resource
    private FileManager fileManager;

    @Override
    public void saveEva(ResultEvaDTO dto) {
        String processType = dto.getProcessType();
        if (!processType.equals("0")) {
            BizSupplierPerformanceEvaluationNotification notification = new BizSupplierPerformanceEvaluationNotification();
            notification.setPerformanceEvaluationId(dto.getPerformanceEvaluationId());
            notification.setProcessType(processType);
            notification.setNotificationTitle(dto.getNotificationTitle());
            notification.setNotificationContent(dto.getNotificationContent());
            notification.setNotifyDate(dto.getNotifyDate());
            notification.setReplyDeadline(dto.getReplyDeadline());
            notification.setFinishDeadline(dto.getFinishDeadline());
            notification.setEnterpriseAddress(dto.getEnterpriseAddress());
            notification.setEnterpriseContact(dto.getEnterpriseContact());
            notification.setEnterpriseTel(dto.getEnterpriseTel());
            notification.setNotificationStatus("1");
            super.save((Object)notification);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean confirmNotification(ProcessDTO dto) {
        this.validateParams(dto);
        IUser user = this.getUser();
        BizSupplierPerformanceEvaluationNotification existingNotification = this.getAndValidateNotification(dto.getNotificationId());
        this.updateNotificationStatus(dto.getNotificationId());
        this.createAcknowledgementRecord(dto.getNotificationId(), user);
        this.processCorrectionReport(dto, existingNotification);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateReportStatus(ProcessDTO dto) {
        BizSupplierPerformanceEvaluationCorrectionReport report = (BizSupplierPerformanceEvaluationCorrectionReport)((Object)this.reportManager.getById((Serializable)((Object)dto.getReportId())));
        if (report == null) {
            throw new ApplicationException("\u6574\u6539\u62a5\u544a\u4e0d\u5b58\u5728");
        }
        try {
            report.setCorrectionStatus(dto.getStatus());
            if ("2".equals(dto.getStatus())) {
                report.setResultDescription(dto.getResultDescription());
                report.setActualCompleteDate(dto.getActualCompleteDate());
                List fileIds = dto.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                this.fileManager.updateFileBizIdByIds(fileIds, dto.getReportId());
            } else if ("3".equals(dto.getStatus()) || "5".equals(dto.getStatus())) {
                this.updateNotificationStatus(report.getNotificationId(), "4");
            }
            this.updateReportAndSaveResult(report, dto.getApprovalOpinion());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void updateNotificationStatus(String notificationId, String status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(BizSupplierPerformanceEvaluationNotification::getId, (Object)notificationId)).set(BizSupplierPerformanceEvaluationNotification::getNotificationStatus, (Object)status);
        super.update((Wrapper)wrapper);
    }

    private void updateReportAndSaveResult(BizSupplierPerformanceEvaluationCorrectionReport report, String approvalOpinion) {
        this.reportManager.updateById((Object)report);
        this.reportManager.saveReportResult(report, approvalOpinion);
    }

    @Override
    public BizSupplierPerformanceEvaluationCorrectionReport getReport(String notificationId) {
        LambdaQueryWrapper reportWrapper = new LambdaQueryWrapper();
        reportWrapper.eq(BizSupplierPerformanceEvaluationCorrectionReport::getNotificationId, (Object)notificationId);
        return (BizSupplierPerformanceEvaluationCorrectionReport)((Object)this.reportManager.getOne((Wrapper)reportWrapper));
    }

    private void validateParams(ProcessDTO dto) {
        if (dto == null || StringUtils.isBlank((String)dto.getNotificationId())) {
            throw new ApplicationException("\u901a\u77e5ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private IUser getUser() {
        return ContextUtil.getCurrentUser();
    }

    private BizSupplierPerformanceEvaluationNotification getAndValidateNotification(String notificationId) {
        BizSupplierPerformanceEvaluationNotification existingNotification = (BizSupplierPerformanceEvaluationNotification)((Object)super.getById((Serializable)((Object)notificationId)));
        if (existingNotification == null) {
            throw new ApplicationException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8003\u6838\u901a\u77e5");
        }
        if ("2".equals(existingNotification.getNotificationStatus())) {
            throw new ApplicationException("\u8be5\u901a\u77e5\u5df2\u88ab\u786e\u8ba4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        return existingNotification;
    }

    private void updateNotificationStatus(String notificationId) {
        LambdaUpdateWrapper notificationWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)notificationWrapper.eq(BizSupplierPerformanceEvaluationNotification::getId, (Object)notificationId)).set(BizSupplierPerformanceEvaluationNotification::getNotificationStatus, (Object)"2");
        boolean update = super.update((Wrapper)notificationWrapper);
        if (!update) {
            throw new ApplicationException("\u66f4\u65b0\u901a\u77e5\u72b6\u6001\u5931\u8d25");
        }
    }

    private void createAcknowledgementRecord(String notificationId, IUser user) {
        BizSupplierPerformanceEvaluationAcknowledgement acknowledgement = new BizSupplierPerformanceEvaluationAcknowledgement();
        acknowledgement.setNotificationId(notificationId);
        acknowledgement.setAckStatus("1");
        acknowledgement.setAckTime(LocalDateTime.now());
        acknowledgement.setAcknowledgedById(user.getUserId());
        acknowledgement.setAcknowledgedByAccount(user.getAccount());
        acknowledgement.setAcknowledgedByName(user.getFullname());
        acknowledgement.setAckMethod("1");
        this.acknowledgementManager.save((Object)acknowledgement);
    }

    private void processCorrectionReport(ProcessDTO dto, BizSupplierPerformanceEvaluationNotification existingNotification) {
        if (!"2".equals(existingNotification.getProcessType())) {
            return;
        }
        BizSupplierPerformanceEvaluationCorrectionReport report = new BizSupplierPerformanceEvaluationCorrectionReport();
        report.setPerformanceEvaluationId(dto.getNotificationId());
        report.setNotificationId(dto.getNotificationId());
        report.setRootCauseAnalysis(dto.getRootCauseAnalysis());
        report.setTemporaryMeasure(dto.getTemporaryMeasure());
        report.setLongTermCorrection(dto.getLongTermCorrection());
        report.setPlanCompleteDate(dto.getPlanCompleteDate());
        report.setCorrectionStatus("1");
        this.reportManager.save((Object)report);
    }
}

