/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.gyl.supplierAccess.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.supplierAccess.dao.BizSupplierReviewConfigurationDao;
import com.artfess.gyl.supplierAccess.dto.BizSupplierReviewConfigurationDto;
import com.artfess.gyl.supplierAccess.manager.BizSupplierReviewConfigurationDetailsManager;
import com.artfess.gyl.supplierAccess.manager.BizSupplierReviewConfigurationManager;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfiguration;
import com.artfess.gyl.supplierAccess.model.BizSupplierReviewConfigurationDetails;
import com.artfess.gyl.supplierAccess.vo.BizSupplierReviewConfigurationVo;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierReviewConfigurationManagerImpl
extends BaseManagerImpl<BizSupplierReviewConfigurationDao, BizSupplierReviewConfiguration>
implements BizSupplierReviewConfigurationManager {
    @Resource
    private BizSupplierReviewConfigurationDetailsManager supplierReviewConfigurationDetailsManager;
    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean saveModel(BizSupplierReviewConfigurationDto dto) {
        Boolean result = false;
        BizSupplierReviewConfiguration supplierReviewConfiguration = BizSupplierReviewConfigurationDto.parse(dto);
        this.validateModel(supplierReviewConfiguration);
        String currentOrgId = ContextUtil.getCurrentOrgId();
        String currentOrgCode = ContextUtil.getCurrentOrgCode();
        dto.setEnterpriseId(currentOrgId);
        dto.setEnterpriseCode(currentOrgCode);
        String code = this.sysIdentityManager.nextId("gyszrpspfpzbm");
        dto.setCode(code);
        supplierReviewConfiguration.setIsDele("0");
        result = this.save((Object)supplierReviewConfiguration);
        if (!result.booleanValue()) {
            return false;
        }
        String id = supplierReviewConfiguration.getId();
        dto.setId(id);
        this.saveDetails(dto);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchDelete(String[] ids) {
        this.batchDeleteDetail(ids);
        return this.removeByIds(Arrays.asList(ids));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateModel(BizSupplierReviewConfigurationDto dto) {
        Boolean result = false;
        BizSupplierReviewConfiguration supplierReviewConfiguration = BizSupplierReviewConfigurationDto.parse(dto);
        this.validateModel(supplierReviewConfiguration);
        result = this.updateById((Object)supplierReviewConfiguration);
        if (!result.booleanValue()) {
            return false;
        }
        String id = dto.getId();
        this.batchDeleteDetail(new String[]{id});
        this.saveDetails(dto);
        return true;
    }

    @Override
    public BizSupplierReviewConfigurationVo getInfo(String id) {
        BizSupplierReviewConfiguration supplierReviewConfiguration = (BizSupplierReviewConfiguration)this.get((Serializable)((Object)id));
        BizSupplierReviewConfigurationVo vo = new BizSupplierReviewConfigurationVo();
        vo.copy(supplierReviewConfiguration);
        List detailsList = this.supplierReviewConfigurationDetailsManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizSupplierReviewConfigurationDetails::getReviewConfigurationId, (Object)id)).eq(BizSupplierReviewConfigurationDetails::getIsDele, (Object)"0"));
        Map<String, List<BizSupplierReviewConfigurationDetails>> detailsMap = detailsList.stream().collect(Collectors.groupingBy(BizSupplierReviewConfigurationDetails::getClassificationName));
        vo.setDetailsMap(detailsMap);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDeleteDetail(String[] ids) {
        this.supplierReviewConfigurationDetailsManager.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BizSupplierReviewConfigurationDetails::getReviewConfigurationId, (Object[])ids)).eq(BizSupplierReviewConfigurationDetails::getIsDele, (Object)"0"));
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveDetails(BizSupplierReviewConfigurationDto dto) {
        String reviewConfigurationId = dto.getId();
        Map<String, List<BizSupplierReviewConfigurationDetails>> detailsMap = dto.getDetailsMap();
        ArrayList detailsList = new ArrayList();
        Set<String> keySet = detailsMap.keySet();
        for (String key : keySet) {
            detailsList.addAll(BeanUtils.isEmpty(detailsMap.get(key)) ? new ArrayList() : (Collection)detailsMap.get(key));
        }
        detailsList.forEach(d -> {
            d.setIsDele("0");
            String code = this.sysIdentityManager.nextId("gyszrpspfpzzblbbm");
            d.setCode(code);
            d.setReviewConfigurationId(reviewConfigurationId);
        });
        this.supplierReviewConfigurationDetailsManager.saveBatch(detailsList);
    }

    private void validateModel(BizSupplierReviewConfiguration supplierReviewConfiguration) {
        if (BeanUtils.isEmpty((Object)((Object)supplierReviewConfiguration))) {
            throw new ApplicationException("\u4fdd\u5b58\u7684\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
    }
}

