package com.artfess.base.jackson;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

import org.apache.commons.io.IOUtils;

import com.alibaba.druid.proxy.jdbc.NClobProxyImpl;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * NClobProxyImpl序列化处理器
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年12月2日
 */
public class NClobProxyImplSerializer extends JsonSerializer<NClobProxyImpl>{

	@Override
	public void serialize(NClobProxyImpl value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
		try(InputStream asciiStream = value.getAsciiStream()){
			StringWriter writer = new StringWriter();
			IOUtils.copy(asciiStream, writer, StandardCharsets.UTF_8.name());
			String str = writer.toString();
			gen.writeString(str);
		}
		catch(Exception e) {
			throw new IOException(e);
		}
	}
}
