package com.artfess.base.constants;

import java.util.Arrays;
import java.util.List;

/**
 * 租户常量
 *
 * @author jason
 * @data 2020-04-19
 */
public interface TenantConstant {

    /**
     * 平台的租户id
     */
    String PLATFORM_TENANT_ID = "-1";

    /**
     * 租户用户系统忽略的菜单
     */
    List<String> IGNORE_MENU = Arrays.asList("sysPropertiesManager", "schedulerManager", "tenant", "tenantTypeManager",
            "tenantManager", "tenantType", "tenantParamsManager", "i18n", "i18nMessageTypeManager", "i18nMessageManager", "pwdStrategy");

    /**
     * 创建租户用户时哪些PORTAL模块的表的数据需要创建一份给租户
     */
    List<String> INIT_PORTAL_DATA_TABLE_NAMES = Arrays.asList("portal_sys_type", "portal_sys_logs_settings", "portal_sys_layout_manage", "portal_news_tree_", "portal_sys_column");

    /**
     * 创建租户用户时哪些UC模块的表的数据需要创建一份给租户
     */
    List<String> INIT_UC_DATA_TABLE_NAMES = Arrays.asList("uc_demension");

    /**
     * 多租户模式下不按照租户隔离的物理表清单
     */
    final List<String> IGNORE_TABLES = Arrays.asList("ACT_HI_PROCINST", "ACT_HI_ACTINST", "ACT_HI_TASKINST",
            "ACT_HI_VARINST", "ACT_HI_DETAIL", "ACT_HI_COMMENT", "ACT_HI_ATTACHMENT", "ACT_HI_IDENTITYLINK",
            "ACT_GE_PROPERTY", "ACT_GE_BYTEARRAY", "ACT_RE_DEPLOYMENT", "ACT_RE_MODEL", "ACT_RU_EXECUTION",
            "ACT_RU_JOB", "ACT_RE_PROCDEF", "ACT_RU_TASK", "ACT_RU_IDENTITYLINK", "ACT_RU_VARIABLE",
            "ACT_RU_EVENT_SUBSCR", "ACT_EVT_LOG", "ACT_PROCDEF_INFO", "qrtz_JOB_DETAILS", "portal_sys_joblog",
            "uc_tenant_manage", "uc_tenant_type", "uc_tenant_type", "uc_tenant_auth", "uc_tenant_manage", "uc_tenant_params",
            "uc_security_personloginlimit",
            "uc_tenant_mail_server", "uc_tenant_logs", "portal_sys_datasource_def", "portal_i18n_message_type", "uc_tenant_ignore_menu",
            "portal_sys_type_group", "form_bo_ent_relation", "form_bo_attr", "form_template",
            "bpm_exe_stack_relation_his", "bpm_exe_stack_his", "uc_pwd_strategy", "bpm_exe_stack_relation", "bpm_exe_stack", "bpm_pro_inst_status",
            "bpm_exe_stack_executor", "form_import_check_jar", "portal_sys_properties", "portal_sys_msg_tpl", "bpm_multi_script", "bpm_script", "bpm_test_case_logs",
            "portal_sys_actuator", "portal_sys_areas", "portal_sys_dictionary", "portal_sys_dictionary_cascade", "portal_sys_dictionary_detail",
            "portal_sys_common_basic", "protal_system_authorization", "portal_sys_data_access_defined", "portal_sys_data_access_control", "uc_backup_log",
            "portal_excel_temp_fields", "pg_class", "pg_attribute",
            "biz_tunnel_often_check_detail", "biz_bridge_often_check_detail", "biz_contract_item", "biz_contract_payment", "biz_side_slope_often_check_detail",
            "biz_culvert_often_check_detail", "biz_bill_of_quantities", "biz_bridge_regular_check_detail", "biz_culvert_regular_check_detail", "biz_side_regular_check_detail",
            "biz_tunnel_regular_check_detail", "biz_project_contract_payment", "biz_bill_of_quantities","columns","biz_maintenance_station_statistic","biz_main_station_per_statistic"

    );


}
