/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.dao.BizSupplierEnterpriseDao;
import com.artfess.cgpt.supplier.manager.AdmittedSuppliersQualificationManager;
import com.artfess.cgpt.supplier.manager.BizSupplierEnterpriseManager;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgQualificationLabelManager;
import com.artfess.cgpt.supplier.manager.impl.SupplierEnterpriseAuditingManagerImpl;
import com.artfess.cgpt.supplier.model.AdmittedSuppliersQualification;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.supplier.model.SupplierEnterpriseAuditing;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierEnterpriseManagerImpl
extends BaseManagerImpl<BizSupplierEnterpriseDao, BizSupplierEnterprise>
implements BizSupplierEnterpriseManager {
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private AdmittedSuppliersQualificationManager suppliersQualificationManager;
    @Autowired
    private SupplierEnterpriseAuditingManagerImpl supplierEnterpriseAuditingManager;
    @Autowired
    private BizSupplierOrgQualificationLabelManager supplierOrgQualificationLabelManager;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private BizMaterialCategoryManager matCategoryManager;

    public BizSupplierEnterprise getById(Serializable id) {
        return ((BizSupplierEnterpriseDao)this.baseMapper).getById(id);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizSupplierEnterprise entity) {
        List<AdmittedSuppliersQualification> suppliersQualificationList = entity.getSuppliersQualificationList();
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            String supplierTypeId = entity.getSupplierTypeId();
            List<Org> supplierList = entity.getSupplierList();
            if (BeanUtils.isEmpty(supplierList) || supplierList.size() <= 0) {
                throw new BaseException("\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\uff01");
            }
            for (Org supplier : supplierList) {
                if (BeanUtils.isNotEmpty((Object)supplierTypeId)) {
                    List<String> cateIdList = Arrays.asList(supplierTypeId.split(","));
                    for (String string : cateIdList) {
                        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BizSupplierEnterprise::getEnterpriseId, (Object)entity.getEnterpriseId())).eq(BizSupplierEnterprise::getSupplierId, (Object)supplier.getId())).like(BizSupplierEnterprise::getSupplierTypeId, (Object)string)).eq(BizModel::getIsDele, (Object)0);
                        Integer count = ((BizSupplierEnterpriseDao)this.baseMapper).selectCount((Wrapper)hisQW);
                        if (count <= 0) continue;
                        BizMaterialCategory cate = (BizMaterialCategory)((Object)this.matCategoryManager.getById((Serializable)((Object)string)));
                        throw new BaseException("\u4f9b\u5e94\u5546\u3010" + supplier.getName() + "\u3011\u7684\u4e1a\u52a1\u3010" + cate.getName() + "\u3011\u5df2\u5b58\u5728");
                    }
                }
                BizSupplierEnterprise data = new BizSupplierEnterprise();
                try {
                    BeanUtils.copyNotNullProperties((Object)((Object)data), (Object)((Object)entity));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                data.setSupplierId(supplier.getId());
                data.setSupplierCode(supplier.getCode());
                data.setSupplierName(supplier.getName());
                super.save((Object)data);
                if (BeanUtils.isNotEmpty(suppliersQualificationList) && suppliersQualificationList.size() > 0) {
                    ArrayList<AdmittedSuppliersQualification> supQualificationDataList = new ArrayList<AdmittedSuppliersQualification>();
                    for (AdmittedSuppliersQualification temp : suppliersQualificationList) {
                        AdmittedSuppliersQualification supQualification = new AdmittedSuppliersQualification();
                        try {
                            BeanUtils.copyNotNullProperties((Object)((Object)supQualification), (Object)((Object)temp));
                        }
                        catch (ReflectiveOperationException e) {
                            e.printStackTrace();
                        }
                        supQualification.setAdmittedSupplierId(data.getId());
                        supQualificationDataList.add(supQualification);
                    }
                    this.suppliersQualificationManager.saveBatch(supQualificationDataList);
                }
                if (!BeanUtils.isNotEmpty(qualificationLabelList) || qualificationLabelList.size() <= 0) continue;
                ArrayList<BizSupplierOrgQualificationLabel> supplierOrgQualificationLabelList = new ArrayList<BizSupplierOrgQualificationLabel>();
                for (BizQualificationLabel label : qualificationLabelList) {
                    if (BeanUtils.isEmpty((Object)label.getId())) {
                        this.qualificationLabelManager.saveOrUpdateEntity(label);
                    }
                    BizSupplierOrgQualificationLabel temp = new BizSupplierOrgQualificationLabel();
                    temp.setAdmittedSupplierId(data.getId());
                    temp.setQualificationLabelId(label.getId());
                    supplierOrgQualificationLabelList.add(temp);
                }
                this.supplierOrgQualificationLabelManager.saveBatch(supplierOrgQualificationLabelList);
            }
        } else {
            super.updateById((Object)entity);
            LambdaQueryWrapper supQualificationQW = new LambdaQueryWrapper();
            supQualificationQW.eq(AdmittedSuppliersQualification::getAdmittedSupplierId, (Object)entity.getId());
            this.suppliersQualificationManager.remove((Wrapper)supQualificationQW);
            LambdaQueryWrapper qualificationLabelQW = new LambdaQueryWrapper();
            qualificationLabelQW.eq(BizSupplierOrgQualificationLabel::getAdmittedSupplierId, (Object)entity.getId());
            this.supplierOrgQualificationLabelManager.remove((Wrapper)qualificationLabelQW);
            if (BeanUtils.isNotEmpty(suppliersQualificationList) && suppliersQualificationList.size() > 0) {
                ArrayList<AdmittedSuppliersQualification> supQualificationDataList = new ArrayList<AdmittedSuppliersQualification>();
                for (AdmittedSuppliersQualification temp : suppliersQualificationList) {
                    AdmittedSuppliersQualification supQualification = new AdmittedSuppliersQualification();
                    try {
                        BeanUtils.copyNotNullProperties((Object)((Object)supQualification), (Object)((Object)temp));
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                    }
                    supQualification.setAdmittedSupplierId(entity.getId());
                    supQualificationDataList.add(supQualification);
                }
                this.suppliersQualificationManager.saveBatch(supQualificationDataList);
                if (BeanUtils.isNotEmpty(qualificationLabelList) && qualificationLabelList.size() > 0) {
                    ArrayList<BizSupplierOrgQualificationLabel> supplierOrgQualificationLabelList = new ArrayList<BizSupplierOrgQualificationLabel>();
                    for (BizQualificationLabel label : qualificationLabelList) {
                        if (BeanUtils.isEmpty((Object)label.getId())) {
                            this.qualificationLabelManager.saveOrUpdateEntity(label);
                        }
                        BizSupplierOrgQualificationLabel bizSupplierOrgQualificationLabel = new BizSupplierOrgQualificationLabel();
                        bizSupplierOrgQualificationLabel.setAdmittedSupplierId(entity.getId());
                        bizSupplierOrgQualificationLabel.setQualificationLabelId(label.getId());
                        supplierOrgQualificationLabelList.add(bizSupplierOrgQualificationLabel);
                    }
                    this.supplierOrgQualificationLabelManager.saveBatch(supplierOrgQualificationLabelList);
                }
            }
        }
    }

    @Override
    @Transactional
    public void saveOrUpdateTempSupplier(BizSupplierEnterprise entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        String supplierTypeId = entity.getSupplierTypeId();
        if (BeanUtils.isNotEmpty((Object)supplierTypeId)) {
            List<String> cateIdList = Arrays.asList(supplierTypeId.split(","));
            for (String cateId : cateIdList) {
                LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BizSupplierEnterprise::getEnterpriseId, (Object)entity.getEnterpriseId())).eq(BizSupplierEnterprise::getSupplierId, (Object)entity.getSupplierId())).eq(BizModel::getIsDele, (Object)0)).like(BizSupplierEnterprise::getSupplierTypeId, (Object)cateId)).ne(BeanUtils.isNotEmpty((Object)entity.getId()), BizSupplierEnterprise::getId, (Object)entity.getId());
                Integer count = ((BizSupplierEnterpriseDao)this.baseMapper).selectCount((Wrapper)hisQW);
                if (count <= 0) continue;
                BizMaterialCategory cate = (BizMaterialCategory)((Object)this.matCategoryManager.getById((Serializable)((Object)cateId)));
                throw new BaseException("\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011\u7684\u4e1a\u52a1\u3010" + cate.getName() + "\u3011\u5df2\u5b58\u5728");
            }
        }
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            this.accessoryService.removeBySourceId(entity.getId());
        }
        entity.setReviewStatus(2);
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
    }

    @Override
    public PageList<BizSupplierEnterprise> queryByPage(QueryFilter<BizSupplierEnterprise> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageList result = new PageList(((BizSupplierEnterpriseDao)this.baseMapper).queryAllByPage((IPage<BizSupplierEnterprise>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierEnterprise>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
        return result;
    }

    @Override
    public PageList<BizSupplierEnterprise> queryQuaByPage(QueryFilter<BizSupplierEnterprise> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        PageList result = new PageList(((BizSupplierEnterpriseDao)this.baseMapper).queryAllByPage((IPage<BizSupplierEnterprise>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierEnterprise>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
        List data = result.getRows();
        if (BeanUtils.isNotEmpty((Object)data) && data.size() > 0) {
            for (BizSupplierEnterprise temp : data) {
                LambdaQueryWrapper supQualificationQW = new LambdaQueryWrapper();
                supQualificationQW.eq(AdmittedSuppliersQualification::getAdmittedSupplierId, (Object)temp.getId());
                temp.setSuppliersQualificationList(this.suppliersQualificationManager.list((Wrapper)supQualificationQW));
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void uploadAccessory(BizSupplierEnterprise entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
        LambdaQueryWrapper qualificationLabelQW = new LambdaQueryWrapper();
        qualificationLabelQW.eq(BizSupplierOrgQualificationLabel::getAdmittedSupplierId, (Object)entity.getId());
        this.supplierOrgQualificationLabelManager.remove((Wrapper)qualificationLabelQW);
        this.accessoryService.removeBySourceId(entity.getId());
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
        if (BeanUtils.isNotEmpty(qualificationLabelList) && qualificationLabelList.size() > 0) {
            ArrayList<BizSupplierOrgQualificationLabel> supplierOrgQualificationLabelList = new ArrayList<BizSupplierOrgQualificationLabel>();
            for (BizQualificationLabel label : qualificationLabelList) {
                if (BeanUtils.isEmpty((Object)label.getId())) {
                    this.qualificationLabelManager.saveOrUpdateEntity(label);
                }
                BizSupplierOrgQualificationLabel temp = new BizSupplierOrgQualificationLabel();
                temp.setAdmittedSupplierId(entity.getId());
                temp.setQualificationLabelId(label.getId());
                supplierOrgQualificationLabelList.add(temp);
            }
            this.supplierOrgQualificationLabelManager.saveBatch(supplierOrgQualificationLabelList);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(BizSupplierEnterprise::getReviewStatus, (Object)(BeanUtils.isNotEmpty((Object)entity.getReviewStatus()) ? entity.getReviewStatus() : 0))).eq(BizSupplierEnterprise::getId, (Object)entity.getId());
        super.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void updateReviewStatus(String id, String status) {
        List<String> idList = Arrays.asList(id.split(","));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(BizSupplierEnterprise::getReviewStatus, (Object)status)).in(BizSupplierEnterprise::getId, idList);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void updateReviewStatus(String id, String status, String rejectionReason) {
        BizSupplierEnterprise data = (BizSupplierEnterprise)((Object)super.getById((Serializable)((Object)id)));
        data.setReviewStatus(Integer.valueOf(status));
        super.updateById((Object)data);
        if (status.equals("2") || status.equals("3")) {
            SupplierEnterpriseAuditing auditing = new SupplierEnterpriseAuditing();
            auditing.setAdmittedSupplierId(id);
            auditing.setType(data.getType());
            auditing.setReviewerId(ContextUtil.getCurrentUserId());
            auditing.setReviewerName(ContextUtil.getCurrentUserName());
            auditing.setReviewTime(LocalDateTime.now());
            if (status.equals("2")) {
                auditing.setReviewResult(1);
            } else {
                auditing.setReviewResult(0);
                if (BeanUtils.isNotEmpty((Object)rejectionReason)) {
                    auditing.setRejectionReason(rejectionReason);
                }
            }
            this.supplierEnterpriseAuditingManager.save((Object)auditing);
        }
    }

    @Override
    public boolean updateVo(BizSupplierEnterprise entity) {
        String supplierIds = entity.getSupplierId();
        List<String> list = Arrays.asList(supplierIds.split(","));
        String supplierCodes = entity.getSupplierCode();
        List<String> codeList = Arrays.asList(supplierCodes.split(","));
        boolean result = this.removeById((Serializable)((Object)entity.getId()));
        for (int i = 0; i < list.size(); ++i) {
            String supplierId = list.get(i);
            String supplierCode = codeList.get(i);
            entity.setSupplierId(supplierId);
            entity.setSupplierCode(supplierCode);
            entity.setId(null);
            this.save((Object)entity);
        }
        return result;
    }

    @Override
    public BizSupplierEnterprise getDetailById(String id) {
        BizSupplierEnterprise result = (BizSupplierEnterprise)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper supQualificationQW = new LambdaQueryWrapper();
        supQualificationQW.eq(AdmittedSuppliersQualification::getAdmittedSupplierId, (Object)id);
        result.setSuppliersQualificationList(this.suppliersQualificationManager.list((Wrapper)supQualificationQW));
        QueryFilter qualificationQF = QueryFilter.build();
        qualificationQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
        qualificationQF.addFilter("a.ADMITTED_SUPPLIER_ID_", (Object)id, QueryOP.EQUAL);
        result.setQualificationLabelList(this.supplierOrgQualificationLabelManager.queryQualificationPage((QueryFilter<BizSupplierOrgQualificationLabel>)qualificationQF).getRows());
        if (BeanUtils.isNotEmpty(result.getQualificationLabelList()) && result.getQualificationLabelList().size() > 0) {
            result.getQualificationLabelList().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
        }
        return result;
    }
}

