/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.dao.ClarifyAnswerDao;
import com.artfess.cgpt.purchasing.manager.ClarifyAnswerManager;
import com.artfess.cgpt.purchasing.model.ClarifyAnswer;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClarifyAnswerManagerImpl
extends BaseManagerImpl<ClarifyAnswerDao, ClarifyAnswer>
implements ClarifyAnswerManager {
    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<ClarifyAnswer> queryAllByPage(QueryFilter<ClarifyAnswer> queryFilter) {
        IPage<ClarifyAnswer> result = ((ClarifyAnswerDao)this.baseMapper).queryAllByPage((IPage<ClarifyAnswer>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ClarifyAnswer>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (ClarifyAnswer temp : records) {
                temp.setAccessoryList(this.accessoryService.getAccessoryBySourceId(temp.getId()));
            }
        }
        return new PageList(result);
    }

    @Override
    public List<ClarifyAnswer> getByQuestionId(String questionId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(ClarifyAnswer::getQuestionsId, (Object)questionId);
        List result = super.list((Wrapper)qw);
        if (BeanUtils.isNotEmpty((Object)result) && result.size() > 0) {
            for (ClarifyAnswer temp : result) {
                temp.setAccessoryList(this.accessoryService.getAccessoryBySourceId(temp.getId()));
            }
        }
        return result;
    }

    @Override
    public void saveOrUpdateEntity(ClarifyAnswer entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateId(ContextUtil.getCurrentUserId());
        entity.setOperateName(ContextUtil.getCurrentUserName());
        IGroup org = ContextUtil.getCurrentGroup();
        entity.setOperateOrgId(org.getGroupId());
        entity.setOperateOrgCode(org.getGroupCode());
        entity.setOperateOrgName(org.getName());
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
    }
}

