/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.dao.ProductDao;
import com.artfess.cgpt.material.manager.ProductDetailManager;
import com.artfess.cgpt.material.manager.ProductManager;
import com.artfess.cgpt.material.model.Product;
import com.artfess.cgpt.material.model.ProductDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductManagerImpl
extends BaseManagerImpl<ProductDao, Product>
implements ProductManager {
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ProductDetailManager productDetailManager;

    @Override
    public PageList<Product> queryAllByPage(QueryFilter<Product> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<Product> result = ((ProductDao)this.baseMapper).queryAllByPage((IPage<Product>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Product>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(Product entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<ProductDetail> detailList = entity.getDetailList();
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            this.accessoryService.removeBySourceId(entity.getId());
            LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
            detailQW.eq(ProductDetail::getProductId, (Object)entity.getId());
            this.productDetailManager.remove((Wrapper)detailQW);
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.forEach(s -> s.setProductId(entity.getId()));
            this.productDetailManager.saveBatch(detailList);
        }
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
    }

    @Override
    @Transactional
    public void updateStatusByIds(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(Product::getStatus, (Object)status)).in(Product::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void removeData(List<String> ids) {
        super.removeByIds(ids);
        LambdaQueryWrapper contractItemQW = new LambdaQueryWrapper();
        contractItemQW.in(ProductDetail::getProductId, ids);
        this.productDetailManager.remove((Wrapper)contractItemQW);
        this.accessoryService.removeBySourceIds(ids);
    }

    @Override
    public Product getDataById(String id) {
        Product result = (Product)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper contractItemQW = new LambdaQueryWrapper();
        contractItemQW.eq(ProductDetail::getProductId, (Object)id);
        result.setDetailList(this.productDetailManager.list((Wrapper)contractItemQW));
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(id));
        return result;
    }
}

