/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.utils.BizUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizMaterialCategory/v1/"})
@Api(tags={"\u7269\u6599\u5206\u7c7b"})
@ApiGroup(group={"group_biz"})
public class BizMaterialCategoryController
extends BaseController<BizMaterialCategoryManager, BizMaterialCategory> {
    @Autowired
    private UCFeignService ucFeignService;

    @PostMapping(value={"/selectTree"})
    @ApiOperation(value="M-\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u6811\u7ed3\u6784", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<List<BizMaterialCategory>> queryOrganization() {
        List<BizMaterialCategory> result = ((BizMaterialCategoryManager)this.baseService).selectTree();
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageAll"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<PageList<BizMaterialCategory>> queryByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterialCategory> queryFilter) {
        PageList<BizMaterialCategory> result = ((BizMaterialCategoryManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/getEnterpriseCategoryTree"})
    @ApiOperation(value="M-\u67e5\u8be2\u4f01\u4e1a\u6388\u6743\u7269\u6599\u5206\u7c7b\u6811\u7ed3\u6784", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<List<BizMaterialCategory>> getEnterpriseCategoryTree() {
        List<BizMaterialCategory> result = ((BizMaterialCategoryManager)this.baseService).getEnterpriseCategoryTree();
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/getEnterpriseCategoryTreeByCode"})
    @ApiOperation(value="M-\u6839\u636e\u4f01\u4e1a\u7f16\u7801\u67e5\u8be2\u6388\u6743\u7269\u6599\u5206\u7c7b\u6811\u7ed3\u6784", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<List<BizMaterialCategory>> getEnterpriseCategoryTreeByCode(@RequestParam(value="companyCode") String companyCode) {
        List<BizMaterialCategory> result = ((BizMaterialCategoryManager)this.baseService).getEnterpriseCategoryTree(companyCode);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/saveCategory"})
    @ApiOperation(value="M-\u6dfb\u52a0\u6216\u4fee\u6539\u7269\u6599\u5206\u7c7b")
    public CommonResult<List<BizMaterialCategory>> saveCategory(@RequestBody BizMaterialCategory category) {
        ((BizMaterialCategoryManager)this.baseService).saveOrUpdateEntity(category);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/updateYqcCategory"})
    @ApiOperation(value="M-\u66f4\u65b0\u6e1d\u4f01\u91c7\u5206\u7c7b")
    public CommonResult<List<BizMaterialCategory>> updateYqcCategory(@RequestBody BizMaterialCategory category) {
        ((BizMaterialCategoryManager)this.baseService).updateYqcCategory(category);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/deletCategory"})
    @ApiOperation(value="M-\u6279\u91cf\u5220\u9664\u7269\u6599\u5206\u7c7b")
    public CommonResult<List<BizMaterialCategory>> deletCategory(@RequestParam List<String> ids) {
        String message = "\u5220\u9664\u6210\u529f";
        if (BizUtils.isAdmin(this.ucFeignService)) {
            message = "\u65e0\u6743\u9650\uff0c\u5220\u9664\u5931\u8d25";
        } else {
            ((BizMaterialCategoryManager)this.baseService).removeByIds(ids);
        }
        return new CommonResult(true, message);
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="M-\u4fee\u6539\u7269\u6599\u5206\u7c7b\u72b6\u6001")
    public CommonResult updateStatus(@RequestBody List<String> ids, @RequestParam String status) {
        ((BizMaterialCategoryManager)this.baseService).updateStatus(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/exportExcelData"})
    @ApiOperation(value="M-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981")
    public CommonResult exportExcelData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterialCategory> queryFilter, HttpServletResponse response) throws Exception {
        ((BizMaterialCategoryManager)this.baseService).exportExcelData(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }
}

