/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.foreignApi.service.Impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.FluentUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.BizUserVo;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.foreignApi.vo.MhTaskVO;
import com.artfess.cgpt.foreignApi.vo.PushNoticeVO;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.artfess.uc.params.user.UserVo;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ForeignCallServiceImpl
implements ForeignCallService {
    @Value(value="${zsj.getTokenUrl}")
    private String zsjGetTokenUrl;
    @Value(value="${zfpt.getTokenUrl}")
    private String zfptGetTokenUrl;
    @Value(value="${zfpt.internalPay}")
    private String internalPayUrl;
    @Value(value="${zfpt.externalPay}")
    private String externalPayUrl;
    @Value(value="${zsj.createTaskUrl}")
    private String createTaskUrl;
    @Value(value="${zsj.completeTaskUrl}")
    private String completeTaskUrl;
    @Value(value="${zsj.createNoticeUrl}")
    private String createNoticeUrl;
    @Value(value="${zsj.pushWxMessageUrl}")
    private String pushWxMessageUrl;
    @Value(value="${zsj.queryUserUrl}")
    private String queryUserUrl;
    @Value(value="${zsj.pushUserUrl}")
    private String pushUserUrl;
    @Value(value="${cgpt.porTaskUrl}")
    private String cgptPorTaskUrl;
    @Value(value="${cgpt.porInstUrl}")
    private String cgptPorInstUrl;
    @Autowired
    BizUtils bizUtils;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Autowired
    BpmTaskManager bpmTaskManager;
    @Autowired
    UserManager userManager;

    @Override
    public void callForeignInterface(String url, Object params, Integer sys) {
        block7: {
            String token = this.getToken(sys);
            if (BeanUtils.isNotEmpty((Object)token)) {
                HashMap<String, String> hearders = new HashMap<String, String>();
                hearders.put("Authorization", token);
                JsonNode jsonNode = null;
                try {
                    jsonNode = JsonUtil.toJsonNode(hearders);
                    String result = FluentUtil.post((String)url, (String)Base64.getBase64((String)jsonNode.toString()), (Object)params);
                    if (BeanUtils.isNotEmpty((Object)result)) {
                        JSONObject jsonObject = JSONUtil.parseObj((String)result);
                        if (jsonObject.get((Object)"state").equals("false")) {
                            throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25:" + jsonObject.get((Object)"message"));
                        }
                        break block7;
                    }
                    throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
                }
                catch (Exception e) {
                    if (sys == 1) {
                        this.redisUtil.del(new String[]{"zsjToken"});
                    }
                    if (sys == 2) {
                        this.redisUtil.del(new String[]{"zfptToken"});
                    }
                    throw new BaseException("\u63a8\u9001\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void callForeignInterfaceResponse(String url, Object params, Integer sys) {
        block7: {
            String token = this.getToken(sys);
            if (BeanUtils.isNotEmpty((Object)token)) {
                HashMap<String, String> hearders = new HashMap<String, String>();
                hearders.put("Authorization", token);
                JsonNode jsonNode = null;
                try {
                    jsonNode = JsonUtil.toJsonNode(hearders);
                    String result = FluentUtil.post((String)url, (String)Base64.getBase64((String)jsonNode.toString()), (Object)params);
                    if (BeanUtils.isNotEmpty((Object)result)) {
                        JSONObject jsonObject = JSONUtil.parseObj((String)result);
                        if (!jsonObject.get((Object)"code").equals("0")) {
                            throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25:" + jsonObject.get((Object)"msg"));
                        }
                        break block7;
                    }
                    throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
                }
                catch (Exception e) {
                    if (sys == 1) {
                        this.redisUtil.del(new String[]{"zsjToken"});
                    }
                    if (sys == 2) {
                        this.redisUtil.del(new String[]{"zfptToken"});
                    }
                    throw new BaseException("\u63a8\u9001\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    @Override
    public JSONObject callInterfaceResponse(String url, JSONObject params, Integer sys) {
        JSONObject jsonObject = new JSONObject();
        String token = this.getToken(sys);
        if (BeanUtils.isNotEmpty((Object)token)) {
            HashMap<String, String> hearders = new HashMap<String, String>();
            hearders.put("Authorization", token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String result = FluentUtil.post((String)url, (String)Base64.getBase64((String)jsonNode.toString()), (Object)params);
                if (!BeanUtils.isNotEmpty((Object)result)) {
                    throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
                }
                jsonObject = JSONUtil.parseObj((String)result);
            }
            catch (Exception e) {
                throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return jsonObject;
    }

    public JSONObject callInterfaceResponse(String url, JSONArray params, Integer sys) {
        JSONObject jsonObject = new JSONObject();
        String token = this.getToken(sys);
        if (BeanUtils.isNotEmpty((Object)token)) {
            HashMap<String, String> hearders = new HashMap<String, String>();
            hearders.put("Authorization", token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String result = FluentUtil.post((String)url, (String)Base64.getBase64((String)jsonNode.toString()), (Object)params);
                if (!BeanUtils.isNotEmpty((Object)result)) {
                    throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
                }
                jsonObject = JSONUtil.parseObj((String)result);
            }
            catch (Exception e) {
                throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return jsonObject;
    }

    @Override
    public ForeignResponseVo callInterface(String url, JSONObject params, Integer sys) {
        ForeignResponseVo result = null;
        String token = this.getToken(sys);
        if (BeanUtils.isNotEmpty((Object)token)) {
            HashMap<String, String> hearders = new HashMap<String, String>();
            hearders.put("Authorization", token);
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode(hearders);
                String info = FluentUtil.post((String)url, (String)Base64.getBase64((String)jsonNode.toString()), (Object)params);
                if (!BeanUtils.isNotEmpty((Object)info)) {
                    throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25");
                }
                result = (ForeignResponseVo)JSONUtil.toBean((String)info, ForeignResponseVo.class);
            }
            catch (Exception e) {
                throw new BaseException("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return result;
    }

    public String getToken(Integer sys) {
        Object redisToken;
        String token = "";
        String redisKey = "zsjToken";
        if (sys == 2) {
            redisKey = "zfptToken";
        }
        if (BeanUtils.isEmpty((Object)(redisToken = this.redisUtil.get(redisKey)))) {
            JSONObject jsonObject;
            String url = this.zsjGetTokenUrl;
            HashMap<String, String> getTokenMap = new HashMap<String, String>();
            String key = null;
            String tokenString = null;
            try {
                key = EncryptUtil.md5Hex((String)"cgptoRifyipFRldpsV2BmmrEv+XL1eBGkG6gzuKN2ITGFNQHwMzxjUDjXjruC1tssi/8t//f3SUaKqzGLY/r7JPyfpP88ofKDpO3PzxMGbjYrdkHwMzxjUDjXjruC1tssi/8");
                if (sys == 2) {
                    key = EncryptUtil.md5Hex((String)"cgptoRifyipFRldpsV2BmmrEv+XL1eBGkG6gzuKN2ITGFNQHwMzxjUDjXjruC1tssi/8t//f3SUaKqzGLY/r7JPyfpP88ofKDpO3PzxMGbjYrdkHwMzxjUDjXjruC1tssi/8");
                    url = this.zfptGetTokenUrl;
                }
                getTokenMap.put("key", key);
                getTokenMap.put("sysCode", "cgpt");
                tokenString = FluentUtil.post((String)url, null, getTokenMap);
            }
            catch (Exception e) {
                throw new BaseException("\u83b7\u53d6TOKEN\u5931\u8d25", (Throwable)e);
            }
            if (BeanUtils.isNotEmpty((Object)tokenString) && BeanUtils.isNotEmpty((Object)(jsonObject = JSONUtil.parseObj((String)tokenString)).get((Object)"value"))) {
                String tokenValue = "Bearer " + jsonObject.get((Object)"value").toString();
                this.redisUtil.set(redisKey, (Object)tokenValue, 28800L);
                token = tokenValue;
            }
        } else {
            token = redisToken.toString();
        }
        return token;
    }

    @Override
    public ForeignResponseVo callPay(TransVo trans, Integer type) {
        JSONObject param;
        JSONObject res;
        String payUrl = this.internalPayUrl;
        if (type == 2) {
            payUrl = this.externalPayUrl;
        }
        if (BeanUtils.isEmpty((Object)(res = this.callInterfaceResponse(payUrl, param = JSONUtil.parseObj((Object)trans), (Integer)2)))) {
            return null;
        }
        ForeignResponseVo result = (ForeignResponseVo)JSONUtil.toBean((String)res.toString(), ForeignResponseVo.class);
        return result;
    }

    @Override
    public String createTokenKey() {
        HttpServletRequest request = HttpUtil.getRequest();
        String tokenStr = request.getHeader("authorization");
        String token = tokenStr.substring(tokenStr.indexOf("Bearer") + 7);
        String tokenKey = StringUtils.upperCase((String)RandomStringUtils.randomAlphanumeric((int)5));
        this.redisUtil.set(tokenKey, (Object)token, 300L);
        return tokenKey;
    }

    @Override
    public CommonResult checkToken(String tokenKey) {
        Object tokenObject = this.redisUtil.get(tokenKey);
        if (BeanUtils.isEmpty((Object)tokenObject)) {
            return new CommonResult(false, "\u65e0\u6548\u7684tokenKey");
        }
        this.redisUtil.del(new String[]{tokenKey});
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)tokenObject.toString());
    }

    @Override
    public CommonResult<BizUserVo> getUserByTOKEN() {
        IUser currentUserOrNull = ContextUtil.getCurrentUserOrNull();
        if (null == currentUserOrNull) {
            return new CommonResult(false, "\u65e0\u6548\u7684token");
        }
        BizUserVo result = new BizUserVo();
        result.setAccount(currentUserOrNull.getAccount());
        result.setFullname(currentUserOrNull.getFullname());
        result.setEmail(currentUserOrNull.getEmail());
        result.setMobile(currentUserOrNull.getMobile());
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    @Override
    public void pushTaskToMh(String instId) throws Exception {
        DefaultBpmProcessInstance proInst = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.getById((Serializable)((Object)instId));
        if (BeanUtils.isEmpty((Object)proInst)) {
            return;
        }
        List taskList = this.bpmTaskManager.getByInstId(proInst.getId());
        if (BeanUtils.isEmpty((Object)taskList) || taskList.size() <= 0) {
            return;
        }
        DefaultBpmTask task = (DefaultBpmTask)taskList.get(0);
        MhTaskVO mhTaskVO = new MhTaskVO();
        mhTaskVO.setWorkflowInstanceId(instId);
        mhTaskVO.setTitle(proInst.getSubject());
        mhTaskVO.setItemType(1);
        mhTaskVO.setUrl(this.cgptPorTaskUrl + task.getId() + "/0");
        User sendUser = (User)this.userManager.getById((Serializable)((Object)proInst.getCreateBy()));
        if (BeanUtils.isNotEmpty((Object)sendUser)) {
            mhTaskVO.setSendUserAccount(sendUser.getAccount());
        }
        mhTaskVO.setSendUserName(proInst.getCreator());
        User recUser = (User)this.userManager.getById((Serializable)((Object)task.getAssigneeId()));
        if (BeanUtils.isNotEmpty((Object)recUser)) {
            mhTaskVO.setReceiveUserAccount(recUser.getAccount());
        }
        mhTaskVO.setReceiveUserName(task.getAssigneeName());
        mhTaskVO.setSendDate(LocalDateTime.now());
        this.callForeignInterface(this.createTaskUrl, mhTaskVO, 1);
    }

    @Override
    public void completeTaskToMh(String instId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("workflowInstanceId", instId);
        params.put("url", this.cgptPorInstUrl + instId + "/doneList");
        params.put("questUrl", this.cgptPorInstUrl + instId + "/request");
        try {
            this.callForeignInterface(this.completeTaskUrl, params, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u63a8\u9001\u4e3b\u6570\u636e\u5df2\u529e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void pushTaskToMhByTaskId(String taskId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.getById((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            return;
        }
        DefaultBpmProcessInstance proInst = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.getById((Serializable)((Object)task.getProcInstId()));
        if (BeanUtils.isEmpty((Object)proInst)) {
            return;
        }
        MhTaskVO mhTaskVO = new MhTaskVO();
        mhTaskVO.setWorkflowInstanceId(proInst.getId());
        mhTaskVO.setTitle(proInst.getSubject());
        mhTaskVO.setItemType(1);
        mhTaskVO.setUrl(this.cgptPorTaskUrl + task.getId() + "/0");
        mhTaskVO.setQuestUrl(this.cgptPorInstUrl + task.getProcInstId() + "/request");
        User sendUser = (User)this.userManager.getById((Serializable)((Object)proInst.getCreateBy()));
        if (BeanUtils.isNotEmpty((Object)sendUser)) {
            mhTaskVO.setSendUserAccount(sendUser.getAccount());
        }
        mhTaskVO.setSendUserName(proInst.getCreator());
        User recUser = (User)this.userManager.getById((Serializable)((Object)task.getAssigneeId()));
        if (BeanUtils.isNotEmpty((Object)recUser)) {
            mhTaskVO.setReceiveUserAccount(recUser.getAccount());
        }
        mhTaskVO.setReceiveUserName(task.getAssigneeName());
        mhTaskVO.setSendDate(LocalDateTime.now());
        mhTaskVO.setWorkflowInstanceName(proInst.getProcDefName());
        Org org = (Org)this.orgManager.getById((Serializable)((Object)proInst.getCreateOrgId()));
        mhTaskVO.setSendDeptName(org.getName());
        this.callForeignInterface(this.createTaskUrl, mhTaskVO, 1);
    }

    @Override
    public void pushNoticeToMh(PushNoticeVO mhNoticeVO) {
        this.callForeignInterface(this.createNoticeUrl, mhNoticeVO, 1);
    }

    @Override
    public JSONObject pushWxMessage(WxNoticeTemplate wxNoticeTemplate) {
        JSONObject param = JSONUtil.parseObj((Object)wxNoticeTemplate);
        JSONObject jsonObject = this.callInterfaceResponse(this.pushWxMessageUrl, param, (Integer)1);
        return jsonObject;
    }

    @Override
    public JSONObject queryUser(User queryVO) {
        JSONObject param = JSONUtil.parseObj((Object)queryVO);
        JSONObject jsonObject = this.callInterfaceResponse(this.queryUserUrl, param, (Integer)1);
        return jsonObject;
    }

    @Override
    public JSONObject pushUser(UserVo vo) {
        JSONObject param = JSONUtil.parseObj((Object)vo);
        JSONObject jsonObject = this.callInterfaceResponse(this.pushUserUrl, param, (Integer)1);
        return jsonObject;
    }
}

