/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.v2sdk;

import java.io.OutputStream;
import java.util.UUID;
import net.qiyuesuo.sdk.common.crypt.MD5;
import net.qiyuesuo.sdk.common.http.HttpHeader;
import net.qiyuesuo.v2sdk.exception.BaseSdkException;
import net.qiyuesuo.v2sdk.http.HttpClient;
import net.qiyuesuo.v2sdk.http.HttpParameter;
import net.qiyuesuo.v2sdk.request.SdkRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkV2Client {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int connectTimeout = 30000;
    private int readTimeout = 120000;
    private String serviceUrl;
    private String accessToken;
    private String accessSecret;

    public SdkV2Client(String serviceUrl, String accessToken, String accessSecret) {
        this.serviceUrl = serviceUrl;
        this.accessToken = accessToken;
        this.accessSecret = accessSecret;
    }

    public String service(SdkRequest request) throws BaseSdkException {
        String url = this.serviceUrl + request.getUrl();
        HttpHeader header = this.buildHttpHeader();
        HttpParameter httpParameter = request.getHttpParameter();
        try {
            if (httpParameter.isJson()) {
                this.logger.debug("jsonParams:{}", (Object)httpParameter.getJsonParams());
                return HttpClient.doServiceWithJson(url, httpParameter.getJsonParams(), header, this.connectTimeout, this.readTimeout);
            }
            return HttpClient.doService(url, httpParameter, header, this.connectTimeout, this.readTimeout);
        }
        catch (Exception e) {
            throw new BaseSdkException(e.getMessage(), e);
        }
    }

    public void download(SdkRequest request, OutputStream outputStream) throws BaseSdkException {
        String url = this.serviceUrl + request.getUrl();
        HttpHeader header = this.buildHttpHeader();
        HttpParameter httpParameter = request.getHttpParameter();
        try {
            if (httpParameter.isJson()) {
                this.logger.debug("jsonParams:{}", (Object)httpParameter.getJsonParams());
                HttpClient.doDownloadWithJson(url, httpParameter.getJsonParams(), header, outputStream, this.connectTimeout, this.readTimeout);
            } else {
                HttpClient.doDownload(url, request.getHttpParameter(), header, this.connectTimeout, this.readTimeout, outputStream);
            }
        }
        catch (Exception e) {
            throw new BaseSdkException(e.getMessage(), e);
        }
    }

    private HttpHeader buildHttpHeader() {
        Long timestamp = System.currentTimeMillis();
        String nonce = UUID.randomUUID().toString();
        String signature = MD5.toMD5(this.accessToken + this.accessSecret + timestamp + nonce);
        return new HttpHeader(this.accessToken, timestamp, signature, nonce);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

