/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.impl;

import java.io.InputStream;
import java.util.Map;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.VerifyService;
import net.qiyuesuo.sdk.bean.datasign.DataSignVerifierRequest;
import net.qiyuesuo.sdk.bean.verifier.FileVerifierResult;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.HttpParamers;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.utils.StringUtils;

public class VerifyServiceImpl
implements VerifyService {
    private SDKClient client;

    public VerifyServiceImpl(SDKClient client) {
        this.client = client;
    }

    @Override
    public FileVerifierResult verify(InputStream inputstream) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        StreamFile file = new StreamFile(inputstream);
        paramers.addFile("file", file);
        Map<String, Object> result = this.client.doService("/file/verify", paramers);
        FileVerifierResult verifierResult = new FileVerifierResult();
        try {
            if (StringUtils.isNotBlank((String)result.get("documentId"))) {
                verifierResult.setDocumentId(Long.valueOf((String)result.get("documentId")));
            }
            verifierResult.setSignatureInfos(result.get("signatureInfos") == null ? null : result.get("signatureInfos").toString());
            verifierResult.setStatusCode((Integer)result.get("statusCode"));
            verifierResult.setStatusMsg((String)result.get("statusMsg"));
        }
        catch (Exception e) {
            throw new PrivateAppException("\u8fd4\u56de\u4fe1\u606f\u7684\u89e3\u6790\u5931\u8d25," + e.getMessage());
        }
        return verifierResult;
    }

    @Override
    public boolean verifyDataSign(DataSignVerifierRequest request) throws PrivateAppException {
        HttpParamers paramers = HttpParamers.httpPostParamers();
        paramers.addParam("signData", request.getSignData());
        if (request.getDataSignId() != null) {
            paramers.addParam("dataSignId", String.valueOf(request.getDataSignId()));
        }
        paramers.addParam("businessId", request.getBizId());
        Map<String, Object> result = this.client.doService("/datasign/verifier", paramers);
        return Boolean.valueOf(result.get("result").toString());
    }
}

