/*
 * Decompiled with CFR 0.152.
 */
package net.qiyuesuo.sdk.common.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.imageio.ImageIO;

public class IOUtils {
    public static final int READ_BUFFER_SIZE = 1024;

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void deleteFile(File file) {
        if (file != null) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamAsString(InputStream in, String charset) throws IOException {
        String result;
        if (in == null) {
            return "";
        }
        BufferedReader reader = null;
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n = -1;
            reader = new BufferedReader(new InputStreamReader(in, charset));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            result = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(in);
            IOUtils.safeClose(reader);
            IOUtils.safeClose(writer);
            throw throwable;
        }
        IOUtils.safeClose(in);
        IOUtils.safeClose(reader);
        IOUtils.safeClose(writer);
        return result;
    }

    public static byte[] readStreamAsByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = in.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
        output.flush();
        return output.toByteArray();
    }

    public static byte[] readStreamAsByteArray(InputStream in, int limit) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        int temp = limit - 1024;
        block0: while ((len = in.read(buffer)) != -1) {
            output.write(buffer, 0, len);
            if (output.size() <= temp) continue;
            if (output.size() == limit) break;
            byte[] buffer2 = new byte[limit - output.size()];
            while ((len = in.read(buffer2)) != -1) {
                output.write(buffer2, 0, len);
                if (output.size() == limit) break block0;
                buffer2 = new byte[limit - output.size()];
            }
            break block0;
        }
        return output.toByteArray();
    }

    public static void writeStream(InputStream in, OutputStream output) throws IOException {
        if (in == null) {
            return;
        }
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = in.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
        output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(InputStream in, OutputStream out, String type) {
        try {
            BufferedImage bi = ImageIO.read(in);
            ImageIO.write((RenderedImage)bi, type, out);
        }
        catch (Exception exception) {
        }
        finally {
            IOUtils.safeClose(in);
            IOUtils.safeClose(out);
        }
    }
}

