/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.BizModel;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.receipt.dao.BizReceiptDao;
import com.artfess.cgpt.receipt.manager.ArrivalDetailManager;
import com.artfess.cgpt.receipt.manager.ArrivalManager;
import com.artfess.cgpt.receipt.manager.BizReceiptDetailManager;
import com.artfess.cgpt.receipt.manager.BizReceiptHandleManager;
import com.artfess.cgpt.receipt.manager.BizReceiptManager;
import com.artfess.cgpt.receipt.model.Arrival;
import com.artfess.cgpt.receipt.model.ArrivalDetail;
import com.artfess.cgpt.receipt.model.BizReceipt;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.UserManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizReceiptManagerImpl
extends BaseManagerImpl<BizReceiptDao, BizReceipt>
implements BizReceiptManager {
    @Resource
    private BizReceiptDetailManager receiptDetailManager;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    BizReceiptHandleManager bizReceiptHandleManager;
    @Autowired
    BaseContext baseContext;
    @Autowired
    UserManager userManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ArrivalManager arrivalManager;
    @Autowired
    private ArrivalDetailManager arrivalDetailManager;

    @Override
    public BizReceipt getDetailById(String id) {
        BizReceipt result = (BizReceipt)((Object)super.getById((Serializable)((Object)id)));
        List<BizReceiptDetail> detailList = this.receiptDetailManager.getByReceiptId(id);
        result.setDetailList(detailList);
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    @Transactional
    public String saveVo(BizReceipt entity) {
        List<BizReceiptDetail> detailList = entity.getDetailList();
        List<Accessory> accessoryList = entity.getAccessoryList();
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            if (BeanUtils.isEmpty((Object)entity.getReceiptCode())) {
                entity.setReceiptCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "cgpt_cgsh"));
            }
            entity.setStatus(1);
        } else {
            List<BizReceiptDetail> receiptDetails = this.receiptDetailManager.getByReceiptId(entity.getId());
            if (BeanUtils.isNotEmpty(receiptDetails) && receiptDetails.size() > 0) {
                List collect = receiptDetails.stream().map(s -> s.getArrivalId()).distinct().collect(Collectors.toList());
                List collect1 = receiptDetails.stream().map(s -> s.getArrivalDetailId()).distinct().collect(Collectors.toList());
                LambdaUpdateWrapper arrivalUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)arrivalUW.set(Arrival::getStatus, (Object)2)).in(Arrival::getId, collect)).eq(BizModel::getIsDele, (Object)"0");
                this.arrivalManager.update((Wrapper)arrivalUW);
                LambdaUpdateWrapper arrivalDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)arrivalDetailUW.set(ArrivalDetail::getStatus, (Object)1)).in(ArrivalDetail::getId, collect1);
                this.arrivalDetailManager.update((Wrapper)arrivalDetailUW);
                this.receiptDetailManager.removeByReceiptId(entity.getId());
            }
            this.accessoryService.removeBySourceId(entity.getId());
        }
        this.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.forEach(s -> s.setReceiptId(entity.getId()));
            this.receiptDetailManager.saveBatch(detailList);
            List collect = detailList.stream().map(s -> s.getArrivalId()).distinct().collect(Collectors.toList());
            List collect1 = detailList.stream().map(s -> s.getArrivalDetailId()).distinct().collect(Collectors.toList());
            LambdaUpdateWrapper arrivalDetailUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)arrivalDetailUW.set(ArrivalDetail::getStatus, (Object)2)).in(ArrivalDetail::getId, collect1);
            this.arrivalDetailManager.update((Wrapper)arrivalDetailUW);
            for (String arrId : collect) {
                LambdaQueryWrapper arrDetailCountQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)arrDetailCountQW.eq(ArrivalDetail::getStatus, (Object)1)).eq(ArrivalDetail::getArrivalId, (Object)arrId);
                if (this.arrivalDetailManager.count((Wrapper)arrDetailCountQW) != 0) continue;
                LambdaUpdateWrapper arrivalUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)arrivalUW.set(Arrival::getStatus, (Object)3)).eq(Arrival::getId, (Object)arrId)).eq(BizModel::getIsDele, (Object)"0");
                this.arrivalManager.update((Wrapper)arrivalUW);
            }
        }
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
        return entity.getId();
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        this.receiptDetailManager.removeByReceiptId(String.join((CharSequence)",", ids));
        this.accessoryService.removeBySourceIds(ids);
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void updateStatus(String id, Integer status) {
        LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(BizReceipt::getStatus, (Object)status)).eq(BizReceipt::getId, (Object)id)).eq(BizModel::getIsDele, (Object)"0");
        if (status == 3) {
            IUser user = ContextUtil.getCurrentUser();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(BizReceipt::getMatUserId, (Object)user.getUserId())).set(BizReceipt::getMatUserName, (Object)user.getFullname())).set(BizReceipt::getMatUserPhone, (Object)user.getMobile())).set(BizReceipt::getReceiptDate, (Object)LocalDateTime.now());
            LambdaUpdateWrapper detailUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)detailUW.set(BizReceiptDetail::getStatus, (Object)2)).eq(BizReceiptDetail::getReceiptId, (Object)id);
            this.receiptDetailManager.update((Wrapper)detailUW);
        }
        super.update((Wrapper)uw);
    }

    @Override
    public PageList<BizReceipt> pageVendorGroup(QueryFilter<BizReceipt> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<BizReceipt> result = ((BizReceiptDao)this.baseMapper).pageVendorGroup((IPage<BizReceipt>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReceipt>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

