/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.order.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.order.dao.BizRegistrationOrderDao;
import com.artfess.cgpt.order.manager.BizRegistrationOrderDetailsManager;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.order.vo.OrderDetailsVo;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizRegistrationOrderManagerImpl
extends BaseManagerImpl<BizRegistrationOrderDao, BizRegistrationOrder>
implements BizRegistrationOrderManager {
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private BizRegistrationOrderDetailsManager registrationOrderDetailsManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private OrgManager orgManager;
    @Value(value="${zfpt.getAccountUrl}")
    private String getAccountUrl;

    @Override
    public BizRegistrationOrder getByIdNoTenant(String id) {
        BizRegistrationOrder result = ((BizRegistrationOrderDao)this.baseMapper).getByIdNoTenant(id);
        return result;
    }

    @Override
    public PageList<BizRegistrationOrder> queryAllByPage(QueryFilter<BizRegistrationOrder> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)0, QueryOP.EQUAL);
        BizUtils.addFilterByOrgCodeAndRole(queryFilter, this.ucFeignService, "MAT_COMPANY_ID_");
        IPage<BizRegistrationOrder> materialIPage = ((BizRegistrationOrderDao)this.baseMapper).queryAllByPage((IPage<BizRegistrationOrder>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizRegistrationOrder>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(materialIPage);
    }

    @Override
    public BizRegistrationOrder getDetailById(String id) {
        BizRegistrationOrder order = (BizRegistrationOrder)((Object)this.getById((Serializable)((Object)id)));
        List<BizRegistrationOrderDetails> details = this.registrationOrderDetailsManager.getListByOrderId(id);
        order.setDetailsList(details);
        return order;
    }

    @Override
    public void saveVo(BizRegistrationOrder entity) {
        this.saveOrUpdate((Object)entity);
        List<BizRegistrationOrderDetails> detailsList = entity.getDetailsList();
        for (BizRegistrationOrderDetails details : detailsList) {
            details.setRegistrationOrderId(entity.getId());
            details.setRegistrationOrderNumber(entity.getOrderNumber());
        }
        this.registrationOrderDetailsManager.saveOrUpdateBatch(detailsList);
    }

    @Override
    public JSONObject getCurrentAccount() {
        String orgId = this.baseContext.getCurrentOrgId();
        if ("" == orgId) {
            return null;
        }
        ObjectNode org = this.ucFeignService.getOrgByIdOrCode(orgId);
        JSONObject param = new JSONObject();
        param.set("bankCompanyCode", (Object)org.get("code").textValue());
        JSONObject jsonObject = this.foreignCallService.callInterfaceResponse(this.getAccountUrl, param, 2);
        return jsonObject;
    }

    @Override
    public void payByBalance(BizRegistrationOrder trans) {
        List<String> partIds = Arrays.asList(trans.getParticipationId().split(","));
        List userParts = this.userParticipationManager.listByIds(partIds);
        if (BeanUtils.isEmpty((Object)userParts) || userParts.size() <= 0) {
            throw new BaseException("\u8bf7\u9009\u62e9\u8bb0\u5f55");
        }
        Map<Integer, List<UserParticipation>> collect = userParts.stream().collect(Collectors.groupingBy(UserParticipation::getType));
        collect.forEach((type, data) -> this.feePay((Integer)type, (List<UserParticipation>)data, partIds, trans));
    }

    @Transactional
    public void feePay(Integer type, List<UserParticipation> data, List<String> partIds, BizRegistrationOrder trans) {
        BizModel notice;
        if (type == 1) {
            for (UserParticipation userParticipation : data) {
                UserParticipation docFeeData;
                if (!BeanUtils.isNotEmpty((Object)userParticipation.getDocumentFeeId()) || partIds.contains(userParticipation.getDocumentFeeId()) || !BeanUtils.isNotEmpty((Object)((Object)(docFeeData = (UserParticipation)((Object)this.userParticipationManager.getById((Serializable)((Object)userParticipation.getDocumentFeeId())))))) || docFeeData.getPrice().compareTo(BigDecimal.ZERO) <= 0 || docFeeData.getStatus() == 1) continue;
                throw new BaseException("\u8bf7\u5148\u652f\u4ed8\u9879\u76ee\u6807\u4e66\u8d39\uff1a" + docFeeData.getNoticeTitle());
            }
            trans.setPayType(2);
        } else if (type == 2) {
            trans.setPayType(5);
        }
        BigDecimal amount = BigDecimal.ZERO;
        for (UserParticipation temp : data) {
            amount = amount.add(temp.getPrice());
        }
        String string = "";
        if (trans.getNoticeType().equals(1)) {
            notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)trans.getNoticeId())));
            String string2 = notice.getNoticeTitle();
        } else {
            notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)trans.getNoticeId())));
            String string3 = notice.getNoticeTitle();
        }
        String orderNumber = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "zfjl_ddh");
        trans.setOrderNumber(orderNumber);
        trans.setPayStatus(3);
        IUser user = ContextUtil.getCurrentUser();
        trans.setUserId(user.getUserId());
        trans.setUserAccount(user.getAccount());
        trans.setUserName(user.getFullname());
        if (BeanUtils.isNotEmpty((Object)user.getMobile())) {
            trans.setUserPhone(user.getMobile());
        }
        IGroup org = ContextUtil.getCurrentGroup();
        trans.setPayUnitId(org.getGroupId());
        trans.setPayUnitCode(org.getGroupCode());
        trans.setPayUnitName(org.getName());
        trans.setPayTime(LocalDateTime.now());
        trans.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        Org colOrg = this.orgManager.getByCode("00001513");
        if (BeanUtils.isEmpty((Object)colOrg)) {
            throw new BaseException("\u672a\u627e\u5230\u7f16\u53f7\u4e3a\u301000001513\u3011\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6ce8\u518c");
        }
        trans.setCollectUnitId(colOrg.getId());
        trans.setCollectUnitCode(colOrg.getCode());
        trans.setCollectUnitName(colOrg.getName());
        trans.setCollectTime(trans.getPayTime());
        trans.setCollectTimer(trans.getPayTimer());
        if (trans.getPayType().equals(2)) {
            trans.setPayDescribe("\u7f34\u7eb3\u4fdd\u8bc1\u91d1");
        } else if (trans.getPayType().equals(5)) {
            trans.setPayDescribe("\u7f34\u7eb3\u6807\u4e66\u8d39");
        }
        trans.setPayAmount(amount);
        super.save((Object)trans);
        ArrayList<BizRegistrationOrderDetails> detailedList = new ArrayList<BizRegistrationOrderDetails>();
        ArrayList<OrderDetailsVo> orderDetailsList = new ArrayList<OrderDetailsVo>();
        ForeignResponseVo res = null;
        if (trans.getPayType().equals(2) || trans.getPayType().equals(5)) {
            TransVo transVo = new TransVo();
            try {
                BeanUtils.copyNotNullProperties((Object)transVo, (Object)((Object)trans));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                throw new BaseException(e.getMessage());
            }
            transVo.setStatementsCode(trans.getOrderNumber());
            transVo.setDepositPaymentStatus(trans.getPayStatus());
            for (UserParticipation temp : data) {
                BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
                detail.setRegistrationOrderId(trans.getId());
                detail.setRegistrationOrderNumber(trans.getOrderNumber());
                detail.setUserId(trans.getUserId());
                detail.setUserName(trans.getUserName());
                detail.setUserAccount(trans.getUserAccount());
                if (BeanUtils.isNotEmpty((Object)trans.getUserPhone())) {
                    detail.setUserPhone(trans.getUserPhone());
                }
                detail.setCompanyId(trans.getPayUnitId());
                detail.setCompanyCode(trans.getPayUnitCode());
                detail.setCompanyName(trans.getPayUnitName());
                detail.setNoticeId(temp.getNoticeId());
                detail.setNoticeType(temp.getNoticeType());
                detail.setNoticeTitle(temp.getNoticeTitle());
                detail.setPayName(temp.getNoticeTitle());
                detail.setRechargeNumber(BigDecimal.ONE);
                detail.setRechargePrice(temp.getPrice());
                detail.setSalesCompanyId(trans.getCollectUnitId());
                detail.setSalesCompanyCode(trans.getCollectUnitCode());
                detail.setSalesCompanyName(trans.getCollectUnitName());
                detailedList.add(detail);
                OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
                try {
                    BeanUtils.copyNotNullProperties((Object)orderDetailsVo, (Object)((Object)detail));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    System.out.println("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
                    throw new BaseException("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
                }
                if (temp.getType() == 2) {
                    orderDetailsVo.setPayType(5);
                } else {
                    orderDetailsVo.setPayType(2);
                }
                orderDetailsList.add(orderDetailsVo);
            }
            transVo.setOrderDetails(orderDetailsList);
            res = trans.getPayType().equals(2) ? this.foreignCallService.callPay(transVo, 1) : this.foreignCallService.callPay(transVo, 2);
        }
        if (BeanUtil.isEmpty(res, (String[])new String[0])) {
            throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25");
        }
        if (!res.getCode().equals("0")) {
            throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25:" + res.getMsg());
        }
        if (detailedList.size() > 0) {
            this.registrationOrderDetailsManager.saveBatch(detailedList);
        }
        List updateDataIds = data.stream().map(s -> s.getId()).collect(Collectors.toList());
        if (type == 2) {
            LambdaUpdateWrapper bondUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)bondUW.set(UserParticipation::getStatus, (Object)1)).in(UserParticipation::getDocumentFeeId, updateDataIds)).eq(UserParticipation::getType, (Object)1)).eq(UserParticipation::getStatus, (Object)4)).eq(BizModel::getIsDele, (Object)"0");
            this.userParticipationManager.update((Wrapper)bondUW);
        }
        LambdaUpdateWrapper userParticipationUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)userParticipationUW.set(UserParticipation::getStatus, (Object)1)).set(UserParticipation::getRegistrationOrderId, (Object)trans.getId())).set(UserParticipation::getRegistrationOrderNumber, (Object)trans.getOrderNumber())).in(UserParticipation::getId, updateDataIds)).eq(BizModel::getIsDele, (Object)"0");
        this.userParticipationManager.update((Wrapper)userParticipationUW);
    }

    @Override
    @Transactional
    public void refundBond(UserParticipation userPart) {
        BizRegistrationOrder regisOrder = (BizRegistrationOrder)((Object)super.getById((Serializable)((Object)userPart.getRegistrationOrderId())));
        BizRegistrationOrder refundRegisOrder = new BizRegistrationOrder();
        refundRegisOrder.setParticipationId(userPart.getId());
        String orderNumber = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "zfjl_ddh");
        refundRegisOrder.setOrderNumber(orderNumber);
        refundRegisOrder.setPayStatus(3);
        refundRegisOrder.setRefundStatus(1);
        refundRegisOrder.setNoticeId(userPart.getNoticeId());
        refundRegisOrder.setNoticeType(1);
        if (BeanUtils.isNotEmpty((Object)regisOrder.getUserId())) {
            refundRegisOrder.setUserId(regisOrder.getUserId());
        }
        if (BeanUtils.isNotEmpty((Object)regisOrder.getUserAccount())) {
            refundRegisOrder.setUserAccount(regisOrder.getUserAccount());
        }
        if (BeanUtils.isNotEmpty((Object)regisOrder.getUserName())) {
            refundRegisOrder.setUserName(regisOrder.getUserName());
        }
        if (BeanUtils.isNotEmpty((Object)regisOrder.getUserPhone())) {
            refundRegisOrder.setUserPhone(regisOrder.getUserPhone());
        }
        refundRegisOrder.setPayType(6);
        Org payOrg = this.orgManager.getByCode("00001513");
        if (BeanUtils.isEmpty((Object)payOrg)) {
            throw new BaseException("\u672a\u627e\u5230\u7f16\u53f7\u4e3a\u301000001513\u3011\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6ce8\u518c");
        }
        refundRegisOrder.setPayUnitId(regisOrder.getCollectUnitId());
        refundRegisOrder.setPayUnitCode(regisOrder.getCollectUnitCode());
        refundRegisOrder.setPayUnitName(regisOrder.getCollectUnitName());
        refundRegisOrder.setPayAccount(regisOrder.getCollectAccount());
        refundRegisOrder.setPayAccountBank(regisOrder.getCollectAccountBank());
        refundRegisOrder.setPayTime(LocalDateTime.now());
        refundRegisOrder.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        refundRegisOrder.setPayAmount(regisOrder.getPayAmount());
        refundRegisOrder.setCollectUnitId(regisOrder.getPayUnitId());
        refundRegisOrder.setCollectUnitCode(regisOrder.getPayUnitCode());
        refundRegisOrder.setCollectUnitName(regisOrder.getPayUnitName());
        refundRegisOrder.setCollectAccount(regisOrder.getPayAccount());
        refundRegisOrder.setCollectAccountBank(regisOrder.getPayAccountBank());
        refundRegisOrder.setCollectTime(regisOrder.getPayTime());
        refundRegisOrder.setCollectTimer(regisOrder.getPayTimer());
        refundRegisOrder.setPayDescribe("\u9000\u8fd8\u4fdd\u8bc1\u91d1");
        super.save((Object)refundRegisOrder);
        ArrayList<BizRegistrationOrderDetails> detailedList = new ArrayList<BizRegistrationOrderDetails>();
        ForeignResponseVo res = null;
        TransVo transVo = new TransVo();
        try {
            BeanUtils.copyNotNullProperties((Object)transVo, (Object)((Object)refundRegisOrder));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            throw new BaseException(e.getMessage());
        }
        transVo.setStatementsCode(refundRegisOrder.getOrderNumber());
        transVo.setDepositPaymentStatus(refundRegisOrder.getPayStatus());
        BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
        detail.setRegistrationOrderId(refundRegisOrder.getId());
        detail.setRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
        detail.setUserId(refundRegisOrder.getUserId());
        detail.setUserName(refundRegisOrder.getUserName());
        detail.setUserAccount(refundRegisOrder.getUserAccount());
        if (BeanUtils.isNotEmpty((Object)refundRegisOrder.getUserPhone())) {
            detail.setUserPhone(refundRegisOrder.getUserPhone());
        }
        detail.setCompanyId(refundRegisOrder.getPayUnitId());
        detail.setCompanyCode(refundRegisOrder.getPayUnitCode());
        detail.setCompanyName(refundRegisOrder.getPayUnitName());
        detail.setNoticeId(refundRegisOrder.getNoticeId());
        detail.setNoticeType(refundRegisOrder.getNoticeType());
        detail.setNoticeTitle(userPart.getNoticeTitle());
        detail.setPayName(userPart.getNoticeTitle());
        detail.setRechargeNumber(BigDecimal.ONE);
        detail.setRechargePrice(refundRegisOrder.getPayAmount());
        detail.setSalesCompanyId(refundRegisOrder.getCollectUnitId());
        detail.setSalesCompanyCode(refundRegisOrder.getCollectUnitCode());
        detail.setSalesCompanyName(refundRegisOrder.getCollectUnitName());
        detailedList.add(detail);
        ArrayList<OrderDetailsVo> orderDetailsList = new ArrayList<OrderDetailsVo>();
        OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
        try {
            BeanUtils.copyNotNullProperties((Object)orderDetailsVo, (Object)((Object)detail));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            System.out.println("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
            throw new BaseException("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
        }
        orderDetailsVo.setPayType(6);
        orderDetailsList.add(orderDetailsVo);
        transVo.setOrderDetails(orderDetailsList);
        res = this.foreignCallService.callPay(transVo, 1);
        if (BeanUtil.isEmpty((Object)res, (String[])new String[0])) {
            throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25");
        }
        if (!res.getCode().equals("0")) {
            throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25:" + res.getMsg());
        }
        if (detailedList.size() > 0) {
            this.registrationOrderDetailsManager.saveBatch(detailedList);
        }
        regisOrder.setRefundStatus(3);
        regisOrder.setRefundOrderId(refundRegisOrder.getId());
        super.updateById((Object)regisOrder);
        userPart.setRefundRegistrationOrderId(refundRegisOrder.getId());
        userPart.setRefundRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
        this.userParticipationManager.updateById((Object)userPart);
    }
}

