/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BidDocumentsManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.model.BidDocuments;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.vo.QuoVo;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizBiddingQuotation/v1/"})
@Api(tags={"\u5f53\u524d\u62a5\u4ef7\u8868"})
@ApiGroup(group={"group_biz"})
public class BizBiddingQuotationController
extends BaseController<BizBiddingQuotationManager, BizBiddingQuotation> {
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private TenderDocumentManager tenderDocumentManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private BidDocumentsManager bidDocumentsManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizBiddingQuotation>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        PageList<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageQuoAndMatDetail"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e\uff08\u5305\u542b\u7269\u8d44\u7acb\u9879\u660e\u7ec6\uff09")
    public CommonResult<PageList<BizBiddingQuotation>> pageQuoAndMatDetail(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        PageList<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).pageQuoAndMatDetail(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageMatDetail"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e\uff08\u5305\u542b\u7269\u8d44\u7acb\u9879\u660e\u7ec6\uff09")
    public CommonResult<PageList<BizBiddingQuotation>> pageMatDetail(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        PageList<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).pageMatDetail(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageQuoOrg"})
    @ApiOperation(value="M-\u5206\u9875\u53bb\u91cd\u67e5\u8be2\u62a5\u4ef7\u5355\u4f4d\u53ca\u8bc4\u5206")
    public CommonResult<PageList<BizBiddingQuotation>> pageQuoOrg(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        PageList<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).pageQuoOrg(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageProDetail"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e\uff08\u5305\u542b\u9879\u76ee\u7acb\u9879\u660e\u7ec6\uff09")
    public CommonResult<PageList<BizBiddingQuotation>> pageProDetail(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        PageList<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).pageProDetail(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageLowestEva"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e\uff08\u5305\u542b\u6700\u4f4e\u4ef7\u6807\u8bc6\uff09")
    public CommonResult<PageList<BizBiddingQuotation>> pageLowestEva(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        PageList<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).pageLowestEva(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @PostMapping(value={"/quotationMat"})
    @ApiOperation(value="M-\u7269\u8d44\u62a5\u4ef7", httpMethod="POST")
    public CommonResult quoMat(@RequestBody QuoVo quoVo) {
        notice = quoVo.getMatApproval();
        matApproval = (MatApproval)this.matApprovalManager.getById((Serializable)notice.getId());
        if (LocalDateTime.now().isBefore(matApproval.getBiddingStartTime())) {
            return new CommonResult(false, "\u6295\u6807\u62a5\u4ef7\u6682\u672a\u5f00\u59cb\uff01");
        }
        if (LocalDateTime.now().isAfter(matApproval.getBiddingEndTime())) {
            return new CommonResult(false, "\u6295\u6807\u62a5\u4ef7\u5df2\u7ed3\u675f\uff01");
        }
        if (matApproval.getBidStatus() == 5) {
            return new CommonResult(false, "\u5df2\u5f00\u6807\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6295\u6807\u62a5\u4ef7\uff01");
        }
        confirmStatus = this.tenderDocumentManager.queryConfirmStatus(notice.getId());
        if (!confirmStatus.booleanValue()) {
            return new CommonResult(false, "\u6295\u6807\u62a5\u4ef7\u5931\u8d25\uff0c\u8bf7\u5148\u786e\u8ba4\u8865\u9057\u6587\u4ef6\uff01");
        }
        offerRedisKey = null;
        if (notice.getProcureType() == 3) {
            detailList = notice.getDetailsList();
            for (MatApprovalDetails detail : detailList) {
                quoPriceRedisKey = "quoPrice:" + detail.getId();
                priceObj = this.redisUtil.get(quoPriceRedisKey);
                if (!BeanUtils.isNotEmpty((Object)priceObj) || (quoPrice = (BigDecimal)priceObj).compareTo(detail.getMyPrice()) >= 0) continue;
                return new CommonResult(false, "\u6807\u7684ID\u3010" + detail.getId() + "\u3011\u62a5\u4ef7\u91d1\u989d\u4e0d\u80fd\u9ad8\u4e8e\u5f53\u524d\u6700\u4f4e\u62a5\u4ef7,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5...");
            }
            offerRedisKey = "offer:" + notice.getDetailsList().get(0).getId();
            obj = this.redisUtil.get(offerRedisKey);
            if (BeanUtils.isNotEmpty((Object)obj) && (isOffer = ((Boolean)obj).booleanValue())) {
                return new CommonResult(false, "\u5176\u4ed6\u4eba\u6b63\u5728\u62a5\u4ef7\u4e2d,\u8bf7\u7a0d\u540e\u5c1d\u8bd5...");
            }
            this.redisUtil.set(offerRedisKey, (Object)true, 60L);
        }
        try {
            ((BizBiddingQuotationManager)this.baseService).quoMat(quoVo);
            ** if (notice.getProcureType().intValue() != 3) goto lbl-1000
        }
        catch (Exception e) {
            block15: {
                try {
                    e.printStackTrace();
                    System.out.println("\u62a5\u4ef7\u5931\u8d25:" + e.getMessage());
                    var7_8 = new CommonResult(false, "\u62a5\u4ef7\u5931\u8d25:" + e.getMessage());
                    if (notice.getProcureType() != 3) break block15;
                }
                catch (Throwable var12_15) {
                    if (notice.getProcureType() == 3) {
                        this.redisUtil.set(offerRedisKey, (Object)false, 86400L);
                    }
                    throw var12_15;
                }
                this.redisUtil.set(offerRedisKey, (Object)false, 86400L);
            }
            return var7_8;
        }
lbl-1000:
        // 1 sources

        {
            this.redisUtil.set(offerRedisKey, (Object)false, 86400L);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (notice.getProcureType() == 3) {
            detailList = notice.getDetailsList();
            for (MatApprovalDetails detail : detailList) {
                quoPriceRedisKey = "quoPrice:" + detail.getId();
                this.redisUtil.set(quoPriceRedisKey, (Object)detail.getMyPrice(), 259200L);
            }
        }
        return new CommonResult(true, "\u62a5\u4ef7\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @PostMapping(value={"/quotationProject"})
    @ApiOperation(value="M-\u9879\u76ee\u62a5\u4ef7", httpMethod="POST")
    public CommonResult quoProject(@RequestBody QuoVo quoVo) {
        notice = quoVo.getProjectApproval();
        approval = (ProjectApproval)this.projectApprovalManager.getById((Serializable)notice.getId());
        if (LocalDateTime.now().isBefore(approval.getBiddingStartTime())) {
            return new CommonResult(false, "\u6295\u6807\u62a5\u4ef7\u6682\u672a\u5f00\u59cb\uff01");
        }
        if (LocalDateTime.now().isAfter(approval.getBiddingEndTime())) {
            return new CommonResult(false, "\u6295\u6807\u62a5\u4ef7\u5df2\u7ed3\u675f\uff01");
        }
        if (approval.getBidStatus() == 5) {
            return new CommonResult(false, "\u5df2\u5f00\u6807\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6295\u6807\u62a5\u4ef7\uff01");
        }
        confirmStatus = this.tenderDocumentManager.queryConfirmStatus(notice.getId());
        if (!confirmStatus.booleanValue()) {
            return new CommonResult(false, "\u6295\u6807\u62a5\u4ef7\u5931\u8d25\uff0c\u8bf7\u5148\u786e\u8ba4\u8865\u9057\u6587\u4ef6\uff01");
        }
        offerRedisKey = null;
        if (approval.getProcureType() == 3) {
            detailList = notice.getDetailsList();
            for (ProjectApprovalDetails detail : detailList) {
                quoPriceRedisKey = "quoPrice:" + detail.getId();
                priceObj = this.redisUtil.get(quoPriceRedisKey);
                if (!BeanUtils.isNotEmpty((Object)priceObj) || (quoPrice = (BigDecimal)priceObj).compareTo(detail.getMyPrice()) >= 0) continue;
                return new CommonResult(false, "\u6807\u7684ID\u3010" + detail.getId() + "\u3011\u62a5\u4ef7\u91d1\u989d\u4e0d\u80fd\u9ad8\u4e8e\u5f53\u524d\u6700\u4f4e\u62a5\u4ef7,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5...");
            }
            offerRedisKey = "offer:" + notice.getDetailsList().get(0).getId();
            obj = this.redisUtil.get(offerRedisKey);
            if (BeanUtils.isNotEmpty((Object)obj) && (isOffer = ((Boolean)obj).booleanValue())) {
                return new CommonResult(false, "\u5176\u4ed6\u4eba\u6b63\u5728\u62a5\u4ef7\u4e2d,\u8bf7\u7a0d\u540e\u5c1d\u8bd5...");
            }
            this.redisUtil.set(offerRedisKey, (Object)true, 60L);
        }
        if (BeanUtils.isNotEmpty((Object)approval) && approval.getIsBidDocumentsUpload() == 1) {
            bidDocuments = new BidDocuments();
            bidDocuments.setProjectApprovalType(2);
            bidDocuments.setProjectApprovalId(approval.getId());
            bidDocuments.setSupplierId(ContextUtil.getCurrentOrgId());
            bidDocuments.setQuotationRounds(BeanUtils.isNotEmpty((Object)approval.getQuotationRoundsNum()) != false ? approval.getQuotationRoundsNum() : 1);
            allSignStatus = this.bidDocumentsManager.getAllSignStatus(bidDocuments);
            if (allSignStatus == 0) {
                throw new BaseException("\u8bf7\u5148\u4e0a\u4f20\u6295\u6807\u6587\u4ef6\u540e\u91cd\u8bd5\u3010\u5982\u6295\u6807\u6587\u4ef6\u4e3a\u5728\u7ebf\u7b7e\u7f72\u8bf7\u7b7e\u7f72\u540e\u91cd\u8bd5\u3011");
            }
        }
        try {
            ((BizBiddingQuotationManager)this.baseService).quoProject(quoVo);
            ** if (notice.getProcureType().intValue() != 3) goto lbl-1000
        }
        catch (Exception e) {
            block17: {
                try {
                    e.printStackTrace();
                    System.out.println("\u62a5\u4ef7\u5931\u8d25:" + e.getMessage());
                    var7_8 = new CommonResult(false, "\u62a5\u4ef7\u5931\u8d25:" + e.getMessage());
                    if (notice.getProcureType() != 3) break block17;
                }
                catch (Throwable var12_15) {
                    if (notice.getProcureType() == 3) {
                        this.redisUtil.set(offerRedisKey, (Object)false, 86400L);
                    }
                    throw var12_15;
                }
                this.redisUtil.set(offerRedisKey, (Object)false, 86400L);
            }
            return var7_8;
        }
lbl-1000:
        // 1 sources

        {
            this.redisUtil.set(offerRedisKey, (Object)false, 86400L);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (notice.getProcureType() == 3) {
            detailList = notice.getDetailsList();
            for (ProjectApprovalDetails detail : detailList) {
                quoPriceRedisKey = "quoPrice:" + detail.getId();
                this.redisUtil.set(quoPriceRedisKey, (Object)detail.getMyPrice(), 259200L);
            }
        }
        return new CommonResult(true, "\u62a5\u4ef7\u6210\u529f");
    }

    @PostMapping(value={"/matBidOpenOrgData"})
    @ApiOperation(value="M-\u5f00\u6807\u7ba1\u7406-\u7269\u8d44\u67e5\u8be2\u516c\u53f8\u62a5\u4ef7")
    public CommonResult<MatApproval> matBidOpenOrgData(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        MatApproval result = ((BizBiddingQuotationManager)this.baseService).matBidOpenOrgData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/proBidOpenOrgData"})
    @ApiOperation(value="M-\u5f00\u6807\u7ba1\u7406-\u9879\u76ee\u67e5\u8be2\u516c\u53f8\u62a5\u4ef7")
    public CommonResult<ProjectApproval> proBidOpenOrgData(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        ProjectApproval result = ((BizBiddingQuotationManager)this.baseService).proBidOpenOrgData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/evaOrgQuoData"})
    @ApiOperation(value="M-\u8bc4\u6807\u7ba1\u7406-\u67e5\u8be2\u516c\u53f8\u603b\u62a5\u4ef7")
    public CommonResult<PageList<BizBiddingQuotation>> evaOrgQuoData(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizBiddingQuotation> queryFilter) {
        PageList<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).evaOrgQuoData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/evaOrgRankData"})
    @ApiOperation(value="M-\u5b9a\u6807\u7ba1\u7406-\u67e5\u8be2\u516c\u53f8\u8bc4\u5206\u6392\u540d")
    public CommonResult<List<BizBiddingQuotation>> evaOrgRankData(@RequestParam(value="noticeId") String noticeId) {
        List<BizBiddingQuotation> result = ((BizBiddingQuotationManager)this.baseService).evaOrgRankData(noticeId);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/exportDataToExcel"})
    @ApiOperation(value="M-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981")
    public CommonResult exportDataToExcel(@RequestBody QueryFilter<BizBiddingQuotation> queryFilter, HttpServletResponse response) throws IOException {
        ((BizBiddingQuotationManager)this.baseService).exportDataToExcel(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }
}

