/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.qualification.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.qualification.dao.BizQualificationCategoryDao;
import com.artfess.cgpt.qualification.manager.BizQualificationCategoryManager;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.manager.AdmissionConfigQualificationManager;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizQualificationCategoryManagerImpl
extends BaseManagerImpl<BizQualificationCategoryDao, BizQualificationCategory>
implements BizQualificationCategoryManager {
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private AdmissionConfigQualificationManager admissionConfigQualificationManager;

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizQualificationCategory entity) {
        if (BeanUtils.isEmpty((Object)entity.getCode())) {
            entity.setCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "zzbqzzbm"));
        }
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            this.existData(entity);
        }
        super.saveOrUpdate((Object)entity);
    }

    @Override
    public PageList<BizQualificationCategory> queryAllByPage(QueryFilter<BizQualificationCategory> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)0, QueryOP.EQUAL);
        IPage<BizQualificationCategory> iPage = ((BizQualificationCategoryDao)this.baseMapper).queryAllByPage((IPage<BizQualificationCategory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizQualificationCategory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        List categoryList = super.listByIds(ids);
        for (BizQualificationCategory data : categoryList) {
            this.existData(data);
        }
        super.removeByIds(ids);
    }

    void existData(BizQualificationCategory data) {
        LambdaQueryWrapper quaLabelQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)quaLabelQW.eq(BizQualificationLabel::getQualificationTypeCode, (Object)data.getCode())).eq(BizModel::getIsDele, (Object)"0");
        if (this.qualificationLabelManager.count((Wrapper)quaLabelQW) > 0) {
            throw new BaseException("\u8d44\u8d28\u7c7b\u578b\u7f16\u7801\u3010" + data.getCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        QueryFilter configQuaQF = QueryFilter.build();
        configQuaQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
        configQuaQF.addFilter("a.QUALIFICATION_CATEGORY_ID_", (Object)data.getId(), QueryOP.EQUAL);
        List configQuaList = this.admissionConfigQualificationManager.queryByPage((QueryFilter<AdmissionConfigQualification>)configQuaQF).getRows();
        if (BeanUtils.isNotEmpty((Object)configQuaList) && configQuaList.size() > 0) {
            throw new BaseException("\u8d44\u8d28\u7c7b\u578b\u7f16\u7801\u3010" + data.getCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
    }
}

