/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.aspect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.constants.SystemConstants;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.query.PageList;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.reader.TableHeaderDef;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.model.ExcelTemp;
import com.artfess.sysConfig.model.ExcelTempFields;
import com.artfess.sysConfig.persistence.manager.ExcelTempManager;
import com.artfess.sysConfig.vo.ExcelTempVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Aspect
@Component
public class ExportAspect {
    private static final Logger log = LoggerFactory.getLogger(ExportAspect.class);
    @Resource
    ExcelTempManager excelTempManager;

    @Pointcut(value="execution(public * com.artfess..*.*Controller.*(..))")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        HttpServletResponse response = attributes.getResponse();
        String export = request.getParameter("export");
        Object result = pjp.proceed();
        if ("export".equals(export)) {
            long start = System.currentTimeMillis();
            this.parseText(result, response, request);
            long end = System.currentTimeMillis();
            log.debug("\u5c01\u88c5excel\u6570\u636e  \u8017\u65f6" + (end - start) + "ms");
        } else if ("template".equals(export)) {
            this.parseTemplate(result, response, request);
        } else if ("import".equals(export)) {
            this.parseImport(pjp, response, request);
        }
        return result;
    }

    private void parseTemplate(Object result, HttpServletResponse response, HttpServletRequest request) {
        String tempId = request.getParameter("tempId");
        if (tempId.isEmpty()) {
            throw new BaseException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExcelTempVo vo = this.excelTempManager.getExcelTempByCode(tempId, 2);
        if (null == vo) {
            throw new BaseException("\u6a21\u677f\u53c2\u6570\u9519\u8bef");
        }
        ArrayList dataList = new ArrayList();
        ExcelTemp temp = vo.getExcelTemp();
        String fileName = temp.getTempFiles();
        List<ExcelTempFields> fields = vo.getFields();
        ArrayList<TableHeaderDef> headerDefList = new ArrayList<TableHeaderDef>();
        TableHeaderDef def = null;
        for (ExcelTempFields field : fields) {
            def = new TableHeaderDef();
            def.setKey(field.getFieldName());
            def.setName(field.getFieldComments());
            def.setComment(field.getFieldComments());
            headerDefList.add(def);
        }
        try {
            HSSFWorkbook book = ExcelUtil.exportExcel((String)"sheet1", (int)28, headerDefList, dataList);
            ExcelUtil.saveExcel((HSSFWorkbook)book, (String)fileName, (String)SystemConstants.TEMP_DATA_EXCEL);
            String file = SystemConstants.TEMP_DATA_EXCEL + File.separator + fileName + ".xls";
            FileInputStream is = new FileInputStream(new File(file));
            int len = 0;
            byte[] buffer = new byte[1024];
            ServletOutputStream out = response.getOutputStream();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(file.getBytes(), "iso-8859-1"));
            response.setContentType("application/octet-stream");
            while ((len = ((InputStream)is).read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            ((InputStream)is).close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseText(Object result, HttpServletResponse response, HttpServletRequest request) {
        IdGenerator id = new IdGenerator(0L, 1L);
        String tempId = request.getParameter("tempId");
        if (tempId.isEmpty()) {
            throw new BaseException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExcelTempVo vo = this.excelTempManager.getExcelTempByCode(tempId, 1);
        if (null == vo) {
            throw new BaseException("\u6a21\u677f\u53c2\u6570\u9519\u8bef");
        }
        ExcelTemp temp = vo.getExcelTemp();
        Integer type = temp.getType();
        List<ExcelTempFields> fields = vo.getFields();
        if (type == 1) {
            String jsonStr;
            String value;
            String fileName;
            HashMap<String, String> objectList;
            JSONObject item2;
            int i;
            JSONArray array;
            String json;
            ObjectMapper mapper;
            ArrayList dataList = new ArrayList();
            if (result instanceof PageList) {
                mapper = new ObjectMapper();
                json = "{}";
                try {
                    json = mapper.writeValueAsString((Object)((PageList)result).getRows());
                }
                catch (JsonProcessingException e) {
                    log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
                }
                array = JSONArray.parseArray((String)json);
                for (i = 0; i < array.size(); ++i) {
                    try {
                        item2 = array.getJSONObject(i);
                        objectList = new HashMap<String, String>();
                        for (ExcelTempFields key : fields) {
                            fileName = key.getFieldName();
                            value = item2.getString(ExportAspect.underlineToHump(fileName));
                            jsonStr = key.getFieldDataJson();
                            if (!StringUtils.isEmpty((CharSequence)jsonStr)) {
                                objectList.put(key.getFieldComments(), this.translateDictValue(jsonStr, value));
                                continue;
                            }
                            objectList.put(key.getFieldComments(), value);
                        }
                        dataList.add(objectList);
                        continue;
                    }
                    catch (Exception item2) {
                        // empty catch block
                    }
                }
            } else if (result instanceof ArrayList) {
                mapper = new ObjectMapper();
                json = "{}";
                try {
                    json = mapper.writeValueAsString(result);
                }
                catch (JsonProcessingException e) {
                    log.error("json\u89e3\u6790\u5931\u8d25" + e.getMessage(), (Throwable)e);
                }
                array = JSONArray.parseArray((String)json);
                for (i = 0; i < array.size(); ++i) {
                    try {
                        item2 = array.getJSONObject(i);
                        objectList = new HashMap();
                        for (ExcelTempFields key : fields) {
                            fileName = key.getFieldName();
                            value = item2.getString(ExportAspect.underlineToHump(fileName));
                            jsonStr = key.getFieldDataJson();
                            if (!StringUtils.isEmpty((CharSequence)jsonStr)) {
                                objectList.put(key.getFieldComments(), this.translateDictValue(jsonStr, value));
                                continue;
                            }
                            objectList.put(key.getFieldComments(), value);
                        }
                        dataList.add(objectList);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            String fileName2 = vo.getExcelTemp().getTempFiles();
            ArrayList<TableHeaderDef> headerDefList = new ArrayList<TableHeaderDef>();
            TableHeaderDef def = null;
            for (ExcelTempFields field : fields) {
                def = new TableHeaderDef();
                def.setKey(field.getFieldComments());
                def.setName(field.getFieldComments());
                def.setComment(field.getFieldComments());
                headerDefList.add(def);
            }
            try {
                HSSFWorkbook book = ExcelUtil.exportExcel((String)"sheet1", (int)28, headerDefList, dataList);
                ExcelUtil.saveExcel((HSSFWorkbook)book, (String)fileName2, (String)SystemConstants.TEMP_DATA_EXCEL);
                String file = SystemConstants.TEMP_DATA_EXCEL + File.separator + fileName2 + ".xls";
                FileInputStream is = new FileInputStream(new File(file));
                int len = 0;
                byte[] buffer = new byte[1024];
                ServletOutputStream out = response.getOutputStream();
                response.addHeader("Content-Disposition", "attachment;filename=" + new String(file.getBytes(), "iso-8859-1"));
                response.setContentType("application/octet-stream");
                while ((len = ((InputStream)is).read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                ((InputStream)is).close();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseImport(ProceedingJoinPoint pjp, HttpServletResponse response, HttpServletRequest request) {
        String userId = AuthenticationUtil.getCurrentUserId();
        String userName = AuthenticationUtil.getCurrentUsername();
        String orgId = AuthenticationUtil.getCurrentUserOrgIds();
        String mainOrgId = AuthenticationUtil.getCurrentUserMainOrgId();
        IUser currentUser = ContextUtil.getCurrentUser();
        String tenantId = currentUser.getTenantId();
        IdGenerator id = new IdGenerator(0L, 1L);
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        String tempId = request.getParameter("tempId");
        if (tempId.isEmpty()) {
            throw new BaseException("\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExcelTempVo vo = this.excelTempManager.getExcelTempByCode(tempId, 2);
        if (null == vo) {
            throw new BaseException("\u6a21\u677f\u53c2\u6570\u9519\u8bef");
        }
        ExcelTemp temp = vo.getExcelTemp();
        Integer type = temp.getType();
        List<ExcelTempFields> fields = vo.getFields();
        for (ExcelTempFields field : fields) {
            fieldMap.put(field.getFieldComments(), field.getFieldName());
        }
        if (type == 2) {
            Object[] obj;
            MultipartFile multipartFile = null;
            for (Object o : obj = pjp.getArgs()) {
                String typeClass = o.getClass().toString();
                if (typeClass.indexOf("MultipartFile") == -1) continue;
                multipartFile = (MultipartFile)o;
            }
            if (null == multipartFile) {
                return;
            }
            List list = ExcelUtil.ImportDate(multipartFile);
            StringBuffer insertField = new StringBuffer("id_,CREATE_BY_,CREATE_ORG_NAME_,CREATE_ORG_ID_,CREATE_DEPT_NAME_,CREATE_DEPT_ID_,CREATE_NAME_,CREATE_TIME_,TENANT_ID_,");
            StringBuffer valueField = new StringBuffer("?,'" + userId + "','" + ContextUtil.getCurrentOrgName() + "','" + ContextUtil.getCurrentOrgId() + "','" + ContextUtil.getCurrentDeptName() + "','" + ContextUtil.getCurrentDeptId() + "','" + userName + "',now(),'" + tenantId + "',");
            for (int i = 0; i < fields.size(); ++i) {
                ExcelTempFields f = fields.get(i);
                String tableField = StringUtil.humpToUnderline((String)((String)fieldMap.get(f.getFieldComments())));
                if (i < fields.size() - 1) {
                    insertField.append(f.getFieldName()).append(",");
                    valueField.append("?,");
                    continue;
                }
                insertField.append(f.getFieldName());
                valueField.append("?");
            }
            String insertSql = "insert into " + temp.getDbTable() + "(" + insertField + ") values(" + valueField + ")";
            LinkedList<Object[]> data = new LinkedList<Object[]>();
            for (Map map : list) {
                Object[] row = new Object[fields.size() + 1];
                row[0] = id.nextId();
                for (int i = 0; i < fields.size(); ++i) {
                    ExcelTempFields field = fields.get(i);
                    String key = field.getFieldComments();
                    String val = (String)map.get(key);
                    if (StringUtils.isEmpty((CharSequence)val)) {
                        row[i + 1] = null;
                        continue;
                    }
                    try {
                        Integer v = Integer.parseInt(val);
                        row[i + 1] = v;
                        continue;
                    }
                    catch (Exception e) {
                        row[i + 1] = val;
                    }
                }
                data.add(row);
            }
            try {
                JdbcTemplate jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
                jdbcTemplate.batchUpdate(insertSql, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ApplicationException(e.getMessage());
            }
        }
    }

    public MultipartFile getFile(HttpServletRequest request) {
        try {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile pic = multipartRequest.getFile("file");
            return pic;
        }
        catch (ClassCastException e) {
            log.info("\u6ca1\u6709\u9644\u4ef6");
            return null;
        }
    }

    private String translateDictValue(String JsonStr, String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JsonStr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!key.equals(jsonObject.getString("value"))) continue;
            String value = jsonObject.getString("label");
            return value;
        }
        return "";
    }

    public static String underlineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        for (String s : a = para.split("_")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }
}

