/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.cache.annotation.FirstCache;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.feign.FormFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.constant.DesignerType;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.event.BpmDefinitionDelEvent;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.engine.def.DefXmlTransForm;
import com.artfess.bpm.engine.def.impl.DefaultBpmDefConditionService;
import com.artfess.bpm.model.form.BpmForm;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.natapi.def.DefTransform;
import com.artfess.bpm.natapi.def.NatProDefinitionService;
import com.artfess.bpm.persistence.dao.ActTaskDao;
import com.artfess.bpm.persistence.dao.BpmDefinitionDao;
import com.artfess.bpm.persistence.dao.BpmProcessInstanceDao;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.artfess.bpm.persistence.manager.BpmDefDataManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmInstFormManager;
import com.artfess.bpm.persistence.manager.BpmProBoManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmSecretaryManageManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.model.AuthorizeRight;
import com.artfess.bpm.persistence.model.BpmDefData;
import com.artfess.bpm.persistence.model.BpmProBo;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.query.BpmDefFieldSorts;
import com.artfess.bpm.persistence.model.query.BpmDefQueryFields;
import com.artfess.bpm.persistence.util.BpmnXmlValidateUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BpmDefinitionManagerImpl
extends BaseManagerImpl<BpmDefinitionDao, DefaultBpmDefinition>
implements BpmDefinitionManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Resource
    BpmDefinitionDao bpmDefinitionDao;
    @Resource
    BpmDefDataManager bpmDefDataManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    NatProDefinitionService natProDefinitionService;
    @Resource
    DefXmlTransForm defXmlTransForm;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmProBoManager bpmProBoManager;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    IUserService userServiceImpl;
    @Resource
    ActTaskDao actTaskDao;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    DefaultBpmDefConditionService bpmDefHandler;
    @Resource
    BpmTaskNoticeManager bpmTaskNoticeManager;
    @Resource
    BpmTaskNoticeDoneManager bpmTaskNoticeDoneManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmProcessInstanceDao bpmProcessInstanceDao;
    @Resource
    BpmInstFormManager bpmInstFromManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    private void addCache(DefaultBpmDefinition def) {
        Assert.notNull((Object)def, (String)"\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u7a7a");
        String defId = def.getDefId();
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        bean.putDefInCache(def);
        bean.putBpmnDefIdInCache(def.getBpmnDefId(), defId);
        if (def.isMain()) {
            bean.putFlowKeyInCache(def.getDefKey(), defId);
        }
    }

    @CachePut(value={"bpm:bpm:definition"}, key="#def.defId")
    protected DefaultBpmDefinition putDefInCache(DefaultBpmDefinition def) {
        return def;
    }

    @CachePut(value={"bpm:bpm:definitionBpmnId"}, key="#bpmnDefId")
    protected String putBpmnDefIdInCache(String bpmnDefId, String defId) {
        return defId;
    }

    @CachePut(value={"bpm:bpm:definitionFlowKey"}, key="#flowKey")
    protected String putFlowKeyInCache(String flowKey, String defId) {
        return defId;
    }

    @Cacheable(value={"bpm:bpm:definition"}, key="#defId")
    protected DefaultBpmDefinition getFromCache(String defId) {
        return null;
    }

    @Cacheable(value={"bpm:bpm:definitionBpmnId"}, key="#bpmnDefId")
    protected String getDefIdByBpmnIdFromCache(String bpmnDefId) {
        return null;
    }

    private void publishEvent(BpmDefinition def) {
        List<DefaultBpmDefinition> defList = this.bpmDefinitionDao.getByDefKey(def.getDefKey());
        for (DefaultBpmDefinition defEntity : defList) {
            AppUtil.publishEvent((ApplicationEvent)new BpmDefinitionDelEvent(defEntity));
        }
    }

    @Override
    @Transactional
    public DefaultBpmDefinition getById(String entityId) {
        if (StringUtil.isEmpty((String)entityId)) {
            return null;
        }
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        DefaultBpmDefinition bpmDef = bean.getFromCache(entityId);
        if (bpmDef != null) {
            return bpmDef;
        }
        DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.get((Serializable)((Object)entityId));
        if (defaultBpmDefinition == null) {
            return null;
        }
        BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)entityId));
        defaultBpmDefinition.setBpmDefData(bpmDefData);
        this.addCache(defaultBpmDefinition);
        return defaultBpmDefinition;
    }

    @Override
    public DefaultBpmDefinition getMainByDefKey(String defKey) {
        return this.getMainByDefKey(defKey, false);
    }

    @Override
    public DefaultBpmDefinition getMainByDefKey(String defKey, boolean needData) {
        DefaultBpmDefinition bpmDef = this.bpmDefinitionDao.getMainByDefKey(defKey);
        if (BeanUtils.isEmpty((Object)bpmDef) || !needData) {
            return bpmDef;
        }
        BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)bpmDef.getDefId()));
        bpmDef.setBpmDefData(bpmDefData);
        return bpmDef;
    }

    @Transactional
    public void create(DefaultBpmDefinition entity) {
        super.create((Model)entity);
        if (StringUtil.isEmpty((String)entity.getBpmDefData().getId())) {
            entity.getBpmDefData().setId(entity.getDefId());
        }
        this.bpmDefDataManager.create((Model)entity.getBpmDefData());
    }

    @Transactional
    public void update(DefaultBpmDefinition entity) {
        super.update((Model)entity);
        if (StringUtil.isNotEmpty((String)entity.getBpmDefData().getId())) {
            this.bpmDefDataManager.update((Model)entity.getBpmDefData());
        }
        this.publishEvent(entity);
    }

    @Override
    @Transactional
    public void removeCascade(String defId) throws Exception {
        BpmDefinition bpmDef = (BpmDefinition)this.get((Serializable)((Object)defId));
        String defKey = bpmDef.getDefKey();
        List<DefaultBpmDefinition> defList = this.bpmDefinitionDao.getByDefKey(defKey);
        for (DefaultBpmDefinition def : defList) {
            this.publishEvent(def);
        }
        List<DefaultBpmProcessInstance> instList = this.bpmProcessInstanceManager.getListByBpmnDefKey(defKey);
        for (DefaultBpmProcessInstance inst : instList) {
            this.bpmProcessInstanceManager.physicsRemove(inst.getId());
        }
        if (StringUtil.isNotEmpty((String)bpmDef.getBpmnDefId())) {
            this.bpmDefinitionDao.delActTask(bpmDef.getBpmnDefId());
        }
        this.removeActviti(defKey);
        this.removeDef(defKey);
    }

    @Transactional
    private void removeDef(String defKey) throws Exception {
        this.bpmDefDataManager.delByDefKey(defKey);
        this.bpmDefinitionDao.delByKey(defKey);
        ObjectNode params = JsonUtil.getMapper().createObjectNode();
        params.put("flowKey", defKey);
        params.put("parentFlowKey", "");
        params.put("permissionType", 1);
        this.formRestfulService.removeFormRightByFlowKey(params);
        ObjectNode params1 = JsonUtil.getMapper().createObjectNode();
        params1.put("flowKey", defKey);
        params1.put("parentFlowKey", "");
        params1.put("permissionType", 2);
        this.formRestfulService.removeFormRightByFlowKey(params1);
    }

    @Transactional
    private void removeActviti(String defKey) {
        this.bpmDefinitionDao.delActByteArray(defKey);
        this.bpmDefinitionDao.delActDeploy(defKey);
        this.bpmDefinitionDao.delActRunIdentitylink(defKey);
        this.bpmDefinitionDao.delActRunVariable(defKey);
        this.bpmDefinitionDao.delActRunExecution(defKey);
        this.bpmDefinitionDao.delActDef(defKey);
    }

    @Override
    @Transactional
    public DefaultBpmDefinition cloneToMain(DefaultBpmDefinition bpmDefinition) {
        DefaultBpmDefinition newBpmDefinition = (DefaultBpmDefinition)bpmDefinition.clone();
        newBpmDefinition.setDefId(UniqueIdUtil.getSuid());
        newBpmDefinition.setIsMain("Y");
        Integer maxVersion = this.getMaxVersion(bpmDefinition.getDefKey());
        newBpmDefinition.setVersion(maxVersion);
        newBpmDefinition.setCreateTime(LocalDateTime.now());
        super.create((Model)newBpmDefinition);
        this.updMainVersion(newBpmDefinition.getDefId());
        newBpmDefinition.getBpmDefData().setId(newBpmDefinition.getDefId());
        this.bpmDefDataManager.create((Model)newBpmDefinition.getBpmDefData());
        return newBpmDefinition;
    }

    @Override
    public List<DefaultBpmDefinition> queryByDefKey(String defKey) {
        return this.bpmDefinitionDao.queryByDefKey(defKey);
    }

    @Override
    public List<DefaultBpmDefinition> queryHistorys(String defKey) {
        return this.bpmDefinitionDao.queryHistorys(defKey);
    }

    @Override
    public Integer getMaxVersion(String defKey) {
        Integer version = this.bpmDefinitionDao.getMaxVersion(defKey);
        if (version != null) {
            return version + 1;
        }
        return 1;
    }

    @Override
    public List<DefaultBpmDefinition> query(BpmDefQueryFields bpmDefQueryFields, FieldRelation fieldRelation, PageBean page) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setQuerys(bpmDefQueryFields.getQueryFields());
        queryFilter.setPageBean(page);
        return (List)this.query((QueryFilter<DefaultBpmDefinition>)queryFilter);
    }

    @Override
    public List<DefaultBpmDefinition> query(BpmDefQueryFields bpmDefQueryFields, FieldRelation fieldRelation, BpmDefFieldSorts bpmDefFieldSorts) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setQuerys(bpmDefQueryFields.getQueryFields());
        queryFilter.setSorter(bpmDefFieldSorts.getFieldSorts());
        queryFilter.setPageBean(null);
        return (List)this.query((QueryFilter<DefaultBpmDefinition>)queryFilter);
    }

    @Override
    public String getDefIdByBpmnDefId(String bpmnDefId) {
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        String defId = bean.getDefIdByBpmnIdFromCache(bpmnDefId);
        if (StringUtil.isNotEmpty((String)defId)) {
            return defId;
        }
        return this.bpmDefinitionDao.getDefIdByBpmnDefId(bpmnDefId);
    }

    @Override
    @Transactional
    public void updMainVersion(String entityId) {
        BpmDefinition def = (BpmDefinition)this.get((Serializable)((Object)entityId));
        this.bpmDefinitionDao.updateNotMainVersion(entityId);
        this.bpmDefinitionDao.updateToMainVersion(entityId);
        this.publishEvent(def);
    }

    @Override
    public DefaultBpmDefinition getByBpmnDefId(String bpmnDefId) {
        DefaultBpmDefinition bpmDef = null;
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        String defId = bean.getDefIdByBpmnIdFromCache(bpmnDefId);
        if (StringUtil.isNotEmpty((String)defId)) {
            bpmDef = bean.getFromCache(defId);
        }
        if (bpmDef == null) {
            bpmDef = this.bpmDefinitionDao.getByBpmnDefId(bpmnDefId);
        }
        return bpmDef;
    }

    @Override
    public DefaultBpmDefinition getByBpmnDeployId(String bpmnDeployId) {
        return this.bpmDefinitionDao.getByBpmnDeployId(bpmnDeployId);
    }

    @Override
    @Transactional
    public String updateBpmDefXml(String defId, String defXml) throws Exception {
        DefaultBpmDefinition bpmDefinition = (DefaultBpmDefinition)this.get((Serializable)((Object)defId));
        BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)defId));
        if (bpmDefData == null) {
            return null;
        }
        bpmDefData.setDefXml(defXml);
        DesignerType designType = DesignerType.valueOf(bpmDefinition.getDesigner());
        DefTransform trans = this.natProDefinitionService.getDefTransform(designType);
        String bpmnDefXml = trans.convert(bpmDefinition.getDefKey(), bpmDefinition.getName(), defXml);
        bpmDefData.setBpmnXml(bpmnDefXml);
        this.bpmDefDataManager.update((Model)bpmDefData);
        this.publishEvent(bpmDefinition);
        return bpmnDefXml;
    }

    @Override
    @Transactional
    public void updateStatus(String defId, String status) {
        this.bpmDefinitionDao.updateStatus(defId, status);
    }

    @Override
    @Transactional
    public void updBpmData(String defId, BpmDefData bpmDefData) {
        DefaultBpmDefinition bpmDefinition = (DefaultBpmDefinition)super.get((Serializable)((Object)defId));
        this.bpmDefDataManager.update((Model)bpmDefData);
        String deployId = bpmDefinition.getBpmnDeployId();
        this.natProDefinitionService.writeDefXml(deployId, bpmDefData.getBpmnXml());
        this.publishEvent(bpmDefinition);
    }

    @Override
    public List<String> queryByCreateBy(String userId) {
        return this.bpmDefinitionDao.queryDefKeyByCreateBy(userId);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            try {
                this.removeCascade(id);
            }
            catch (Exception e) {
                throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    @Override
    @Transactional
    public boolean deploy(BpmDefinition bpmDefinition) throws Exception {
        String bpmnXml;
        if (!this.isAvailable(bpmDefinition)) {
            return false;
        }
        boolean isNewDef = StringUtil.isEmpty((String)bpmDefinition.getDefId());
        boolean isDraft = false;
        String oldBpmnXml = "";
        if (isNewDef) {
            DefaultBpmDefinition mainBpmDefinition = this.getMainByDefKey(bpmDefinition.getDefKey(), false);
            if (mainBpmDefinition != null) {
                this.logger.error((Object)("defKey '" + bpmDefinition.getDefKey() + "' is exists "));
                return false;
            }
        } else {
            DefaultBpmDefinition tempDef = this.getById(bpmDefinition.getDefId());
            oldBpmnXml = tempDef.getBpmnXml();
            if (tempDef != null && StringUtil.isEmpty((String)tempDef.getBpmnDefId())) {
                isDraft = true;
            }
        }
        if (StringUtil.isEmpty((String)(bpmnXml = this.getBpmnXmlByDesignFile(bpmDefinition)))) {
            throw new RuntimeException("\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25\uff01\u6d41\u7a0b\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        }
        bpmnXml = this.updateBpmnXmlPlugins(bpmnXml, oldBpmnXml);
        ArrayList<BpmNodeDef> nodeDefs = new ArrayList();
        try {
            nodeDefs = BpmnXmlValidateUtil.getNodeDefs(bpmnXml);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u89e3\u6790\u5931\u8d25\uff08\u53ef\u80fd\u662f\u672a\u6267\u884c\u66f4\u65b0\u6d41\u7a0b\u5f15\u64ce\u64cd\u4f5c\uff09\uff1a" + e.getMessage());
        }
        ObjectNode msg = BpmnXmlValidateUtil.vilateBpmXml(nodeDefs);
        if (!msg.get("isTrue").asBoolean()) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u6821\u9a8c\u5931\u8d25\uff1a" + msg.get("errorMsgs").asText());
        }
        String deployId = null;
        String bpmnDefId = null;
        try {
            deployId = this.natProDefinitionService.deploy("", bpmDefinition.getName(), bpmnXml);
            bpmnDefId = this.natProDefinitionService.getProcessDefinitionIdByDeployId(deployId);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("Invoke natProDefinitionService.deploy method error = " + e.getMessage()));
            return false;
        }
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
        if (isNewDef) {
            def.setDefId(UniqueIdUtil.getSuid());
            def.setVersion(1);
            def.setMainDefId(bpmDefinition.getDefId());
            def.setIsMain("Y");
            def.setStatus("deploy");
            def.setTestStatus("test");
            def.setBpmnDefId(bpmnDefId);
            def.setBpmnDeployId(deployId);
            def.setBpmnXml(bpmnXml);
            def.setCreateTime(LocalDateTime.now());
            this.create(def);
        } else if (isDraft) {
            def.setStatus("deploy");
            def.setTestStatus("test");
            def.setVersion(1);
            def.setMainDefId(bpmDefinition.getDefId());
            def.setIsMain("Y");
            def.setBpmnDefId(bpmnDefId);
            def.setBpmnDeployId(deployId);
            def.setBpmnXml(bpmnXml);
            this.update(def);
        } else {
            DefaultBpmDefinition oldBpmDefinition = (DefaultBpmDefinition)bpmDefinition;
            oldBpmDefinition.setStatus("deploy");
            oldBpmDefinition.setTestStatus("test");
            oldBpmDefinition.setBpmnDefId(bpmnDefId);
            oldBpmDefinition.setBpmnDeployId(deployId);
            oldBpmDefinition.setBpmnXml(bpmnXml);
            DefaultBpmDefinition cloneToMain = this.cloneToMain(oldBpmDefinition);
            oldBpmDefinition.setId(cloneToMain.getId());
        }
        this.publishEvent(def);
        return true;
    }

    @Override
    @Transactional
    public boolean updateBpmDefinition(BpmDefinition bpmDefinition) throws Exception {
        if (!this.isAvailable(bpmDefinition)) {
            return false;
        }
        String bpmnXml = this.getBpmnXmlByDesignFile(bpmDefinition);
        if (StringUtil.isEmpty((String)bpmnXml)) {
            return false;
        }
        ArrayList<BpmNodeDef> nodeDefs = new ArrayList();
        try {
            nodeDefs = BpmnXmlValidateUtil.getNodeDefs(bpmnXml);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u89e3\u6790\u5931\u8d25\uff08\u53ef\u80fd\u662f\u672a\u6267\u884c\u66f4\u65b0\u6d41\u7a0b\u5f15\u64ce\u64cd\u4f5c\uff09\uff1a" + e.getMessage());
        }
        ObjectNode msg = BpmnXmlValidateUtil.vilateBpmXml(nodeDefs);
        if (!msg.get("isTrue").asBoolean()) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u6821\u9a8c\u5931\u8d25\uff1a" + msg.get("errorMsgs").asText());
        }
        DefaultBpmDefinition oldBpmDefinition = this.getById(bpmDefinition.getDefId());
        String oldBpmnXml = oldBpmDefinition.getBpmnXml();
        boolean isBpmnXmlChange = !(bpmnXml = this.updateBpmnXmlPlugins(bpmnXml, oldBpmnXml)).equals(bpmDefinition.getBpmnXml());
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
        if (isBpmnXmlChange) {
            if (StringUtil.isEmpty((String)def.getStatus())) {
                def.setStatus(oldBpmDefinition.getStatus());
            }
            def.setBpmnXml(bpmnXml);
            if (StringUtil.isNotEmpty((String)bpmDefinition.getBpmnDeployId())) {
                this.natProDefinitionService.writeDefXml(bpmDefinition.getBpmnDeployId(), bpmnXml);
            }
        }
        this.update(def);
        this.publishEvent(def);
        return true;
    }

    @Override
    @Transactional
    public boolean saveDraft(BpmDefinition bpmDefinition) throws Exception {
        if (bpmDefinition == null || StringUtil.isEmpty((String)bpmDefinition.getDefKey())) {
            // empty if block
        }
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
        String bpmnXml = this.getBpmnXmlByDesignFile(bpmDefinition);
        if (StringUtil.isEmpty((String)bpmnXml)) {
            throw new RuntimeException("\u6d41\u7a0b\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        def.setBpmnXml(bpmnXml);
        def.setIsMain("Y");
        def.setStatus("draft");
        def.setTestStatus("test");
        def.setVersion(0);
        String defId = UniqueIdUtil.getSuid();
        def.setDefId(defId);
        def.setMainDefId(defId);
        def.setCreateTime(LocalDateTime.now());
        this.create(def);
        return true;
    }

    private String getBpmnXmlByDesignFile(BpmDefinition bpmDefinition) throws Exception {
        String bpmnXml = "";
        DesignerType designType = DesignerType.valueOf(bpmDefinition.getDesigner());
        DefTransform trans = this.natProDefinitionService.getDefTransform(designType);
        if (DesignerType.WEB.name().equals(bpmDefinition.getDesigner())) {
            DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
            bpmnXml = trans.convert(bpmDefinition.getDefKey(), bpmDefinition.getName(), def.getDefJson());
        } else {
            bpmnXml = trans.convert(bpmDefinition.getDefKey(), bpmDefinition.getName(), bpmDefinition.getDefXml());
        }
        if (StringUtil.isNotEmpty((String)bpmDefinition.getDefId()) && DesignerType.WEB.name().equals(bpmDefinition.getDesigner())) {
            List<BpmNodeDef> nodeDefs = this.bpmDefinitionService.getAllBpmNodeDefs(bpmDefinition.getDefId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("xml", bpmnXml);
            this.copyBranchConfig(nodeDefs, map);
            bpmnXml = (String)map.get("xml");
        }
        return bpmnXml;
    }

    private void copyBranchConfig(List<BpmNodeDef> nodeDefs, Map<String, String> map) {
        if (BeanUtils.isEmpty(nodeDefs)) {
            return;
        }
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            if (NodeType.EXCLUSIVEGATEWAY.equals((Object)bpmNodeDef.getType()) || NodeType.INCLUSIVEGATEWAY.equals((Object)bpmNodeDef.getType())) {
                Map<String, String> conditionsMap = bpmNodeDef.getConditions();
                if (!BeanUtils.isNotEmpty(conditionsMap)) continue;
                try {
                    map.put("xml", DefaultBpmDefConditionService.converConditionXml(bpmNodeDef.getNodeId(), conditionsMap, map.get("xml")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!NodeType.SUBPROCESS.equals((Object)bpmNodeDef.getType())) continue;
            SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)bpmNodeDef;
            this.copyBranchConfig(subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs(), map);
        }
    }

    private String updateBpmnXmlPlugins(String newBpmnXml, String oldBpmnXml) {
        if (StringUtil.isEmpty((String)oldBpmnXml)) {
            return newBpmnXml;
        }
        String bpmnXml = this.defXmlTransForm.transform(oldBpmnXml, newBpmnXml);
        return bpmnXml;
    }

    private boolean isAvailable(BpmDefinition bpmDefinition) {
        if (bpmDefinition == null || StringUtil.isEmpty((String)bpmDefinition.getName()) || StringUtil.isEmpty((String)bpmDefinition.getDefKey())) {
            this.logger.error((Object)("DefaultBpmDefinitionService.deploy data error, bpmDefinition=" + bpmDefinition));
            return false;
        }
        return true;
    }

    @Override
    public PageList<DefaultBpmDefinition> queryList(QueryFilter queryFilter) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        return this.queryList(queryFilter, user);
    }

    @Override
    public PageList<DefaultBpmDefinition> queryList(QueryFilter queryFilter, IUser user) throws IOException {
        String oldDefKeys;
        String userId = user.getUserId();
        Map<String, ObjectNode> authorizeRightMap = null;
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            authorizeRightMap = this.getCommUserCondition(userId, queryFilter);
        }
        BpmSecretaryManageManager secretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map<String, Object> leaderHasRightShareDefs = secretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "1", true);
        HashMap defShareMap = new HashMap();
        HashSet allShareDefs = new HashSet();
        for (Map.Entry<String, Object> next : leaderHasRightShareDefs.entrySet()) {
            Map<String, Object> leaderActRightMap;
            String defKeys;
            String leaderId = next.getKey();
            Map value = (Map)next.getValue();
            Map leaderRightMap = (Map)value.get("groupMap");
            String shareDefKeys = (String)value.get("defKeys");
            if (StringUtil.isEmpty((String)shareDefKeys) || StringUtil.isEmpty((String)(defKeys = (String)(leaderActRightMap = this.bpmDefAuthorizeManager.getActRightByRightMapAndUserId(leaderId, "start", true, true, leaderRightMap)).get("defKeys")))) continue;
            defKeys = defKeys.replaceAll("'", "");
            HashSet<String> hasRightDefs = new HashSet<String>(Arrays.asList(defKeys.split(",")));
            HashSet<String> set = new HashSet<String>();
            set.addAll(hasRightDefs);
            if (!StringUtil.isNotEmpty((String)shareDefKeys)) continue;
            shareDefKeys = shareDefKeys.replaceAll("'", "");
            set.retainAll(new HashSet<String>(Arrays.asList(shareDefKeys.split(","))));
            for (String defKey : set) {
                Set<String> leaderIdSet = defShareMap.containsKey(defKey) ? (Set)defShareMap.get(defKey) : new HashSet();
                leaderIdSet.add(leaderId);
                defShareMap.put(defKey, leaderIdSet);
            }
            allShareDefs.addAll(set);
        }
        String string = oldDefKeys = BeanUtils.isEmpty(queryFilter.getParams().get("defKeys")) ? "''" : (String)queryFilter.getParams().get("defKeys");
        if (!allShareDefs.isEmpty()) {
            oldDefKeys = oldDefKeys + ",'" + StringUtil.join(new ArrayList(allShareDefs), (String)"','") + "'";
        }
        queryFilter.addParams("defKeys", (Object)oldDefKeys);
        PageList<DefaultBpmDefinition> list = this.query((QueryFilter<DefaultBpmDefinition>)queryFilter);
        if (list == null) {
            return list;
        }
        UCFeignService uCFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        ArrayNode users = uCFeignService.getUserByIdsOrAccounts(StringUtil.join(new ArrayList<String>(leaderHasRightShareDefs.keySet()), (String)","));
        HashMap<String, String> userNameMap = new HashMap<String, String>();
        for (JsonNode jsonNode : users) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            userNameMap.put(objectNode.get("id").asText(), objectNode.get("fullname").asText());
        }
        for (DefaultBpmDefinition bpmDefinition : list.getRows()) {
            ObjectNode authorizeRight = null;
            authorizeRight = isAdmin ? AuthorizeRight.getAdminRight() : authorizeRightMap.get(bpmDefinition.getDefKey());
            bpmDefinition.setAuthorizeRight(authorizeRight);
            if (!defShareMap.containsKey(bpmDefinition.getDefKey())) continue;
            ArrayList<BpmIdentity> lIdentities = new ArrayList<BpmIdentity>();
            lIdentities.add(new DefaultBpmIdentity("0", "\u81ea\u5df1", "user"));
            Set leaderIdSet = (Set)defShareMap.get(bpmDefinition.getDefKey());
            for (String leaderId : leaderIdSet) {
                lIdentities.add(new DefaultBpmIdentity(leaderId, (String)userNameMap.get(leaderId) + "(\u9886\u5bfc)", "user"));
            }
            bpmDefinition.setLeaders(lIdentities);
        }
        return list;
    }

    public PageList<DefaultBpmDefinition> query(QueryFilter<DefaultBpmDefinition> queryFilter) {
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty((Object)params) && (Integer)params.get("isAdmin") == 0) {
            String defKeys = (String)params.get("defKeys");
            if (BeanUtils.isEmpty((Object)defKeys)) {
                return new PageList();
            }
            queryFilter.addFilter("def_key_", (Object)defKeys, QueryOP.IN, FieldRelation.AND, "a");
        }
        queryFilter.setDefaultSort("createTime", Direction.DESC);
        queryFilter.setParams(new HashMap());
        return super.query(queryFilter);
    }

    private Map<String, ObjectNode> getCommUserCondition(String userId, QueryFilter queryFilter) throws IOException {
        Map<String, Object> actRightMap;
        String defKeys;
        String bpmDefAuthorizeRightType = "management";
        Map params = queryFilter.getParams();
        String right = (String)params.get("bpmDefAuthorizeRightType");
        if (StringUtil.isNotEmpty((String)right)) {
            bpmDefAuthorizeRightType = right;
        }
        if (StringUtil.isNotEmpty((String)(defKeys = (String)(actRightMap = this.bpmDefAuthorizeManager.getActRightByUserId(userId, bpmDefAuthorizeRightType, true, true)).get("defKeys")))) {
            queryFilter.addParams("defKeys", (Object)defKeys);
        }
        Map authorizeRightMap = (Map)actRightMap.get("authorizeRightMap");
        return authorizeRightMap;
    }

    @Override
    public Boolean canStartFlow(String defId) throws IOException {
        DefaultBpmDefinition definition = (DefaultBpmDefinition)this.get((Serializable)((Object)defId));
        if (BeanUtils.isEmpty((Object)definition)) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u6b64\u6d41\u7a0b");
        }
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL);
        queryFilter.addFilter("status_", (Object)"deploy", QueryOP.EQUAL);
        queryFilter.addParams("bpmDefAuthorizeRightType", (Object)"start");
        Map<String, ObjectNode> map = this.getCommUserCondition(userId, queryFilter);
        BpmSecretaryManageManager secretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map<String, Object> shareDefs = secretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "1", true);
        HashSet shareDefKeys = new HashSet();
        shareDefs.forEach((key, value) -> {
            Map v = (Map)value;
            String shareDefKey = (String)v.get("defKeys");
            if (StringUtil.isNotEmpty((String)shareDefKey)) {
                String[] keys;
                String keyStr = shareDefKey.replace("'", "");
                for (String k : keys = keyStr.split(",")) {
                    shareDefKeys.add(k);
                }
            }
        });
        return map.containsKey(definition.getDefKey()) || shareDefKeys.contains(definition.getDefKey());
    }

    @Override
    public List<DefaultBpmDefinition> queryListByMap(Map<String, Object> map) {
        return this.bpmDefinitionDao.queryListByMap(map);
    }

    @Override
    @Transactional
    public void updDefType(String typeId, String typeName, List<String> defList) {
        this.bpmDefinitionDao.updDefType(typeId, typeName, defList);
    }

    @Override
    @Transactional
    public void removeDefId(String defId) {
        BpmDefinition bpmDef = (BpmDefinition)super.get((Serializable)((Object)defId));
        if (bpmDef.isMain()) {
            throw new RuntimeException("\u975e\u7ea7\u8054\u5220\u9664\u65f6\uff0c\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u4e3b\u7248\u672c\u7684\u6d41\u7a0b\u5b9a\u4e49");
        }
        this.publishEvent(bpmDef);
        List<DefaultBpmProcessInstance> instList = this.bpmProcessInstanceManager.getListByDefId(defId);
        for (DefaultBpmProcessInstance inst : instList) {
            this.bpmProcessInstanceManager.physicsRemove(inst.getId());
        }
        this.removeActvitiByDefId(defId);
        this.removeDefByDefId(defId);
    }

    @Transactional
    private void removeDefByDefId(String defId) {
        this.bpmDefDataManager.remove((Serializable)((Object)defId));
        super.remove((Serializable)((Object)defId));
    }

    @Transactional
    private void removeActvitiByDefId(String defId) {
        this.bpmDefinitionDao.delActByteArrayByDefId(defId);
        this.bpmDefinitionDao.delActDeployByDefId(defId);
        this.bpmDefinitionDao.delActDefByDefId(defId);
    }

    @Override
    @Transactional
    public void removeDefIds(boolean cascade, Boolean isVersion, String ... defIds) throws Exception {
        for (String defId : defIds) {
            DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
            List<DefaultBpmProcessInstance> instances = null;
            instances = isVersion != false ? this.bpmProcessInstanceManager.getListByDefId(defId) : this.bpmProcessInstanceDao.getListByBpmnDefKey(defaultBpmDefinition.getDefKey());
            if (BeanUtils.isNotEmpty(instances)) {
                for (DefaultBpmProcessInstance entity : instances) {
                    List<DefaultBpmProcessInstance> instancesSub = this.bpmProcessInstanceDao.getByParentId(entity.getId());
                    if (!BeanUtils.isNotEmpty(instancesSub)) continue;
                    ArrayList<String> listStr = new ArrayList<String>();
                    for (DefaultBpmProcessInstance instance : instancesSub) {
                        String instId = instance.getId();
                        this.bpmProcessInstanceManager.remove((Serializable)((Object)instId));
                        this.bpmInstFromManager.removeDataByInstId(instId);
                        this.bpmTaskNoticeManager.delBpmTaskNoticeByInstId(instId);
                        this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByInstId(instId);
                        listStr.add(instId);
                    }
                    if (!BeanUtils.isNotEmpty(listStr)) continue;
                    this.bpmTaskTurnManager.delByInstList(listStr);
                }
            }
            List<DefaultBpmDefinition> listDefaultBpmDefinition = new ArrayList<DefaultBpmDefinition>();
            if (isVersion.booleanValue()) {
                listDefaultBpmDefinition.add(defaultBpmDefinition);
            } else {
                listDefaultBpmDefinition = this.bpmDefinitionManager.queryByDefKey(defaultBpmDefinition.getDefKey());
            }
            for (DefaultBpmDefinition entity : listDefaultBpmDefinition) {
                defId = entity.getDefId();
                DefaultBpmDefinition bpmDef = entity;
                this.bpmTaskNoticeManager.delBpmTaskNoticeByDefId(defId);
                this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByDefId(defId);
                List<DefaultBpmProcessInstance> list = this.bpmProcessInstanceManager.getListByDefId(defId);
                ArrayList<String> listStr = new ArrayList<String>();
                if (BeanUtils.isNotEmpty(list)) {
                    for (DefaultBpmProcessInstance defaultBpmProcessInstance : list) {
                        listStr.add(defaultBpmProcessInstance.getId());
                    }
                }
                if (BeanUtils.isNotEmpty(listStr)) {
                    this.bpmTaskTurnManager.delByInstList(listStr);
                }
                if (cascade) {
                    this.removeCascadeByDef(bpmDef);
                    continue;
                }
                this.removeDefByDef(bpmDef);
            }
        }
    }

    @Transactional
    public void removeCascadeByDef(BpmDefinition bpmDef) throws Exception {
        String defKey = bpmDef.getDefKey();
        List<DefaultBpmDefinition> defList = this.bpmDefinitionDao.getByDefKey(defKey);
        for (DefaultBpmDefinition def : defList) {
            this.publishEvent(def);
        }
        List<DefaultBpmProcessInstance> instList = this.bpmProcessInstanceManager.getListByBpmnDefKey(defKey);
        for (DefaultBpmProcessInstance inst : instList) {
            this.bpmProcessInstanceManager.physicsRemove(inst.getId());
        }
        if (StringUtil.isNotEmpty((String)bpmDef.getBpmnDefId())) {
            this.bpmDefinitionDao.delActTask(bpmDef.getBpmnDefId());
        }
        this.removeActviti(defKey);
        this.removeDef(defKey);
    }

    @Transactional
    public void removeDefByDef(BpmDefinition bpmDef) {
        if (bpmDef.isMain()) {
            throw new RuntimeException("\u975e\u7ea7\u8054\u5220\u9664\u65f6\uff0c\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u4e3b\u7248\u672c\u7684\u6d41\u7a0b\u5b9a\u4e49");
        }
        this.publishEvent(bpmDef);
        List<DefaultBpmProcessInstance> instList = this.bpmProcessInstanceManager.getListByDefId(bpmDef.getDefId());
        for (DefaultBpmProcessInstance inst : instList) {
            this.bpmProcessInstanceManager.physicsRemove(inst.getId());
        }
        this.removeActvitiByDefId(bpmDef.getDefId());
        this.removeDefByDefId(bpmDef.getDefId());
    }

    @Override
    @Transactional
    public void copyDef(String defId, String name, String defKey, String typeId, String typeName) throws Exception {
        DefaultBpmDefinition bpmDefinition = (DefaultBpmDefinition)super.get((Serializable)((Object)defId));
        BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)defId));
        String bpmnXml = bpmDefData.getBpmnXml();
        String oldDefKey = bpmDefinition.getDefKey();
        bpmnXml = this.updateBpmXml(bpmnXml, defKey, name);
        bpmDefinition.setDefKey(defKey);
        bpmDefinition.setName(name);
        bpmDefData.setBpmnXml(bpmnXml);
        String deployId = null;
        String bpmnDefId = null;
        try {
            deployId = this.natProDefinitionService.deploy("", bpmDefinition.getName(), bpmnXml);
            bpmnDefId = this.natProDefinitionService.getProcessDefinitionIdByDeployId(deployId);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("Invoke natProDefinitionService.deploy method error = " + e.getMessage()));
        }
        bpmDefinition.setDefId(UniqueIdUtil.getSuid());
        bpmDefinition.setVersion(1);
        bpmDefinition.setMainDefId(bpmDefinition.getDefId());
        bpmDefinition.setIsMain("Y");
        bpmDefinition.setStatus("deploy");
        bpmDefinition.setTestStatus("test");
        bpmDefinition.setDesc("");
        bpmDefinition.setBpmnDefId(bpmnDefId);
        bpmDefinition.setBpmnDeployId(deployId);
        bpmDefinition.setBpmnXml(bpmnXml);
        bpmDefData.setId(bpmDefinition.getDefId());
        bpmDefinition.setCreateTime(LocalDateTime.now());
        if (StringUtil.isNotEmpty((String)typeId)) {
            bpmDefinition.setTypeId(typeId);
        }
        if (StringUtil.isNotEmpty((String)typeName)) {
            bpmDefinition.setTypeName(typeName);
        }
        super.create((Model)bpmDefinition);
        this.bpmDefDataManager.create((Model)bpmDefData);
        this.copyBpmProByDefId(defId, bpmDefinition.getDefId());
        this.copyBpmFormRightByFlowKey(oldDefKey, defKey);
    }

    @Transactional
    private void copyBpmFormRightByFlowKey(String oldDefKey, String defKey) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("flow_key_", (Object)oldDefKey, QueryOP.EQUAL);
        queryFilter.addFilter("permission_type_", (Object)1, QueryOP.EQUAL);
        queryFilter.setPageBean(null);
        List lists = this.formRestfulService.queryFormRight(queryFilter);
        for (ObjectNode bpmFormRight : lists) {
            bpmFormRight.put("id", UniqueIdUtil.getSuid());
            bpmFormRight.put("flowKey", defKey);
            this.formRestfulService.createFormRight(bpmFormRight);
        }
    }

    @Transactional
    private void copyBpmProByDefId(String oldDefId, String newDefId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", oldDefId);
        List<BpmProBo> lists = this.bpmProBoManager.getByProcess(params);
        for (BpmProBo bpmProBo : lists) {
            bpmProBo.setId(UniqueIdUtil.getSuid());
            bpmProBo.setProcessId(newDefId);
            this.bpmProBoManager.create((Model)bpmProBo);
        }
    }

    @Transactional
    private String updateBpmXml(String bpmnXml, String defKey, String name) {
        Document loadXml = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = loadXml.getRootElement();
        List nodes = root.elements("process");
        if (nodes != null && nodes.size() == 1) {
            Element element = (Element)nodes.get(0);
            element.attribute("id").setText(defKey);
            element.attribute("name").setText(name);
        }
        return Dom4jUtil.docToString((Document)loadXml);
    }

    @Override
    @Transactional
    public void updBpmDefinitionStatus(DefaultBpmDefinition bpmDefinition, String oldStatus) throws Exception {
    }

    @Override
    public DefaultBpmDefinition getBpmDefinitionByRev(Map<String, Object> map) {
        return this.bpmDefinitionDao.getBpmDefinitionByRev(map);
    }

    @Override
    @Transactional
    public void updateTypeIdByDefKey(String defKey, String typeId) {
        this.bpmDefinitionDao.updateInstTypeIdByDefKey(defKey, typeId);
        this.bpmDefinitionDao.updateInstHiTypeIdByDefKey(defKey, typeId);
        this.bpmDefinitionDao.updateTaskTypeIdByDefKey(defKey, typeId);
        this.bpmDefinitionDao.updateTaskNoticeTypeIdByDefKey(defKey, typeId);
    }

    @Override
    @Transactional
    public CommonResult<String> setDefType(String typeName, String typeId, List<String> defIds) {
        this.bpmDefinitionDao.updDefType(typeId, typeName, defIds);
        return new CommonResult("\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public List<Map<String, Object>> getDefCount(QueryFilter queryFilter) throws Exception {
        String oldDefKeys;
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        Map<String, ObjectNode> authorizeRightMap = null;
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            authorizeRightMap = this.getCommUserCondition(userId, queryFilter);
        }
        BpmSecretaryManageManager secretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map<String, Object> leaderHasRightShareDefs = secretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "1", true);
        HashMap defShareMap = new HashMap();
        HashSet allShareDefs = new HashSet();
        for (Map.Entry<String, Object> next : leaderHasRightShareDefs.entrySet()) {
            Map<String, Object> leaderActRightMap;
            String defKeys;
            String leaderId = next.getKey();
            Map value = (Map)next.getValue();
            Map laederRightMap = (Map)value.get("groupMap");
            String shaerDefKeys = (String)value.get("defKeys");
            if (StringUtil.isEmpty((String)shaerDefKeys) || StringUtil.isEmpty((String)(defKeys = (String)(leaderActRightMap = this.bpmDefAuthorizeManager.getActRightByRightMapAndUserId(leaderId, "start", true, true, laederRightMap)).get("defKeys")))) continue;
            defKeys = defKeys.replaceAll("'", "");
            HashSet<String> hasRightDefs = new HashSet<String>(Arrays.asList(defKeys.split(",")));
            HashSet<String> set = new HashSet<String>();
            set.addAll(hasRightDefs);
            if (!StringUtil.isNotEmpty((String)shaerDefKeys)) continue;
            shaerDefKeys = shaerDefKeys.replaceAll("'", "");
            set.retainAll(new HashSet<String>(Arrays.asList(shaerDefKeys.split(","))));
            for (String defKey : set) {
                Set<String> leaderIdSet = defShareMap.containsKey(defKey) ? (Set)defShareMap.get(defKey) : new HashSet();
                leaderIdSet.add(leaderId);
                defShareMap.put(defKey, leaderIdSet);
            }
            allShareDefs.addAll(set);
        }
        String string = oldDefKeys = BeanUtils.isEmpty(queryFilter.getParams().get("defKeys")) ? "''" : (String)queryFilter.getParams().get("defKeys");
        if (!allShareDefs.isEmpty()) {
            oldDefKeys = oldDefKeys + ",'" + StringUtil.join(new ArrayList(allShareDefs), (String)"','") + "'";
        }
        queryFilter.addParams("defKeys", (Object)oldDefKeys);
        this.copyQuerysInParams(queryFilter);
        return this.bpmDefinitionDao.getDefCount((Wrapper<DefaultBpmDefinition>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<String> queryByTypeId(List<String> typeIds) {
        return ((BpmDefinitionDao)this.baseMapper).queryDefKeyByTypeId(typeIds);
    }

    @Override
    public Map<String, Object> getBindRelation(String defId) throws Exception {
        FormExt mobileFrm;
        BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        String defKey = bpmProcessDefExt.getDefKey();
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        FormExt frm = defExt.getGlobalForm();
        HashMap<String, String> pcForm = new HashMap<String, String>();
        HashMap<String, String> mobileForm = new HashMap<String, String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.get((Serializable)((Object)defId));
        DefaultBpmDefinition mainByDefKey = this.getMainByDefKey(defKey);
        String mainDefId = mainByDefKey.getDefId();
        String name = mainByDefKey.getName();
        result.put("defKey", defKey);
        result.put("mainDefId", mainDefId);
        result.put("defName", name);
        result.put("version", defaultBpmDefinition.getVersion());
        if (frm != null) {
            pcForm.put("pcName", frm.getName());
            pcForm.put("pcAlias", frm.getFormValue());
            ObjectNode objectNode = this.formRestfulService.getByFormKey(frm.getFormValue());
            BpmForm bpmForm = (BpmForm)JsonUtil.toBean((JsonNode)objectNode, BpmForm.class);
            pcForm.put("pcDefId", bpmForm.getDefId());
            pcForm.put("pcFormId", bpmForm.getId());
            Map pcEnt = this.formRestfulService.getFormData(frm.getFormValue(), "");
            result.put("pcForm", pcForm);
            result.put("pcEnt", pcEnt.get("pcEnt"));
        }
        if ((mobileFrm = defExt.getGlobalMobileForm()) != null) {
            mobileForm.put("mobileName", mobileFrm.getName());
            mobileForm.put("mobileAlias", mobileFrm.getFormValue());
            ObjectNode objectNode = this.formRestfulService.getByFormKey(mobileFrm.getFormValue());
            BpmForm bpmForm = (BpmForm)JsonUtil.toBean((JsonNode)objectNode, BpmForm.class);
            mobileForm.put("mobileDefId", bpmForm.getDefId());
            mobileForm.put("mobileFormId", bpmForm.getId());
            Map mobileEnt = this.formRestfulService.getFormData("", mobileFrm.getFormValue());
            result.put("mobileForm", mobileForm);
            result.put("mobileEnt", mobileEnt.get("mobileEnt"));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> bpmDefinitionData(String alias) {
        return this.bpmDefinitionDao.getBpmDefinitionData(alias);
    }

    @Override
    @CachePut(value={"bpm:bpm:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"bpm:bpm:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"bpm:bpm:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }
}

