/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.DataSharingDao;
import com.artfess.cgpt.supplier.manager.DataSharingDetailManager;
import com.artfess.cgpt.supplier.manager.DataSharingManager;
import com.artfess.cgpt.supplier.model.DataSharing;
import com.artfess.cgpt.supplier.model.DataSharingDetail;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSharingManagerImpl
extends BaseManagerImpl<DataSharingDao, DataSharing>
implements DataSharingManager {
    @Autowired
    private DataSharingDetailManager dataSharingDetailManager;

    @Override
    public PageList<DataSharing> queryByPage(QueryFilter<DataSharing> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<DataSharing> result = ((DataSharingDao)this.baseMapper).queryAllByPage((IPage<DataSharing>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<DataSharing>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(DataSharing entity) {
        List<DataSharingDetail> detailList = entity.getDetailList();
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
            detailQW.eq(DataSharingDetail::getDataSharingId, (Object)entity.getId());
            this.dataSharingDetailManager.remove((Wrapper)detailQW);
        }
        IGroup group = ContextUtil.getCurrentGroup();
        entity.setOrgId(group.getGroupId());
        entity.setOrgCode(group.getGroupCode());
        entity.setOrgName(group.getName());
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.forEach(s -> s.setDataSharingId(entity.getId()));
            this.dataSharingDetailManager.saveBatch(detailList);
        }
    }

    @Override
    public DataSharing getDataById(String id) {
        DataSharing result = (DataSharing)((Object)super.getById((Serializable)((Object)id)));
        QueryFilter detailQF = QueryFilter.build();
        detailQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
        detailQF.addFilter("a.DATA_SHARING_ID_", (Object)id, QueryOP.EQUAL);
        List detailList = this.dataSharingDetailManager.queryAllByPage((QueryFilter<DataSharingDetail>)detailQF).getRows();
        result.setDetailList(detailList);
        return result;
    }

    @Override
    public List<String> getBizIdsByOrg(String orgId) {
        return ((DataSharingDao)this.baseMapper).getBizIdsByOrgId(orgId);
    }

    @Override
    @Transactional
    public void removeByIds(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        super.removeByIds(idList);
        LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
        detailQW.in(DataSharingDetail::getDataSharingId, idList);
        this.dataSharingDetailManager.remove((Wrapper)detailQW);
    }
}

