/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.dao.BizMaterialDao;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.material.vo.MaterialVo;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class BizMaterialManagerImpl
extends BaseManagerImpl<BizMaterialDao, BizMaterial>
implements BizMaterialManager {
    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private PlatMaterialManager platMaterialManager;
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private EnterpriseManager enterpriseManager;

    @Override
    public PageList<BizMaterial> queryAllByPage(QueryFilter<BizMaterial> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<BizMaterial> materialIPage = ((BizMaterialDao)this.baseMapper).queryAllByPage((IPage<BizMaterial>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizMaterial>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(materialIPage);
    }

    @Override
    public void exportExcelData(QueryFilter<BizMaterial> queryFilter, HttpServletResponse response) throws IOException {
        BizUtils.addFilterByHisOrgCodeAndRole(queryFilter, this.ucFeignService, "MAT_COMPANY_CODE_", this.enterpriseManager);
        PageList<BizMaterial> bizMaterialPageList = this.queryAllByPage(queryFilter);
        List data = bizMaterialPageList.getRows();
        String fileName = "\u4f01\u4e1a\u7269\u6599-\u5bfc\u51fa\u6570\u636e";
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BizMaterial.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    @Transactional
    public void updateMatCategory(List<String> ids, String categoryCode) {
        LambdaUpdateWrapper materialUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)materialUW.set(BizMaterial::getMatCategory, (Object)categoryCode)).in(BizMaterial::getId, ids)).eq(BizMaterial::getMatStatus, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)materialUW);
    }

    @Override
    @Transactional
    public void updateMatStatus(List<String> ids, String status) {
        List materials = super.listByIds(ids);
        List platCodes = materials.stream().map(s -> s.getMatPlatcode()).collect(Collectors.toList());
        if (status.equals("0")) {
            QueryWrapper applicationDetailQW = new QueryWrapper();
            applicationDetailQW.select(new String[]{"DISTINCT MAT_PLATCODE_"}).lambda().in(PurchasingApplicationDetails::getMatId, ids);
            List objList = this.applicationDetailsManager.listObjs((Wrapper)applicationDetailQW);
            if (BeanUtils.isNotEmpty((Object)objList) && objList.size() > 0) {
                List matPlatCodes = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("\u5e73\u53f0\u7269\u6599\u7f16\u53f7\u3010" + String.join((CharSequence)",", matPlatCodes) + "\u3011\u5df2\u6709\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u7981\u7528");
            }
        } else {
            QueryWrapper platMaterialQW = new QueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)platMaterialQW.select(new String[]{"DISTINCT MAT_PLATCODE_"}).lambda().in(PlatMaterial::getMatPlatcode, platCodes)).eq(PlatMaterial::getMatStatus, (Object)0)).eq(BizModel::getIsDele, (Object)"0");
            List objList = this.platMaterialManager.listObjs((Wrapper)platMaterialQW);
            if (BeanUtils.isNotEmpty((Object)objList) && objList.size() > 0) {
                List tempMatPlatCodes = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("\u5e73\u53f0\u7269\u6599\u3010" + String.join((CharSequence)",", tempMatPlatCodes) + "\u3011\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u542f\u7528");
            }
        }
        LambdaUpdateWrapper materialUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)materialUW.set(BizMaterial::getMatStatus, (Object)status)).in(BizMaterial::getId, ids)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)materialUW);
    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(JSONObject param) {
        String code = "0";
        String message = "\u64cd\u4f5c\u6210\u529f";
        String errDetail = "";
        try {
            List data = JSONUtil.toList((JSONArray)param.getJSONArray((Object)"data"), MaterialVo.class);
            for (MaterialVo temp : data) {
                List<String> platCodes = Arrays.asList("01,02,03,04,07".split(","));
                if (platCodes.contains(temp.getMatCategory().substring(0, 2))) {
                    temp.setMatIfPlat(1);
                } else {
                    temp.setMatIfPlat(0);
                }
                BizMaterial material = new BizMaterial();
                BeanUtils.copyNotNullProperties((Object)((Object)material), (Object)temp);
                material.setMatTransferTime(LocalDateTime.now());
                if (BeanUtils.isEmpty((Object)material.getMatTaxrate())) {
                    material.setMatTaxrate(13);
                }
                material.setAuditStatus("1");
                PlatMaterial platMaterial = new PlatMaterial();
                BeanUtils.copyNotNullProperties((Object)((Object)platMaterial), (Object)((Object)material));
                LambdaQueryWrapper platMaterialQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)platMaterialQW.eq(PlatMaterial::getMatPlatcode, (Object)material.getMatPlatcode())).eq(BizModel::getIsDele, (Object)"0");
                this.platMaterialManager.saveOrUpdate((Object)platMaterial, (Wrapper)platMaterialQW);
                if (!BeanUtils.isNotEmpty((Object)temp.getMatCompany()) || null == temp.getMatCompany()) continue;
                material.setMatCompanyCode(temp.getMatCompany());
                LambdaQueryWrapper qw = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(BizMaterial::getMatPlatcode, (Object)material.getMatPlatcode())).eq(BizMaterial::getMatCompanyCode, (Object)material.getMatCompanyCode())).eq(BizModel::getIsDele, (Object)"0");
                super.saveOrUpdate((Object)material, (Wrapper)qw);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "\u64cd\u4f5c\u5931\u8d25:" + errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return new Response<String>(code, message, errDetail);
    }
}

