/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.dao.TenderDocumentDao;
import com.artfess.cgpt.purchasing.manager.TenderDocumentConfirmManager;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.TenderDocument;
import com.artfess.cgpt.purchasing.model.TenderDocumentConfirm;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenderDocumentManagerImpl
extends BaseManagerImpl<TenderDocumentDao, TenderDocument>
implements TenderDocumentManager {
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private TenderDocumentConfirmManager tenderDocumentConfirmManager;

    @Override
    public Boolean queryConfirmStatus(String noticeId) {
        LambdaQueryWrapper tdQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tdQW.select(new SFunction[]{TenderDocument::getId}).eq(BizModel::getIsDele, (Object)"0")).eq(TenderDocument::getProjectApprovalId, (Object)noticeId)).eq(TenderDocument::getReleaseStatus, (Object)2)).eq(TenderDocument::getIsVendorConfirm, (Object)2)).eq(TenderDocument::getType, (Object)2);
        List objList = super.listObjs((Wrapper)tdQW);
        if (BeanUtils.isNotEmpty((Object)objList) && objList.size() > 0) {
            List collect = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            LambdaQueryWrapper confirmQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)confirmQW.in(TenderDocumentConfirm::getTenderDocumentId, collect)).eq(TenderDocumentConfirm::getVendorId, (Object)ContextUtil.getCurrentOrgId());
            int count = this.tenderDocumentConfirmManager.count((Wrapper)confirmQW);
            if (count != collect.size()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Boolean queryConfirmStatus(QueryFilter<TenderDocument> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List records = ((TenderDocumentDao)this.baseMapper).queryAllByPage((IPage<TenderDocument>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<TenderDocument>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            List collect = records.stream().map(s -> s.getId()).collect(Collectors.toList());
            LambdaQueryWrapper confirmQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)confirmQW.in(TenderDocumentConfirm::getTenderDocumentId, collect)).eq(TenderDocumentConfirm::getVendorId, (Object)ContextUtil.getCurrentOrgId());
            int count = this.tenderDocumentConfirmManager.count((Wrapper)confirmQW);
            if (count != collect.size()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public PageList<TenderDocument> queryAllByPage(QueryFilter<TenderDocument> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<TenderDocument> result = ((TenderDocumentDao)this.baseMapper).queryAllByPage((IPage<TenderDocument>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TenderDocument>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<TenderDocument> pageAccessory(QueryFilter<TenderDocument> queryFilter) {
        String orgId = ContextUtil.getCurrentOrgId();
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<TenderDocument> result = ((TenderDocumentDao)this.baseMapper).queryAllByPage((IPage<TenderDocument>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<TenderDocument>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (TenderDocument td : records) {
                td.setAccessoryList(this.accessoryService.getAccessoryBySourceId(td.getId()));
                td.setConfirmStatus(0);
                if (td.getIsVendorConfirm() != 2 || !BeanUtils.isNotEmpty((Object)orgId)) continue;
                LambdaQueryWrapper confirmQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)confirmQW.eq(TenderDocumentConfirm::getVendorId, (Object)orgId)).eq(TenderDocumentConfirm::getTenderDocumentId, (Object)td.getId());
                if (this.tenderDocumentConfirmManager.count((Wrapper)confirmQW) <= 0) continue;
                td.setConfirmStatus(1);
            }
        }
        return new PageList(result);
    }

    @Override
    @Transactional
    public void modifyReleaseStatus(String ids, String status) {
        LambdaUpdateWrapper tenderUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)tenderUW.set(TenderDocument::getReleaseStatus, (Object)status)).in(TenderDocument::getId, Arrays.asList(ids.split(",")));
        super.update((Wrapper)tenderUW);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        super.removeByIds(ids);
        this.accessoryService.removeBySourceIds(ids);
    }

    @Override
    @Transactional
    public void uploadByDoc(List<TenderDocument> docList) {
        if (BeanUtils.isNotEmpty(docList) && docList.size() > 0) {
            for (TenderDocument byDocument : docList) {
                List<Accessory> accessoryList = byDocument.getAccessoryList();
                if (!BeanUtils.isNotEmpty(accessoryList) || accessoryList.size() <= 0) continue;
                byDocument.setType(2);
                byDocument.setReleaseStatus(1);
                super.save((Object)byDocument);
                accessoryList.stream().forEach(accessory -> accessory.setSourceId(byDocument.getId()));
                this.accessoryService.saveBatch(accessoryList);
            }
        }
    }
}

