/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.BizBidEvaluationDao;
import com.artfess.cgpt.bidding.manager.BidEvaluationDetailManager;
import com.artfess.cgpt.bidding.manager.BiddingQuotationTemplateDetailDataManager;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.CalibrationDetailManager;
import com.artfess.cgpt.bidding.manager.CalibrationManager;
import com.artfess.cgpt.bidding.model.BidEvaluationDetail;
import com.artfess.cgpt.bidding.model.BiddingQuotationTemplateDetailData;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.Calibration;
import com.artfess.cgpt.bidding.model.CalibrationDetail;
import com.artfess.cgpt.bidding.vo.EvaVo;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizBidEvaluationManagerImpl
extends BaseManagerImpl<BizBidEvaluationDao, BizBidEvaluation>
implements BizBidEvaluationManager {
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private MatApprovalDetailsManager matDetailsManager;
    @Autowired
    private ProjectApprovalDetailsManager paDetailManager;
    @Autowired
    private CalibrationDetailManager calibrationDetailManager;
    @Autowired
    private CalibrationManager calibrationManager;
    @Autowired
    private BidEvaluationDetailManager evaluationDetailManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private BiddingQuotationTemplateDetailDataManager quotationTemplateDetailDataManager;
    @Autowired
    private ProjectApprovalDetailsManager projectDetailsManager;

    @Override
    public PageList<BizBidEvaluation> queryAllByPage(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizBidEvaluation> result = ((BizBidEvaluationDao)this.baseMapper).queryAllByPage((IPage<BizBidEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveOrUpdateEntity(BizBidEvaluation entity) {
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        super.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional
    public void saveByEva(List<BizBidEvaluation> data) {
        LambdaUpdateWrapper noticeUW;
        for (BizBidEvaluation entity : data) {
            entity.setOperateTime(LocalDateTime.now());
            entity.setOperateUserId(ContextUtil.getCurrentUserId());
            entity.setOperateUserName(ContextUtil.getCurrentUserName());
        }
        super.saveOrUpdateBatch(data);
        BizBidEvaluation bidEvaluation = data.get(0);
        if (bidEvaluation.getNoticeType() == 1) {
            noticeUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeUW.set(MatApproval::getBidStatus, (Object)6)).eq(MatApproval::getId, (Object)bidEvaluation.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            this.matApprovalManager.update((Wrapper)noticeUW);
        } else {
            noticeUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeUW.set(ProjectApproval::getBidStatus, (Object)6)).eq(ProjectApproval::getId, (Object)bidEvaluation.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            this.projectApprovalManager.update((Wrapper)noticeUW);
        }
    }

    @Override
    @Transactional
    public void saveByEva(BizBidEvaluation entity) {
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BizBidEvaluation::getNoticeId, (Object)entity.getNoticeId())).eq(BizBidEvaluation::getQuotationOrgId, (Object)entity.getQuotationOrgId())).eq(BizModel::getIsDele, (Object)"0")).last("limit 1");
        BizBidEvaluation evaHis = (BizBidEvaluation)((Object)((BizBidEvaluationDao)this.baseMapper).selectOne((Wrapper)hisQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaHis))) {
            // empty if block
        }
        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        entity.setNoticeCode(notice.getProjectNumber());
        entity.setNoticeName(notice.getNoticeTitle());
        entity.setProcureOrgId(notice.getProcureOrgId());
        entity.setProcureOrgCode(notice.getProcureOrgCode());
        entity.setProcureOrgName(notice.getProcureOrgName());
        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(2);
        super.save((Object)entity);
        this.evaluationDetailManager.saveBatch(evaDetailList);
        if (entity.getNoticeType() == 1) {
            LambdaUpdateWrapper noticeUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeUW.set(MatApproval::getBidStatus, (Object)6)).eq(MatApproval::getId, (Object)entity.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            this.matApprovalManager.update((Wrapper)noticeUW);
        } else {
            LambdaUpdateWrapper noticeUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeUW.set(ProjectApproval::getBidStatus, (Object)6)).eq(ProjectApproval::getId, (Object)entity.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            this.projectApprovalManager.update((Wrapper)noticeUW);
        }
    }

    @Override
    @Transactional
    public void saveByEvaMat(BizBidEvaluation entity) {
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BizBidEvaluation::getNoticeId, (Object)entity.getNoticeId())).eq(BizBidEvaluation::getNoticeType, (Object)entity.getNoticeType())).eq(BizBidEvaluation::getNoticeDetailedId, (Object)entity.getNoticeDetailedId())).eq(BizBidEvaluation::getQuotationOrgId, (Object)entity.getQuotationOrgId())).eq(BizModel::getIsDele, (Object)"0")).last("limit 1");
        BizBidEvaluation evaHis = (BizBidEvaluation)((Object)((BizBidEvaluationDao)this.baseMapper).selectOne((Wrapper)hisQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaHis))) {
            LambdaQueryWrapper evaDetailHisQW = new LambdaQueryWrapper();
            this.evaluationDetailManager.remove((Wrapper)evaDetailHisQW);
            super.remove((Serializable)((Object)evaHis.getId()));
        }
        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        entity.setNoticeCode(notice.getProjectNumber());
        entity.setNoticeName(notice.getNoticeTitle());
        entity.setProcureOrgId(notice.getProcureOrgId());
        entity.setProcureOrgCode(notice.getProcureOrgCode());
        entity.setProcureOrgName(notice.getProcureOrgName());
        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(1);
        super.save((Object)entity);
        this.evaluationDetailManager.saveBatch(evaDetailList);
        if (entity.getNoticeType() == 1) {
            LambdaUpdateWrapper noticeDetailUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeDetailUW.set(MatApprovalDetails::getBidStatus, (Object)2)).eq(MatApprovalDetails::getId, (Object)entity.getNoticeDetailedId())).eq(BizModel::getIsDele, (Object)"0");
            this.matDetailsManager.update((Wrapper)noticeDetailUW);
            LambdaQueryWrapper approvalDetailQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)approvalDetailQW.eq(MatApprovalDetails::getBidStatus, (Object)1)).eq(MatApprovalDetails::getNoticeId, (Object)entity.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            if (this.matDetailsManager.count((Wrapper)approvalDetailQW) == 0) {
                notice.setBidStatus(6);
                this.matApprovalManager.updateById((Object)notice);
            }
        } else {
            LambdaUpdateWrapper noticeUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeUW.set(ProjectApproval::getBidStatus, (Object)6)).eq(ProjectApproval::getId, (Object)entity.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            this.projectApprovalManager.update((Wrapper)noticeUW);
        }
    }

    @Override
    @Transactional
    public void bidEvaLowest(BizBiddingQuotation biddingQuotation) {
        BizModel notice;
        LambdaQueryWrapper caQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)caQW.eq(Calibration::getNoticeId, (Object)biddingQuotation.getNoticeId())).eq(Calibration::getNoticeType, (Object)biddingQuotation.getNoticeType())).eq(BizModel::getIsDele, (Object)"0");
        this.calibrationManager.remove((Wrapper)caQW);
        LambdaQueryWrapper caDetailQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)caDetailQW.eq(CalibrationDetail::getNoticeId, (Object)biddingQuotation.getNoticeId())).eq(CalibrationDetail::getNoticeDetailedId, (Object)biddingQuotation.getNoticeDetailedId());
        this.calibrationDetailManager.remove((Wrapper)caDetailQW);
        BizBidEvaluation entity = new BizBidEvaluation();
        Calibration calibration = new Calibration();
        CalibrationDetail caliDetail = new CalibrationDetail();
        LambdaQueryWrapper bidEvaQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaQW.eq(BizBidEvaluation::getNoticeId, (Object)biddingQuotation.getNoticeId())).eq(BizBidEvaluation::getNoticeDetailedId, (Object)biddingQuotation.getNoticeDetailedId())).eq(BizModel::getIsDele, (Object)"0")).last("limit 1");
        BizBidEvaluation evaRecord = (BizBidEvaluation)((Object)((BizBidEvaluationDao)this.baseMapper).selectOne((Wrapper)bidEvaQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaRecord))) {
            this.accessoryService.removeBySourceId(evaRecord.getId());
            entity = evaRecord;
        }
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        entity.setNoticeId(biddingQuotation.getNoticeId());
        List<Accessory> evaExplainAccessory = biddingQuotation.getEvaExplainAccessory();
        String noticeType = biddingQuotation.getNoticeType();
        entity.setNoticeType(Integer.valueOf(noticeType));
        if (noticeType.equals("1")) {
            notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)biddingQuotation.getNoticeId())));
            entity.setNoticeCode(notice.getProjectNumber());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            notice.setBidStatus(6);
            this.matApprovalManager.updateById(notice);
            calibration.setNoticeCode(notice.getProjectNumber());
            calibration.setNoticeName(notice.getNoticeTitle());
            caliDetail.setNoticeCode(notice.getProjectNumber());
            caliDetail.setNoticeName(notice.getNoticeTitle());
            caliDetail.setProcureOrgId(notice.getProcureOrgId());
            caliDetail.setProcureOrgCode(notice.getProcureOrgCode());
            caliDetail.setProcureOrgName(notice.getProcureOrgName());
            MatApprovalDetails detail = (MatApprovalDetails)((Object)this.matDetailsManager.getById((Serializable)((Object)biddingQuotation.getNoticeDetailedId())));
            caliDetail.setMatId(detail.getMatId());
            caliDetail.setMatPlatcode(detail.getMatPlatcode());
            caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
            caliDetail.setMatCode(detail.getMatCode());
            caliDetail.setMatName(detail.getMatName());
            caliDetail.setMatMaterial(detail.getMatMaterial());
            caliDetail.setMatSpec(detail.getMatSpec());
            caliDetail.setMatNum(detail.getMatNum());
            caliDetail.setMatUnit(detail.getMatUnit());
            caliDetail.setMatBrand(detail.getMatBrand());
            caliDetail.setMatBaseExt(detail.getMatBaseExt());
            caliDetail.setMatOtherExt(detail.getMatOtherExt());
            caliDetail.setTaxRate(detail.getTaxRate());
        } else {
            notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)biddingQuotation.getNoticeId())));
            entity.setNoticeCode(notice.getNoticeCode());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            notice.setBidStatus(6);
            this.projectApprovalManager.updateById(notice);
            caliDetail.setNoticeCode(notice.getNoticeCode());
            caliDetail.setNoticeName(notice.getNoticeTitle());
            caliDetail.setProcureOrgId(notice.getProcureOrgId());
            caliDetail.setProcureOrgCode(notice.getProcureOrgCode());
            caliDetail.setProcureOrgName(notice.getProcureOrgName());
            ProjectApprovalDetails detail = (ProjectApprovalDetails)((Object)this.paDetailManager.getById((Serializable)((Object)biddingQuotation.getNoticeDetailedId())));
            caliDetail.setMatId(detail.getMatId());
            caliDetail.setMatPlatcode(detail.getMatPlatcode());
            caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
            caliDetail.setMatCode(detail.getMatCode());
            caliDetail.setMatName(detail.getMatName());
            caliDetail.setMatMaterial(detail.getMatMaterial());
            caliDetail.setMatSpec(detail.getMatSpec());
            caliDetail.setMatNum(detail.getMatNum());
            caliDetail.setMatUnit(detail.getMatUnit());
            caliDetail.setMatBrand(detail.getMatBrand());
            caliDetail.setMatBaseExt(detail.getMatBaseExt());
            caliDetail.setMatOtherExt(detail.getMatOtherExt());
            caliDetail.setTaxRate(detail.getTaxRate());
        }
        entity.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
        entity.setQuotationId(biddingQuotation.getId());
        entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
        entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
        entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
        entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
        if (BeanUtils.isNotEmpty((Object)biddingQuotation.getEvaExplain())) {
            entity.setEvaExplain(biddingQuotation.getEvaExplain());
        }
        super.save((Object)entity);
        if (BeanUtils.isNotEmpty(evaExplainAccessory) && evaExplainAccessory.size() > 0) {
            BizBidEvaluation finalEntity = entity;
            evaExplainAccessory.stream().forEach(s -> s.setSourceId(finalEntity.getId()));
            this.accessoryService.saveBatch(evaExplainAccessory);
        }
        calibration.setNoticeId(biddingQuotation.getNoticeId());
        calibration.setNoticeType(Integer.valueOf(biddingQuotation.getNoticeType()));
        calibration.setVendorId(biddingQuotation.getQuotationCompanyId());
        calibration.setVendorCode(biddingQuotation.getQuotationCompanyCode());
        calibration.setVendorName(biddingQuotation.getQuotationCompanyName());
        calibration.setWinBidPrice(biddingQuotation.getQuotationPrice());
        if (BeanUtils.isNotEmpty((Object)biddingQuotation.getRank())) {
            calibration.setRank(biddingQuotation.getRank());
        }
        this.calibrationManager.save((Object)calibration);
        caliDetail.setCalibrationId(calibration.getId());
        caliDetail.setNoticeId(biddingQuotation.getNoticeId());
        caliDetail.setVendorId(biddingQuotation.getQuotationCompanyId());
        caliDetail.setVendorCode(biddingQuotation.getQuotationCompanyCode());
        caliDetail.setVendorName(biddingQuotation.getQuotationCompanyName());
        caliDetail.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
        caliDetail.setIsTax(biddingQuotation.getIsTax());
        caliDetail.setStatus(1);
        caliDetail.setWinBidPrice(biddingQuotation.getQuotationPrice());
        this.calibrationDetailManager.save((Object)caliDetail);
    }

    @Override
    @Transactional
    public void bidEvaLowest(EvaVo evaVo) {
        LambdaQueryWrapper bidEvaQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaQW.eq(BizBidEvaluation::getNoticeId, (Object)evaVo.getNoticeId())).eq(BizBidEvaluation::getNoticeType, (Object)evaVo.getNoticeType())).eq(BizBidEvaluation::getNoticeDetailedId, (Object)evaVo.getNoticeDetailedId());
        super.remove((Wrapper)bidEvaQW);
        List<BizBiddingQuotation> quotationList = evaVo.getQuotationList();
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)evaVo.getNoticeId())));
        Integer bidOrgNum = notice.getAllocationOfShares();
        if (bidOrgNum.intValue() != quotationList.size()) {
            throw new BaseException("\u8bc4\u6807\u4f9b\u5e94\u5546\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9" + bidOrgNum + "\u5bb6\u4f9b\u5e94\u5546");
        }
        if (bidOrgNum > 1) {
            quotationList.sort(new Comparator<BizBiddingQuotation>(){

                @Override
                public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                    if (o1.getQuotationPrice().compareTo(o2.getQuotationPrice()) == 0) {
                        return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                    }
                    return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                }
            });
        }
        MatApprovalDetails noticeDetail = (MatApprovalDetails)((Object)this.matDetailsManager.getById((Serializable)((Object)evaVo.getNoticeDetailedId())));
        int i = 1;
        for (BizBiddingQuotation biddingQuotation : quotationList) {
            BizBidEvaluation entity = new BizBidEvaluation();
            entity.setOperateTime(LocalDateTime.now());
            entity.setOperateUserId(ContextUtil.getCurrentUserId());
            entity.setOperateUserName(ContextUtil.getCurrentUserName());
            entity.setNoticeId(evaVo.getNoticeId());
            List<Accessory> evaExplainAccessory = biddingQuotation.getEvaExplainAccessory();
            entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
            entity.setNoticeCode(notice.getProjectNumber());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            entity.setEvaluationMode(1);
            entity.setNoticeDetailedId(evaVo.getNoticeDetailedId());
            entity.setQuotationId(biddingQuotation.getId());
            entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
            entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
            entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
            entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
            entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
            if (BeanUtils.isNotEmpty((Object)biddingQuotation.getEvaExplain())) {
                entity.setEvaExplain(biddingQuotation.getEvaExplain());
            }
            if (bidOrgNum == 1) {
                entity.setShareAllocationRate(new BigDecimal("100"));
                entity.setShareAllocationNum(noticeDetail.getMatNum());
            } else {
                if (i == 1) {
                    entity.setShareAllocationRate(notice.getAllocationRate1());
                } else if (i == 2) {
                    entity.setShareAllocationRate(notice.getAllocationRate2());
                } else if (i == 3) {
                    entity.setShareAllocationRate(notice.getAllocationRate3());
                } else if (i == 4) {
                    entity.setShareAllocationRate(notice.getAllocationRate4());
                } else {
                    entity.setShareAllocationRate(notice.getAllocationRate5());
                }
                entity.setShareAllocationNum(entity.getShareAllocationRate().divide(new BigDecimal("100")).multiply(noticeDetail.getMatNum()));
            }
            super.save((Object)entity);
            String entityId = entity.getId();
            if (BeanUtils.isNotEmpty(evaExplainAccessory) && evaExplainAccessory.size() > 0) {
                evaExplainAccessory.stream().forEach(s -> s.setSourceId(entityId));
                this.accessoryService.saveBatch(evaExplainAccessory);
            }
            ++i;
        }
        noticeDetail.setBidStatus(2);
        this.matDetailsManager.updateById((Object)noticeDetail);
        LambdaQueryWrapper approvalDetailQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)approvalDetailQW.eq(MatApprovalDetails::getBidStatus, (Object)1)).eq(MatApprovalDetails::getNoticeId, (Object)evaVo.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
        if (this.matDetailsManager.count((Wrapper)approvalDetailQW) == 0) {
            notice.setBidStatus(6);
            this.matApprovalManager.updateById((Object)notice);
        }
    }

    @Override
    @Transactional
    public void choiceBidEvaLowestPro(EvaVo evaVo) {
        LambdaQueryWrapper bidEvaQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaQW.eq(BizBidEvaluation::getNoticeId, (Object)evaVo.getNoticeId())).eq(BizBidEvaluation::getNoticeType, (Object)evaVo.getNoticeType())).eq(BizBidEvaluation::getNoticeDetailedId, (Object)evaVo.getNoticeDetailedId());
        super.remove((Wrapper)bidEvaQW);
        List<BizBiddingQuotation> quotationList = evaVo.getQuotationList();
        ProjectApproval notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)evaVo.getNoticeId())));
        Integer bidOrgNum = 1;
        if (bidOrgNum.intValue() != quotationList.size()) {
            throw new BaseException("\u8bc4\u6807\u4f9b\u5e94\u5546\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9" + bidOrgNum + "\u5bb6\u4f9b\u5e94\u5546");
        }
        if (bidOrgNum > 1) {
            quotationList.sort(new Comparator<BizBiddingQuotation>(){

                @Override
                public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                    if (o1.getQuotationPrice().compareTo(o2.getQuotationPrice()) == 0) {
                        return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                    }
                    return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                }
            });
        }
        ProjectApprovalDetails noticeDetail = (ProjectApprovalDetails)((Object)this.projectDetailsManager.getById((Serializable)((Object)evaVo.getNoticeDetailedId())));
        int i = 1;
        for (BizBiddingQuotation biddingQuotation : quotationList) {
            BizBidEvaluation entity = new BizBidEvaluation();
            entity.setOperateTime(LocalDateTime.now());
            entity.setOperateUserId(ContextUtil.getCurrentUserId());
            entity.setOperateUserName(ContextUtil.getCurrentUserName());
            entity.setNoticeId(evaVo.getNoticeId());
            List<Accessory> evaExplainAccessory = biddingQuotation.getEvaExplainAccessory();
            entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
            entity.setNoticeCode(notice.getNoticeCode());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            entity.setEvaluationMode(1);
            entity.setNoticeDetailedId(evaVo.getNoticeDetailedId());
            entity.setQuotationId(biddingQuotation.getId());
            entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
            entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
            entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
            entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
            entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
            if (BeanUtils.isNotEmpty((Object)biddingQuotation.getEvaExplain())) {
                entity.setEvaExplain(biddingQuotation.getEvaExplain());
            }
            if (bidOrgNum == 1) {
                entity.setShareAllocationRate(new BigDecimal("100"));
                entity.setShareAllocationNum(noticeDetail.getMatNum());
            } else {
                entity.setShareAllocationNum(entity.getShareAllocationRate().divide(new BigDecimal("100")).multiply(noticeDetail.getMatNum()));
            }
            super.save((Object)entity);
            String entityId = entity.getId();
            if (BeanUtils.isNotEmpty(evaExplainAccessory) && evaExplainAccessory.size() > 0) {
                evaExplainAccessory.stream().forEach(s -> s.setSourceId(entityId));
                this.accessoryService.saveBatch(evaExplainAccessory);
            }
            ++i;
        }
        noticeDetail.setBidStatus(2);
        this.projectDetailsManager.updateById((Object)noticeDetail);
        LambdaQueryWrapper approvalDetailQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)approvalDetailQW.eq(ProjectApprovalDetails::getBidStatus, (Object)1)).eq(ProjectApprovalDetails::getNoticeId, (Object)evaVo.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
        if (this.projectDetailsManager.count((Wrapper)approvalDetailQW) == 0) {
            notice.setBidStatus(6);
            this.projectApprovalManager.updateById((Object)notice);
        }
    }

    @Override
    @Transactional
    public void bidEvaLowestAuto(EvaVo evaVo) {
        LambdaQueryWrapper bidEvaQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)bidEvaQW.eq(BizBidEvaluation::getNoticeId, (Object)evaVo.getNoticeId())).eq(BizBidEvaluation::getNoticeType, (Object)evaVo.getNoticeType());
        super.remove((Wrapper)bidEvaQW);
        Integer bidOrgNum = 1;
        ArrayList<BizBidEvaluation> evaSaveData = new ArrayList<BizBidEvaluation>();
        if (evaVo.getNoticeType().equals("2")) {
            ProjectApproval notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)evaVo.getNoticeId())));
            LambdaQueryWrapper noticeDetailQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)noticeDetailQW.eq(ProjectApprovalDetails::getNoticeId, (Object)notice.getId())).eq(BizModel::getIsDele, (Object)"0");
            List noticeDetailList = this.projectDetailsManager.list((Wrapper)noticeDetailQW);
            LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)quoQW.eq(BizBiddingQuotation::getNoticeId, (Object)notice.getId())).eq(BizBiddingQuotation::getNoticeType, (Object)evaVo.getNoticeType())).eq(BizBiddingQuotation::getQuotationRounds, (Object)notice.getQuotationRoundsNum())).gt(BizBiddingQuotation::getQuotationPrice, (Object)BigDecimal.ZERO);
            List quoList = this.quotationManager.list((Wrapper)quoQW);
            for (ProjectApprovalDetails noticeDetail : noticeDetailList) {
                List quotationList = quoList.stream().filter(s -> s.getNoticeDetailedId().equals(noticeDetail.getId())).sorted(new Comparator<BizBiddingQuotation>(){

                    @Override
                    public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                        if (o1.getQuotationPrice().compareTo(o2.getQuotationPrice()) == 0) {
                            return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                        }
                        return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                    }
                }).limit(bidOrgNum.intValue()).collect(Collectors.toList());
                for (BizBiddingQuotation biddingQuotation : quotationList) {
                    BizBidEvaluation entity = new BizBidEvaluation();
                    entity.setOperateTime(LocalDateTime.now());
                    entity.setNoticeId(evaVo.getNoticeId());
                    entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
                    entity.setNoticeCode(notice.getNoticeCode());
                    entity.setNoticeName(notice.getNoticeTitle());
                    entity.setProcureOrgId(notice.getProcureOrgId());
                    entity.setProcureOrgCode(notice.getProcureOrgCode());
                    entity.setProcureOrgName(notice.getProcureOrgName());
                    entity.setEvaluatingMethods(notice.getEvaluationMethod());
                    entity.setEvaluationMode(1);
                    entity.setNoticeDetailedId(noticeDetail.getId());
                    entity.setQuotationId(biddingQuotation.getId());
                    entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
                    entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
                    entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
                    entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
                    entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
                    if (BeanUtils.isNotEmpty((Object)biddingQuotation.getEvaExplain())) {
                        entity.setEvaExplain(biddingQuotation.getEvaExplain());
                    }
                    entity.setShareAllocationRate(new BigDecimal("100"));
                    entity.setShareAllocationNum(noticeDetail.getMatNum());
                    evaSaveData.add(entity);
                }
            }
            LambdaUpdateWrapper approvalDetailUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalDetailUW.set(ProjectApprovalDetails::getBidStatus, (Object)2)).eq(ProjectApprovalDetails::getNoticeId, (Object)evaVo.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            this.projectDetailsManager.update((Wrapper)approvalDetailUW);
            notice.setBidStatus(6);
            this.projectApprovalManager.updateById((Object)notice);
        } else {
            MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)evaVo.getNoticeId())));
            bidOrgNum = notice.getAllocationOfShares();
            LambdaQueryWrapper noticeDetailQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)noticeDetailQW.eq(MatApprovalDetails::getNoticeId, (Object)notice.getId())).eq(BizModel::getIsDele, (Object)"0");
            List noticeDetailList = this.matDetailsManager.list((Wrapper)noticeDetailQW);
            LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)quoQW.eq(BizBiddingQuotation::getNoticeId, (Object)notice.getId())).eq(BizBiddingQuotation::getNoticeType, (Object)evaVo.getNoticeType())).eq(BizBiddingQuotation::getQuotationRounds, (Object)notice.getQuotationRoundsNum())).gt(BizBiddingQuotation::getQuotationPrice, (Object)BigDecimal.ZERO);
            List quoList = this.quotationManager.list((Wrapper)quoQW);
            for (MatApprovalDetails noticeDetail : noticeDetailList) {
                List quotationList = quoList.stream().filter(s -> s.getNoticeDetailedId().equals(noticeDetail.getId())).sorted(new Comparator<BizBiddingQuotation>(){

                    @Override
                    public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                        if (o1.getQuotationPrice().compareTo(o2.getQuotationPrice()) == 0) {
                            return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                        }
                        return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                    }
                }).limit(bidOrgNum.intValue()).collect(Collectors.toList());
                for (BizBiddingQuotation biddingQuotation : quotationList) {
                    int i = 1;
                    BizBidEvaluation entity = new BizBidEvaluation();
                    entity.setOperateTime(LocalDateTime.now());
                    entity.setNoticeId(evaVo.getNoticeId());
                    entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
                    entity.setNoticeCode(notice.getProjectNumber());
                    entity.setNoticeName(notice.getNoticeTitle());
                    entity.setProcureOrgId(notice.getProcureOrgId());
                    entity.setProcureOrgCode(notice.getProcureOrgCode());
                    entity.setProcureOrgName(notice.getProcureOrgName());
                    entity.setEvaluatingMethods(notice.getEvaluationMethod());
                    entity.setEvaluationMode(1);
                    entity.setNoticeDetailedId(noticeDetail.getId());
                    entity.setQuotationId(biddingQuotation.getId());
                    entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
                    entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
                    entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
                    entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
                    entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
                    if (BeanUtils.isNotEmpty((Object)biddingQuotation.getEvaExplain())) {
                        entity.setEvaExplain(biddingQuotation.getEvaExplain());
                    }
                    if (quotationList.size() == 1) {
                        entity.setShareAllocationRate(new BigDecimal("100"));
                        entity.setShareAllocationNum(noticeDetail.getMatNum());
                    } else {
                        if (i == 1) {
                            entity.setShareAllocationRate(notice.getAllocationRate1());
                        } else if (i == 2) {
                            entity.setShareAllocationRate(notice.getAllocationRate2());
                        } else if (i == 3) {
                            entity.setShareAllocationRate(notice.getAllocationRate3());
                        } else if (i == 4) {
                            entity.setShareAllocationRate(notice.getAllocationRate4());
                        } else {
                            entity.setShareAllocationRate(notice.getAllocationRate5());
                        }
                        entity.setShareAllocationNum(entity.getShareAllocationRate().divide(new BigDecimal("100")).multiply(noticeDetail.getMatNum()));
                    }
                    evaSaveData.add(entity);
                    ++i;
                }
            }
            LambdaUpdateWrapper approvalDetailUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalDetailUW.set(MatApprovalDetails::getBidStatus, (Object)2)).eq(MatApprovalDetails::getNoticeId, (Object)evaVo.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            this.matDetailsManager.update((Wrapper)approvalDetailUW);
            notice.setBidStatus(6);
            this.matApprovalManager.updateById((Object)notice);
        }
        if (evaSaveData.size() > 0) {
            super.saveBatch(evaSaveData);
        }
    }

    @Override
    public BigDecimal getTotalScore(String quoOrgId, String noticeId) {
        BigDecimal result = ((BizBidEvaluationDao)this.baseMapper).getTotalScore(quoOrgId, noticeId);
        return result;
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailComprehensive(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        String noticeId = null;
        String noticeType = "1";
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (qf.getProperty().equals("a.NOTICE_ID_")) {
                    noticeId = String.valueOf(qf.getValue());
                }
                if (!qf.getProperty().equals("a.NOTICE_TYPE_")) continue;
                noticeType = String.valueOf(qf.getValue());
            }
        }
        List records = new ArrayList();
        HashMap shareMap = new HashMap();
        if (noticeType.equals("2")) {
            records = ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPagePro((IPage<BizBidEvaluation>)new Page(0L, -1L, false), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
            Map<String, List<BizBidEvaluation>> collect = records.stream().collect(Collectors.groupingBy(BizBidEvaluation::getNoticeDetailedId));
            collect.forEach((k, v) -> {
                List data = v.stream().sorted(new Comparator<BizBidEvaluation>(){

                    @Override
                    public int compare(BizBidEvaluation o1, BizBidEvaluation o2) {
                        return o2.getScore().compareTo(o1.getScore());
                    }
                }).collect(Collectors.toList());
                shareMap.put(((BizBidEvaluation)((Object)((Object)data.get(0)))).getId(), new BigDecimal("100"));
            });
        } else {
            MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)noticeId)));
            records = ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPage((IPage<BizBidEvaluation>)new Page(0L, -1L, false), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
            Map<String, List<BizBidEvaluation>> collect = records.stream().collect(Collectors.groupingBy(BizBidEvaluation::getNoticeDetailedId));
            collect.forEach((k, v) -> {
                List data = v.stream().sorted(new Comparator<BizBidEvaluation>(){

                    @Override
                    public int compare(BizBidEvaluation o1, BizBidEvaluation o2) {
                        return o2.getScore().compareTo(o1.getScore());
                    }
                }).collect(Collectors.toList());
                for (int i = 0; i < notice.getAllocationOfShares(); ++i) {
                    BigDecimal shareRate = new BigDecimal("100");
                    if (notice.getAllocationOfShares() > 1) {
                        if (i == 0) {
                            shareRate = notice.getAllocationRate1();
                        } else if (i == 1) {
                            shareRate = notice.getAllocationRate2();
                        } else if (i == 2) {
                            shareRate = notice.getAllocationRate3();
                        } else if (i == 3) {
                            shareRate = notice.getAllocationRate4();
                        } else if (i == 4) {
                            shareRate = notice.getAllocationRate5();
                        }
                    }
                    shareMap.put(((BizBidEvaluation)((Object)((Object)data.get(i)))).getId(), shareRate);
                }
            });
        }
        queryFilter.addFilter("a.ID_", new ArrayList(shareMap.keySet()), QueryOP.IN);
        IPage<BizBidEvaluation> result = null;
        result = noticeType.equals("2") ? ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPagePro((IPage<BizBidEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPage((IPage<BizBidEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records1 = result.getRecords();
        for (BizBidEvaluation temp : records1) {
            temp.setShareAllocationRate((BigDecimal)shareMap.get(temp.getId()));
            temp.setShareAllocationNum(temp.getShareAllocationRate().divide(new BigDecimal("100")).multiply(temp.getMatNum()).setScale(4, RoundingMode.HALF_UP));
        }
        return new PageList(result);
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailComprehensivePro(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        String noticeId = null;
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equals("a.NOTICE_ID_")) continue;
                noticeId = String.valueOf(qf.getValue());
                break;
            }
        }
        ProjectApproval notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)noticeId)));
        List records = ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPagePro((IPage<BizBidEvaluation>)new Page(0L, -1L, false), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        Map<String, List<BizBidEvaluation>> collect = records.stream().collect(Collectors.groupingBy(BizBidEvaluation::getNoticeDetailedId));
        ArrayList evaIds = new ArrayList();
        HashMap shareMap = new HashMap();
        collect.forEach((k, v) -> {
            List data = v.stream().sorted(new Comparator<BizBidEvaluation>(){

                @Override
                public int compare(BizBidEvaluation o1, BizBidEvaluation o2) {
                    return o2.getScore().compareTo(o1.getScore());
                }
            }).collect(Collectors.toList());
            evaIds.add(((BizBidEvaluation)((Object)((Object)data.get(0)))).getId());
        });
        queryFilter.addFilter("a.ID_", evaIds, QueryOP.IN);
        IPage<BizBidEvaluation> result = ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPagePro((IPage<BizBidEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records1 = result.getRecords();
        for (BizBidEvaluation temp : records1) {
            temp.setShareAllocationRate(new BigDecimal("100"));
            temp.setShareAllocationNum(temp.getShareAllocationRate().divide(new BigDecimal("100")).multiply(temp.getMatNum()).setScale(4, RoundingMode.HALF_UP));
        }
        return new PageList(result);
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailById(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizBidEvaluation> result = ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPage((IPage<BizBidEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBidEvaluation eva : records) {
                LambdaQueryWrapper templateDataQW = new LambdaQueryWrapper();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId, (Object)eva.getQuotationId());
                List templateDataList = this.quotationTemplateDetailDataManager.list((Wrapper)templateDataQW);
                eva.setQuotationTemplateDetailDataList(templateDataList);
            }
        }
        return new PageList(result);
    }

    @Override
    public void exportCalibraDetail(QueryFilter<BizBidEvaluation> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u8bc4\u6807\u660e\u7ec6-\u5bfc\u51fa\u7ed3\u679c";
        Boolean noticeIdFilter = false;
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            List collect = querys.stream().filter(s -> s.getProperty().equals("a.NOTICE_ID_")).collect(Collectors.toList());
            if (BeanUtils.isEmpty(collect) || collect.size() <= 0) {
                noticeIdFilter = true;
            }
        } else {
            noticeIdFilter = true;
        }
        if (noticeIdFilter.booleanValue()) {
            QueryFilter noticeQF = QueryFilter.build();
            noticeQF.addFilter("BID_STATUS_", (Object)"6", QueryOP.EQUAL);
            noticeQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
            List rows = this.matApprovalManager.bidEvaAgencyData((QueryFilter<MatApproval>)noticeQF).getRows();
            if (BeanUtils.isEmpty((Object)rows) || rows.size() <= 0) {
                throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
            }
            List collect1 = rows.stream().map(s -> s.getId()).collect(Collectors.toList());
            queryFilter.addFilter("a.NOTICE_ID_", collect1, QueryOP.IN);
        }
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List data = ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPage((IPage<BizBidEvaluation>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (BeanUtils.isEmpty((Object)data) || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BizBidEvaluation.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailByIdPro(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizBidEvaluation> result = ((BizBidEvaluationDao)this.baseMapper).queryNoticeDetailAllByPagePro((IPage<BizBidEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizBidEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizBidEvaluation eva : records) {
                LambdaQueryWrapper templateDataQW = new LambdaQueryWrapper();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId, (Object)eva.getQuotationId());
                List templateDataList = this.quotationTemplateDetailDataManager.list((Wrapper)templateDataQW);
                eva.setQuotationTemplateDetailDataList(templateDataList);
            }
        }
        return new PageList(result);
    }

    @Override
    public List<BizBidEvaluation> getCalibraDetailMaxScoreById(String noticeId) {
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)noticeId)));
        LambdaQueryWrapper resultQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)resultQW.eq(BizBidEvaluation::getNoticeId, (Object)noticeId)).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(BizBidEvaluation::getScore)).last("limit " + notice.getAllocationOfShares());
        List result = super.list((Wrapper)resultQW);
        if (BeanUtils.isNotEmpty((Object)result) && result.size() > 0) {
            int i = 1;
            for (BizBidEvaluation temp : result) {
                if (i == 1) {
                    temp.setShareAllocationRate(notice.getAllocationRate1());
                } else if (i == 2) {
                    temp.setShareAllocationRate(notice.getAllocationRate2());
                } else if (i == 3) {
                    temp.setShareAllocationRate(notice.getAllocationRate3());
                } else if (i == 4) {
                    temp.setShareAllocationRate(notice.getAllocationRate4());
                } else {
                    temp.setShareAllocationRate(notice.getAllocationRate5());
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<BizBidEvaluation> getCalibraDetailMaxScoreByIdPro(String noticeId) {
        ProjectApproval notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)noticeId)));
        LambdaQueryWrapper resultQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)resultQW.eq(BizBidEvaluation::getNoticeId, (Object)noticeId)).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(BizBidEvaluation::getScore)).last("limit 1");
        List result = super.list((Wrapper)resultQW);
        if (BeanUtils.isNotEmpty((Object)result) && result.size() > 0) {
            for (BizBidEvaluation temp : result) {
                temp.setShareAllocationRate(new BigDecimal("100"));
            }
        }
        return result;
    }
}

