/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.util;

import com.artfess.base.annotation.ExcelColumn;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.Excel;
import com.artfess.poi.editor.IFontEditor;
import com.artfess.poi.reader.TableHeaderDef;
import com.artfess.poi.style.Align;
import com.artfess.poi.style.BorderStyle;
import com.artfess.poi.style.Color;
import com.artfess.poi.style.font.BoldWeight;
import com.artfess.poi.style.font.Font;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String EXCEL2003 = "xls";
    public static final String EXCEL2007 = "xlsx";

    public static int getLastRowNum(HSSFSheet sheet) {
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum == 0) {
            lastRowNum = sheet.getPhysicalNumberOfRows() - 1;
        }
        return lastRowNum;
    }

    public static int getFirstCellNum(HSSFRow row) {
        return row.getFirstCellNum();
    }

    public static int getLastCellNum(HSSFRow row) {
        return row.getLastCellNum();
    }

    public static HSSFRow getHSSFRow(HSSFSheet sheet, int row) {
        HSSFRow r;
        if (row < 0) {
            row = 0;
        }
        if ((r = sheet.getRow(row)) == null) {
            r = sheet.createRow(row);
        }
        return r;
    }

    public static HSSFCell getHSSFCell(HSSFSheet sheet, int row, int col) {
        HSSFRow r = ExcelUtil.getHSSFRow(sheet, row);
        return ExcelUtil.getHSSFCell(r, col);
    }

    public static HSSFCell getHSSFCell(HSSFRow row, int col) {
        HSSFCell c;
        if (col < 0) {
            col = 0;
        }
        c = (c = row.getCell(col)) == null ? row.createCell(col) : c;
        return c;
    }

    public static HSSFSheet getHSSFSheet(HSSFWorkbook workbook, int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > workbook.getNumberOfSheets() - 1) {
            workbook.createSheet();
            return workbook.getSheetAt(workbook.getNumberOfSheets() - 1);
        }
        return workbook.getSheetAt(index);
    }

    public static void downloadExcel(HSSFWorkbook workBook, String fileName, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName + ".xls", "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ServletOutputStream os = response.getOutputStream();){
            workBook.write((OutputStream)baos);
            response.setHeader("Content-Length", String.valueOf(baos.size()));
            os.write(baos.toByteArray());
            os.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void downloadExcel(Workbook workBook, String fileName, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName, "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ServletOutputStream os = response.getOutputStream();){
            workBook.write((OutputStream)baos);
            response.setHeader("Content-Length", String.valueOf(baos.size()));
            os.write(baos.toByteArray());
            os.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HSSFWorkbook exportExcel(String title, int rowHeight, Map<String, String> fieldMap, List data) throws Exception {
        return ExcelUtil.exportExcel(title, rowHeight, fieldMap, data, 0);
    }

    public static HSSFWorkbook exportExcel(String title, int rowHeight, Map<String, String> fieldMap, List data, int headerRowIndex) throws Exception {
        int size = fieldMap.size();
        Excel excel = new Excel();
        int titleCols = size;
        if (titleCols == 0) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u5217\uff01");
        }
        excel.sheet().sheetName(title);
        int i = 0;
        for (String name : fieldMap.values()) {
            excel.cell(headerRowIndex, i).value("").border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(14).warpText(true).align(Align.LEFT);
            excel.cell(headerRowIndex, i).value(name).align(Align.CENTER).bgColor(Color.GREY_25_PERCENT).fontHeightInPoint(14).width(12800).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

                @Override
                public void updateFont(Font font) {
                    font.boldweight(BoldWeight.BOLD);
                    font.color(Color.BLACK);
                }
            });
            ++i;
        }
        int rows = headerRowIndex + 1;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int col = 0;
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(rows, col).value(val).border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(14).warpText(true).align(Align.LEFT);
                ++col;
            }
            ++rows;
        }
        return excel.getWorkBook();
    }

    public static HSSFWorkbook exportExcel(String title, int rowHeight, Map<String, String> fieldMap, List data, int headerRowIndex, String firstLineTitle, List<String> requiredList, List<String> inputList, HashMap<String, Integer> formatMap, Integer freezePaneCol) throws Exception {
        int size = fieldMap.size();
        Excel excel = new Excel();
        int titleCols = size;
        if (titleCols == 0) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u5217\uff01");
        }
        excel.sheet().sheetName(title);
        HSSFSheet sheet = excel.getWorkBook().getSheetAt(0);
        excel.cell(headerRowIndex - 1, 0).value(firstLineTitle).fontHeightInPoint(20).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

            @Override
            public void updateFont(Font font) {
                font.boldweight(BoldWeight.BOLD);
                font.color(Color.BLACK);
            }
        });
        int i = 0;
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            Integer formatType;
            if (BeanUtils.isNotEmpty(formatMap) && formatMap.containsKey(entry.getKey()) && (formatType = formatMap.get(entry.getKey())) == 1) {
                excel.cell(headerRowIndex, i).dataFormat("0.0000");
            }
            excel.cell(headerRowIndex, i).value(entry.getValue()).align(Align.CENTER).fontHeightInPoint(15).width(4608).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

                @Override
                public void updateFont(Font font) {
                    font.boldweight(BoldWeight.BOLD);
                    font.color(Color.BLACK);
                }
            });
            if (requiredList.contains(entry.getKey())) {
                excel.cell(headerRowIndex, i).bgColor(Color.YELLOW);
            } else if (inputList.contains(entry.getKey())) {
                excel.cell(headerRowIndex, i).bgColor(Color.CORNFLOWER_BLUE);
            }
            ++i;
        }
        int rows = headerRowIndex + 1;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int col = 0;
            for (String key : fieldMap.keySet()) {
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(rows, col).value(val).border(BorderStyle.THIN, Color.BLACK).fontHeightInPoint(12).warpText(true).align(Align.CENTER);
                ++col;
            }
            ++rows;
        }
        CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, i - 1);
        sheet.addMergedRegion(cellRangeAddress);
        sheet.createFreezePane(freezePaneCol.intValue(), 0, freezePaneCol.intValue(), 0);
        return excel.getWorkBook();
    }

    public static HSSFWorkbook exportExcel(String sheetName, int rowHeight, List<TableHeaderDef> headerDefList, List data) throws Exception {
        int size = headerDefList.size();
        Excel excel = new Excel();
        int titleCols = size;
        if (titleCols == 0) {
            throw new Exception("\u8bf7\u8bbe\u7f6e\u5217\uff01");
        }
        excel.sheet().sheetName(sheetName);
        int i = 0;
        for (TableHeaderDef headerDef : headerDefList) {
            String name = headerDef.getName();
            String comment = headerDef.getComment();
            excel.cell(0, i).value(name).comment(comment).align(Align.CENTER).bgColor(Color.GREY_25_PERCENT).fontHeightInPoint(14).width(7680).border(BorderStyle.THIN, Color.BLACK).font(new IFontEditor(){

                @Override
                public void updateFont(Font font) {
                    font.boldweight(BoldWeight.BOLD);
                    font.color(Color.BLACK);
                }
            });
            ++i;
        }
        int rows = 1;
        for (Object obj : data) {
            Map rowObj = (Map)obj;
            int col = 0;
            for (TableHeaderDef headerDef : headerDefList) {
                String key = headerDef.getKey();
                String val = rowObj.get(key) == null ? "" : rowObj.get(key).toString();
                excel.cell(rows, col).value(val).border(BorderStyle.MEDIUM, Color.BLACK).fontHeightInPoint(14).warpText(true).align(Align.LEFT);
                ++col;
            }
            ++rows;
        }
        return excel.getWorkBook();
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile) {
        return ExcelUtil.ImportDate(firstFile, false);
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile, boolean commentAsKey) {
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        ArrayList list = null;
        String cellData = null;
        ArrayList<String> columns = new ArrayList<String>();
        wb = ExcelUtil.readExcel(firstFile);
        if (wb != null) {
            list = new ArrayList();
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows();
            row = sheet.getRow(0);
            int colnum = row.getPhysicalNumberOfCells();
            for (int i = 0; i < rownum; ++i) {
                int j;
                LinkedHashMap map = new LinkedHashMap();
                row = sheet.getRow(i);
                if (i == 0) {
                    for (j = 0; j < colnum; ++j) {
                        cellData = commentAsKey ? ExcelUtil.getCellComment(row.getCell(j)) : (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                        columns.add(cellData);
                    }
                    continue;
                }
                if (row == null) break;
                for (j = 0; j < colnum; ++j) {
                    cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                    map.put(columns.get(j), cellData);
                }
                list.add(map);
            }
        }
        return list;
    }

    public static List<Map<String, String>> ImportDate(MultipartFile firstFile, boolean commentAsKey, Integer startRow) {
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        ArrayList list = null;
        String cellData = null;
        ArrayList<String> columns = new ArrayList<String>();
        wb = ExcelUtil.readExcel(firstFile);
        if (wb != null) {
            list = new ArrayList();
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows();
            row = sheet.getRow(startRow.intValue());
            int colnum = row.getPhysicalNumberOfCells();
            for (int i = startRow.intValue(); i < rownum; ++i) {
                int j;
                LinkedHashMap map = new LinkedHashMap();
                row = sheet.getRow(i);
                if (i == startRow) {
                    for (j = 0; j < colnum; ++j) {
                        cellData = commentAsKey ? ExcelUtil.getCellComment(row.getCell(j)) : (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                        columns.add(cellData);
                    }
                    continue;
                }
                if (row == null) break;
                for (j = 0; j < colnum; ++j) {
                    cellData = (String)ExcelUtil.getCellFormatValue(row.getCell(j));
                    map.put(columns.get(j), cellData.trim());
                }
                list.add(map);
            }
        }
        return list;
    }

    public static String getCellComment(Cell cell) {
        RichTextString richTextString;
        String comment = "";
        Comment cellComment = cell.getCellComment();
        if (cellComment != null && (richTextString = cellComment.getString()) != null) {
            comment = richTextString.getString();
        }
        return comment;
    }

    public static Workbook readExcel(MultipartFile multipartFile) {
        String filePath = multipartFile.getOriginalFilename();
        HSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        InputStream is = null;
        try {
            is = multipartFile.getInputStream();
            if (".xls".equals(extString)) {
                wb = new HSSFWorkbook(is);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook(is);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getCellFormatValue(Cell cell) {
        String cellValue = null;
        if (cell == null) return "";
        if (cell.getCellType() != CellType.FORMULA) return ExcelUtil.getCellValueOfCellType(cell, cell.getCellType());
        if (!DateUtil.isCellDateFormatted((Cell)cell)) return ExcelUtil.getCellValueOfCellType(cell, cell.getCachedFormulaResultType());
        ExcelStyleDateFormatter formatter = new ExcelStyleDateFormatter("yyyy-MM-dd");
        return formatter.format(cell.getDateCellValue());
    }

    private static Object getCellValueOfCellType(Cell cell, CellType cellType) {
        Object cellValue = "";
        switch (cellType) {
            case NUMERIC: {
                cellValue = StringUtil.format((double)cell.getNumericCellValue());
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue();
                break;
            }
            case STRING: {
                cellValue = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                cellValue = "";
            }
        }
        return cellValue;
    }

    public static void saveExcel(HSSFWorkbook workBook, String fileName, String path) throws IOException {
        FileUtil.createFolder((String)path, (boolean)true);
        String excelName = fileName + ".xls";
        String filePath = path + File.separator + excelName;
        FileOutputStream fout = new FileOutputStream(filePath);
        workBook.write((OutputStream)fout);
        fout.flush();
        fout.close();
    }

    public static void mergeSameColumnCell(Sheet sheet, int startRow, int mergeCol) {
        String startValue = ExcelUtil.getCellContentAsString(ExcelUtil.getCell(sheet, startRow, mergeCol));
        int totalRows = sheet.getPhysicalNumberOfRows();
        int startMergeRow = startRow - 1;
        for (int compareRow = startRow + 1; totalRows > compareRow; ++compareRow) {
            Cell cell = ExcelUtil.getCell(sheet, compareRow, mergeCol);
            String rowCellValue = ExcelUtil.getCellContentAsString(cell);
            if (startValue.equals(rowCellValue)) continue;
            if (compareRow - startMergeRow > 1 && ExcelUtil.getCellContentAsString(ExcelUtil.getCell(sheet, startMergeRow, mergeCol)).equals(ExcelUtil.getCellContentAsString(ExcelUtil.getCell(sheet, compareRow - 1, mergeCol)))) {
                ExcelUtil.addMergeCellReign(sheet, startMergeRow, mergeCol, compareRow - 1, mergeCol);
            }
            startMergeRow = compareRow;
            startValue = rowCellValue;
        }
    }

    public static void mergeRowTotal(Sheet sheet, int startRow, int startCol, String totalName) {
        int totalRows = sheet.getPhysicalNumberOfRows();
        int totalCols = sheet.getRow(0).getPhysicalNumberOfCells();
        while (totalRows > startRow) {
            Cell cell = ExcelUtil.getCell(sheet, startRow, startCol);
            String rowCellValue = ExcelUtil.getCellContentAsString(cell);
            if (totalName.equals(rowCellValue)) {
                for (int currentCol = startCol + 1; totalCols > currentCol; ++currentCol) {
                    cell = ExcelUtil.getCell(sheet, startRow, currentCol);
                    rowCellValue = ExcelUtil.getCellContentAsString(cell);
                    if (totalName.equals(rowCellValue)) continue;
                    ExcelUtil.addMergeCellReign(sheet, startRow, startCol, startRow, currentCol - 1);
                    break;
                }
            }
            ++startRow;
        }
    }

    public static void setRowFillForegroundColor(Sheet sheet, int startRow, int startCol, String totalName, short indexedColors) {
        int totalRows = sheet.getPhysicalNumberOfRows();
        while (totalRows > startRow) {
            Cell cell = ExcelUtil.getCell(sheet, startRow, startCol);
            String rowCellValue = ExcelUtil.getCellContentAsString(cell);
            if (totalName.equals(rowCellValue)) {
                Row styleRow = sheet.getRow(startRow);
                for (Cell oldCell : styleRow) {
                    CellStyle cellStyle = oldCell.getCellStyle();
                    cellStyle.setFillForegroundColor(indexedColors);
                    oldCell.setCellStyle(cellStyle);
                }
            }
            ++startRow;
        }
    }

    public static void addMergeCellReign(Sheet sheet, int startRow, int startCol, int endRow, int endCol) {
        CellRangeAddress region = new CellRangeAddress(startRow, endRow, startCol, endCol);
        sheet.addMergedRegion(region);
        Cell cell = ExcelUtil.getCell(sheet, startRow, startCol);
        CellStyle cellStyle = cell.getCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    private static Cell getCell(Sheet sheet, int row, int col) {
        Row row2 = sheet.getRow(row);
        if (BeanUtils.isEmpty((Object)row2)) {
            return null;
        }
        Cell cell = row2.getCell(col);
        return cell;
    }

    public static void calcAndSetRowHeigt(HSSFRow sourceRow) {
        for (int cellIndex = sourceRow.getFirstCellNum(); cellIndex <= sourceRow.getPhysicalNumberOfCells(); ++cellIndex) {
            double stringNeedsHeight;
            double maxHeight = sourceRow.getHeight();
            HSSFCell sourceCell = sourceRow.getCell(cellIndex);
            String cellContent = ExcelUtil.getCellContentAsString((Cell)sourceCell);
            if (null == cellContent || "".equals(cellContent)) continue;
            Map<String, Object> cellInfoMap = ExcelUtil.getCellInfo(sourceCell);
            Integer cellWidth = (Integer)cellInfoMap.get("width");
            Integer cellHeight = (Integer)cellInfoMap.get("height");
            if ((double)cellHeight.intValue() > maxHeight) {
                maxHeight = cellHeight.intValue();
            }
            HSSFCellStyle cellStyle = sourceCell.getCellStyle();
            HSSFFont font = cellStyle.getFont((Workbook)sourceRow.getSheet().getWorkbook());
            short fontHeight = font.getFontHeight();
            double cellContentWidth = cellContent.getBytes().length * 2 * 256;
            double stringNeedsRows = cellContentWidth / (double)cellWidth.intValue();
            if (stringNeedsRows < 1.0) {
                stringNeedsRows = 1.0;
            }
            if (!((stringNeedsHeight = (double)fontHeight * stringNeedsRows) > maxHeight)) continue;
            maxHeight = stringNeedsHeight;
            if (maxHeight / (double)cellHeight.intValue() > 5.0) {
                maxHeight = 5 * cellHeight;
            }
            maxHeight = Math.ceil(maxHeight);
            Boolean isPartOfRowsRegion = (Boolean)cellInfoMap.get("isPartOfRowsRegion");
            if (isPartOfRowsRegion.booleanValue()) {
                Integer firstRow = (Integer)cellInfoMap.get("firstRow");
                Integer lastRow = (Integer)cellInfoMap.get("lastRow");
                double addHeight = (maxHeight - (double)cellHeight.intValue()) / (double)(lastRow - firstRow + 1);
                for (int i = firstRow.intValue(); i <= lastRow; ++i) {
                    double rowsRegionHeight = (double)sourceRow.getSheet().getRow(i).getHeight() + addHeight;
                    sourceRow.getSheet().getRow(i).setHeight((short)rowsRegionHeight);
                }
                continue;
            }
            sourceRow.setHeight((short)maxHeight);
        }
    }

    private static String getCellContentAsString(Cell cell) {
        if (null == cell) {
            return "";
        }
        return ExcelUtil.getCellFormatValue(cell).toString();
    }

    private static Map<String, Object> getCellInfo(HSSFCell cell) {
        HSSFSheet sheet = cell.getSheet();
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        boolean isPartOfRegion = false;
        int firstColumn = 0;
        int lastColumn = 0;
        int firstRow = 0;
        int lastRow = 0;
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            firstColumn = ca.getFirstColumn();
            lastColumn = ca.getLastColumn();
            firstRow = ca.getFirstRow();
            lastRow = ca.getLastRow();
            if (rowIndex < firstRow || rowIndex > lastRow || columnIndex < firstColumn || columnIndex > lastColumn) continue;
            isPartOfRegion = true;
            break;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer width = 0;
        Integer height = 0;
        boolean isPartOfRowsRegion = false;
        if (isPartOfRegion) {
            int i;
            for (i = firstColumn; i <= lastColumn; ++i) {
                width = width + sheet.getColumnWidth(i);
            }
            for (i = firstRow; i <= lastRow; ++i) {
                height = height + sheet.getRow(i).getHeight();
            }
            if (lastRow > firstRow) {
                isPartOfRowsRegion = true;
            }
        } else {
            width = sheet.getColumnWidth(columnIndex);
            height = height + cell.getRow().getHeight();
        }
        map.put("isPartOfRowsRegion", isPartOfRowsRegion);
        map.put("firstRow", firstRow);
        map.put("lastRow", lastRow);
        map.put("width", width);
        map.put("height", height);
        return map;
    }

    public static <T> List<T> readExcel(Class<T> cls, MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (!fileName.matches("^.+\\.(?i)(xls)$") && !fileName.matches("^.+\\.(?i)(xlsx)$")) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        ArrayList<T> dataList = new ArrayList<T>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
            if (workbook != null) {
                HashMap classMap = new HashMap();
                List<Field> fields = Stream.of(cls.getDeclaredFields()).collect(Collectors.toList());
                fields.forEach(field -> {
                    ExcelColumn annotation = field.getAnnotation(ExcelColumn.class);
                    if (annotation != null) {
                        String value = annotation.col() + "";
                        annotation.col();
                        if (StringUtils.isBlank((String)value)) {
                            return;
                        }
                        if (!classMap.containsKey(value)) {
                            classMap.put(value, new ArrayList());
                        }
                        field.setAccessible(true);
                        ((List)classMap.get(value)).add(field);
                    }
                });
                HashMap reflectionMap = new HashMap(16);
                Sheet sheet = workbook.getSheetAt(0);
                boolean firstRow = true;
                for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                    Row row = sheet.getRow(i);
                    if (firstRow) {
                        for (int j = row.getFirstCellNum(); j <= row.getLastCellNum(); ++j) {
                            if (!classMap.containsKey(j + "")) continue;
                            reflectionMap.put(j, classMap.get(j + ""));
                        }
                        firstRow = false;
                        continue;
                    }
                    if (row == null) continue;
                    try {
                        Object t = cls.newInstance();
                        boolean allBlank = true;
                        for (int j = row.getFirstCellNum(); j <= row.getLastCellNum(); ++j) {
                            if (!reflectionMap.containsKey(j)) continue;
                            Cell cell = row.getCell(j);
                            String cellValue = ExcelUtil.getCellContentAsString(cell);
                            if (StringUtils.isNotBlank((String)cellValue)) {
                                allBlank = false;
                            }
                            List fieldList = (List)reflectionMap.get(j);
                            fieldList.forEach(x -> {
                                try {
                                    ExcelUtil.handleField(t, cellValue, x);
                                }
                                catch (Exception e) {
                                    log.error(String.format("reflect field:%s value:%s exception!", x.getName(), cellValue), (Throwable)e);
                                }
                            });
                        }
                        if (!allBlank) {
                            dataList.add(t);
                            continue;
                        }
                        log.warn(String.format("row:%s is blank ignore!", i));
                        continue;
                    }
                    catch (Exception e) {
                        log.error(String.format("parse row:%s exception!", i), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("parse excel exception!", new Object[0]), (Throwable)e);
        }
        return dataList;
    }

    private static <T> void handleField(T t, String value, Field field) throws Exception {
        Class<?> type = field.getType();
        if (type == null || type == Void.TYPE || StringUtils.isBlank((String)value)) {
            return;
        }
        if (type == Object.class) {
            field.set(t, value);
        } else if (type.getSuperclass() == null || type.getSuperclass() == Number.class) {
            if (type == Integer.TYPE || type == Integer.class) {
                field.set(t, NumberUtils.toInt((String)value));
            } else if (type == Long.TYPE || type == Long.class) {
                field.set(t, NumberUtils.toLong((String)value));
            } else if (type == Byte.TYPE || type == Byte.class) {
                field.set(t, NumberUtils.toByte((String)value));
            } else if (type == Short.TYPE || type == Short.class) {
                field.set(t, NumberUtils.toShort((String)value));
            } else if (type == Double.TYPE || type == Double.class) {
                field.set(t, NumberUtils.toDouble((String)value));
            } else if (type == Float.TYPE || type == Float.class) {
                field.set(t, Float.valueOf(NumberUtils.toFloat((String)value)));
            } else if (type == Character.TYPE || type == Character.class) {
                field.set(t, Character.valueOf(CharUtils.toChar((String)value)));
            } else if (type == Boolean.TYPE) {
                field.set(t, BooleanUtils.toBoolean((String)value));
            } else if (type == BigDecimal.class) {
                field.set(t, new BigDecimal(value));
            }
        } else if (type == Boolean.class) {
            field.set(t, BooleanUtils.toBoolean((String)value));
        } else if (type == Date.class) {
            field.set(t, value);
        } else if (type == String.class) {
            field.set(t, value);
        } else {
            Constructor<?> constructor = type.getConstructor(String.class);
            field.set(t, constructor.newInstance(value));
        }
    }

    public static void setAutoResizeColumn(Workbook workbook) {
        int sheets = workbook.getNumberOfSheets();
        for (int index = 0; index < sheets; ++index) {
            Sheet sheet = workbook.getSheetAt(index);
            int cols = sheet.getRow(0).getPhysicalNumberOfCells();
            for (int i = 0; i < cols; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    public static void exportCSV(String fileName, LinkedHashMap<String, String> headerMap, List<Map<String, Object>> exportData, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName + ".csv", "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        try (ServletOutputStream out = response.getOutputStream();
             ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             BufferedWriter buffCvsWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteStream, StandardCharsets.UTF_8));){
            ExcelUtil.fillDataToCsv(buffCvsWriter, headerMap, headerMap);
            Iterator<Map<String, Object>> iterator = exportData.iterator();
            while (iterator.hasNext()) {
                ExcelUtil.fillDataToCsv(buffCvsWriter, headerMap, iterator.next());
            }
            buffCvsWriter.flush();
            out.write(byteStream.toByteArray());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void fillDataToCsv(BufferedWriter buffCvsWriter, LinkedHashMap<String, String> header, Map row) throws IOException {
        Iterator<String> keyIterator = header.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            String propertyValue = "";
            if (BeanUtils.isNotEmpty(row.get(key))) {
                propertyValue = row.get(key).toString();
            }
            buffCvsWriter.write("\t" + propertyValue + " ");
            if (!keyIterator.hasNext()) continue;
            buffCvsWriter.write(",");
        }
        buffCvsWriter.newLine();
    }
}

