/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.base.util.CommonUtil;
import com.artfess.base.util.StringUtil;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    private static String minioUrl;
    private static String minioName;
    private static String minioPass;
    private static String bucketName;
    private static MinioClient minioClient;

    public static void setMinioUrl(String minioUrl) {
        MinioUtil.minioUrl = minioUrl;
    }

    public static void setMinioName(String minioName) {
        MinioUtil.minioName = minioName;
    }

    public static void setMinioPass(String minioPass) {
        MinioUtil.minioPass = minioPass;
    }

    public static void setBucketName(String bucketName) {
        MinioUtil.bucketName = bucketName;
    }

    public static String getMinioUrl() {
        return minioUrl;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static String uploadRelative(MultipartFile file, String bizPath, String fileName, String customBucket) throws Exception {
        String file_url = "";
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists(newBucket)) {
            log.info("Bucket already exists.");
        } else {
            minioClient.makeBucket(newBucket);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        InputStream stream = file.getInputStream();
        String objectName = "";
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            String orgName = file.getOriginalFilename();
            orgName = CommonUtil.getFileName((String)orgName);
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf("."));
        } else {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + fileName;
        }
        if (objectName.startsWith("/")) {
            objectName = objectName.substring(1);
        }
        minioClient.putObject(newBucket, objectName, stream, (long)stream.available(), "application/octet-stream");
        stream.close();
        if (!minioUrl.endsWith("/")) {
            minioUrl = minioUrl.concat("/");
        }
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        if (newBucket.startsWith("/")) {
            newBucket = newBucket.substring(1);
        }
        file_url = newBucket + objectName;
        return file_url;
    }

    public static String upload(File file, String bizPath, String fileName, String customBucket) throws Exception {
        String file_url = "";
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists(newBucket)) {
            log.info("Bucket already exists.");
        } else {
            minioClient.makeBucket(newBucket);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        FileInputStream stream = new FileInputStream(file);
        String objectName = "";
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            String orgName = file.getName();
            orgName = CommonUtil.getFileName((String)orgName);
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf("."));
        } else {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + fileName;
        }
        if (objectName.startsWith("/")) {
            objectName = objectName.substring(1);
        }
        minioClient.putObject(newBucket, objectName, (InputStream)stream, (long)((InputStream)stream).available(), "application/octet-stream");
        ((InputStream)stream).close();
        if (!minioUrl.endsWith("/")) {
            minioUrl = minioUrl.concat("/");
        }
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        if (newBucket.startsWith("/")) {
            newBucket = newBucket.substring(1);
        }
        file_url = minioUrl + newBucket + objectName;
        return file_url;
    }

    public static String upload(MultipartFile file, String bizPath, String fileName, String customBucket) throws Exception {
        String file_url = "";
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists(newBucket)) {
            log.info("Bucket already exists.");
        } else {
            minioClient.makeBucket(newBucket);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        InputStream stream = file.getInputStream();
        String objectName = "";
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            String orgName = file.getOriginalFilename();
            orgName = CommonUtil.getFileName((String)orgName);
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.indexOf("."));
        } else {
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (!bizPath.endsWith("/")) {
                bizPath = bizPath.concat("/");
            }
            objectName = bizPath + fileName;
        }
        if (objectName.startsWith("/")) {
            objectName = objectName.substring(1);
        }
        minioClient.putObject(newBucket, objectName, stream, (long)stream.available(), "application/octet-stream");
        stream.close();
        if (!minioUrl.endsWith("/")) {
            minioUrl = minioUrl.concat("/");
        }
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        if (newBucket.startsWith("/")) {
            newBucket = newBucket.substring(1);
        }
        file_url = minioUrl + newBucket + objectName;
        return file_url;
    }

    public static String getMinIoUrl(String bizPath, String fileName) {
        String newBucket = bucketName;
        String objectName = bizPath + "/" + fileName.substring(0, fileName.lastIndexOf(".")) + fileName.substring(fileName.indexOf("."));
        if (!newBucket.endsWith("/")) {
            newBucket = newBucket.concat("/");
        }
        if (newBucket.startsWith("/")) {
            newBucket = newBucket.substring(1);
        }
        return minioUrl + newBucket + objectName;
    }

    public static String uploadByInputStream(InputStream stream, String relativePath, String customBucket) throws Exception {
        String newBucket = bucketName;
        if (StringUtil.isNotEmpty((String)customBucket)) {
            newBucket = customBucket;
        }
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        if (minioClient.bucketExists(newBucket)) {
            log.info("Bucket already exists.");
        } else {
            minioClient.makeBucket(newBucket);
            log.info("create a new bucket as \u3010" + newBucket + "\u3011\uff01");
        }
        minioClient.putObject(newBucket, relativePath, stream, (long)stream.available(), "application/octet-stream");
        stream.close();
        return minioUrl + newBucket + "/" + relativePath;
    }

    public static String uploadByInputStream(InputStream stream, String relativePath) throws Exception {
        return MinioUtil.uploadByInputStream(stream, relativePath, bucketName);
    }

    public static InputStream getMinioFile(String customBucket, String fileName, boolean isRelative) {
        InputStream inputStream = null;
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                fileName = fileName.replace(minioUrl, "");
                fileName = fileName.replace(newBucket, "");
            }
            inputStream = minioClient.getObject(newBucket, fileName);
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        return inputStream;
    }

    public static InputStream getMinioFile(String fileName, boolean isRelative) {
        return MinioUtil.getMinioFile(bucketName, fileName, isRelative);
    }

    public static void removeObject(String customBucket, String fileName, boolean isRelative) {
        try {
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                if (!minioUrl.endsWith("/")) {
                    minioUrl = minioUrl.concat("/");
                }
                if (newBucket.startsWith("/")) {
                    newBucket = newBucket.substring(1);
                }
                fileName = fileName.replace(minioUrl + newBucket, "");
            }
            ObjectStat objectStat = minioClient.statObject(newBucket, fileName);
            objectStat.toString();
            minioClient.removeObject(newBucket, fileName);
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u5220\u9664\u5931\u8d25" + e.getMessage());
        }
    }

    public static void removeObject(String fileName, boolean isRelative) {
        MinioUtil.removeObject(bucketName, fileName, isRelative);
    }

    public static String getObjectURL(String customBucket, String objectName, Integer expires) throws Exception {
        MinioUtil.initMinio(minioUrl, minioName, minioPass);
        try {
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            String url = minioClient.presignedGetObject(newBucket, objectName, expires);
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public static boolean downFile(String customBucket, String fileName, OutputStream out, boolean isRelative) {
        InputStream inputStream = null;
        try {
            int len;
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                fileName = fileName.replace(minioUrl, "");
                fileName = fileName.replace(newBucket, "");
            }
            inputStream = minioClient.getObject("xypm", fileName);
            byte[] b = new byte[1024];
            while ((len = inputStream.read(b)) != -1) {
                out.write(b, 0, len);
            }
            out.close();
            inputStream.close();
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean checkFile(String customBucket, String fileName, boolean isRelative) {
        InputStream inputStream = null;
        try {
            int len;
            MinioUtil.initMinio(minioUrl, minioName, minioPass);
            String newBucket = bucketName;
            if (StringUtil.isNotEmpty((String)customBucket)) {
                newBucket = customBucket;
            }
            if (!isRelative) {
                fileName = fileName.replace(minioUrl, "");
                fileName = fileName.replace(newBucket, "");
            }
            inputStream = minioClient.getObject(newBucket, fileName);
            int byteCount = 0;
            byte[] b = new byte[1024];
            while ((len = inputStream.read(b)) != -1) {
                byteCount += byteCount;
            }
            inputStream.close();
            return byteCount > 0;
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
            return false;
        }
    }

    private static MinioClient initMinio(String minioUrl, String minioName, String minioPass) throws InvalidEndpointException, InvalidPortException {
        if (minioClient == null) {
            minioClient = new MinioClient(minioUrl, minioName, minioPass);
        }
        return minioClient;
    }

    static {
        minioClient = null;
    }
}

