/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.FormFeignService;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.bpm.api.constant.DesignerType;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.model.process.def.BpmBoDef;
import com.artfess.bpm.api.model.process.def.BpmDefExtProperties;
import com.artfess.bpm.api.model.process.def.BpmDefSetting;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmFormInit;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDefComparator;
import com.artfess.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.context.PluginParse;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.api.service.BpmTaskService;
import com.artfess.bpm.api.service.DiagramService;
import com.artfess.bpm.engine.def.BpmDefUtil;
import com.artfess.bpm.engine.def.impl.handler.BoBpmDefXmlHandler;
import com.artfess.bpm.engine.def.impl.handler.BpmDefSettingBpmDefXmlHandler;
import com.artfess.bpm.engine.def.impl.handler.BpmFormInitBpmDefXmlHandler;
import com.artfess.bpm.engine.def.impl.handler.ButtonsBpmDefXmlHandler;
import com.artfess.bpm.engine.def.impl.handler.PropertiesBpmDefXmlHandler;
import com.artfess.bpm.engine.task.skip.SkipConditionUtil;
import com.artfess.bpm.model.def.BpmDefXml;
import com.artfess.bpm.model.def.BpmDefXmlList;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProBoManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.model.BpmProBo;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.plugin.task.userassign.context.UserAssignPluginContext;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.workflow.bpmModel.manager.BpmDefTransform;
import com.artfess.workflow.bpmModel.params.CopyFlow;
import com.artfess.workflow.bpmModel.params.DefBoSetVo;
import com.artfess.workflow.bpmModel.params.DefBtnsSaveVo;
import com.artfess.workflow.bpmModel.params.DefPropSaveVo;
import com.artfess.workflow.bpmModel.params.DefaultBpmDefinitionVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.ClientProtocolException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/flow/def/v1/"})
@Api(tags={"\u6d41\u7a0b\u5b9a\u4e49"})
@ApiGroup(group={"group_bpm"})
public class DefController
extends BaseController<BpmDefinitionManager, DefaultBpmDefinition> {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    DiagramService diagramService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    PropertiesBpmDefXmlHandler propertiesBpmDefXmlHandler;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmDefTransform bpmDefTransform;
    @Resource
    BoBpmDefXmlHandler boBpmDefXmlHandler;
    @Resource
    BpmFormInitBpmDefXmlHandler bpmFormInitBpmDefXmlHandler;
    @Resource
    BpmProBoManager bpmProBoManager;
    @Resource
    ButtonsBpmDefXmlHandler buttonsBpmDefXmlHandler;
    @Resource
    BpmTaskService bpmTaskService;
    private static final String ROOT_PATH = "attachFiles" + File.separator + "tempZip";

    @RequestMapping(value={"bpmnXml"}, method={RequestMethod.GET}, produces={"application/xml; charset=UTF-8"})
    @ApiOperation(value="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u751f\u6210\u7684BPMNxml", httpMethod="GET", notes="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u751f\u6210\u7684BPMNxml")
    public Object bpmnXml(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        if (StringUtils.isEmpty((String)defId)) {
            return "no def input";
        }
        DefaultBpmDefinition po = this.bpmDefinitionManager.getById(defId);
        String bpmnXml = po.getBpmnXml();
        return bpmnXml;
    }

    @RequestMapping(value={"designXml"}, method={RequestMethod.GET}, produces={"application/xml; charset=UTF-8"})
    @ApiOperation(value="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml", httpMethod="GET", notes="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml")
    public Object designXml(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        if (StringUtils.isEmpty((String)defId)) {
            return "no def input";
        }
        DefaultBpmDefinition po = this.bpmDefinitionManager.getById(defId);
        String bpmnXml = po.getDefXml();
        return bpmnXml;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5bf9\u8c61")
    public DefaultBpmDefinition getJson(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49Key", required=true) @RequestParam String defKey) {
        DefaultBpmDefinition po = this.bpmDefinitionManager.getMainByDefKey(defKey);
        if (BeanUtils.isNotEmpty((Object)po)) {
            po.setBpmnXml("");
        }
        return po;
    }

    @RequestMapping(value={"webDefDesign"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml", httpMethod="GET", notes="\u8fd4\u56de\u6d41\u7a0b\u8bbe\u8ba1\u7684xml")
    public Object webDefDesign(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws ClientProtocolException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        if (BeanUtils.isNotEmpty((Object)def)) {
            map.put("defId", def.getDefId());
            map.put("name", def.getName());
            map.put("desc", def.getDesc());
            map.put("defKey", def.getDefKey());
            map.put("modelId", def.getDefId());
            map.put("model", def.getDefJson());
            map.put("reason", def.getReason());
            map.put("version", def.getVersion());
            map.put("showUrgentState", def.getShowUrgentState());
            map.put("showModifyRecord", def.getShowModifyRecord());
            map.put("isReadRevoke", def.getIsReadRevoke());
            map.put("urgentMailTel", def.getUrgentMailTel());
            map.put("urgentSmsTel", def.getUrgentSmsTel());
            ObjectNode type = null;
            if (BeanUtils.isNotEmpty((Object)def.getTypeId())) {
                type = this.systemConfigFeignService.getSysTypeById(def.getTypeId());
            }
            if (BeanUtils.isNotEmpty(type)) {
                map.put("typeId", def.getTypeId());
                map.put("typeName", type.get("name").asText());
            }
        }
        return map;
    }

    @RequestMapping(value={"webDefSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="web\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58", httpMethod="POST", notes="web\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58")
    public CommonResult<String> webDefSave(@ApiParam(name="bpmDefinitionVo", value="\u4fdd\u5b58\u6d41\u7a0b\u5bf9\u8c61", required=true) @RequestBody DefaultBpmDefinitionVo bpmDefinitionVo) throws Exception {
        Boolean isDeploy = bpmDefinitionVo.getIsdeploy();
        DefaultBpmDefinition bpmDefinition = this.getWebDesignFromRequest(bpmDefinitionVo);
        String actionName = isDeploy != false ? "\u6d41\u7a0b\u53d1\u5e03" : "\u6d41\u7a0b\u4fdd\u5b58";
        String resultMsg = "";
        try {
            String oldTypeId;
            List oldDefs = this.bpmDefinitionManager.queryByDefKey(bpmDefinition.getDefKey());
            if (StringUtils.isEmpty((String)bpmDefinition.getDefId()) && BeanUtils.isNotEmpty((Object)oldDefs)) {
                resultMsg = "\u6d41\u7a0b\u5b9a\u4e49KEY\u201c" + bpmDefinition.getDefKey() + "\u201d \u5df2\u7ecf\u5b58\u5728\u4e8e\uff1a" + ((DefaultBpmDefinition)oldDefs.get(0)).getName();
                return new CommonResult(false, resultMsg, (Object)"");
            }
            if (isDeploy.booleanValue()) {
                bpmDefinition.setUpdateTime(LocalDateTime.now());
                if (!this.bpmDefinitionService.deploy((BpmDefinition)bpmDefinition)) {
                    return new CommonResult(false, actionName + "\u5931\u8d25", (Object)"");
                }
            } else if (StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                this.bpmDefinitionService.updateBpmDefinition((BpmDefinition)bpmDefinition);
            } else {
                this.bpmDefinitionService.saveDraft((BpmDefinition)bpmDefinition);
            }
            if (BeanUtils.isNotEmpty((Object)oldDefs) && oldDefs.size() > 0 && !(oldTypeId = ((DefaultBpmDefinition)oldDefs.get(0)).getTypeId()).equals(bpmDefinition.getTypeId())) {
                this.bpmDefinitionManager.updateTypeIdByDefKey(bpmDefinition.getDefKey(), bpmDefinition.getTypeId());
            }
            return new CommonResult(true, actionName + "\u6210\u529f", (Object)bpmDefinition.getDefId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new CommonResult(false, actionName + "\u5931\u8d25\uff1a" + ex.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"flexDefSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="flex\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58", httpMethod="POST", notes="flex\u6d41\u7a0b\u8bbe\u8ba1\u5668\u4fdd\u5b58")
    public CommonResult<String> flexDefSave(@ApiParam(name="bpmDefinitionVo", value="\u4fdd\u5b58\u6d41\u7a0b\u5bf9\u8c61", required=true) @RequestBody DefaultBpmDefinitionVo bpmDefinitionVo) throws Exception {
        Boolean isDeploy = bpmDefinitionVo.getIsdeploy();
        DefaultBpmDefinition bpmDefinition = this.getFromRequest(bpmDefinitionVo);
        String resultMsg = "";
        try {
            List oldDefs;
            if (StringUtils.isEmpty((String)bpmDefinition.getDefId()) && BeanUtils.isNotEmpty((Object)(oldDefs = this.bpmDefinitionManager.queryByDefKey(bpmDefinition.getDefKey())))) {
                resultMsg = "\u6d41\u7a0b\u5b9a\u4e49KEY\u201c" + bpmDefinition.getDefKey() + "\u201d \u5df2\u7ecf\u5b58\u5728\u4e8e\uff1a" + ((DefaultBpmDefinition)oldDefs.get(0)).getName();
                return new CommonResult(false, resultMsg, (Object)"");
            }
            if (isDeploy.booleanValue()) {
                this.bpmDefinitionService.deploy((BpmDefinition)bpmDefinition);
            } else if (StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                this.bpmDefinitionService.updateBpmDefinition((BpmDefinition)bpmDefinition);
            } else {
                this.bpmDefinitionService.saveDraft((BpmDefinition)bpmDefinition);
            }
            return new CommonResult(true, "\u6d41\u7a0b\u53d1\u5e03\u6210\u529f", (Object)"");
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            return new CommonResult(false, "\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25\uff1a" + rootCauseMessage, (Object)"");
        }
    }

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<DefaultBpmDefinition> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter) throws Exception {
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
        PageList bpmDefinitionList = this.bpmDefinitionManager.queryList(queryFilter);
        return bpmDefinitionList;
    }

    @RequestMapping(value={"formDeflist"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ed1\u5b9a\u6307\u5b9a\u8868\u5355\u7684\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<DefaultBpmDefinition> formDeflist(@ApiParam(name="boCode", value="boCode", required=true) @RequestParam String boCode, @ApiParam(name="formKey", value="formKey", required=true) @RequestParam String formKey, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter) throws Exception {
        List proBos = this.bpmProBoManager.getByBoCode(boCode);
        if (BeanUtils.isNotEmpty((Object)proBos)) {
            HashSet<String> defIds = new HashSet<String>();
            HashSet<String> defKeys = new HashSet<String>();
            for (BpmProBo proBo : proBos) {
                defIds.add(proBo.getProcessId());
                defKeys.add(proBo.getProcessKey());
            }
            queryFilter.addFilter("defId", (Object)defIds.toArray(new String[defIds.size()]), QueryOP.IN, FieldRelation.OR, "def");
            queryFilter.addFilter("def_key_", (Object)defKeys.toArray(new String[defKeys.size()]), QueryOP.IN, FieldRelation.OR, "def");
            queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL, FieldRelation.AND, "isMain");
            PageList bpmDefinitionList = this.bpmDefinitionManager.queryList(queryFilter);
            for (String str : defIds) {
                boolean form;
                BpmProcessDef bpmProcessDef;
                DefaultBpmDefinition result = this.bpmDefinitionManager.getById(str);
                if (BeanUtils.isEmpty((Object)result) || !BeanUtils.isNotEmpty((Object)(bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(str)))) continue;
                DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
                FormExt globalForm = defExt.getGlobalForm();
                FormExt globalMobileForm = defExt.getGlobalMobileForm();
                boolean bl = globalForm != null ? !formKey.equals(globalForm.getFormValue()) : (form = true);
                boolean mobile = globalMobileForm != null ? !formKey.equals(globalMobileForm.getFormValue()) : true;
                int i = 0;
                ArrayList<Integer> list = null;
                for (DefaultBpmDefinition def : bpmDefinitionList.getRows()) {
                    if (def.getDefKey().equals(bpmProcessDef.getDefKey()) && form && mobile) {
                        list = new ArrayList<Integer>();
                        list.add(i);
                    }
                    ++i;
                }
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    bpmDefinitionList.getRows().remove(j);
                    bpmDefinitionList.setTotal(bpmDefinitionList.getTotal() - 1L);
                }
            }
            return bpmDefinitionList;
        }
        return new PageList((IPage)new Page(1L, (long)queryFilter.getPageBean().getPageSize().intValue()));
    }

    @RequestMapping(value={"getByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5206\u7c7bid\u67e5\u8be2\u6570\u636e", httpMethod="GET", notes="\u6d41\u7a0b\u5b9a\u4e49\u5206\u7c7bid\u67e5\u8be2\u6570\u636e")
    public PageList<DefaultBpmDefinition> getByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid") @RequestParam String typeId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("is_main_", (Object)"Y", QueryOP.EQUAL);
        queryFilter.addFilter("type_id_", (Object)typeId, QueryOP.EQUAL);
        return this.bpmDefinitionManager.queryList(queryFilter);
    }

    @RequestMapping(value={"defGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f")
    public DefaultBpmDefinition defGet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        DefaultBpmDefinition bpmDefinition = null;
        if (StringUtil.isNotEmpty((String)defId)) {
            bpmDefinition = this.bpmDefinitionManager.getById(defId);
        }
        return bpmDefinition;
    }

    private InputStream getDiagramByInstance(DiagramService diagramService, String bpmnInstId) {
        BpmInstService bpmInstService = (BpmInstService)AppUtil.getBean(BpmInstService.class);
        BpmProcessInstance bpmProcessInstance = bpmInstService.getProcessInstanceByBpmnInstId(bpmnInstId);
        BpmProStatusManager bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        Map colorMap = bpmProStatusManager.getProcessInstanceStatus(bpmProcessInstance.getId());
        return diagramService.getDiagramByDefId(bpmProcessInstance.getProcDefId(), colorMap);
    }

    @RequestMapping(value={"image"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56fe", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u56fe")
    public void image(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="bpmnInstId", value="bpmn\u5b9e\u4f8bid", required=false) @RequestParam String bpmnInstId, @ApiParam(name="taskId", value="\u4efb\u52a1idid", required=false) @RequestParam String taskId, HttpServletResponse response) throws Exception {
        InputStream is = null;
        if (StringUtils.isNotEmpty((String)defId)) {
            is = this.diagramService.getDiagramByBpmnDefId(defId);
        } else if (StringUtils.isNotEmpty((String)bpmnInstId)) {
            is = this.getDiagramByInstance(this.diagramService, bpmnInstId);
        } else if (StringUtils.isNotEmpty((String)taskId)) {
            BpmTask bpmTask = this.bpmTaskService.getByTaskId(taskId);
            is = this.getDiagramByInstance(this.diagramService, bpmTask.getBpmnInstId());
        }
        if (is == null) {
            return;
        }
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        FileUtil.writeInput((InputStream)is, (OutputStream)out);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u3002")
    public Object save(@ApiParam(name="bpmVo", value="\u6d41\u7a0b\u4fdd\u5b58\u5bf9\u8c61", required=true) @RequestParam DefaultBpmDefinitionVo bpmVo) throws Exception {
        String resultMsg = null;
        String isDeploy = String.valueOf(bpmVo.getIsdeploy());
        String isSave = String.valueOf(bpmVo.getIsSave());
        String defXml = bpmVo.getDefXml();
        DefaultBpmDefinition bpmDefinition = bpmVo.getDefaultBpmDefinition();
        MultipartFile fileLoad = bpmVo.getFile();
        if (fileLoad == null) {
            bpmDefinition.setDefXml(defXml);
        } else {
            bpmDefinition.setDefXml(FileUtil.inputStream2String((InputStream)fileLoad.getInputStream()));
        }
        bpmDefinition.setDesigner(DesignerType.ECLIPSE.name());
        try {
            if ("true".equals(isDeploy)) {
                if (StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                    DefaultBpmDefinition oldBpmDefinition = this.bpmDefinitionManager.getById(bpmDefinition.getDefId());
                    BeanUtils.copyNotNullProperties((Object)oldBpmDefinition, (Object)bpmDefinition);
                    this.bpmDefinitionService.deploy((BpmDefinition)oldBpmDefinition);
                    resultMsg = "\u6210\u529f\u53d1\u5e03\u65b0\u7248\u672c\u6d41\u7a0b\u5b9a\u4e49\uff01";
                } else {
                    this.bpmDefinitionService.deploy((BpmDefinition)bpmDefinition);
                    resultMsg = "\u6210\u529f\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49\uff01";
                }
            } else if ("true".equals(isSave) && StringUtils.isNotEmpty((String)bpmDefinition.getDefId())) {
                DefaultBpmDefinition oldBpmDefinition = this.bpmDefinitionManager.getById(bpmDefinition.getDefId());
                BeanUtils.copyNotNullProperties((Object)oldBpmDefinition, (Object)bpmDefinition);
                this.bpmDefinitionService.updateBpmDefinition((BpmDefinition)oldBpmDefinition);
                resultMsg = "\u6210\u529f\u66f4\u65b0\u6d41\u7a0b\u5b9a\u4e49\uff01";
            } else {
                this.bpmDefinitionService.saveDraft((BpmDefinition)bpmDefinition);
                resultMsg = "\u6210\u529f\u4fdd\u5b58\u6d41\u7a0b\u5b9a\u4e49\u8349\u7a3f\uff01";
            }
            return new CommonResult(true, resultMsg, (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, " \u64cd\u4f5c\u51fa\u9519\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"removeByDefIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49")
    public CommonResult<String> removeByDefIds(@ApiParam(name="ids", value="\u6d41\u7a0b\u5b9a\u4e49id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids, @ApiParam(name="cascade", value="\u662f\u5426\u7ea7\u8054\u5220\u9664\u8be5\u6d41\u7a0b\u6240\u6709\u7248\u672c", required=true) @RequestParam Optional<Boolean> cascade, @ApiParam(name="isVersion", value="\u662f\u5426\u662f\u4ece\u7248\u672c\u7ba1\u7406\u5220\u9664", required=true) @RequestParam Optional<Boolean> isVersion) throws Exception {
        try {
            String[] aryIds = ids.split(",");
            this.bpmDefinitionManager.removeDefIds(cascade.orElse(false).booleanValue(), isVersion.orElse(false), aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25:" + rootCauseMessage, (Object)"");
        }
    }

    @RequestMapping(value={"saveSetBos"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u8bbe\u7f6e\u7684BO\u8bbe\u7f6e", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u8bbe\u7f6e\u7684BO\u8bbe\u7f6e")
    public CommonResult<String> saveSetBos(@ApiParam(name="defBoSetVo", value="\u6d41\u7a0bbo\u8bbe\u7f6e\u5bf9\u8c61", required=true) @RequestBody DefBoSetVo defBoSetVo) throws Exception {
        CommonResult msg = new CommonResult(false, "BO\u8bbe\u7f6e\u5185\u5bb9\u4e3a\u7a7a!", (Object)"\u5185\u5bb9\u4e3a\u7a7a!");
        String userId = ContextUtil.getCurrentUser().getUserId();
        String json = defBoSetVo.getJson();
        String topDefKey = defBoSetVo.getTopDefKey();
        String flowId = defBoSetVo.getFlowId();
        Boolean isClearForm = defBoSetVo.getIsClearForm();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(flowId);
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        BpmFormInit formInit = new BpmFormInit();
        if (jsonObj.findValue("formInitItems") != null) {
            formInit = (BpmFormInit)JsonUtil.toBean((String)json, BpmFormInit.class);
            formInit.setParentDefKey(topDefKey);
        }
        this.bpmFormInitBpmDefXmlHandler.saveNodeXml(flowId, "", (Object)formInit);
        ObjectNode bodefJson = (ObjectNode)jsonObj.get("bodef");
        BpmBoDef bpmBoDef = new BpmBoDef();
        if (bodefJson != null) {
            bpmBoDef = (BpmBoDef)JsonUtil.toBean((JsonNode)bodefJson, BpmBoDef.class);
            this.saveBpmProBoList(userId, flowId, def.getDefKey(), topDefKey, bpmBoDef, isClearForm);
        }
        this.boBpmDefXmlHandler.saveNodeXml(flowId, "", (Object)bpmBoDef);
        msg.setState(Boolean.valueOf(true));
        msg.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
        msg.setValue((Object)"\u5185\u5bb9\u5b8c\u6574\uff01");
        return msg;
    }

    private void saveBpmProBoList(String userId, String flowId, String flowKey, String parentFlowKey, BpmBoDef bpmBoDef, Boolean isClearForm) throws Exception {
        List dbProBos = this.bpmProBoManager.getByProcessId(flowId);
        ArrayList<BpmProBo> bpmProBoList = new ArrayList<BpmProBo>();
        List boDefs = bpmBoDef.getBoDefs();
        for (ProcBoDef procBoDef : boDefs) {
            BpmProBo bpmProBo = new BpmProBo();
            bpmProBo.setProcessId(flowId);
            bpmProBo.setProcessKey(flowKey);
            bpmProBo.setBoCode(procBoDef.getKey());
            bpmProBo.setBoName(procBoDef.getName());
            bpmProBo.setCreatorId(userId);
            bpmProBoList.add(bpmProBo);
        }
        this.bpmProBoManager.createByBpmProBoList(bpmProBoList, flowId, flowKey);
        if (BeanUtils.isNotEmpty((Object)boDefs) && dbProBos.containsAll(bpmProBoList)) {
            return;
        }
        if (isClearForm.booleanValue()) {
            FormFeignService formService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            formService.removeFormRights(flowKey, parentFlowKey);
            BpmDefSetting bpmDefSetting = new BpmDefSetting();
            BpmDefSettingBpmDefXmlHandler bpmDefSettingBpmDefXmlHandler = (BpmDefSettingBpmDefXmlHandler)AppUtil.getBean(BpmDefSettingBpmDefXmlHandler.class);
            bpmDefSettingBpmDefXmlHandler.saveNodeXml(flowId, null, (Object)bpmDefSetting);
        }
    }

    private DefaultBpmDefinition getWebDesignFromRequest(DefaultBpmDefinitionVo vo) throws Exception {
        DefaultBpmDefinition defaultBpmDef = vo.getDefaultBpmDefinition();
        String typeId = defaultBpmDef.getTypeId();
        String name = defaultBpmDef.getName();
        String defKey = defaultBpmDef.getDefKey();
        String descp = defaultBpmDef.getDesc();
        String defJson = defaultBpmDef.getDefJson();
        Boolean isDeploy = vo.getIsdeploy();
        String reason = defaultBpmDef.getReason();
        String defId = defaultBpmDef.getDefId();
        DefaultBpmDefinition bpmDefinition = null;
        if (StringUtils.isNotEmpty((String)defId)) {
            bpmDefinition = isDeploy != false ? this.bpmDefinitionManager.getById(defId) : this.bpmDefinitionManager.getById(defId);
        }
        if (bpmDefinition == null) {
            bpmDefinition = new DefaultBpmDefinition();
            if (StringUtils.isNotEmpty((String)defKey)) {
                bpmDefinition.setDefKey(defKey);
            }
        }
        if (StringUtils.isNotEmpty((String)typeId)) {
            bpmDefinition.setTypeId(typeId);
            bpmDefinition.setTypeName(defaultBpmDef.getTypeName());
        }
        if (StringUtils.isNotEmpty((String)name)) {
            bpmDefinition.setName(name);
        }
        if (StringUtils.isNotEmpty((String)descp)) {
            bpmDefinition.setDesc(descp);
        }
        if (StringUtils.isNotEmpty((String)defJson)) {
            bpmDefinition.setDefJson(defJson);
        }
        bpmDefinition.setDesigner(DesignerType.WEB.name());
        bpmDefinition.setReason(reason);
        bpmDefinition.setCreateBy(ContextUtil.getCurrentUser().getUserId());
        bpmDefinition.setCreateOrgId(ContextUtil.getCurrentGroupId());
        return bpmDefinition;
    }

    private DefaultBpmDefinition getFromRequest(DefaultBpmDefinitionVo vo) throws Exception {
        DefaultBpmDefinition defaultBpmDef = vo.getDefaultBpmDefinition();
        String typeId = defaultBpmDef.getTypeId();
        String subject = defaultBpmDef.getName();
        String defKey = defaultBpmDef.getDefKey();
        String descp = defaultBpmDef.getDesc();
        String defXml = defaultBpmDef.getDefXml();
        String defJson = defaultBpmDef.getDefJson();
        Boolean isDeploy = vo.getIsdeploy();
        defXml = defXml.replace("''", "'");
        String reason = defaultBpmDef.getReason();
        String defId = defaultBpmDef.getDefId();
        DefaultBpmDefinition bpmDefinition = null;
        if (StringUtils.isNotEmpty((String)defId)) {
            bpmDefinition = isDeploy != false ? this.bpmDefinitionManager.getById(defId) : this.bpmDefinitionManager.getById(defId);
        }
        if (bpmDefinition == null) {
            bpmDefinition = new DefaultBpmDefinition();
            if (StringUtils.isNotEmpty((String)defKey)) {
                bpmDefinition.setDefKey(defKey);
            }
        }
        if (StringUtils.isNotEmpty((String)typeId)) {
            bpmDefinition.setTypeId(typeId);
        }
        if (StringUtils.isNotEmpty((String)subject)) {
            bpmDefinition.setName(subject);
        }
        if (StringUtils.isNotEmpty((String)descp)) {
            bpmDefinition.setDesc(descp);
        } else {
            bpmDefinition.setDesc(subject);
        }
        if (StringUtils.isNotEmpty((String)defXml)) {
            bpmDefinition.setDefXml("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + defXml);
            bpmDefinition.setDesigner(DesignerType.FLASH.name());
        }
        if (StringUtils.isNotEmpty((String)defJson)) {
            bpmDefinition.setDefJson(defJson);
            bpmDefinition.setDesigner(DesignerType.WEB.name());
        }
        bpmDefinition.setReason(reason);
        return bpmDefinition;
    }

    @RequestMapping(value={"getFlowListByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4ee3\u7406\u4fe1\u606f", httpMethod="GET", notes="\u4fdd\u5b58\u4ee3\u7406\u4fe1\u606f")
    public void getFlowListByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bid", required=true) @RequestParam String typeId, @ApiParam(name="word", value="\u67e5\u8be2\u5173\u952e\u5b57", required=true) @RequestParam String word, HttpServletResponse response) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)typeId)) {
            params.put("typeId", typeId);
        }
        if (StringUtil.isNotEmpty((String)word)) {
            word = "%" + word + "%";
            params.put(typeId, typeId);
        }
        List list = this.bpmDefinitionManager.queryListByMap(params);
        StringBuffer msg = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Result>");
        for (DefaultBpmDefinition bpmDefinition : list) {
            msg.append("<item name=\"" + bpmDefinition.getName() + "\" key=\"" + bpmDefinition.getDefKey() + "\" type=\"" + bpmDefinition.getTypeId() + "\"></item>");
        }
        msg.append("</Result>");
        PrintWriter out = response.getWriter();
        out.println(msg.toString());
    }

    @RequestMapping(value={"flexGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5728\u7ebf\u8bbe\u8ba1\uff0c\u6839\u636edefId\u83b7\u53d6\u6d41\u7a0b\u5bf9\u5e94\u7684\u8be6\u7ec6\u4fe1\u606f", httpMethod="GET", notes="\u6d41\u7a0b\u5728\u7ebf\u8bbe\u8ba1\uff0c\u6839\u636edefId\u83b7\u53d6\u6d41\u7a0b\u5bf9\u5e94\u7684\u8be6\u7ec6\u4fe1\u606f")
    public void flexGet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, HttpServletResponse response) throws Exception {
        DefaultBpmDefinition bpmDefinition = null;
        bpmDefinition = StringUtil.isNotEmpty((String)defId) ? this.bpmDefinitionManager.getById(defId) : new DefaultBpmDefinition();
        StringBuffer msg = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Result>");
        msg.append("<defId>" + bpmDefinition.getDefId() + "</defId>");
        msg.append("<defXml>" + bpmDefinition.getDefXml() + "</defXml>");
        if (bpmDefinition.getTypeId() != null) {
            ObjectNode proType = this.systemConfigFeignService.getSysTypeById(bpmDefinition.getTypeId());
            msg.append("<typeName>" + proType.get("name").asText() + "</typeName>");
            msg.append("<typeId>" + proType.get("id").asText() + "</typeId>");
        }
        msg.append("<subject>" + bpmDefinition.getName() + "</subject>");
        msg.append("<defKey>" + bpmDefinition.getDefKey() + "</defKey>");
        msg.append("<descp>" + bpmDefinition.getDesc() + "</descp>");
        msg.append("<versionNo>" + bpmDefinition.getVersion() + "</versionNo>");
        msg.append("</Result>");
        PrintWriter out = response.getWriter();
        out.println(msg.toString());
    }

    @RequestMapping(value={"getOtherParam"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570")
    public Map<String, Object> getOtherParam(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(defId);
        BpmProcessDef procDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        BpmDefExtProperties prop = procDef.getProcessDefExt().getExtProperties();
        Map handlerTypes = MessageUtil.getHandlerTypes();
        List skipConditionList = SkipConditionUtil.getSkipConditions();
        if (StringUtil.isEmpty((String)prop.getDescription())) {
            prop.setDescription(bpmDefinition.getDesc());
        }
        prop.setTestStatus(bpmDefinition.getTestStatus());
        prop.setStatus(bpmDefinition.getStatus());
        prop.setShowUrgentState(bpmDefinition.getShowUrgentState() == 1);
        prop.setShowModifyRecord(bpmDefinition.getShowModifyRecord() == 1);
        prop.setReadRevoke(bpmDefinition.getIsReadRevoke().equals("true"));
        prop.setUrgentMailTel(bpmDefinition.getUrgentMailTel());
        prop.setUrgentSmsTel(bpmDefinition.getUrgentSmsTel());
        prop.setUseMainForm(BeanUtils.isNotEmpty((Object)prop.getUseMainForm()) ? prop.getUseMainForm() : "mainVersion");
        prop.setDoneDataVersion(BeanUtils.isNotEmpty((Object)prop.getDoneDataVersion()) ? prop.getDoneDataVersion() : "history");
        resMap.put("prop", prop);
        resMap.put("handlerTypes", handlerTypes);
        resMap.put("skipConditionList", skipConditionList);
        return resMap;
    }

    @RequestMapping(value={"saveProp"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570", httpMethod="POST", notes="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570")
    public CommonResult<String> saveProp(@ApiParam(name="defPropVo", value="\u6d41\u7a0b\u5176\u4ed6\u53c2\u6570\u4fdd\u5b58\u5bf9\u8c61", required=true) @RequestBody DefPropSaveVo defPropVo) throws Exception {
        try {
            String defId = defPropVo.getDefId();
            String description = defPropVo.getDescription();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", defId);
            map.put("rev", defPropVo.getRev());
            DefaultBpmDefinition defaultBpmDefinition1 = this.bpmDefinitionManager.getBpmDefinitionByRev(map);
            if (BeanUtils.isNotEmpty((Object)defaultBpmDefinition1)) {
                String urgentSms;
                BpmDefExtProperties prop = defPropVo.getBpmProp();
                String status = prop.getStatus();
                this.propertiesBpmDefXmlHandler.saveNodeXml(defId, "", (Object)prop);
                DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(defId);
                String oldStatus = bpmDefinition.getStatus();
                bpmDefinition.setTestStatus(prop.getTestStatus());
                bpmDefinition.setStatus(status);
                bpmDefinition.setDesc(description);
                bpmDefinition.setShowUrgentState(prop.isShowUrgentState() ? 1 : 0);
                bpmDefinition.setShowModifyRecord(prop.isShowModifyRecord() ? 1 : 0);
                bpmDefinition.setIsReadRevoke(prop.isReadRevoke() ? "true" : "false");
                String urgentMail = prop.getUrgentMailTel();
                if (StringUtil.isNotEmpty((String)urgentMail)) {
                    urgentMail = urgentMail.replace("<p>", "");
                    urgentMail = urgentMail.replace("</p>", "");
                }
                if (StringUtil.isNotEmpty((String)(urgentSms = prop.getUrgentSmsTel()))) {
                    urgentSms = urgentSms.replace("<p>", "");
                    urgentSms = urgentSms.replace("</p>", "");
                }
                bpmDefinition.setUrgentMailTel(urgentMail);
                bpmDefinition.setUrgentSmsTel(urgentSms);
                this.bpmDefinitionManager.update((Model)bpmDefinition);
                this.bpmDefinitionManager.updBpmDefinitionStatus(bpmDefinition, oldStatus);
                this.bpmDefinitionAccessor.clean(defId);
                return new CommonResult(true, "\u4fdd\u5b58\u6d41\u7a0b\u53c2\u6570\u6210\u529f!", (Object)"");
            }
            return new CommonResult(false, "\u6b64\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fdd\u5b58\u6d41\u7a0b\u53c2\u6570\u5931\u8d25!", (Object)"");
        }
    }

    @RequestMapping(value={"nodeBos"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5c55\u793a\u6d41\u7a0b\u8282\u70b9BO\u8bbe\u7f6e", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5176\u4ed6\u5c5e\u6027\u7684\u53c2\u6570")
    public Object nodeBos(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="topDefKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String topDefKey) throws Exception {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(defId);
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        BpmBoDef boDef = null;
        if (StringUtil.isNotEmpty((String)topDefKey)) {
            DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getMainByDefKey(topDefKey, false);
            BpmProcessDef topProcessExt = this.bpmDefinitionAccessor.getBpmProcessDef(bpmDef.getDefId());
            boDef = BpmDefUtil.getBpmBoDef((BpmProcessDef)topProcessExt);
        } else {
            boDef = BpmDefUtil.getBpmBoDef((BpmProcessDef)bpmProcessDefExt);
        }
        List nodeDefList = BpmDefUtil.getNodeDefs((BpmProcessDef)bpmProcessDefExt);
        BpmFormInit formInit = BpmDefUtil.getBpmFormInit((BpmProcessDef)bpmProcessDefExt, (String)topDefKey);
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((Object)formInit);
        ObjectNode boDefJson = (ObjectNode)JsonUtil.toJsonNode((Object)boDef);
        jsonObj.set("bodef", (JsonNode)boDefJson);
        ArrayNode jry = JsonUtil.getMapper().createArrayNode();
        for (BpmNodeDef def : nodeDefList) {
            ObjectNode jo = JsonUtil.getMapper().createObjectNode();
            jo.put("nodeId", def.getNodeId());
            jo.put("name", def.getName());
            jry.add((JsonNode)jo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bpmDefinition", bpmDefinition);
        map.put("json", jsonObj);
        map.put("nodeDefList", jry);
        return map;
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="bpmDefId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String bpmDefId) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)bpmDefId)) {
            String[] bpmDefIds = bpmDefId.split(",");
            List<String> defList = Arrays.asList(bpmDefIds);
            String zipName = "ht_flow_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = this.bpmDefTransform.exportDef(defList);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    public static void checkXmlFormat(String xml) throws Exception {
        String firstName = "bpmlist";
        String nextName = "bpmDef";
        Document doc = Dom4jUtil.loadXml((String)xml);
        Element root = doc.getRootElement();
        String msg = "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9";
        if (!root.getName().equals(firstName)) {
            throw new Exception(msg);
        }
        List itemLists = root.elements();
        for (Element elm : itemLists) {
            if (elm.getName().equals(nextName)) continue;
            throw new Exception(msg);
        }
    }

    public BpmDefinition getBpmDefByXml(String xmlStr) {
        String key = "";
        Pattern pattern = Pattern.compile("defKey=\"(.*?)\"");
        Matcher matcher = pattern.matcher(xmlStr);
        while (matcher.find()) {
            key = matcher.group(1);
        }
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(key);
        return bpmDefinition;
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5bfc\u5165\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165", required=false) @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id", required=false) @RequestParam Optional<String> cacheFileId) throws Exception {
        CommonResult<String> message = null;
        try {
            if (confirmImport.orElse(false).booleanValue()) {
                String byKey = ((BpmDefinitionManager)this.baseService).getImportFileFromCache(cacheFileId.get());
                if (StringUtil.isEmpty((String)byKey)) {
                    return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:\u4e0a\u4f20\u7684\u6587\u4ef6\u5df2\u4ece\u7f13\u5b58\u4e2d\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
                }
                ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
                message = this.bpmDefTransform.importDef(objectNode, typeId.orElse(""));
            }
            ((BpmDefinitionManager)this.baseService).delImportFileFromCache(cacheFileId.orElse(""));
        }
        catch (Exception e) {
            message = new CommonResult<String>(false, "\u5bfc\u5165\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c,\u901a\u8fc7\u6821\u9a8c\u5219\u76f4\u63a5\u5bfc\u5165\uff0c\u5982\u6709\u91cd\u590d\u6d41\u7a0b\uff0c\u5219\u8fd4\u56de\u6d41\u7a0bxml\u7684\u7f13\u5b58key\uff0c\u5f85\u7528\u6237\u786e\u8ba4\u8986\u76d6\u540e\u518d\u6b21\u5bfc\u5165", httpMethod="POST", notes="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c")
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId) throws Exception {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String bpmdefsXml = FileUtil.readFile((String)(unZipFilePath + "/bpmdefs.flow.xml"));
            String formXmlStr = FileUtil.readFile((String)(unZipFilePath + "/form.xml"));
            String boXmlStr = FileUtil.readFile((String)(unZipFilePath + "/bo.xml"));
            String formRightsXml = FileUtil.readFile((String)(unZipFilePath + "/formrights.xml"));
            if (StringUtils.isEmpty((String)bpmdefsXml)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            DefController.checkXmlFormat(bpmdefsXml);
            BpmDefXmlList defList = (BpmDefXmlList)JAXBUtil.unmarshall((String)bpmdefsXml, BpmDefXmlList.class);
            List list = defList.getBpmList();
            ArrayList<String> names = new ArrayList<String>();
            for (BpmDefXml defXml : list) {
                DefaultBpmDefinition odef;
                DefaultBpmDefinition def = defXml.getBpmDefinition();
                if (!BeanUtils.isNotEmpty((Object)def) || (odef = this.bpmDefinitionManager.getMainByDefKey(def.getDefKey())) == null) continue;
                names.add(def.getName() + "\uff08" + def.getDefKey() + "\uff09");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("bpmdefsXml", bpmdefsXml);
            obj.put("formXmlStr", formXmlStr);
            obj.put("boXmlStr", boXmlStr);
            obj.put("formRightsXml", formRightsXml);
            if (BeanUtils.isEmpty(names)) {
                message = this.bpmDefTransform.importDef(obj, typeId.orElse(""));
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((BpmDefinitionManager)this.baseService).putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u6d41\u7a0b\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u4e3a\u5176\u65b0\u589e\u7248\u672c\uff1f", (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    @RequestMapping(value={"versions"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5386\u53f2\u7248\u672c", httpMethod="POST", notes="\u6d41\u7a0b\u5b9a\u4e49\u5386\u53f2\u7248\u672c")
    public PageList<DefaultBpmDefinition> versions(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key") @RequestParam String defKey, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmDefinition> queryFilter) throws Exception {
        DefaultBpmDefinition defaultBpmDefinition = null;
        if (StringUtil.isEmpty((String)defKey) && StringUtil.isNotEmpty((String)defId)) {
            defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
            if (defaultBpmDefinition != null) {
                queryFilter.addFilter("def_key_", (Object)defaultBpmDefinition.getDefKey(), QueryOP.EQUAL);
            } else {
                queryFilter.addFilter("def_key_", (Object)"", QueryOP.EQUAL);
            }
        } else {
            queryFilter.addFilter("def_key_", (Object)defKey, QueryOP.EQUAL);
        }
        return this.bpmDefinitionManager.query(queryFilter);
    }

    @RequestMapping(value={"switchMainVersion"})
    @ApiOperation(value="\u8bbe\u7f6e\u5386\u53f2\u7248\u672c\u7684\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u4e3b\u7248\u672c", httpMethod="GET", notes="\u8bbe\u7f6e\u5386\u53f2\u7248\u672c\u7684\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u4e3b\u7248\u672c")
    public CommonResult<String> switchMainVersion(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId) throws Exception {
        try {
            this.bpmDefinitionService.switchMainVersion(defId);
            return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u8bbe\u7f6e\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"subFlowDetail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u5916\u90e8\u5b50\u6d41\u7a0b", httpMethod="GET", notes="\u8bbe\u7f6e\u5916\u90e8\u5b50\u6d41\u7a0b")
    public Map<String, Object> subFlowDetail(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        BpmNodeDef node = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (node.getType() != NodeType.CALLACTIVITY) {
            throw new RuntimeException("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5916\u90e8\u5b50\u6d41\u7a0b\u8282\u70b9\uff01");
        }
        resMap.put("topDefKey", node.getBpmProcessDef().getDefKey());
        CallActivityNodeDef callActivityNode = (CallActivityNodeDef)node;
        String childFlowKey = callActivityNode.getFlowKey();
        DefaultBpmDefinition subProcessDef = this.bpmDefinitionManager.getMainByDefKey(childFlowKey);
        if (BeanUtils.isEmpty((Object)subProcessDef)) {
            throw new RuntimeException("\u6839\u636e\u7ed1\u5b9a\u7684\u5b50\u6d41\u7a0bkey\u672a\u627e\u5230\u5bf9\u5e94\u6d41\u7a0b\uff01");
        }
        resMap.put("defId", subProcessDef.getDefId());
        return resMap;
    }

    @RequestMapping(value={"getNodeBtns"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u4ee3\u7406\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u4ee3\u7406\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<BpmNodeDef> getNodeBtns(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestBody String defId) throws Exception {
        List nodeDefs = this.bpmDefinitionAccessor.getSignUserNode(defId);
        ArrayList list = new ArrayList();
        if (nodeDefs != null && !nodeDefs.isEmpty()) {
            for (BpmNodeDef bnd : nodeDefs) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("nodeId", bnd.getNodeId());
                map.put("name", bnd.getName());
                map.put("type", (String)bnd.getType());
                map.put("btns", JsonUtil.toJson((Object)bnd.getButtons()));
                list.add(map);
            }
        }
        return new PageList(list);
    }

    @RequestMapping(value={"getNodeSet"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f97\u5230\u67d0\u4e2a\u8282\u70b9\u81ea\u5b9a\u4e49\u6309\u94ae", httpMethod="POST", notes="\u5f97\u5230\u67d0\u4e2a\u8282\u70b9\u81ea\u5b9a\u4e49\u6309\u94ae")
    public List<Button> getNodeSet(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId, @ApiParam(name="action", value="0:\u83b7\u53d6\u9ed8\u8ba4\u521d\u59cb\u5316\u7684\u6309\u94ae,1:\u83b7\u53d6\u914d\u7f6e\u7684\u6309\u94ae,2:\u83b7\u53d6\u9ed8\u8ba4\u4e0d\u521d\u59cb\u5316\u7684\u6309\u94ae") @RequestParam int action) throws Exception {
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List nodeBtns = nodeDef.getButtons();
        List defaultBtns = nodeDef.getButtonsByType(true);
        if (action == 0) {
            return defaultBtns;
        }
        if (action == 2) {
            List notInitBtns = nodeDef.getButtonsByType(false);
            return notInitBtns;
        }
        for (Button btn : nodeBtns) {
            btn.setSupportScript(Boolean.valueOf(true));
            for (Button b : defaultBtns) {
                if (!btn.getAlias().equals(b.getAlias()) || b.getSupportScript().booleanValue()) continue;
                btn.setSupportScript(Boolean.valueOf(false));
            }
        }
        return nodeBtns;
    }

    @RequestMapping(value={"saveNodeBtns"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8282\u70b9\u7684\u6309\u94ae", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9\u7684\u6309\u94ae")
    public CommonResult<List<Button>> saveNodeBtns(@ApiParam(name="btnsVo", value="\u6d41\u7a0b\u8282\u70b9\u6309\u94ae\u5bf9\u8c61") @RequestBody DefBtnsSaveVo btnsVo) throws Exception {
        try {
            String defId = btnsVo.getDefId();
            String nodeId = btnsVo.getNodeId();
            List<Button> btns = btnsVo.getBtns();
            this.buttonsBpmDefXmlHandler.saveNodeXml(defId, nodeId, btns);
            return new CommonResult(true, "\u6309\u94ae\u8bbe\u7f6e\u6210\u529f", btns);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6309\u94ae\u8bbe\u7f6e\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"cleanData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6e05\u9664\u6d4b\u8bd5\u72b6\u6001\u6d41\u7a0b\u7684\u6d4b\u8bd5\u6570\u636e", httpMethod="POST", notes="\u6e05\u9664\u6d4b\u8bd5\u72b6\u6001\u6d41\u7a0b\u7684\u6d4b\u8bd5\u6570\u636e")
    public CommonResult<String> cleanData(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId) throws Exception {
        try {
            this.bpmDefinitionService.cleanData(defId);
            return new CommonResult(true, "\u6e05\u9664\u6570\u636e\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u6e05\u9664\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"deploy"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49", httpMethod="POST", notes="\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49")
    public CommonResult<String> deploy(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam String defId) throws Exception {
        try {
            BpmDefinition def = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
            this.bpmDefinitionService.deploy(def);
            return new CommonResult(true, "\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"getBindRelation"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u7ed1\u5b9a\u5173\u7cfb\u3002", httpMethod="GET", notes="\u6839\u636e\u7ec4\u4ef6\u522b\u540d\u83b7\u53d6\u6240\u6709\u5b50\u5b9e\u4f53\u3002")
    public Map<String, Object> getBindRelation(@ApiParam(name="defId", value="\u8868\u5355defId") @RequestParam String defId) throws Exception {
        return this.bpmDefinitionManager.getBindRelation(defId);
    }

    private void getNodeButtonMap(BpmNodeDef bpmNodeDef, String nodeId, Map<String, Boolean> nodeButtonMap) {
        if (BeanUtils.isNotEmpty((Object)bpmNodeDef.getButtons())) {
            nodeButtonMap.put(nodeId, true);
        } else {
            nodeButtonMap.put(nodeId, false);
        }
    }

    private void getNodeRulesMap(BpmNodeDef bpmNodeDef, String nodeId, Map<String, Boolean> nodeRulesMap) {
        if (!(bpmNodeDef instanceof UserTaskNodeDef)) {
            return;
        }
        UserTaskNodeDef userTaskNodeDef = (UserTaskNodeDef)bpmNodeDef;
        if (BeanUtils.isNotEmpty((Object)userTaskNodeDef.getJumpRuleList())) {
            nodeRulesMap.put(nodeId, true);
        } else {
            nodeRulesMap.put(nodeId, false);
        }
    }

    private void getNodeScriptMap(BpmNodeDef bpmNodeDef, String nodeId, Map<String, Boolean> startScriptMap, Map<String, Boolean> endScriptMap, Map<String, Boolean> preScriptMap, Map<String, Boolean> afterScriptMap, Map<String, Boolean> assignScriptMap) {
        Map scriptMap = bpmNodeDef.getScripts();
        for (Map.Entry entry : scriptMap.entrySet()) {
            if (StringUtil.isEmpty((String)((String)entry.getValue()))) continue;
            switch ((ScriptType)entry.getKey()) {
                case START: {
                    startScriptMap.put(nodeId, true);
                    break;
                }
                case END: {
                    endScriptMap.put(nodeId, true);
                    break;
                }
                case CREATE: {
                    preScriptMap.put(nodeId, true);
                    break;
                }
                case COMPLETE: {
                    afterScriptMap.put(nodeId, true);
                    break;
                }
            }
        }
    }

    private void orderNodeDefList(List<BpmNodeDef> nodeDefList) {
        for (BpmNodeDef bpmNodeDef : nodeDefList) {
            if (bpmNodeDef.getType() == NodeType.START) {
                bpmNodeDef.setOrder(bpmNodeDef.getOrder());
                continue;
            }
            if (bpmNodeDef.getType() == NodeType.END) {
                bpmNodeDef.setOrder(Integer.valueOf(bpmNodeDef.getOrder() + 100));
                continue;
            }
            bpmNodeDef.setOrder(Integer.valueOf(bpmNodeDef.getOrder() + 1000));
        }
        Collections.sort(nodeDefList, new BpmNodeDefComparator());
    }

    private void getNodeUserMap(BpmNodeDef bpmNodeDef, String nodeId, Map<String, Boolean> nodeUserMap) throws Exception {
        PluginParse userPluginContext;
        if ((bpmNodeDef.getType() == NodeType.USERTASK || bpmNodeDef.getType() == NodeType.SIGNTASK) && (userPluginContext = (PluginParse)bpmNodeDef.getPluginContext(UserAssignPluginContext.class)) != null && userPluginContext.getJson() != null) {
            nodeUserMap.put(nodeId, true);
        }
    }

    @RequestMapping(value={"initNodeBtn"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u521d\u59cb\u5316\u6240\u6709\u6309\u94ae", httpMethod="GET", notes="\u521d\u59cb\u5316\u6240\u6709\u6309\u94ae")
    public CommonResult<String> initNodeBtn(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        String resultMsg = "";
        try {
            List nodeDefs = this.bpmDefinitionAccessor.getSignUserNode(defId);
            if (BeanUtils.isNotEmpty((Object)nodeDefs)) {
                if (StringUtil.isEmpty((String)nodeId)) {
                    for (BpmNodeDef bnd : nodeDefs) {
                        String key = bnd.getType().getKey();
                        if (!key.equals("signTask") && !key.equals("userTask") && !key.equals("start")) continue;
                        this.buttonsBpmDefXmlHandler.saveNodeXml(defId, bnd.getNodeId(), (Object)bnd.getButtonsByType(true));
                    }
                } else {
                    for (BpmNodeDef bnd : nodeDefs) {
                        if (!nodeId.equals(bnd.getNodeId())) continue;
                        this.buttonsBpmDefXmlHandler.saveNodeXml(defId, nodeId, (Object)bnd.getButtonsByType(true));
                    }
                }
            }
            resultMsg = "\u521d\u59cb\u5316\u6210\u529f";
            return new CommonResult(true, resultMsg, (Object)"");
        }
        catch (Exception e) {
            resultMsg = "\u521d\u59cb\u5316\u5931\u8d25";
            return new CommonResult(false, resultMsg + ":" + e.getMessage(), (Object)"");
        }
    }

    @Deprecated
    @RequestMapping(value={"copyDef"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u6d41\u7a0b", httpMethod="GET", notes="\u590d\u5236\u6d41\u7a0b")
    public CommonResult<String> copyDef(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="name", value="\u6d41\u7a0b\u540d\u79f0", required=true) @RequestParam String name, @ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String defKey) throws IOException {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(defKey, false);
        if (bpmDefinition != null) {
            return new CommonResult(false, "\u6d41\u7a0bkey\u5df2\u7ecf\u5b58\u5728", (Object)"");
        }
        try {
            this.bpmDefinitionManager.copyDef(defId, name, defKey, null, null);
        }
        catch (Exception ex) {
            return new CommonResult(false, ex.getMessage(), (Object)"");
        }
        return new CommonResult(true, "\u590d\u5236\u6210\u529f", (Object)"");
    }

    @PostMapping(value={"copy"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u590d\u5236\u6d41\u7a0b", httpMethod="POST", notes="\u590d\u5236\u6d41\u7a0b")
    public CommonResult<String> copyDef(@ApiParam(name="flowInfo", value="\u6d41\u7a0b\u4fe1\u606f", required=true) @RequestBody CopyFlow flow) throws IOException {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(flow.getDefKey(), false);
        if (bpmDefinition != null) {
            return new CommonResult(false, "\u6d41\u7a0bkey\u5df2\u7ecf\u5b58\u5728", (Object)"");
        }
        try {
            this.bpmDefinitionManager.copyDef(flow.getDefId(), flow.getName(), flow.getDefKey(), flow.getTypeId(), flow.getTypeName());
        }
        catch (Exception ex) {
            return new CommonResult(false, ex.getMessage(), (Object)"");
        }
        return new CommonResult(true, "\u590d\u5236\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"getBpmDefId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6\u6700\u65b0\u7684\u6d41\u7a0b\u5b9a\u4e49id", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6\u6700\u65b0\u7684\u6d41\u7a0b\u5b9a\u4e49id")
    public String getBpmDefId(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String defKey) throws Exception {
        List defs = this.bpmDefinitionManager.queryByDefKey(defKey);
        String defId = "";
        if (defs.size() > 0 && BeanUtils.isNotEmpty(defs.get(defs.size() - 1))) {
            defId = ((DefaultBpmDefinition)defs.get(defs.size() - 1)).getDefId();
        }
        return defId;
    }

    @RequestMapping(value={"isBoBindFlowCheck"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u6d4bbo\u662f\u5426\u5df2\u7ed1\u5b9a\u6d41\u7a0b", httpMethod="GET", notes="\u68c0\u6d4bbo\u662f\u5426\u5df2\u7ed1\u5b9a\u6d41\u7a0b")
    public CommonResult<Boolean> isBoBindFlowCheck(@ApiParam(name="boCode", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String boCode, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey) throws Exception {
        List bpmProBos = this.bpmProBoManager.getByBoCode(boCode);
        for (BpmProBo bpmProBo : bpmProBos) {
            String defId;
            boolean isFormExist;
            DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(bpmProBo.getProcessId());
            if (BeanUtils.isEmpty((Object)bpmDef) || !(isFormExist = this.isFormExists(defId = bpmDef.getDefId(), formKey))) continue;
            return new CommonResult(true, "\u5df2\u7ed1\u5b9a\u6d41\u7a0b\u3010" + bpmDef.getName() + "\u3011", (Object)true);
        }
        return new CommonResult(true, "\u68c0\u6d4b\u6210\u529f\uff01", (Object)false);
    }

    private boolean isFormExists(String defId, String formKey) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        FormExt frm = defExt.getGlobalForm();
        FormExt mobileFrm = defExt.getGlobalMobileForm();
        FormExt instFrm = defExt.getInstForm();
        FormExt instMobileFrm = defExt.getInstMobileForm();
        if (frm != null && frm.getFormValue().equals(formKey) || mobileFrm != null && mobileFrm.getFormValue().equals(formKey) || instFrm != null && instFrm.getFormValue().equals(formKey) || instMobileFrm != null && instMobileFrm.getFormValue().equals(formKey)) {
            return true;
        }
        List nodeList = this.bpmDefinitionAccessor.getSignUserNode(defId);
        for (BpmNodeDef bpmNodeDef : nodeList) {
            frm = bpmNodeDef.getForm();
            if (frm != null && frm.getFormValue().equals(formKey)) {
                return true;
            }
            frm = bpmNodeDef.getMobileForm();
            if (frm == null || !frm.getFormValue().equals(formKey)) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"getBpmdefByDefId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49")
    public DefaultBpmDefinition getBpmdefByDefId(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId) throws Exception {
        return this.bpmDefinitionManager.getById(defId);
    }

    @RequestMapping(value={"defSetCategory"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u6d41\u7a0b\u5206\u7c7b", httpMethod="POST", notes="\u8bbe\u7f6e\u6d41\u7a0b\u5206\u7c7b")
    public CommonResult<String> defSetCategory(@ApiParam(name="jNode", value="\u8bbe\u7f6e\u5206\u7c7b\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody ObjectNode jNode) throws Exception {
        List<String> defIds = Arrays.asList(jNode.get("defIds").asText().split(","));
        String typeName = jNode.get("typeName").asText();
        String typeId = jNode.get("typeId").asText();
        return this.bpmDefinitionManager.setDefType(typeName, typeId, defIds);
    }

    @RequestMapping(value={"bpmDefinitionData"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b")
    public List<Map<String, Object>> bpmDefinitionData(String alias) {
        return this.bpmDefinitionManager.bpmDefinitionData(alias);
    }

    @RequestMapping(value={"flowHasStartRights"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u542f\u52a8\u6d41\u7a0b\u6743\u9650", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u542f\u52a8\u6d41\u7a0b\u6743\u9650")
    public CommonResult<Boolean> flowHasStartRights(@ApiParam(required=false, name="defKey", value="defKey") @RequestParam String defKey) throws IOException {
        ObjectNode reslt = this.bpmDefAuthorizeManager.getRight(defKey, "start");
        return new CommonResult(true, "", (Object)BeanUtils.isNotEmpty((Object)reslt));
    }
}

