/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.model.Column;
import com.artfess.table.model.Table;
import com.artfess.table.model.impl.DefaultColumn;
import com.artfess.table.model.impl.DefaultTable;
import com.artfess.table.operator.ITableOperator;
import com.artfess.table.util.MetaDataUtil;
import com.artfess.uc.dao.MatrixDao;
import com.artfess.uc.manager.MatrixColDefManager;
import com.artfess.uc.manager.MatrixManager;
import com.artfess.uc.model.Matrix;
import com.artfess.uc.model.MatrixColDef;
import com.artfess.uc.model.MatrixColField;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matrixManager")
public class MatrixManagerImpl
extends BaseManagerImpl<MatrixDao, Matrix>
implements MatrixManager {
    @Resource
    ITableOperator tableOperator;
    @Resource
    MatrixColDefManager matrixColDefManager;
    @Resource
    CommonManager commonManager;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    JdbcTemplate jdbcTemplate;

    @Override
    public Matrix getDetail(String id) {
        Matrix matrix = (Matrix)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)matrix))) {
            List<MatrixColDef> condList = this.matrixColDefManager.getCondList(matrix.getId());
            List<MatrixColDef> roleList = this.matrixColDefManager.getRoleList(matrix.getId());
            matrix.setCondList(condList);
            matrix.setRoleList(roleList);
        }
        return matrix;
    }

    @Override
    public Matrix getByCode(String code) {
        return ((MatrixDao)this.baseMapper).getByCode(code);
    }

    @Override
    public Boolean isCodeExist(String code, String id) {
        return ((MatrixDao)this.baseMapper).isCodeExist(code, id);
    }

    @Override
    @Transactional
    public void saveMatrix(Matrix matrix) {
        User user = ContextUtil.getCurrentUser();
        String matrixId = BeanUtils.isNotEmpty((Object)matrix.getId()) ? matrix.getId() : UniqueIdUtil.getSuid();
        boolean setMatrixUnpublish = false;
        List<MatrixColDef> oldCondList = this.matrixColDefManager.getColAllList(matrixId, MatrixColDef.COND_COL_TYPE);
        HashMap<String, MatrixColDef> condOldCodeMap = new HashMap<String, MatrixColDef>();
        for (MatrixColDef colDef : oldCondList) {
            condOldCodeMap.put(colDef.getCode(), colDef);
        }
        List<MatrixColDef> condList = matrix.getCondList();
        if (BeanUtils.isNotEmpty(condList)) {
            for (int i = 0; i < condList.size(); ++i) {
                MatrixColDef col = condList.get(i);
                boolean isExist = false;
                if (condOldCodeMap.containsKey(col.getCode())) {
                    isExist = true;
                    condOldCodeMap.remove(col.getCode());
                }
                col.setSn(i + 1);
                boolean isAddCol = this.matrixColDefManager.saveCol(matrixId, col, MatrixColDef.COND_COL_TYPE, isExist);
                if (!isAddCol) continue;
                setMatrixUnpublish = true;
            }
        }
        for (String code : condOldCodeMap.keySet()) {
            MatrixColDef willDele = (MatrixColDef)((Object)condOldCodeMap.get(code));
            willDele.setIsDele(1);
            this.matrixColDefManager.update((Model)willDele);
        }
        List<MatrixColDef> oldRoleList = this.matrixColDefManager.getColAllList(matrixId, MatrixColDef.ROLE_COL_TYPE);
        HashMap<String, MatrixColDef> roleOldCodeMap = new HashMap<String, MatrixColDef>();
        for (MatrixColDef colDef : oldRoleList) {
            roleOldCodeMap.put(colDef.getCode(), colDef);
        }
        List<MatrixColDef> roleList = matrix.getRoleList();
        if (BeanUtils.isNotEmpty(roleList)) {
            for (int i = 0; i < roleList.size(); ++i) {
                MatrixColDef col = roleList.get(i);
                boolean isExist = false;
                if (roleOldCodeMap.containsKey(col.getCode())) {
                    isExist = true;
                    roleOldCodeMap.remove(col.getCode());
                }
                col.setSn(i + 1);
                boolean isAddCol = this.matrixColDefManager.saveCol(matrixId, col, MatrixColDef.ROLE_COL_TYPE, isExist);
                if (!isAddCol) continue;
                setMatrixUnpublish = true;
            }
        }
        for (String code : roleOldCodeMap.keySet()) {
            MatrixColDef willDele = (MatrixColDef)((Object)roleOldCodeMap.get(code));
            willDele.setIsDele(1);
            this.matrixColDefManager.update((Model)willDele);
        }
        if (StringUtil.isEmpty((String)matrix.getId())) {
            matrix.setId(matrixId);
            matrix.setCreateBy(user.getId());
            matrix.setCreateTime(LocalDateTime.now());
            this.create((Model)matrix);
        } else {
            matrix.setUpdateBy(user.getId());
            matrix.setUpdateTime(LocalDateTime.now());
            if (setMatrixUnpublish) {
                matrix.setStatus(0);
            }
            this.update((Model)matrix);
        }
    }

    @Override
    @Transactional
    public void deleLogical(String[] ids) {
        ((MatrixDao)this.baseMapper).deleLogical(ids);
    }

    @Override
    public void publish(String id) throws SQLException {
        ArrayList<String> pulishedColIds = new ArrayList<String>();
        Matrix matrix = this.getDetail(id);
        String tableName = "uc_matrix_" + matrix.getCode();
        boolean isCreatedTable = this.tableOperator.isTableExist(tableName.toLowerCase());
        if (!isCreatedTable) {
            DefaultTable table = new DefaultTable();
            table.setTableName(tableName.toLowerCase());
            table.setComment(matrix.getName());
            DefaultColumn pk = new DefaultColumn();
            pk.setFieldName("ID_");
            pk.setComment("\u4e3b\u952e");
            pk.setColumnType("varchar");
            pk.setCharLen(64);
            pk.setIsPk(true);
            pk.setIsNull(false);
            table.addColumn((Column)pk);
            List<MatrixColDef> condList = matrix.getCondList();
            for (MatrixColDef matrixColDef : condList) {
                DefaultColumn columnK = this.buildCondK(matrixColDef);
                table.addColumn((Column)columnK);
                DefaultColumn columnV = this.buildCondV(matrixColDef);
                table.addColumn((Column)columnV);
                pulishedColIds.add(matrixColDef.getId());
            }
            List<MatrixColDef> roleList = matrix.getRoleList();
            for (MatrixColDef col : roleList) {
                DefaultColumn roleColumn = this.buildRole(col);
                table.addColumn((Column)roleColumn);
                pulishedColIds.add(col.getId());
            }
            this.tableOperator.createTable((Table)table);
        } else {
            BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)this.databaseContext.getDbType());
            Table table = baseTableMeta.getTableByName(tableName);
            List existColumnList = table.getColumnList();
            Set<String> existFieldNames = MatrixManagerImpl.getFieldNameSet(existColumnList);
            List<MatrixColDef> list = matrix.getCondList();
            for (MatrixColDef col : list) {
                DefaultColumn columnV;
                if (col.getStatus() != 0) continue;
                DefaultColumn columnK = this.buildCondK(col);
                if (!existFieldNames.contains(columnK.getFieldName().toLowerCase())) {
                    this.tableOperator.addColumn(tableName, (Column)columnK);
                }
                if (!existFieldNames.contains((columnV = this.buildCondV(col)).getFieldName().toLowerCase())) {
                    this.tableOperator.addColumn(tableName, (Column)columnV);
                }
                pulishedColIds.add(col.getId());
            }
            List<MatrixColDef> roleList = matrix.getRoleList();
            for (MatrixColDef col : roleList) {
                if (col.getStatus() != 0) continue;
                DefaultColumn roleColumn = this.buildRole(col);
                if (!existFieldNames.contains(roleColumn.getFieldName().toLowerCase())) {
                    this.tableOperator.addColumn(tableName, (Column)roleColumn);
                }
                pulishedColIds.add(col.getId());
            }
        }
        matrix.setStatus(1);
        this.update((Model)matrix);
        if (pulishedColIds.size() > 0) {
            this.matrixColDefManager.updateStatus(pulishedColIds, 1);
        }
    }

    private static Set<String> getFieldNameSet(List<Column> existColumnList) {
        HashSet<String> set = new HashSet<String>();
        if (BeanUtils.isNotEmpty(existColumnList)) {
            for (Column col : existColumnList) {
                String colName = col.getFieldName();
                set.add(colName.toLowerCase());
            }
        }
        return set;
    }

    public DefaultColumn buildRole(MatrixColDef col) {
        DefaultColumn roleColumn = new DefaultColumn();
        roleColumn.setFieldName("ROLE_" + col.getCode());
        roleColumn.setComment(col.getName());
        roleColumn.setColumnType("clob");
        return roleColumn;
    }

    public DefaultColumn buildCondK(MatrixColDef col) {
        DefaultColumn columnK = new DefaultColumn();
        columnK.setFieldName("CONDK_" + col.getCode());
        columnK.setComment(col.getName() + "key");
        columnK.setColumnType("varchar");
        columnK.setCharLen(2000);
        return columnK;
    }

    public DefaultColumn buildCondV(MatrixColDef col) {
        DefaultColumn columnV = new DefaultColumn();
        columnV.setFieldName("CONDV_" + col.getCode());
        columnV.setComment(col.getName() + "value");
        columnV.setColumnType("varchar");
        columnV.setCharLen(2000);
        return columnV;
    }

    private List<MatrixColField> buildSelectFields(Matrix matrix) {
        ArrayList<MatrixColField> colFields = new ArrayList<MatrixColField>();
        colFields.add(new MatrixColField("ID_", "ID_", "\u4e3b\u952e", "id", null));
        for (MatrixColDef col : matrix.getCondList()) {
            if (col.getStatus() != 1) continue;
            colFields.add(new MatrixColField("CONDK_" + col.getCode(), col.getCode(), col.getName(), "ck", col));
            colFields.add(new MatrixColField("CONDV_" + col.getCode(), col.getCode(), col.getName(), "cv", col));
        }
        for (MatrixColDef col : matrix.getRoleList()) {
            if (col.getStatus() != 1) continue;
            colFields.add(new MatrixColField("ROLE_" + col.getCode(), col.getCode(), col.getName(), "ro", col));
        }
        return colFields;
    }

    @Override
    public Map<String, Object> getData(String matrixId, PageBean pageBean) throws Exception {
        Matrix matrix = this.getDetail(matrixId);
        boolean tableExist = this.tableOperator.isTableExist("uc_matrix_" + matrix.getCode());
        if (!tableExist) {
            throw new RuntimeException("\u8be5\u77e9\u9635\u8fd8\u672a\u53d1\u5e03\uff01");
        }
        List<MatrixColField> colFields = this.buildSelectFields(matrix);
        String sql = this.constructSelectListSql(matrix.getCode(), colFields);
        PageList dataList = this.commonManager.query(sql, pageBean);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("colFields", colFields);
        map.put("matrix", (Object)matrix);
        map.put("data", dataList);
        return map;
    }

    @Override
    public Map<String, Object> getOneData(String matrixId, String pk) throws Exception {
        Matrix matrix = this.getDetail(matrixId);
        boolean tableExist = this.tableOperator.isTableExist("uc_matrix_" + matrix.getCode());
        if (!tableExist) {
            throw new RuntimeException("\u8be5\u77e9\u9635\u8fd8\u672a\u53d1\u5e03\uff01");
        }
        List<MatrixColField> colFields = this.buildSelectFields(matrix);
        String sql = this.constructSelectOneSql(matrix.getCode(), colFields, pk);
        List dataList = this.commonManager.query(sql);
        Map data = dataList != null && dataList.size() > 0 ? (Map)dataList.get(0) : null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("colFields", colFields);
        map.put("matrix", (Object)matrix);
        map.put("data", data);
        return map;
    }

    @Override
    public Map<String, Object> getBlankOneData(String matrixId) {
        Matrix matrix = this.getDetail(matrixId);
        boolean tableExist = this.tableOperator.isTableExist("uc_matrix_" + matrix.getCode());
        if (!tableExist) {
            throw new RuntimeException("\u8be5\u77e9\u9635\u8fd8\u672a\u53d1\u5e03\uff01");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (MatrixColDef col : matrix.getCondList()) {
            if (col.getStatus() != 1) continue;
            data.put("CONDK_" + col.getCode(), "");
            data.put("CONDV_" + col.getCode(), "");
        }
        for (MatrixColDef col : matrix.getRoleList()) {
            if (col.getStatus() != 1) continue;
            data.put("ROLE_" + col.getCode(), "");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        return map;
    }

    @Override
    @Transactional
    public void saveData(String matrixId, String data) throws Exception {
        Matrix matrix = (Matrix)this.get((Serializable)((Object)matrixId));
        Map bean = (Map)JsonUtil.toBean((String)data, Map.class);
        if (BeanUtils.isNotEmpty((Object)bean)) {
            String existSql = this.constructIsCondKeyExistSql(matrix.getCode(), bean);
            List query = this.commonManager.query(existSql);
            if (query != null && query.size() > 0) {
                throw new RuntimeException("\u6761\u4ef6\u7ec4\u5408\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\u3002");
            }
            String ID_ = (String)bean.get("ID_");
            String sql = "";
            if (BeanUtils.isNotEmpty((Object)ID_)) {
                this.updateData(matrix.getCode(), bean);
            } else {
                this.insertData(matrix.getCode(), bean);
            }
        }
    }

    @Override
    @Transactional
    public void dataRemove(String matrixId, String[] ids) {
        Matrix matrix = (Matrix)this.get((Serializable)((Object)matrixId));
        String sql = this.cunstructDeleteSql(matrix.getCode(), ids);
        this.jdbcTemplate.execute(sql);
    }

    public String constructSelectListSql(String matrixCode, List<MatrixColField> colFields) {
        StringBuffer sql = new StringBuffer("select ");
        ArrayList<String> fields = new ArrayList<String>();
        for (MatrixColField field : colFields) {
            fields.add(field.getField());
        }
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql") || dbType.equals("oracle") || dbType.equals("dm")) {
            for (int i = 0; i < fields.size(); ++i) {
                sql.append((String)fields.get(i) + " as \"" + (String)fields.get(i) + "\"");
                if (i == fields.size() - 1) continue;
                sql.append(",");
            }
        } else {
            sql.append(String.join((CharSequence)",", fields));
        }
        sql.append(" from uc_matrix_" + matrixCode + " ");
        return sql.toString();
    }

    public String constructSelectOneSql(String matrixCode, List<MatrixColField> colFields, String pk) {
        StringBuffer sql = new StringBuffer("select ");
        ArrayList<String> fields = new ArrayList<String>();
        for (MatrixColField field : colFields) {
            fields.add(field.getField());
        }
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql") || dbType.equals("oracle") || dbType.equals("dm")) {
            for (int i = 0; i < fields.size(); ++i) {
                sql.append((String)fields.get(i) + " as \"" + (String)fields.get(i) + "\"");
                if (i == fields.size() - 1) continue;
                sql.append(",");
            }
        } else {
            sql.append(String.join((CharSequence)",", fields));
        }
        sql.append(" from uc_matrix_" + matrixCode + " ");
        sql.append(" where ");
        sql.append("ID_ = '" + pk + "'");
        return sql.toString();
    }

    private String cunstructDeleteSql(String matrixCode, String[] ids) {
        StringBuffer sb = new StringBuffer("delete from ");
        sb.append("uc_matrix_" + matrixCode + " where ");
        sb.append("ID_ in ('" + String.join((CharSequence)"','", ids) + "')");
        return sb.toString();
    }

    private void insertData(String matrixCode, Map<String, Object> bean) throws Exception {
        StringBuffer sb = new StringBuffer("insert into ");
        sb.append("uc_matrix_" + matrixCode);
        ArrayList<String> setFields = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String ID_ = UniqueIdUtil.getSuid();
        setFields.add("ID_");
        values.add(ID_);
        for (String key : bean.keySet()) {
            setFields.add(key);
            Object value = bean.get(key);
            if (value instanceof List) {
                values.add(JsonUtil.toJson((Object)value));
                continue;
            }
            if (BeanUtils.isEmpty((Object)value)) {
                values.add("");
                continue;
            }
            values.add(value.toString());
        }
        sb.append("(" + String.join((CharSequence)",", setFields) + ")");
        sb.append(" values ");
        sb.append("(" + String.join((CharSequence)",", values.stream().map(e -> "?").collect(Collectors.toList())) + ")");
        this.commonManager.execute(sb.toString(), values.toArray());
    }

    private void updateData(String matrixCode, Map<String, Object> bean) throws Exception {
        StringBuffer sb = new StringBuffer("update ");
        sb.append("uc_matrix_" + matrixCode + " set ");
        ArrayList<String> setFields = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String ID_ = (String)bean.remove("ID_");
        for (String key : bean.keySet()) {
            Object value = bean.get(key);
            setFields.add(key + "=?");
            if (value instanceof List) {
                values.add(JsonUtil.toJson((Object)value));
                continue;
            }
            if (BeanUtils.isEmpty((Object)value)) {
                values.add("");
                continue;
            }
            values.add(value.toString());
        }
        sb.append(String.join((CharSequence)",", setFields));
        sb.append(" where ID_" + String.format("='%s'", ID_));
        this.commonManager.execute(sb.toString(), values.toArray());
    }

    private String constructIsCondKeyExistSql(String matrixCode, Map<String, Object> bean) throws IOException {
        StringBuffer sb = new StringBuffer("select * from ");
        sb.append("uc_matrix_" + matrixCode);
        String dbType = SQLUtil.getDbType();
        ArrayList<String> setFields = new ArrayList<String>();
        for (String key : bean.keySet()) {
            if (key.indexOf("CONDK_") != 0) continue;
            Object value = bean.get(key);
            if (BeanUtils.isNotEmpty((Object)value)) {
                if ("oracle".equals(dbType)) {
                    setFields.add("to_char(" + key + ") = '" + value + "'");
                    continue;
                }
                setFields.add(key + " = '" + value + "'");
                continue;
            }
            String empty = "(" + key + " is null or " + key + "='')";
            setFields.add(empty);
        }
        if (BeanUtils.isNotEmpty((Object)bean.get("ID_"))) {
            setFields.add("ID_ != '" + bean.get("ID_") + "'");
        }
        if (setFields.size() > 0) {
            sb.append(" where ");
        }
        sb.append(String.join((CharSequence)" and ", setFields));
        return sb.toString();
    }

    @Override
    public List<Map<String, Object>> getUsers(Map<String, Object> params) throws Exception {
        String sql = (String)params.get("sql");
        sql = Base64.getFromBase64((String)sql);
        List query = null;
        query = this.commonManager.query(sql);
        return query;
    }
}

