/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.supplier.dao.EnterpriseDao;
import com.artfess.cgpt.supplier.manager.BizSupplierEnterpriseManager;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.UcBaseModel;
import com.artfess.uc.model.User;
import com.artfess.uc.params.org.OrgUserVo;
import com.artfess.uc.params.org.OrgVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class EnterpriseManagerImpl
extends BaseManagerImpl<EnterpriseDao, Enterprise>
implements EnterpriseManager {
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private OrgUserManager orgUserManager;
    @Autowired
    private RoleManager roleManager;
    @Autowired
    private BizSupplierEnterpriseManager supplierEnterpriseManager;

    @Override
    public PageList<Org> queryOrgNoOccupy(QueryFilter<Enterprise> queryFilter) {
        String groupCode = ContextUtil.getCurrentGroup().getGroupCode();
        if (BeanUtils.isEmpty((Object)groupCode)) {
            return new PageList(new ArrayList());
        }
        ArrayList<String> orgCodes = new ArrayList<String>();
        orgCodes.add(groupCode);
        LambdaQueryWrapper supplierEnterpriseQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)supplierEnterpriseQW.select(new SFunction[]{BizSupplierEnterprise::getSupplierCode}).eq(BizSupplierEnterprise::getEnterpriseCode, (Object)groupCode)).eq(BizModel::getIsDele, (Object)"0");
        List objs = this.supplierEnterpriseManager.listObjs((Wrapper)supplierEnterpriseQW);
        if (BeanUtils.isNotEmpty((Object)objs) && objs.size() > 0) {
            List collect = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            orgCodes.addAll(collect);
        }
        queryFilter.addFilter("a.code_", orgCodes, QueryOP.NOT_IN);
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<Org> result = ((EnterpriseDao)this.baseMapper).queryOrg((IPage<Enterprise>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Enterprise>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<Org> queryAllOrg(QueryFilter<Enterprise> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<Org> result = ((EnterpriseDao)this.baseMapper).queryOrg((IPage<Enterprise>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Enterprise>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<Enterprise> queryByPage(QueryFilter<Enterprise> queryFilter) {
        BizUtils.addFilterByOrgCodeAndRole(queryFilter, this.ucFeignService, "COMPANY_CODE_");
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<Enterprise> result = ((EnterpriseDao)this.baseMapper).queryAllByPage((IPage<Enterprise>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Enterprise>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveOrUpdateEntity(Enterprise entity) {
        LambdaQueryWrapper enterExistQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)enterExistQW.and(s -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.eq(Enterprise::getCompanyName, (Object)entity.getCompanyName())).or()).eq(Enterprise::getCompanyOrgcode, (Object)entity.getCompanyOrgcode());
        })).eq(BizModel::getIsDele, (Object)"0")).ne(BeanUtils.isNotEmpty((Object)entity.getId()), Enterprise::getId, (Object)entity.getId());
        if (super.count((Wrapper)enterExistQW) > 0) {
            throw new BaseException("\u4f01\u4e1a\u540d\u79f0\u6216\u7a0e\u53f7\u5df2\u5b58\u5728");
        }
        if (BeanUtils.isEmpty((Object)entity.getCompanyCode())) {
            LambdaQueryWrapper orgQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)orgQW.eq(Org::getName, (Object)entity.getCompanyName())).eq(UcBaseModel::getIsDelete, (Object)"0")).orderByDesc(AutoFillModel::getCreateTime)).last("limit 1");
            Org org = (Org)this.orgManager.getBaseMapper().selectOne((Wrapper)orgQW);
            if (BeanUtils.isEmpty((Object)org)) {
                String value;
                String orgId = "";
                String orgCode = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "qygl_qybh");
                OrgVo orgVo = new OrgVo();
                orgVo.setCode(orgCode);
                orgVo.setDemId("1258608622670319616");
                orgVo.setExceedLimitNum(Integer.valueOf(0));
                orgVo.setLimitNum(Integer.valueOf(0));
                orgVo.setName(entity.getCompanyName());
                orgVo.setNowNum(Integer.valueOf(0));
                orgVo.setOrgKind("ogn");
                orgVo.setParentId("0");
                CommonResult stringCommonResult = null;
                try {
                    stringCommonResult = this.orgManager.addOrg(orgVo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
                }
                if (BeanUtils.isNotEmpty((Object)stringCommonResult) && BeanUtils.isNotEmpty((Object)(value = (String)stringCommonResult.getValue()))) {
                    com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)value);
                    orgId = jsonObject.get((Object)"id").toString();
                }
                entity.setOrgId(orgId);
                entity.setCompanyOrgcode(orgCode);
            } else {
                entity.setOrgId(org.getId());
                entity.setCompanyOrgcode(org.getCode());
            }
        } else {
            Org org = this.orgManager.getByCode(entity.getCompanyCode());
            if (BeanUtils.isNotEmpty((Object)org)) {
                if (!org.getName().equals(entity.getCompanyName())) {
                    org.setName(entity.getCompanyName());
                    this.orgManager.updateById((Object)org);
                }
                entity.setOrgId(org.getId());
            } else {
                String value;
                String orgId = "";
                OrgVo orgVo = new OrgVo();
                orgVo.setCode(entity.getCompanyCode());
                orgVo.setDemId("1258608622670319616");
                orgVo.setExceedLimitNum(Integer.valueOf(0));
                orgVo.setLimitNum(Integer.valueOf(0));
                orgVo.setName(entity.getCompanyName());
                orgVo.setNowNum(Integer.valueOf(0));
                orgVo.setOrgKind("ogn");
                orgVo.setParentId("0");
                CommonResult stringCommonResult = null;
                try {
                    stringCommonResult = this.orgManager.addOrg(orgVo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
                }
                if (BeanUtils.isNotEmpty((Object)stringCommonResult) && BeanUtils.isNotEmpty((Object)(value = (String)stringCommonResult.getValue()))) {
                    com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)value);
                    orgId = jsonObject.get((Object)"id").toString();
                }
                entity.setOrgId(orgId);
            }
        }
        super.saveOrUpdate((Object)entity);
    }

    @Transactional
    public void saveOrUpdateEntityByApi(Enterprise entity) {
        Org org = this.orgManager.getByCode(entity.getCompanyCode());
        ArrayList<String> orgRoleTypeList = new ArrayList<String>();
        if (BeanUtils.isNotEmpty((Object)entity.getOrgRoleType())) {
            orgRoleTypeList.addAll(Arrays.asList(entity.getOrgRoleType().split(",")));
        } else {
            orgRoleTypeList.add("1");
        }
        String grade = null;
        grade = orgRoleTypeList.contains("0") && orgRoleTypeList.contains("1") ? "1004001" : (orgRoleTypeList.contains("0") ? "1001001" : "1003001");
        if (BeanUtils.isNotEmpty((Object)org)) {
            org.setGrade(grade);
            org.setName(entity.getCompanyName());
            this.orgManager.updateById((Object)org);
            entity.setOrgId(org.getId());
        } else {
            String value;
            String orgId = "";
            OrgVo orgVo = new OrgVo();
            orgVo.setCode(entity.getCompanyCode());
            orgVo.setDemId("1258608622670319616");
            orgVo.setExceedLimitNum(Integer.valueOf(0));
            orgVo.setLimitNum(Integer.valueOf(0));
            orgVo.setName(entity.getCompanyName());
            orgVo.setNowNum(Integer.valueOf(0));
            orgVo.setOrgKind("ogn");
            orgVo.setParentId("0");
            orgVo.setGrade(grade);
            CommonResult stringCommonResult = null;
            try {
                stringCommonResult = this.orgManager.addOrg(orgVo);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
            }
            if (BeanUtils.isNotEmpty((Object)stringCommonResult) && BeanUtils.isNotEmpty((Object)(value = (String)stringCommonResult.getValue()))) {
                com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)value);
                orgId = jsonObject.get((Object)"id").toString();
            }
            entity.setOrgId(orgId);
        }
        LambdaQueryWrapper enterpriseQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)enterpriseQW.eq(Enterprise::getCompanyCode, (Object)entity.getCompanyCode())).eq(BizModel::getIsDele, (Object)"0");
        super.saveOrUpdate((Object)entity, (Wrapper)enterpriseQW);
    }

    @Transactional
    public void saveOrUpdateUserByApi(UserVo userVo) throws Exception {
        userVo.setStatus(Integer.valueOf(1));
        userVo.setId(null);
        userVo.setTenantId(null);
        String userId = "";
        LambdaQueryWrapper userQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)userQW.eq(User::getAccount, (Object)userVo.getAccount())).eq(UcBaseModel::getIsDelete, (Object)"0")).last("limit 1");
        User userHis = (User)this.userManager.getBaseMapper().selectOne((Wrapper)userQW);
        if (BeanUtils.isNotEmpty((Object)userHis)) {
            userId = userHis.getId();
            userVo.setId(userHis.getId());
            this.userManager.updateUserById(userVo);
        } else {
            userVo.setPassword("Spwz@" + userVo.getMobile());
            userId = this.userManager.addUser(userVo).getId();
        }
        if (BeanUtils.isNotEmpty((Object)userVo.getOrgCode())) {
            Org org = this.orgManager.getByCode(userVo.getOrgCode());
            if (BeanUtils.isEmpty((Object)org)) {
                throw new BaseException("\u7ec4\u7ec7\u7f16\u53f7\u672a\u627e\u5230");
            }
            OrgUser orgUser = this.orgUserManager.getOrgUser(org.getId(), userId, null);
            if (BeanUtils.isEmpty((Object)orgUser)) {
                OrgUserVo orgUserVo = new OrgUserVo();
                orgUserVo.setAccount(userVo.getAccount());
                orgUserVo.setOrgCode(userVo.getOrgCode());
                orgUserVo.setIsMaster(1);
                this.orgManager.addOrgUser(orgUserVo);
            } else {
                orgUser.setIsMaster(Integer.valueOf(1));
                this.orgUserManager.updateById((Object)orgUser);
            }
        }
        if (BeanUtils.isNotEmpty((Object)userVo.getBusinessType())) {
            ArrayList<String> roleList = new ArrayList<String>();
            if (userVo.getBusinessType().equals("0")) {
                roleList.add("wzjp");
            } else if (userVo.getBusinessType().equals("1")) {
                roleList.add("wzcz");
            } else {
                roleList.add("wzjp");
                roleList.add("wzcz");
            }
            if (roleList.size() > 0) {
                this.roleManager.saveUserRoles(String.join((CharSequence)",", roleList), userVo.getAccount());
            }
        }
    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(JSONObject param) {
        String code = "0";
        String message = "\u64cd\u4f5c\u6210\u529f";
        String errDetail = "";
        try {
            List data = JSONUtil.toList((JSONArray)param.getJSONArray((Object)"data"), Enterprise.class);
            for (Enterprise temp : data) {
                temp.setId(null);
                this.saveOrUpdateEntityByApi(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "\u64cd\u4f5c\u5931\u8d25:" + errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return new Response<String>(code, message, errDetail);
    }

    @Override
    @Transactional
    public Response saveOrUpdateUserByApi(JSONObject param) {
        String code = "0";
        String message = "\u64cd\u4f5c\u6210\u529f";
        String errDetail = "";
        try {
            List data = JSONUtil.toList((JSONArray)param.getJSONArray((Object)"data"), UserVo.class);
            for (UserVo temp : data) {
                this.saveOrUpdateUserByApi(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "\u64cd\u4f5c\u5931\u8d25:" + errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return new Response<String>(code, message, errDetail);
    }

    @Override
    public Enterprise getByOrgIdOrCode(String orgId, String orgCode) {
        LambdaQueryWrapper enterpriseQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)enterpriseQW.and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(Enterprise::getOrgId, (Object)orgId)).or()).eq(Enterprise::getCompanyCode, (Object)orgCode);
        })).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(AutoFillModel::getCreateTime)).last("limit 1");
        return (Enterprise)((Object)((EnterpriseDao)this.baseMapper).selectOne((Wrapper)enterpriseQW));
    }

    @Override
    public Enterprise getByCodeOrHisCode(String code) {
        LambdaQueryWrapper enterpriseQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)enterpriseQW.and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(Enterprise::getCompanyCode, (Object)code)).or()).eq(Enterprise::getHistoryCompanyCode, (Object)code);
        })).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(AutoFillModel::getCreateTime)).last("limit 1");
        return (Enterprise)((Object)((EnterpriseDao)this.baseMapper).selectOne((Wrapper)enterpriseQW));
    }
}

