/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.BizSupplierEvaluationDao;
import com.artfess.cgpt.supplier.manager.BizSupplierEnterpriseManager;
import com.artfess.cgpt.supplier.manager.BizSupplierEvaluationManager;
import com.artfess.cgpt.supplier.manager.SupplierEvaluationDetailManager;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.BizSupplierEvaluation;
import com.artfess.cgpt.supplier.model.SupplierEvaluationDetail;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizSupplierEvaluationManagerImpl
extends BaseManagerImpl<BizSupplierEvaluationDao, BizSupplierEvaluation>
implements BizSupplierEvaluationManager {
    @Autowired
    private SupplierEvaluationDetailManager supplierEvaluationDetailManager;
    @Autowired
    private BizSupplierEnterpriseManager supplierEnterpriseManager;

    @Override
    public PageList<BizSupplierEvaluation> queryAllByPage(QueryFilter<BizSupplierEvaluation> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<BizSupplierEvaluation> result = ((BizSupplierEvaluationDao)this.baseMapper).queryAllByPage((IPage<BizSupplierEvaluation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizSupplierEvaluation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizSupplierEvaluation getDetailById(String id) {
        BizSupplierEvaluation result = (BizSupplierEvaluation)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
        detailQW.eq(SupplierEvaluationDetail::getSupplierEvaluationId, (Object)id);
        result.setDetailList(this.supplierEvaluationDetailManager.list((Wrapper)detailQW));
        return result;
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizSupplierEvaluation entity) {
        List<SupplierEvaluationDetail> detailList = entity.getDetailList();
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
            detailQW.eq(SupplierEvaluationDetail::getSupplierTypeEvaluationId, (Object)entity.getId());
            this.supplierEvaluationDetailManager.remove((Wrapper)detailQW);
        } else {
            LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BizSupplierEvaluation::getAdmittedSupplierId, (Object)entity.getAdmittedSupplierId())).likeRight(BizSupplierEvaluation::getScoreTime, (Object)LocalDate.now().getYear())).eq(BizModel::getIsDele, (Object)"0");
            int count = super.count((Wrapper)hisQW);
            if (count > 0) {
                throw new BaseException("\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011\u672c\u5e74\u5ea6\u5df2\u8bc4\u5206\uff0c\u8bf7\u5728\u5df2\u6709\u8bb0\u5f55\u4e0a\u8fdb\u884c\u4fee\u6539");
            }
        }
        entity.setScoreTime(LocalDateTime.now());
        LambdaUpdateWrapper supplierEnterpriseUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)supplierEnterpriseUW.set(BizSupplierEnterprise::getLevel, (Object)entity.getLevel())).eq(BizSupplierEnterprise::getId, (Object)entity.getAdmittedSupplierId())).eq(BizModel::getIsDele, (Object)"0");
        this.supplierEnterpriseManager.update((Wrapper)supplierEnterpriseUW);
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.stream().forEach(s -> s.setSupplierEvaluationId(entity.getId()));
            this.supplierEvaluationDetailManager.saveBatch(detailList);
        }
    }

    @Override
    @Transactional
    public void removeById(String id) {
        super.removeById((Serializable)((Object)id));
        LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
        detailQW.eq(SupplierEvaluationDetail::getSupplierTypeEvaluationId, (Object)id);
        this.supplierEvaluationDetailManager.remove((Wrapper)detailQW);
    }
}

