/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.supplier.dao.AdmissionConfigDao;
import com.artfess.cgpt.supplier.manager.AdmissionConfigManager;
import com.artfess.cgpt.supplier.manager.AdmissionConfigQualificationManager;
import com.artfess.cgpt.supplier.model.AdmissionConfig;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdmissionConfigManagerImpl
extends BaseManagerImpl<AdmissionConfigDao, AdmissionConfig>
implements AdmissionConfigManager {
    @Autowired
    private AdmissionConfigQualificationManager configQualificationManager;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizMaterialCategoryManager matCategoryManager;

    @Override
    @Transactional
    public void saveOrUpdateEntity(AdmissionConfig entity) {
        List<AdmissionConfigQualification> configQualificationList = entity.getConfigQualificationList();
        IGroup org = ContextUtil.getCurrentGroup();
        List<String> matCategoryIdList = Arrays.asList(entity.getMatCategoryId().split(","));
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        if (BeanUtils.isNotEmpty(matCategoryIdList) && matCategoryIdList.size() > 0) {
            for (String cateId : matCategoryIdList) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(AdmissionConfig::getEnterpriseId, (Object)org.getGroupId())).like(AdmissionConfig::getMatCategoryId, (Object)cateId)).ne(BeanUtils.isNotEmpty((Object)entity.getId()), AdmissionConfig::getId, (Object)entity.getId());
                if (super.count((Wrapper)hisQW) <= 0) continue;
                BizMaterialCategory cate = (BizMaterialCategory)((Object)this.matCategoryManager.getById((Serializable)((Object)cateId)));
                throw new BaseException("\u5df2\u5b58\u5728\u3010" + cate.getName() + "\u3011\u5206\u7c7b\u6570\u636e\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0");
            }
        }
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            if (BeanUtils.isEmpty((Object)entity.getCode())) {
                entity.setCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "zrgz_bm"));
            }
            entity.setEnterpriseId(org.getGroupId());
            entity.setEnterpriseCode(org.getGroupCode());
            entity.setEnterpriseName(org.getName());
            entity.setAddUserId(ContextUtil.getCurrentUserId());
            entity.setAddUserName(ContextUtil.getCurrentUserName());
            entity.setAddTime(LocalDateTime.now());
        } else {
            LambdaQueryWrapper configQualificationQW = new LambdaQueryWrapper();
            configQualificationQW.eq(AdmissionConfigQualification::getAdmissionConfigId, (Object)entity.getId());
            this.configQualificationManager.remove((Wrapper)configQualificationQW);
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(configQualificationList) && configQualificationList.size() > 0) {
            configQualificationList.stream().forEach(s -> s.setAdmissionConfigId(entity.getId()));
            this.configQualificationManager.saveBatch(configQualificationList);
        }
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(List<AdmissionConfig> data) {
        IGroup org = ContextUtil.getCurrentGroup();
        IUser user = ContextUtil.getCurrentUser();
        data.stream().forEach(entity -> {
            if (BeanUtils.isEmpty((Object)entity.getId())) {
                entity.setEnterpriseId(org.getGroupId());
                entity.setEnterpriseCode(org.getGroupCode());
                entity.setEnterpriseName(org.getName());
                entity.setAddUserId(user.getUserId());
                entity.setAddUserName(user.getUsername());
                entity.setAddTime(LocalDateTime.now());
            }
        });
        super.saveOrUpdateBatch(data);
    }

    @Override
    @Transactional
    public void removeByIds(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaQueryWrapper configQualificationQW = new LambdaQueryWrapper();
        configQualificationQW.in(AdmissionConfigQualification::getAdmissionConfigId, idList);
        this.configQualificationManager.remove((Wrapper)configQualificationQW);
        super.removeByIds(idList);
    }

    @Override
    public PageList<AdmissionConfig> queryByPage(QueryFilter<AdmissionConfig> queryFilter) {
        IPage<AdmissionConfig> result = ((AdmissionConfigDao)this.baseMapper).queryAllByPage((IPage<AdmissionConfig>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<AdmissionConfig>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<AdmissionConfig> queryQuaCategory(QueryFilter<AdmissionConfig> queryFilter) {
        IPage<AdmissionConfig> result = ((AdmissionConfigDao)this.baseMapper).queryAllByPage((IPage<AdmissionConfig>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<AdmissionConfig>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            records.stream().forEach(s -> s.setQualificationCategoryList(this.configQualificationManager.getQualificationCategoryByConfigId(s.getId())));
        }
        return new PageList(result);
    }

    @Override
    public AdmissionConfig getDataById(String id) {
        AdmissionConfig result = (AdmissionConfig)((Object)super.getById((Serializable)((Object)id)));
        if (BeanUtils.isNotEmpty((Object)((Object)result))) {
            result.setQualificationCategoryList(this.configQualificationManager.getQualificationCategoryByConfigId(result.getId()));
        }
        return result;
    }
}

