/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.receipt.dao.ArrivalDao;
import com.artfess.cgpt.receipt.manager.ArrivalDetailManager;
import com.artfess.cgpt.receipt.manager.ArrivalManager;
import com.artfess.cgpt.receipt.model.Arrival;
import com.artfess.cgpt.receipt.model.ArrivalDetail;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArrivalManagerImpl
extends BaseManagerImpl<ArrivalDao, Arrival>
implements ArrivalManager {
    @Autowired
    private ArrivalDetailManager arrivalDetailManager;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;

    @Override
    public Arrival getDetailById(String id) {
        Arrival result = (Arrival)((Object)super.getById((Serializable)((Object)id)));
        List<ArrivalDetail> detailList = this.arrivalDetailManager.getByArrivalId(id);
        result.setDetailList(detailList);
        return result;
    }

    @Override
    @Transactional
    public String saveVo(Arrival entity) {
        List<ArrivalDetail> detailList = entity.getDetailList();
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            if (BeanUtils.isEmpty((Object)entity.getArrivalCode())) {
                entity.setArrivalCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "cgpt_cgfh"));
            }
            entity.setStatus(1);
        } else {
            this.arrivalDetailManager.removeByArrivalId(entity.getId());
        }
        this.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.forEach(s -> s.setArrivalId(entity.getId()));
            this.arrivalDetailManager.saveBatch(detailList);
        }
        return entity.getId();
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        this.arrivalDetailManager.removeByArrivalId(String.join((CharSequence)",", ids));
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public void updateStatus(String id, Integer status) {
        LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(Arrival::getStatus, (Object)status)).eq(Arrival::getId, (Object)id)).eq(BizModel::getIsDele, (Object)"0");
        if (status == 2) {
            IUser user = ContextUtil.getCurrentUser();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(Arrival::getVendorUserId, (Object)user.getUserId())).set(Arrival::getVendorUserName, (Object)user.getFullname())).set(Arrival::getVendorPhone, (Object)user.getMobile())).set(Arrival::getArrivalDate, (Object)LocalDateTime.now());
        }
        super.update((Wrapper)uw);
    }

    @Override
    public PageList<Arrival> queryByPage(QueryFilter<Arrival> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<Arrival> result = ((ArrivalDao)this.baseMapper).queryByPage((IPage<Arrival>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Arrival>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<Arrival> pageVendorGroup(QueryFilter<Arrival> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<Arrival> result = ((ArrivalDao)this.baseMapper).pageVendorGroup((IPage<Arrival>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Arrival>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

