/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.winbind.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.order.manager.BizRegistrationOrderDetailsManager;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.order.vo.OrderDetailsVo;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.violate.manager.BizViolateRecordDetailManager;
import com.artfess.cgpt.violate.manager.BizViolateRecordManager;
import com.artfess.cgpt.violate.model.BizViolateRecord;
import com.artfess.cgpt.violate.model.BizViolateRecordDetail;
import com.artfess.cgpt.winbind.dao.BizWinBiddingNoticeDao;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizWinBiddingNoticeManagerImpl
extends BaseManagerImpl<BizWinBiddingNoticeDao, BizWinBiddingNotice>
implements BizWinBiddingNoticeManager {
    @Resource
    private BizWinBiddingNoticeDetaileManager detaileManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager proApprovalManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private BizWinBiddingNoticeDetaileManager winBidNoticeDetaileManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private BizRegistrationOrderManager registrationOrderManager;
    @Autowired
    private BizRegistrationOrderDetailsManager registrationOrderDetailsManager;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BizViolateRecordManager violateRecordManager;
    @Autowired
    private BizViolateRecordDetailManager violateRecordDetailManager;

    @Override
    @Transactional
    public void removeIdList(List<String> ids) {
        List dataList = super.listByIds(ids);
        List collect = dataList.stream().filter(s -> s.getProcureType() == 5 && BeanUtils.isNotEmpty((Object)s.getApplicationId())).map(s -> s.getApplicationId()).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(collect) && collect.size() > 0) {
            LambdaUpdateWrapper applicationUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)applicationUW.set(PurchasingApplication::getStatus, (Object)3)).in(PurchasingApplication::getId, collect)).eq(BizModel::getIsDele, (Object)"0");
            this.purchasingApplicationManager.update((Wrapper)applicationUW);
        }
        LambdaQueryWrapper winBidNoticeDetailQW = new LambdaQueryWrapper();
        winBidNoticeDetailQW.in(BizWinBiddingNoticeDetaile::getWinNoticeId, ids);
        this.winBidNoticeDetaileManager.remove((Wrapper)winBidNoticeDetailQW);
        this.accessoryService.removeBySourceIds(ids);
    }

    @Override
    public BizWinBiddingNotice getDetailById(String id) {
        BizWinBiddingNotice result = (BizWinBiddingNotice)((Object)super.getById((Serializable)((Object)id)));
        result.setWinBiddingNoticeDetailList(this.detaileManager.getByPid(id));
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizWinBiddingNotice entity) {
        List<BizWinBiddingNoticeDetaile> detailList = entity.getWinBiddingNoticeDetailList();
        List<Accessory> accessoryList = entity.getAccessoryList();
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            this.detaileManager.removeByPid(entity.getId());
            this.accessoryService.removeBySourceId(entity.getId());
        } else {
            IUser user = ContextUtil.getCurrentUser();
            entity.setSendUserId(user.getUserId());
            entity.setSendUserAccount(user.getAccount());
            entity.setSendUserName(user.getUsername());
            if (BeanUtils.isNotEmpty((Object)user.getMobile())) {
                entity.setSendUserMobile(user.getMobile());
            }
        }
        if (entity.getStatus() == 1) {
            entity.setSendTime(LocalDateTime.now());
        }
        this.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.stream().forEach(s -> s.setWinNoticeId(entity.getId()));
            this.detaileManager.saveOrUpdateBatch(detailList);
        }
        if (entity.getProcureType() == 5) {
            if (BeanUtils.isNotEmpty((Object)entity.getApplicationId())) {
                LambdaUpdateWrapper applicationUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)applicationUW.set(PurchasingApplication::getStatus, (Object)6)).eq(PurchasingApplication::getId, (Object)entity.getApplicationId())).eq(BizModel::getIsDele, (Object)"0");
                this.purchasingApplicationManager.update((Wrapper)applicationUW);
            }
            if (BeanUtils.isEmpty((Object)entity.getNoticeCode())) {
                entity.setNoticeCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "xmxx_xmbh"));
            }
        }
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
    }

    @Override
    @Transactional
    public void updateStatus(String id, Integer status) {
        LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(BizWinBiddingNotice::getStatus, (Object)status)).eq(BizWinBiddingNotice::getId, (Object)id)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)uw);
        LambdaUpdateWrapper detailUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)detailUW.set(BizWinBiddingNoticeDetaile::getStatus, (Object)status)).eq(BizWinBiddingNoticeDetaile::getWinNoticeId, (Object)id);
        this.detaileManager.update((Wrapper)detailUW);
        BizWinBiddingNotice winNotice = (BizWinBiddingNotice)((Object)super.getById((Serializable)((Object)id)));
        MatApproval matNotice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)winNotice.getNoticeId())));
        ProjectApproval proNotice = (ProjectApproval)((Object)this.proApprovalManager.getById((Serializable)((Object)winNotice.getNoticeId())));
        if (status == 1) {
            LambdaQueryWrapper countQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)countQW.eq(BizWinBiddingNotice::getStatus, (Object)2)).eq(BizWinBiddingNotice::getNoticeId, (Object)winNotice.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
            if (super.count((Wrapper)countQW) == 0) {
                if (winNotice.getNoticeType() == 1) {
                    LambdaUpdateWrapper matApprovalUW = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)matApprovalUW.set(MatApproval::getWinNoticeStatus, (Object)2)).eq(MatApproval::getId, (Object)winNotice.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
                    this.matApprovalManager.update((Wrapper)matApprovalUW);
                } else {
                    LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getWinNoticeStatus, (Object)2)).eq(ProjectApproval::getId, (Object)winNotice.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
                    this.proApprovalManager.update((Wrapper)approvalUW);
                }
            }
        } else if (status == 4) {
            IUser currentUser = ContextUtil.getCurrentUser();
            if (winNotice.getNoticeType() == 1) {
                LambdaUpdateWrapper matApprovalUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)matApprovalUW.set(MatApproval::getWinNoticeStatus, (Object)4)).eq(MatApproval::getId, (Object)winNotice.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
                this.matApprovalManager.update((Wrapper)matApprovalUW);
            } else {
                LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(ProjectApproval::getWinNoticeStatus, (Object)4)).eq(ProjectApproval::getId, (Object)winNotice.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
                this.proApprovalManager.update((Wrapper)approvalUW);
            }
            BizViolateRecord violateRecord = new BizViolateRecord();
            if (winNotice.getNoticeType() == 1) {
                violateRecord.setNoticeId(matNotice.getId());
                violateRecord.setNoticeCode(matNotice.getProjectNumber());
                violateRecord.setNoticeTitle(matNotice.getNoticeTitle());
                violateRecord.setMatOrgId(matNotice.getProcureOrgId());
                violateRecord.setMatOrgCode(matNotice.getProcureOrgCode());
                violateRecord.setMatOrgName(matNotice.getProcureOrgName());
                if (BeanUtils.isNotEmpty((Object)matNotice.getAffiliatedUserName())) {
                    violateRecord.setMatContacts(matNotice.getAffiliatedUserName());
                }
                if (BeanUtils.isNotEmpty((Object)matNotice.getContactsPhone())) {
                    violateRecord.setMatContactsPhone(matNotice.getContactsPhone());
                }
            } else {
                violateRecord.setNoticeId(proNotice.getId());
                violateRecord.setNoticeCode(proNotice.getNoticeCode());
                violateRecord.setNoticeTitle(proNotice.getNoticeTitle());
                violateRecord.setMatOrgId(proNotice.getProcureOrgId());
                violateRecord.setMatOrgCode(proNotice.getProcureOrgCode());
                violateRecord.setMatOrgName(proNotice.getProcureOrgName());
                if (BeanUtils.isNotEmpty((Object)proNotice.getAffiliatedUserName())) {
                    violateRecord.setMatContacts(proNotice.getAffiliatedUserName());
                }
                if (BeanUtils.isNotEmpty((Object)proNotice.getContactsPhone())) {
                    violateRecord.setMatContactsPhone(proNotice.getContactsPhone());
                }
            }
            violateRecord.setSupplierOrgId(winNotice.getVendorId());
            violateRecord.setSupplierOrgCode(winNotice.getVendorCode());
            violateRecord.setSupplierOrgName(winNotice.getVendorName());
            violateRecord.setUserId(currentUser.getUserId());
            violateRecord.setUserAccount(currentUser.getAccount());
            violateRecord.setUserName(currentUser.getFullname());
            if (BeanUtils.isNotEmpty((Object)currentUser.getMobile())) {
                violateRecord.setUserMobile(currentUser.getMobile());
            }
            violateRecord.setOrgId(violateRecord.getSupplierOrgId());
            violateRecord.setOrgCode(violateRecord.getSupplierOrgCode());
            violateRecord.setOrgName(violateRecord.getSupplierOrgName());
            violateRecord.setProcureType(winNotice.getProcureType());
            violateRecord.setNoticeType(winNotice.getNoticeType());
            violateRecord.setViolateType(2);
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getCompanyId, (Object)winNotice.getVendorId())).eq(UserParticipation::getNoticeId, (Object)winNotice.getNoticeId())).eq(UserParticipation::getNoticeType, (Object)winNotice.getNoticeType())).eq(UserParticipation::getStatus, (Object)1)).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(UserParticipation::getParticipationDate)).last("limit 1");
            UserParticipation userParticipation = (UserParticipation)((Object)this.userParticipationManager.getBaseMapper().selectOne((Wrapper)userParticipationQW));
            if (BeanUtil.isEmpty((Object)((Object)userParticipation), (String[])new String[0])) {
                throw new BaseException("\u672a\u627e\u5230\u53c2\u4e0e\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
            }
            violateRecord.setViolatePrice(userParticipation.getPrice());
            violateRecord.setViolateTime(LocalDateTime.now());
            violateRecord.setPayStatus(1);
            violateRecord.setRevokeStatus(1);
            violateRecord.setWinNoticeId(winNotice.getId());
            violateRecord.setHandleStatus(1);
            this.violateRecordManager.save((Object)violateRecord);
            List<BizWinBiddingNoticeDetaile> winNoticeDetailList = this.winBidNoticeDetaileManager.getByPid(winNotice.getId());
            if (BeanUtils.isNotEmpty(winNoticeDetailList) && winNoticeDetailList.size() > 0) {
                ArrayList violateRecordDetailList = new ArrayList();
                winNoticeDetailList.stream().forEach(winNoticeDetail -> {
                    BizViolateRecordDetail violateRecordDetail = new BizViolateRecordDetail();
                    violateRecordDetail.setVrId(violateRecord.getId());
                    violateRecordDetail.setNoticeId(violateRecord.getNoticeId());
                    violateRecordDetail.setNoticeCode(violateRecord.getNoticeCode());
                    violateRecordDetail.setNoticeTitle(violateRecord.getNoticeTitle());
                    violateRecordDetail.setNoticeDetailId(winNoticeDetail.getNoticeDetailedId());
                    violateRecordDetail.setMatCategoryCode(winNoticeDetail.getMatCategoryCode());
                    violateRecordDetail.setMatId(winNoticeDetail.getMatId());
                    violateRecordDetail.setMatPlatcode(winNoticeDetail.getMatPlatcode());
                    violateRecordDetail.setMatName(winNoticeDetail.getMatName());
                    violateRecordDetail.setMatMaterial(winNoticeDetail.getMatMaterial());
                    violateRecordDetail.setMatSpec(winNoticeDetail.getMatSpec());
                    violateRecordDetail.setMatUnit(winNoticeDetail.getMatUnit());
                    violateRecordDetail.setMatBaseExt(winNoticeDetail.getMatBaseExt());
                    violateRecordDetail.setMatOtherExt(winNoticeDetail.getMatOtherExt());
                    violateRecordDetail.setMatBrand(winNoticeDetail.getMatBrand());
                    violateRecordDetail.setNum(winNoticeDetail.getMatNum());
                    violateRecordDetail.setTaxRate(winNoticeDetail.getTaxRate());
                    violateRecordDetail.setApplicationMethod(winNoticeDetail.getApplicationMethod());
                    violateRecordDetail.setHasQualifications(winNoticeDetail.getHasQualification());
                    violateRecordDetail.setTransactionPrice(winNoticeDetail.getWinBidPrice());
                    violateRecordDetail.setTransactionAmount(winNoticeDetail.getWinBidAmount());
                    violateRecordDetailList.add(violateRecordDetail);
                });
                this.violateRecordDetailManager.saveBatch(violateRecordDetailList);
            }
        }
    }

    @Override
    @Transactional
    public void pushWinBidNotice(BizWinBiddingNotice entity) {
        QueryFilter bidEvaluationQF;
        LocalDateTime sendTime = LocalDateTime.now();
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        notice.setWinNoticeStatus(2);
        notice.setWinNoticeTime(sendTime);
        LocalDateTime validityDate = sendTime.plusDays(notice.getWinBidValidity().intValue());
        notice.setWinBidValidityTime(validityDate);
        this.matApprovalManager.updateById((Object)notice);
        IUser currentUser = ContextUtil.getCurrentUser();
        ArrayList winBidNoticeDetailList = new ArrayList();
        ArrayList winOrgId = new ArrayList();
        List<Object> bidEvaList = new ArrayList();
        if (notice.getEvaluationMethod() == 2) {
            if (notice.getEvaluationMode() == 1) {
                bidEvaluationQF = QueryFilter.build();
                bidEvaluationQF.addFilter("a.NOTICE_ID_", (Object)entity.getNoticeId(), QueryOP.EQUAL);
                bidEvaluationQF.addFilter("a.STATUS_", (Object)"3", QueryOP.EQUAL);
                bidEvaluationQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                bidEvaList = this.bidEvaluationManager.getCalibraDetailComprehensive((QueryFilter<BizBidEvaluation>)bidEvaluationQF).getRows();
            } else {
                bidEvaList = this.bidEvaluationManager.getCalibraDetailMaxScoreById(notice.getId());
            }
        } else {
            bidEvaluationQF = QueryFilter.build();
            bidEvaluationQF.addFilter("a.NOTICE_ID_", (Object)entity.getNoticeId(), QueryOP.EQUAL);
            bidEvaluationQF.addFilter("a.STATUS_", (Object)"3", QueryOP.EQUAL);
            bidEvaluationQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
            bidEvaList = this.bidEvaluationManager.getCalibraDetailById((QueryFilter<BizBidEvaluation>)bidEvaluationQF).getRows();
        }
        if (bidEvaList.size() > 0) {
            Map<String, List<BizBidEvaluation>> evaOrgListMap = bidEvaList.stream().collect(Collectors.groupingBy(BizBidEvaluation::getQuotationOrgId));
            List<Object> finalBidEvaList = bidEvaList;
            evaOrgListMap.forEach((quoOrgId, evaList) -> {
                winOrgId.add(quoOrgId);
                BizBidEvaluation temp = (BizBidEvaluation)((Object)((Object)evaList.get(0)));
                BizWinBiddingNotice winBidNotice = new BizWinBiddingNotice();
                winBidNotice.setSendUserId(currentUser.getUserId());
                winBidNotice.setSendUserAccount(currentUser.getAccount());
                winBidNotice.setSendUserName(currentUser.getUsername());
                winBidNotice.setSendUserMobile(currentUser.getMobile());
                winBidNotice.setNoticeId(entity.getNoticeId());
                winBidNotice.setNoticeCode(notice.getProjectNumber());
                winBidNotice.setNoticeName(notice.getNoticeTitle());
                winBidNotice.setNoticeType(1);
                winBidNotice.setProcureOrgId(notice.getProcureOrgId());
                winBidNotice.setProcureOrgCode(notice.getProcureOrgCode());
                winBidNotice.setProcureOrgName(notice.getProcureOrgName());
                winBidNotice.setVendorId((String)quoOrgId);
                winBidNotice.setVendorCode(temp.getQuotationOrgCode());
                winBidNotice.setVendorName(temp.getQuotationOrgName());
                winBidNotice.setSendTime(sendTime);
                winBidNotice.setConfirmTime(sendTime);
                winBidNotice.setStatus(1);
                winBidNotice.setProcureType((int)notice.getProcureType());
                winBidNotice.setIsAgencyProcure(notice.getIsAgencyProcure());
                winBidNotice.setValidityDate(validityDate.toLocalDate());
                super.save((Object)winBidNotice);
                if (notice.getEvaluationMode() == 1) {
                    evaList.forEach(s -> {
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();
                        if (BeanUtils.isNotEmpty((Object)s.getTenderExplain())) {
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }
                        winBidNoticeDetail.setDetailType(4);
                        winBidNoticeDetail.setEvaluationId(s.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getProjectNumber());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(1);
                        winBidNoticeDetail.setShareAllocationRate(s.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(s.getShareAllocationNum());
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(winBidNoticeDetail.getWinBidPrice().multiply(winBidNoticeDetail.getShareAllocationNum()));
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        if (BeanUtils.isNotEmpty((Object)s.getAcceptanceTime())) {
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getPendingTime())) {
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getMatRemarks())) {
                            winBidNoticeDetail.setPurNote(s.getMatRemarks());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getUnloadAddress())) {
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());
                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                } else {
                    QueryFilter quoQF = QueryFilter.build();
                    quoQF.addFilter("quo.NOTICE_ID_", (Object)notice.getId(), QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_ROUNDS_", (Object)notice.getQuotationRoundsNum(), QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_COMPANY_ID_", quoOrgId, QueryOP.EQUAL);
                    quoQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                    List quoList = this.quotationManager.pageMatDetail((QueryFilter<BizBiddingQuotation>)quoQF).getRows();
                    BizBidEvaluation bidEvaluation = (BizBidEvaluation)((Object)((Object)finalBidEvaList.stream().filter(s -> s.getQuotationOrgId().equals(quoOrgId)).collect(Collectors.toList()).get(0)));
                    quoList.stream().forEach(s -> {
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();
                        if (BeanUtils.isNotEmpty((Object)s.getTenderExplain())) {
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }
                        winBidNoticeDetail.setDetailType(4);
                        winBidNoticeDetail.setEvaluationId(bidEvaluation.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getProjectNumber());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(1);
                        winBidNoticeDetail.setShareAllocationRate(bidEvaluation.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(winBidNoticeDetail.getShareAllocationRate().divide(new BigDecimal("100")).multiply(winBidNoticeDetail.getMatNum()));
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(s.getQuotationAmount());
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        if (BeanUtils.isNotEmpty((Object)s.getAcceptanceTime())) {
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getPendingTime())) {
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getPurNote())) {
                            winBidNoticeDetail.setPurNote(s.getPurNote());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getUnloadAddress())) {
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());
                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                }
            });
            if (winBidNoticeDetailList.size() > 0) {
                this.winBidNoticeDetaileManager.saveBatch(winBidNoticeDetailList);
            }
        }
        if (BeanUtils.isNotEmpty((Object)notice.getBond()) && notice.getBond().compareTo(BigDecimal.ZERO) > 0) {
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getNoticeId, (Object)notice.getId())).notIn(winOrgId.size() > 0, UserParticipation::getCompanyId, winOrgId)).eq(UserParticipation::getStatus, (Object)1)).gt(UserParticipation::getPrice, (Object)0)).eq(UserParticipation::getType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
            List userParticipationList = this.userParticipationManager.list((Wrapper)userParticipationQW);
            if (BeanUtils.isNotEmpty((Object)userParticipationList) && userParticipationList.size() > 0) {
                for (UserParticipation userPart : userParticipationList) {
                    if (BeanUtils.isEmpty((Object)userPart.getRegistrationOrderId())) continue;
                    BizRegistrationOrder regisOrder = (BizRegistrationOrder)((Object)this.registrationOrderManager.getById((Serializable)((Object)userPart.getRegistrationOrderId())));
                    BizRegistrationOrder refundRegisOrder = new BizRegistrationOrder();
                    refundRegisOrder.setParticipationId(userPart.getId());
                    String orderNumber = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "zfjl_ddh");
                    refundRegisOrder.setOrderNumber(orderNumber);
                    refundRegisOrder.setPayStatus(3);
                    refundRegisOrder.setRefundStatus(1);
                    refundRegisOrder.setNoticeId(notice.getId());
                    refundRegisOrder.setNoticeType(1);
                    IUser user = ContextUtil.getCurrentUser();
                    refundRegisOrder.setUserId(user.getUserId());
                    refundRegisOrder.setUserAccount(user.getAccount());
                    refundRegisOrder.setUserName(user.getFullname());
                    if (BeanUtils.isNotEmpty((Object)user.getMobile())) {
                        refundRegisOrder.setUserPhone(user.getMobile());
                    }
                    refundRegisOrder.setPayType(6);
                    Org payOrg = this.orgManager.getByCode("00001513");
                    if (BeanUtils.isEmpty((Object)payOrg)) {
                        throw new BaseException("\u672a\u627e\u5230\u7f16\u53f7\u4e3a\u301000001513\u3011\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6ce8\u518c");
                    }
                    refundRegisOrder.setPayUnitId(regisOrder.getCollectUnitId());
                    refundRegisOrder.setPayUnitCode(regisOrder.getCollectUnitCode());
                    refundRegisOrder.setPayUnitName(regisOrder.getCollectUnitName());
                    refundRegisOrder.setPayAccount(regisOrder.getCollectAccount());
                    refundRegisOrder.setPayAccountBank(regisOrder.getCollectAccountBank());
                    refundRegisOrder.setPayTime(LocalDateTime.now());
                    refundRegisOrder.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
                    refundRegisOrder.setPayAmount(regisOrder.getPayAmount());
                    refundRegisOrder.setCollectUnitId(regisOrder.getPayUnitId());
                    refundRegisOrder.setCollectUnitCode(regisOrder.getPayUnitCode());
                    refundRegisOrder.setCollectUnitName(regisOrder.getPayUnitName());
                    refundRegisOrder.setCollectAccount(regisOrder.getPayAccount());
                    refundRegisOrder.setCollectAccountBank(regisOrder.getPayAccountBank());
                    refundRegisOrder.setCollectTime(regisOrder.getPayTime());
                    refundRegisOrder.setCollectTimer(regisOrder.getPayTimer());
                    refundRegisOrder.setPayDescribe("\u9000\u8fd8\u4fdd\u8bc1\u91d1");
                    this.registrationOrderManager.save((Object)refundRegisOrder);
                    ArrayList<BizRegistrationOrderDetails> detailedList = new ArrayList<BizRegistrationOrderDetails>();
                    ForeignResponseVo res = null;
                    TransVo transVo = new TransVo();
                    try {
                        BeanUtils.copyNotNullProperties((Object)transVo, (Object)((Object)refundRegisOrder));
                    }
                    catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        throw new BaseException(e.getMessage());
                    }
                    transVo.setStatementsCode(refundRegisOrder.getOrderNumber());
                    transVo.setDepositPaymentStatus(refundRegisOrder.getPayStatus());
                    BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
                    detail.setRegistrationOrderId(refundRegisOrder.getId());
                    detail.setRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
                    detail.setUserId(refundRegisOrder.getUserId());
                    detail.setUserName(refundRegisOrder.getUserName());
                    detail.setUserAccount(refundRegisOrder.getUserAccount());
                    if (BeanUtils.isNotEmpty((Object)refundRegisOrder.getUserPhone())) {
                        detail.setUserPhone(refundRegisOrder.getUserPhone());
                    }
                    detail.setCompanyId(refundRegisOrder.getPayUnitId());
                    detail.setCompanyCode(refundRegisOrder.getPayUnitCode());
                    detail.setCompanyName(refundRegisOrder.getPayUnitName());
                    detail.setNoticeId(refundRegisOrder.getNoticeId());
                    detail.setNoticeType(refundRegisOrder.getNoticeType());
                    detail.setNoticeTitle(notice.getNoticeTitle());
                    detail.setPayName(notice.getNoticeTitle());
                    detail.setRechargeNumber(BigDecimal.ONE);
                    detail.setRechargePrice(refundRegisOrder.getPayAmount());
                    detail.setSalesCompanyId(refundRegisOrder.getCollectUnitId());
                    detail.setSalesCompanyCode(refundRegisOrder.getCollectUnitCode());
                    detail.setSalesCompanyName(refundRegisOrder.getCollectUnitName());
                    detailedList.add(detail);
                    ArrayList<OrderDetailsVo> orderDetailsList = new ArrayList<OrderDetailsVo>();
                    OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
                    try {
                        BeanUtils.copyNotNullProperties((Object)orderDetailsVo, (Object)((Object)detail));
                    }
                    catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        System.out.println("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
                        throw new BaseException("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
                    }
                    orderDetailsVo.setPayType(6);
                    orderDetailsList.add(orderDetailsVo);
                    transVo.setOrderDetails(orderDetailsList);
                    res = this.foreignCallService.callPay(transVo, 1);
                    if (BeanUtil.isEmpty((Object)res, (String[])new String[0])) {
                        throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25");
                    }
                    if (!res.getCode().equals("0")) {
                        throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25:" + res.getMsg());
                    }
                    if (detailedList.size() > 0) {
                        this.registrationOrderDetailsManager.saveBatch(detailedList);
                    }
                    regisOrder.setRefundStatus(3);
                    regisOrder.setRefundOrderId(refundRegisOrder.getId());
                    this.registrationOrderManager.updateById((Object)regisOrder);
                    userPart.setRefundRegistrationOrderId(refundRegisOrder.getId());
                    userPart.setRefundRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
                }
                this.userParticipationManager.updateBatchById(userParticipationList);
            }
        }
    }

    @Override
    @Transactional
    public void pushWinBidNoticePro(BizWinBiddingNotice entity) {
        QueryFilter bidEvaluationQF;
        LocalDateTime sendTime = LocalDateTime.now();
        ProjectApproval notice = (ProjectApproval)((Object)this.proApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        notice.setWinNoticeStatus(3);
        notice.setWinNoticeTime(sendTime);
        LocalDateTime validityDate = sendTime.plusDays(notice.getWinBidValidity().intValue());
        notice.setWinBidValidityTime(validityDate);
        this.proApprovalManager.updateById((Object)notice);
        IUser currentUser = ContextUtil.getCurrentUser();
        ArrayList winBidNoticeDetailList = new ArrayList();
        ArrayList winOrgId = new ArrayList();
        List<Object> bidEvaList = new ArrayList();
        if (notice.getEvaluationMethod() == 2) {
            if (notice.getEvaluationMode() == 1) {
                bidEvaluationQF = QueryFilter.build();
                bidEvaluationQF.addFilter("a.NOTICE_ID_", (Object)entity.getNoticeId(), QueryOP.EQUAL);
                bidEvaluationQF.addFilter("a.STATUS_", (Object)"3", QueryOP.EQUAL);
                bidEvaluationQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                bidEvaList = this.bidEvaluationManager.getCalibraDetailComprehensivePro((QueryFilter<BizBidEvaluation>)bidEvaluationQF).getRows();
            } else {
                bidEvaList = this.bidEvaluationManager.getCalibraDetailMaxScoreByIdPro(notice.getId());
            }
        } else {
            bidEvaluationQF = QueryFilter.build();
            bidEvaluationQF.addFilter("a.NOTICE_ID_", (Object)entity.getNoticeId(), QueryOP.EQUAL);
            bidEvaluationQF.addFilter("a.STATUS_", (Object)"3", QueryOP.EQUAL);
            bidEvaluationQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
            bidEvaList = this.bidEvaluationManager.getCalibraDetailByIdPro((QueryFilter<BizBidEvaluation>)bidEvaluationQF).getRows();
        }
        if (bidEvaList.size() > 0) {
            Map<String, List<BizBidEvaluation>> evaOrgListMap = bidEvaList.stream().collect(Collectors.groupingBy(BizBidEvaluation::getQuotationOrgId));
            List<Object> finalBidEvaList = bidEvaList;
            evaOrgListMap.forEach((quoOrgId, evaList) -> {
                winOrgId.add(quoOrgId);
                BizBidEvaluation temp = (BizBidEvaluation)((Object)((Object)evaList.get(0)));
                BizWinBiddingNotice winBidNotice = new BizWinBiddingNotice();
                winBidNotice.setSendUserId(currentUser.getUserId());
                winBidNotice.setSendUserAccount(currentUser.getAccount());
                winBidNotice.setSendUserName(currentUser.getUsername());
                winBidNotice.setSendUserMobile(currentUser.getMobile());
                winBidNotice.setNoticeId(entity.getNoticeId());
                winBidNotice.setNoticeCode(notice.getNoticeCode());
                winBidNotice.setNoticeName(notice.getNoticeTitle());
                winBidNotice.setNoticeType(2);
                winBidNotice.setProcureOrgId(notice.getProcureOrgId());
                winBidNotice.setProcureOrgCode(notice.getProcureOrgCode());
                winBidNotice.setProcureOrgName(notice.getProcureOrgName());
                winBidNotice.setVendorId((String)quoOrgId);
                winBidNotice.setVendorCode(temp.getQuotationOrgCode());
                winBidNotice.setVendorName(temp.getQuotationOrgName());
                winBidNotice.setSendTime(sendTime);
                winBidNotice.setStatus(2);
                winBidNotice.setProcureType((int)notice.getProcureType());
                winBidNotice.setIsAgencyProcure(0);
                winBidNotice.setValidityDate(validityDate.toLocalDate());
                super.save((Object)winBidNotice);
                if (notice.getEvaluationMode() == 1) {
                    evaList.forEach(s -> {
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();
                        if (BeanUtils.isNotEmpty((Object)s.getTenderExplain())) {
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }
                        winBidNoticeDetail.setEvaluationId(s.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getNoticeCode());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(2);
                        winBidNoticeDetail.setShareAllocationRate(s.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(s.getShareAllocationNum());
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(winBidNoticeDetail.getWinBidPrice().multiply(winBidNoticeDetail.getShareAllocationNum()));
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        if (BeanUtils.isNotEmpty((Object)s.getAcceptanceTime())) {
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getPendingTime())) {
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getMatRemarks())) {
                            winBidNoticeDetail.setPurNote(s.getMatRemarks());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getUnloadAddress())) {
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());
                        winBidNoticeDetail.setProjectSourceType(s.getProjectSourceType());
                        winBidNoticeDetail.setProjectInfoId(s.getProjectInfoId());
                        winBidNoticeDetail.setProjectLedgerId(s.getProjectLedgerId());
                        winBidNoticeDetail.setProjectLedgerCode(s.getProjectLedgerCode());
                        winBidNoticeDetail.setDetailType(s.getDetailType());
                        winBidNoticeDetail.setServiceStartTime(s.getServiceStartTime());
                        winBidNoticeDetail.setServiceEndTime(s.getServiceEndTime());
                        winBidNoticeDetail.setBuildingArea(s.getBuildingArea());
                        winBidNoticeDetail.setConstructionEngineering(s.getConstructionEngineering());
                        winBidNoticeDetail.setEquipmentProcurement(s.getEquipmentProcurement());
                        winBidNoticeDetail.setOtherExpenses(s.getOtherExpenses());
                        winBidNoticeDetail.setEquipmentClassification(s.getEquipmentClassification());
                        winBidNoticeDetail.setTechnicalRequirement(s.getTechnicalRequirement());
                        winBidNoticeDetail.setProjectStatus(s.getProjectStatus());
                        winBidNoticeDetail.setProjectDescript(s.getProjectDescript());
                        winBidNoticeDetail.setPersonLiableId(s.getPersonLiableId());
                        winBidNoticeDetail.setPersonLiableName(s.getPersonLiableName());
                        winBidNoticeDetail.setPersonLiablePhone(s.getPersonLiablePhone());
                        winBidNoticeDetail.setBond(s.getBond());
                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                } else {
                    QueryFilter quoQF = QueryFilter.build();
                    quoQF.addFilter("quo.NOTICE_ID_", (Object)notice.getId(), QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_ROUNDS_", (Object)notice.getQuotationRoundsNum(), QueryOP.EQUAL);
                    quoQF.addFilter("quo.QUOTATION_COMPANY_ID_", quoOrgId, QueryOP.EQUAL);
                    quoQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                    List quoList = this.quotationManager.pageProDetail((QueryFilter<BizBiddingQuotation>)quoQF).getRows();
                    BizBidEvaluation bidEvaluation = (BizBidEvaluation)((Object)((Object)finalBidEvaList.stream().filter(s -> s.getQuotationOrgId().equals(quoOrgId)).collect(Collectors.toList()).get(0)));
                    quoList.stream().forEach(s -> {
                        BizWinBiddingNoticeDetaile winBidNoticeDetail = new BizWinBiddingNoticeDetaile();
                        if (BeanUtils.isNotEmpty((Object)s.getTenderExplain())) {
                            winBidNoticeDetail.setTenderExplain(s.getTenderExplain());
                        }
                        winBidNoticeDetail.setEvaluationId(bidEvaluation.getId());
                        winBidNoticeDetail.setWinNoticeId(winBidNotice.getId());
                        winBidNoticeDetail.setNoticeId(entity.getNoticeId());
                        winBidNoticeDetail.setNoticeCode(notice.getNoticeCode());
                        winBidNoticeDetail.setNoticeName(notice.getNoticeTitle());
                        winBidNoticeDetail.setNoticeDetailedId(s.getNoticeDetailedId());
                        winBidNoticeDetail.setMatId(s.getMatId());
                        winBidNoticeDetail.setMatPlatcode(s.getMatPlatcode());
                        winBidNoticeDetail.setMatCategoryCode(s.getMatCategoryCode());
                        winBidNoticeDetail.setMatCode(s.getMatCode());
                        winBidNoticeDetail.setMatName(s.getMatName());
                        winBidNoticeDetail.setMatMaterial(s.getMatMaterial());
                        winBidNoticeDetail.setMatSpec(s.getMatSpec());
                        winBidNoticeDetail.setMatNum(s.getMatNum());
                        winBidNoticeDetail.setMatUnit(s.getMatUnit());
                        winBidNoticeDetail.setDemandDate(s.getDemandDate());
                        winBidNoticeDetail.setMatBrand(s.getMatBrand());
                        winBidNoticeDetail.setMatBaseExt(s.getMatBaseExt());
                        winBidNoticeDetail.setMatOtherExt(s.getMatOtherExt());
                        winBidNoticeDetail.setTaxRate(s.getTaxRate());
                        winBidNoticeDetail.setStatus(2);
                        winBidNoticeDetail.setShareAllocationRate(bidEvaluation.getShareAllocationRate());
                        winBidNoticeDetail.setShareAllocationNum(winBidNoticeDetail.getShareAllocationRate().divide(new BigDecimal("100")).multiply(winBidNoticeDetail.getMatNum()));
                        winBidNoticeDetail.setWinBidPrice(s.getQuotationPrice());
                        winBidNoticeDetail.setWinBidAmount(s.getQuotationAmount());
                        winBidNoticeDetail.setPlanCode(s.getPlanCode());
                        winBidNoticeDetail.setIsTax(s.getIsTax());
                        if (BeanUtils.isNotEmpty((Object)s.getAcceptanceTime())) {
                            winBidNoticeDetail.setAcceptanceTime(s.getAcceptanceTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getPendingTime())) {
                            winBidNoticeDetail.setPendingTime(s.getPendingTime());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getPurNote())) {
                            winBidNoticeDetail.setPurNote(s.getPurNote());
                        }
                        if (BeanUtils.isNotEmpty((Object)s.getUnloadAddress())) {
                            winBidNoticeDetail.setUnloadAddress(s.getUnloadAddress());
                        }
                        winBidNoticeDetail.setApplicationId(s.getPurchasingApplicationId());
                        winBidNoticeDetail.setApplicationDetailId(s.getPurchasingApplicationDetailId());
                        winBidNoticeDetail.setQuotationMethod(notice.getQuotationMethod());
                        winBidNoticeDetail.setProjectSourceType(s.getProjectSourceType());
                        winBidNoticeDetail.setProjectInfoId(s.getProjectInfoId());
                        winBidNoticeDetail.setProjectLedgerId(s.getProjectLedgerId());
                        winBidNoticeDetail.setProjectLedgerCode(s.getProjectLedgerCode());
                        winBidNoticeDetail.setDetailType(s.getDetailType());
                        winBidNoticeDetail.setServiceStartTime(s.getServiceStartTime());
                        winBidNoticeDetail.setServiceEndTime(s.getServiceEndTime());
                        winBidNoticeDetail.setBuildingArea(s.getBuildingArea());
                        winBidNoticeDetail.setConstructionEngineering(s.getConstructionEngineering());
                        winBidNoticeDetail.setEquipmentProcurement(s.getEquipmentProcurement());
                        winBidNoticeDetail.setOtherExpenses(s.getOtherExpenses());
                        winBidNoticeDetail.setEquipmentClassification(s.getEquipmentClassification());
                        winBidNoticeDetail.setTechnicalRequirement(s.getTechnicalRequirement());
                        winBidNoticeDetail.setProjectStatus(s.getProjectStatus());
                        winBidNoticeDetail.setProjectDescript(s.getProjectDescript());
                        winBidNoticeDetail.setPersonLiableId(s.getPersonLiableId());
                        winBidNoticeDetail.setPersonLiableName(s.getPersonLiableName());
                        winBidNoticeDetail.setPersonLiablePhone(s.getPersonLiablePhone());
                        winBidNoticeDetail.setBond(s.getBond());
                        winBidNoticeDetailList.add(winBidNoticeDetail);
                    });
                }
            });
            if (winBidNoticeDetailList.size() > 0) {
                this.winBidNoticeDetaileManager.saveBatch(winBidNoticeDetailList);
            }
        }
        if (BeanUtils.isNotEmpty((Object)notice.getBond()) && notice.getBond().compareTo(BigDecimal.ZERO) > 0) {
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getNoticeId, (Object)notice.getId())).notIn(winOrgId.size() > 0, UserParticipation::getCompanyId, winOrgId)).eq(UserParticipation::getStatus, (Object)1)).gt(UserParticipation::getPrice, (Object)0)).eq(UserParticipation::getType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
            List userParticipationList = this.userParticipationManager.list((Wrapper)userParticipationQW);
            if (BeanUtils.isNotEmpty((Object)userParticipationList) && userParticipationList.size() > 0) {
                for (UserParticipation userPart : userParticipationList) {
                    if (BeanUtils.isEmpty((Object)userPart.getRegistrationOrderId())) continue;
                    BizRegistrationOrder regisOrder = (BizRegistrationOrder)((Object)this.registrationOrderManager.getById((Serializable)((Object)userPart.getRegistrationOrderId())));
                    BizRegistrationOrder refundRegisOrder = new BizRegistrationOrder();
                    refundRegisOrder.setParticipationId(userPart.getId());
                    String orderNumber = BizUtils.getNextSerialNumber(this.systemConfigFeignService, "zfjl_ddh");
                    refundRegisOrder.setOrderNumber(orderNumber);
                    refundRegisOrder.setPayStatus(3);
                    refundRegisOrder.setRefundStatus(1);
                    refundRegisOrder.setNoticeId(notice.getId());
                    refundRegisOrder.setNoticeType(2);
                    IUser user = ContextUtil.getCurrentUser();
                    refundRegisOrder.setUserId(user.getUserId());
                    refundRegisOrder.setUserAccount(user.getAccount());
                    refundRegisOrder.setUserName(user.getFullname());
                    if (BeanUtils.isNotEmpty((Object)user.getMobile())) {
                        refundRegisOrder.setUserPhone(user.getMobile());
                    }
                    refundRegisOrder.setPayType(6);
                    Org payOrg = this.orgManager.getByCode("00001513");
                    if (BeanUtils.isEmpty((Object)payOrg)) {
                        throw new BaseException("\u672a\u627e\u5230\u7f16\u53f7\u4e3a\u301000001513\u3011\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6ce8\u518c");
                    }
                    refundRegisOrder.setPayUnitId(regisOrder.getCollectUnitId());
                    refundRegisOrder.setPayUnitCode(regisOrder.getCollectUnitCode());
                    refundRegisOrder.setPayUnitName(regisOrder.getCollectUnitName());
                    refundRegisOrder.setPayAccount(regisOrder.getCollectAccount());
                    refundRegisOrder.setPayAccountBank(regisOrder.getCollectAccountBank());
                    refundRegisOrder.setPayTime(LocalDateTime.now());
                    refundRegisOrder.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
                    refundRegisOrder.setPayAmount(regisOrder.getPayAmount());
                    refundRegisOrder.setCollectUnitId(regisOrder.getPayUnitId());
                    refundRegisOrder.setCollectUnitCode(regisOrder.getPayUnitCode());
                    refundRegisOrder.setCollectUnitName(regisOrder.getPayUnitName());
                    refundRegisOrder.setCollectAccount(regisOrder.getPayAccount());
                    refundRegisOrder.setCollectAccountBank(regisOrder.getPayAccountBank());
                    refundRegisOrder.setCollectTime(regisOrder.getPayTime());
                    refundRegisOrder.setCollectTimer(regisOrder.getPayTimer());
                    refundRegisOrder.setPayDescribe("\u9000\u8fd8\u4fdd\u8bc1\u91d1");
                    this.registrationOrderManager.save((Object)refundRegisOrder);
                    ArrayList<BizRegistrationOrderDetails> detailedList = new ArrayList<BizRegistrationOrderDetails>();
                    ForeignResponseVo res = null;
                    TransVo transVo = new TransVo();
                    try {
                        BeanUtils.copyNotNullProperties((Object)transVo, (Object)((Object)refundRegisOrder));
                    }
                    catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        throw new BaseException(e.getMessage());
                    }
                    transVo.setStatementsCode(refundRegisOrder.getOrderNumber());
                    transVo.setDepositPaymentStatus(refundRegisOrder.getPayStatus());
                    BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
                    detail.setRegistrationOrderId(refundRegisOrder.getId());
                    detail.setRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
                    detail.setUserId(refundRegisOrder.getUserId());
                    detail.setUserName(refundRegisOrder.getUserName());
                    detail.setUserAccount(refundRegisOrder.getUserAccount());
                    if (BeanUtils.isNotEmpty((Object)refundRegisOrder.getUserPhone())) {
                        detail.setUserPhone(refundRegisOrder.getUserPhone());
                    }
                    detail.setCompanyId(refundRegisOrder.getPayUnitId());
                    detail.setCompanyCode(refundRegisOrder.getPayUnitCode());
                    detail.setCompanyName(refundRegisOrder.getPayUnitName());
                    detail.setNoticeId(refundRegisOrder.getNoticeId());
                    detail.setNoticeType(refundRegisOrder.getNoticeType());
                    detail.setNoticeTitle(notice.getNoticeTitle());
                    detail.setPayName(notice.getNoticeTitle());
                    detail.setRechargeNumber(BigDecimal.ONE);
                    detail.setRechargePrice(refundRegisOrder.getPayAmount());
                    detail.setSalesCompanyId(refundRegisOrder.getCollectUnitId());
                    detail.setSalesCompanyCode(refundRegisOrder.getCollectUnitCode());
                    detail.setSalesCompanyName(refundRegisOrder.getCollectUnitName());
                    detailedList.add(detail);
                    ArrayList<OrderDetailsVo> orderDetailsList = new ArrayList<OrderDetailsVo>();
                    OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
                    try {
                        BeanUtils.copyNotNullProperties((Object)orderDetailsVo, (Object)((Object)detail));
                    }
                    catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                        System.out.println("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
                        throw new BaseException("\u8ba2\u5355\u660e\u7ec6\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
                    }
                    orderDetailsVo.setPayType(6);
                    orderDetailsList.add(orderDetailsVo);
                    transVo.setOrderDetails(orderDetailsList);
                    res = this.foreignCallService.callPay(transVo, 1);
                    if (BeanUtil.isEmpty((Object)res, (String[])new String[0])) {
                        throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25");
                    }
                    if (!res.getCode().equals("0")) {
                        throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u652f\u4ed8\u5931\u8d25:" + res.getMsg());
                    }
                    if (detailedList.size() > 0) {
                        this.registrationOrderDetailsManager.saveBatch(detailedList);
                    }
                    regisOrder.setRefundStatus(3);
                    regisOrder.setRefundOrderId(refundRegisOrder.getId());
                    this.registrationOrderManager.updateById((Object)regisOrder);
                    userPart.setRefundRegistrationOrderId(refundRegisOrder.getId());
                    userPart.setRefundRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
                }
                this.userParticipationManager.updateBatchById(userParticipationList);
            }
        }
    }

    @Override
    public PageList<BizWinBiddingNotice> getWinBidVendor(QueryFilter<BizWinBiddingNotice> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<BizWinBiddingNotice> result = ((BizWinBiddingNoticeDao)this.baseMapper).getWinBidVendor((IPage<BizWinBiddingNotice>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizWinBiddingNotice>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

