/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.sso.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.conf.JwtConfig;
import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.CertificateException;
import com.artfess.base.jwt.JwtAuthenticationResponse;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.service.LoginLogService;
import com.artfess.base.service.LoginUserService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.IPUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cgpt.sso.manager.SsoSystemManager;
import com.artfess.cgpt.sso.model.SsoSystem;
import com.artfess.cgpt.sso.vo.AuthVO;
import com.artfess.cgpt.sso.vo.BizSsoAuthVO;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5355\u70b9\u7cfb\u7edf\u914d\u7f6e"})
@ApiGroup(group={"group_biz"})
@RestController
@RequestMapping(value={"/ssoSystem/v1/"})
public class SsoSystemController
extends BaseController<SsoSystemManager, SsoSystem> {
    @Resource
    JwtTokenHandler jwtTokenHandler;
    @Resource
    UserDetailsService userDetailsService;
    @Resource
    LoginUserService loginUserService;
    @Resource
    JwtConfig jwtConfig;
    @Autowired
    SsoSystemManager ssoSystemManager;
    @Resource
    SaaSConfig saasConfig;
    @Resource
    LoginLogService loginLogService;

    @PostMapping(value={"/saveEntity"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> saveEntity(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody SsoSystem ssoSystem) throws Exception {
        boolean result = ((SsoSystemManager)this.baseService).insertSsoSystem(ssoSystem);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody SsoSystem ssoSystem) {
        boolean result = ((SsoSystemManager)this.baseService).updateSsoSystem(ssoSystem);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @RequestMapping(value={"/getTokenOfSso"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6token", httpMethod="POST", notes="\u83b7\u53d6token")
    public ResponseEntity<?> getTokenOfSso(@RequestBody BizSsoAuthVO ssoAuthVO) throws AuthenticationException, CertificateException {
        HttpServletRequest request = HttpUtil.getRequest();
        QueryWrapper ssoSystemWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)ssoSystemWrapper.eq((Object)"ACCESS_KEY_", (Object)ssoAuthVO.getAccessKey())).eq((Object)"SECRET_KEY_", (Object)ssoAuthVO.getSecretKey())).last("limit 1");
        SsoSystem ssoSystem = (SsoSystem)((Object)((SsoSystemManager)this.baseService).getBaseMapper().selectOne((Wrapper)ssoSystemWrapper));
        if (BeanUtils.isEmpty((Object)((Object)ssoSystem))) {
            throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728\u6216\u6388\u6743\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (ssoSystem.getIsIpAstrict() == 1 && BeanUtils.isNotEmpty((Object)ssoSystem.getIpAddress()) && ssoSystem.getIpAddress().equals(IPUtils.getIpAddr((HttpServletRequest)request))) {
            throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728\u6216\u6388\u6743\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        HttpSession session = request.getSession();
        UserDetails USER_DETAILS = this.userDetailsService.loadUserByUsername("admin");
        String TOKEN = this.jwtTokenHandler.generateToken(USER_DETAILS);
        String userName = USER_DETAILS.getUsername();
        String account = "";
        String userId = "";
        boolean loginStatus = true;
        HashMap<String, String> userAttrs = new HashMap<String, String>();
        if (USER_DETAILS instanceof IUser) {
            IUser user = (IUser)USER_DETAILS;
            userName = user.getFullname();
            account = user.getAccount();
            userId = user.getUserId();
            request.setAttribute("loginUser", (Object)String.format("%s[%s]", userName, account));
            userAttrs.put("tenantId", user.getTenantId());
        }
        session.removeAttribute("_loginTime_");
        this.loginUserService.updateLastLoginTime(account);
        return ResponseEntity.ok((Object)new JwtAuthenticationResponse(TOKEN, userName, account, userId, Long.valueOf(this.jwtConfig.getExpirationLong()), loginStatus, userAttrs));
    }

    @RequestMapping(value={"/authentication"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7b2c\u4e09\u65b9\u7cfb\u7edf\u8ba4\u8bc1", httpMethod="POST", notes="authVO")
    public CommonResult externalSystemAuth(@RequestBody AuthVO authVO) throws Exception {
        if (BeanUtils.isEmpty((Object)authVO.getSysCode())) {
            return new CommonResult("\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BeanUtils.isEmpty((Object)authVO.getKey())) {
            return new CommonResult("\u5bc6\u5319\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper ssoSystemQW = new QueryWrapper();
        ((QueryWrapper)ssoSystemQW.eq((Object)"SYS_CODE_", (Object)authVO.getSysCode())).last("limit 1");
        SsoSystem data = (SsoSystem)((Object)this.ssoSystemManager.getBaseMapper().selectOne((Wrapper)ssoSystemQW));
        if (BeanUtils.isEmpty((Object)((Object)data))) {
            return new CommonResult(false, "\u7cfb\u7edf\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (BeanUtils.isEmpty((Object)data.getAccessKey()) || BeanUtils.isEmpty((Object)data.getSecretKey())) {
            return new CommonResult(false, "\u8ba4\u8bc1\u5931\u8d25");
        }
        String str = data.getSysCode() + data.getAccessKey() + data.getSecretKey();
        String curKey = EncryptUtil.md5Hex((String)str);
        if (curKey.equalsIgnoreCase(authVO.getKey())) {
            HttpServletRequest request = HttpUtil.getRequest();
            HttpSession session = request.getSession();
            String IP = IPUtils.getIpAddr((HttpServletRequest)request);
            boolean isMobile = HttpUtil.isMobile((HttpServletRequest)request);
            if (BeanUtils.isNotEmpty((Object)data.getIsIpAstrict()) && data.getIsIpAstrict() == 1 && BeanUtils.isNotEmpty((Object)data.getIpAddress()) && IP.equals(data.getIpAddress())) {
                return new CommonResult(false, "\u8ba4\u8bc1\u5931\u8d25");
            }
            UserDetails USER_DETAILS = this.userDetailsService.loadUserByUsername(data.getSysCode());
            String TOKEN = this.jwtTokenHandler.generateToken(USER_DETAILS);
            return new CommonResult(true, "\u8ba4\u8bc1\u6210\u529f", (Object)TOKEN);
        }
        return new CommonResult(false, "\u8ba4\u8bc1\u5931\u8d25");
    }

    private void handleSingleLogin(boolean isMobile, String tenantId, String username, String token) {
        String userAgent;
        String string = userAgent = isMobile ? "mobile" : "pc";
        if (this.jwtConfig.isSingle()) {
            if (StringUtil.isEmpty((String)tenantId) && !this.saasConfig.isEnable()) {
                tenantId = "-1";
            }
            this.jwtTokenHandler.putTokenInCache(userAgent, tenantId, username, this.jwtConfig.getExpiration(), token);
        } else {
            HttpServletRequest request = HttpUtil.getRequest();
            String IP = IPUtils.getIpAddr((HttpServletRequest)request);
            this.jwtTokenHandler.putTokenInCache(userAgent, tenantId, username, IP, this.jwtConfig.getExpiration(), token);
        }
        this.loginLogService.log(username, isMobile ? "mobile" : "pc");
    }
}

