/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.purchasing.dao.PurchasingApplicationDao;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationAuditRecordsManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.manager.PurchasingUnitManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationAuditRecords;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.purchasing.model.PurchasingUnit;
import com.artfess.cgpt.purchasing.vo.PurDetailVo;
import com.artfess.cgpt.purchasing.vo.PurMasterVo;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class PurchasingApplicationManagerImpl
extends BaseManagerImpl<PurchasingApplicationDao, PurchasingApplication>
implements PurchasingApplicationManager {
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private PurchasingUnitManager purchasingUnitManager;
    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private PurchasingApplicationAuditRecordsManager auditRecordsManager;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private BizMaterialManager materialManager;

    @Override
    public PageList<PurchasingApplication> curOrgData(QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)0, QueryOP.EQUAL);
        IPage<PurchasingApplication> result = ((PurchasingApplicationDao)this.baseMapper).queryAllByPage((IPage<PurchasingApplication>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PurchasingApplication>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (PurchasingApplication temp : records) {
                temp.setAccessoryList(this.accessoryService.getAccessoryBySourceId(temp.getId()));
            }
        }
        return new PageList(result);
    }

    @Override
    public PageList<PurchasingApplication> queryAllByPage(QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)0, QueryOP.EQUAL);
        IPage<PurchasingApplication> result = ((PurchasingApplicationDao)this.baseMapper).queryAllByPage((IPage<PurchasingApplication>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PurchasingApplication>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public String saveOrUpdateEntity(PurchasingApplication entity) {
        List<PurchasingApplicationDetails> detailsList = entity.getDetailsList();
        List<PurchasingUnit> unitList = entity.getUnitList();
        List<Accessory> accessoryList = entity.getAccessoryList();
        if (BeanUtils.isEmpty((Object)entity.getPreparedUserId())) {
            entity.setPreparedUserId(ContextUtil.getCurrentUserId());
            entity.setPreparedUserName(ContextUtil.getCurrentUserName());
        }
        if (BeanUtils.isEmpty((Object)entity.getProcurementMethod())) {
            throw new BaseException("\u5b9a\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BeanUtil.isEmpty((Object)entity.getId(), (String[])new String[0])) {
            if (BeanUtils.isEmpty((Object)entity.getApplicationNum())) {
                throw new BaseException("\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            wrapper1.eq(PurchasingUnit::getPurchasingApplicationId, (Object)entity.getId());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            wrapper2.eq(PurchasingApplicationDetails::getPurchasingApplicationId, (Object)entity.getId());
            this.purchasingUnitManager.remove((Wrapper)wrapper1);
            this.applicationDetailsManager.remove((Wrapper)wrapper2);
            this.accessoryService.removeBySourceId(entity.getId());
        }
        if (entity.getIsAgencyProcure() == 1 && BeanUtils.isEmpty((Object)entity.getAgencyProcureOrgId())) {
            throw new BaseException("\u8bf7\u9009\u62e9\u4ee3\u91c7\u5355\u4f4d");
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtil.isNotEmpty(detailsList, (String[])new String[0]) && detailsList.size() > 0) {
            detailsList.stream().forEach(s -> {
                if (BeanUtils.isEmpty((Object)s.getPlanCode())) {
                    throw new BaseException("\u8ba1\u5212\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                s.setPurchasingApplicationId(entity.getId());
            });
            this.applicationDetailsManager.saveBatch(detailsList);
        }
        if (BeanUtil.isNotEmpty(unitList, (String[])new String[0]) && unitList.size() > 0) {
            unitList.stream().forEach(s -> s.setPurchasingApplicationId(entity.getId()));
            this.purchasingUnitManager.saveBatch(unitList);
        }
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(accessory -> accessory.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
        return entity.getId();
    }

    @Override
    public PurchasingApplication getDataById(String id) {
        PurchasingApplication result = (PurchasingApplication)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
        detailsQW.eq(PurchasingApplicationDetails::getPurchasingApplicationId, (Object)id);
        List detailsList = this.applicationDetailsManager.list((Wrapper)detailsQW);
        LambdaQueryWrapper unitQW = new LambdaQueryWrapper();
        unitQW.eq(PurchasingUnit::getPurchasingApplicationId, (Object)id);
        List unitList = this.purchasingUnitManager.list((Wrapper)unitQW);
        result.setDetailsList(detailsList);
        result.setUnitList(unitList);
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        super.removeByIds(ids);
        LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
        detailsQW.in(PurchasingApplicationDetails::getPurchasingApplicationId, ids);
        this.applicationDetailsManager.remove((Wrapper)detailsQW);
        this.accessoryService.removeBySourceIds(ids);
    }

    @Override
    @Transactional
    public void updateStatus(String ids, String status) {
        List list = super.listByIds(Arrays.asList(ids.split(",")));
        ArrayList<PurchasingApplicationAuditRecords> auditRecordsList = new ArrayList<PurchasingApplicationAuditRecords>();
        for (PurchasingApplication data : list) {
            PurchasingApplicationAuditRecords auditRecords;
            data.setStatus(Integer.valueOf(status));
            if (status.equals("3")) {
                data.setAuditingUser(ContextUtil.getCurrentUserName());
                data.setAuditingDate(LocalDateTime.now());
                auditRecords = new PurchasingApplicationAuditRecords();
                auditRecords.setApplicationId(data.getId());
                auditRecords.setApplicationNum(data.getApplicationNum());
                auditRecords.setStatus(1);
                auditRecords.setAuditingDate(data.getAuditingDate());
                auditRecords.setAuditingUser(data.getAuditingUser());
                auditRecordsList.add(auditRecords);
            }
            if (status.equals("8")) {
                data.setAuditingUser(ContextUtil.getCurrentUserName());
                data.setAuditingDate(LocalDateTime.now());
                auditRecords = new PurchasingApplicationAuditRecords();
                auditRecords.setApplicationId(data.getId());
                auditRecords.setApplicationNum(data.getApplicationNum());
                auditRecords.setStatus(2);
                auditRecords.setAuditingDate(data.getAuditingDate());
                auditRecords.setAuditingUser(data.getAuditingUser());
                auditRecords.setAuditingReason(data.getAuditingReason());
                auditRecordsList.add(auditRecords);
            }
            if (!status.equals("1")) continue;
        }
        super.updateBatchById((Collection)list);
        if (auditRecordsList.size() > 0) {
            this.auditRecordsManager.saveBatch(auditRecordsList);
        }
    }

    @Override
    @Transactional
    public void modifyStatusById(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(PurchasingApplication::getStatus, (Object)status)).in(PurchasingApplication::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        if (status.equals("3")) {
            ((LambdaUpdateWrapper)uw.set(PurchasingApplication::getAuditingUser, (Object)ContextUtil.getCurrentUserName())).set(PurchasingApplication::getAuditingDate, (Object)LocalDateTime.now());
        }
        super.update((Wrapper)uw);
    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(JSONObject param) {
        String code = "0";
        String message = "\u64cd\u4f5c\u6210\u529f";
        String errDetail = null;
        try {
            List data = JSONUtil.toList((JSONArray)param.getJSONArray((Object)"data"), PurMasterVo.class);
            List<PurchasingApplication> list = this.purConvertApplication(data);
            for (PurchasingApplication pur : list) {
                List<PurchasingApplicationDetails> detailsList = pur.getDetailsList();
                LambdaQueryWrapper applicationHisQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)applicationHisQW.eq(PurchasingApplication::getApplicationNum, (Object)pur.getApplicationNum())).eq(PurchasingApplication::getMatIfPlat, (Object)pur.getMatIfPlat())).eq(PurchasingApplication::getApplicationSource, (Object)2)).eq(BizModel::getIsDele, (Object)"0");
                List appHisList = super.list((Wrapper)applicationHisQW);
                if (BeanUtils.isNotEmpty((Object)appHisList) && appHisList.size() > 0) {
                    ArrayList<String> collect = new ArrayList<String>();
                    for (PurchasingApplication s2 : appHisList) {
                        if (s2.getStatus() != 1 && s2.getStatus() != 8) {
                            throw new BaseException("\u7533\u8bf7\u5355\u3010" + s2.getApplicationNum() + "\u3011\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u91cd\u65b0\u5bfc\u5165");
                        }
                        collect.add(s2.getId());
                    }
                    LambdaQueryWrapper applicationDetailHisQW = new LambdaQueryWrapper();
                    applicationDetailHisQW.in(PurchasingApplicationDetails::getPurchasingApplicationId, collect);
                    this.applicationDetailsManager.remove((Wrapper)applicationDetailHisQW);
                }
                super.remove((Wrapper)applicationHisQW);
                super.save((Object)pur);
                if (BeanUtils.isNotEmpty(detailsList) && detailsList.size() > 0) {
                    detailsList.forEach(s -> {
                        s.setPurchasingApplicationId(pur.getId());
                        if (BeanUtils.isEmpty((Object)s.getApplicationNum())) {
                            s.setApplicationNum(pur.getApplicationNum());
                        }
                    });
                }
                this.applicationDetailsManager.saveBatch(detailsList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "\u64cd\u4f5c\u5931\u8d25:" + errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return new Response<String>(code, message, errDetail);
    }

    List<PurchasingApplication> purConvertApplication(List<PurMasterVo> purList) {
        ArrayList<PurchasingApplication> result = new ArrayList<PurchasingApplication>();
        for (PurMasterVo pur : purList) {
            List<PurDetailVo> purDetailList = pur.getDetailList();
            LambdaQueryWrapper enterpriseQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)enterpriseQW.and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.eq(Enterprise::getHistoryCompanyCode, (Object)pur.getMatCompany())).or()).eq(Enterprise::getCompanyCode, (Object)pur.getMatCompany());
            })).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(AutoFillModel::getCreateTime)).last("limit 1");
            Enterprise enterprise = (Enterprise)((Object)this.enterpriseManager.getBaseMapper().selectOne((Wrapper)enterpriseQW));
            if (BeanUtils.isEmpty((Object)((Object)enterprise))) {
                throw new BaseException("\u8bf7\u5148\u63a8\u9001\u4f01\u4e1a\u3010" + pur.getMatCompany() + "\u3011\u5230\u91c7\u8d2d\u5e73\u53f0");
            }
            if (BeanUtils.isNotEmpty(purDetailList) && purDetailList.size() > 0) {
                Map<Integer, List<PurDetailVo>> collect = purDetailList.stream().collect(Collectors.groupingBy(s -> s.getMatIfPlat()));
                collect.forEach((matIfPlat, detailVoList) -> {
                    PurchasingApplication temp = new PurchasingApplication();
                    temp.setApplicationNum(pur.getPrbillCode());
                    temp.setPreparedUserName(pur.getPurCreator());
                    temp.setPreparedOrgId(enterprise.getOrgId());
                    temp.setPreparedOrgCode(enterprise.getCompanyCode());
                    temp.setPreparedOrgName(enterprise.getCompanyName());
                    temp.setPurBzbm(pur.getPurBzbm());
                    temp.setPreparedDate(pur.getPurCreatedate().toLocalDate());
                    temp.setHasQualification(0);
                    temp.setApplicationSource(2);
                    temp.setStatus(1);
                    temp.setMergeStatus(1);
                    temp.setIsAgencyProcure(0);
                    temp.setApplicationDate(temp.getPreparedDate());
                    temp.setMatIfPlat((Integer)matIfPlat);
                    ArrayList<PurchasingApplicationDetails> applicationDetailList = new ArrayList<PurchasingApplicationDetails>();
                    for (PurDetailVo detailVo : detailVoList) {
                        PurchasingApplicationDetails detail = new PurchasingApplicationDetails();
                        detail.setApplicationNum(detailVo.getPrbillCode());
                        detail.setPlanCode(detailVo.getPlanCode());
                        LambdaQueryWrapper matQW = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)matQW.eq(BizMaterial::getMatPlatcode, (Object)detailVo.getMatPlatcode())).eq(BizModel::getIsDele, (Object)"0")).orderByDesc(AutoFillModel::getCreateTime)).last("limit 1");
                        if (BeanUtils.isNotEmpty((Object)enterprise.getHistoryCompanyCode())) {
                            matQW.and(s -> {
                                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.eq(BizMaterial::getMatCompanyCode, (Object)enterprise.getCompanyCode())).or()).eq(BizMaterial::getMatCompanyCode, (Object)enterprise.getHistoryCompanyCode());
                            });
                        } else {
                            matQW.eq(BizMaterial::getMatCompanyCode, (Object)enterprise.getCompanyCode());
                        }
                        BizMaterial mat = (BizMaterial)((Object)((Object)this.materialManager.getBaseMapper().selectOne((Wrapper)matQW)));
                        if (BeanUtils.isEmpty((Object)((Object)mat))) {
                            throw new BaseException("\u8bf7\u5148\u63a8\u9001\u7269\u6599\u3010" + detailVo.getMatPlatcode() + "\u3011\u5230\u91c7\u8d2d\u5e73\u53f0");
                        }
                        detail.setMatId(mat.getId());
                        detail.setMatCompanyId(enterprise.getOrgId());
                        detail.setMatCompanyCode(enterprise.getCompanyCode());
                        detail.setMatCompanyName(enterprise.getCompanyName());
                        detail.setMatCategory(mat.getMatCategory());
                        detail.setMatCode(detailVo.getMatCode());
                        detail.setMatPlatcode(detailVo.getMatPlatcode());
                        detail.setMatName(detailVo.getMatName());
                        detail.setMatMaterial(mat.getMatMaterial());
                        detail.setMatSpec(mat.getMatSpec());
                        detail.setMatBrand(mat.getMatBrand());
                        detail.setMatBaseExt(mat.getMatBaseExt());
                        detail.setMatOtherExt(mat.getMatOtherExt());
                        detail.setMatUnit(mat.getMatUnit());
                        detail.setMatNum(detailVo.getPurQuantity());
                        detail.setDemandDate(detailVo.getPurReqdate());
                        detail.setPlannedPrice(detailVo.getTaxInprice());
                        detail.setUnloadAddress(detailVo.getUnloadAddress());
                        detail.setTaxRate(mat.getMatTaxrate());
                        if (mat.getMatTaxrate() == 0) {
                            detail.setIsTax(2);
                        } else {
                            detail.setIsTax(1);
                        }
                        detail.setMatIfPlat(detailVo.getMatIfPlat());
                        detail.setRemarks(detailVo.getPurNote());
                        detail.setMaximumPriceLimit(detailVo.getTaxInprice());
                        detail.setStatus(1);
                        applicationDetailList.add(detail);
                    }
                    temp.setDetailsList(applicationDetailList);
                    result.add(temp);
                });
                continue;
            }
            PurchasingApplication temp = new PurchasingApplication();
            temp.setApplicationNum(pur.getPrbillCode());
            temp.setPreparedUserName(pur.getPurCreator());
            temp.setPreparedOrgId(enterprise.getOrgId());
            temp.setPreparedOrgCode(enterprise.getCompanyCode());
            temp.setPreparedOrgName(enterprise.getCompanyName());
            temp.setPurBzbm(pur.getPurBzbm());
            temp.setPreparedDate(pur.getPurCreatedate().toLocalDate());
            temp.setHasQualification(0);
            temp.setApplicationSource(2);
            temp.setStatus(1);
            temp.setMergeStatus(1);
            temp.setIsAgencyProcure(0);
            temp.setApplicationDate(temp.getPreparedDate());
            result.add(temp);
        }
        return result;
    }
}

