/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.SupplierIssueManagementDao;
import com.artfess.cgpt.supplier.manager.SupplierIssueManagementManager;
import com.artfess.cgpt.supplier.model.SupplierIssueManagement;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SupplierIssueManagementManagerImpl
extends BaseManagerImpl<SupplierIssueManagementDao, SupplierIssueManagement>
implements SupplierIssueManagementManager {
    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<SupplierIssueManagement> queryAllByPage(QueryFilter<SupplierIssueManagement> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<SupplierIssueManagement> result = ((SupplierIssueManagementDao)this.baseMapper).queryAllByPage((IPage<SupplierIssueManagement>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SupplierIssueManagement>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (SupplierIssueManagement temp : records) {
                temp.setAccessoryList(this.accessoryService.getAccessoryBySourceId(temp.getId()));
            }
        }
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(SupplierIssueManagement entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            this.accessoryService.removeBySourceId(entity.getId());
        }
        if (BeanUtils.isNotEmpty((Object)entity.getRecordTime())) {
            entity.setRecordTime(LocalDateTime.now());
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateHandleStatus(SupplierIssueManagement entity) {
        if (entity.getHandleStatus().equals(2)) {
            entity.setHandleTime(LocalDateTime.now());
        }
        super.updateById((Object)entity);
    }

    @Override
    public SupplierIssueManagement getDetailById(String id) {
        SupplierIssueManagement result = (SupplierIssueManagement)((Object)super.getById((Serializable)((Object)id)));
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(id));
        return result;
    }
}

