/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.entity.BizModel;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseManager;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.supplier.vo.BizEnterpriseVo;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enterprise/v1/"})
@Api(tags={"\u4f01\u4e1a\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class EnterpriseController
extends BaseController<EnterpriseManager, Enterprise> {
    @Autowired
    UserManager userService;
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private BizExpertDatabaseManager expertDatabaseManager;

    @PostMapping(value={"/queryOrgNoOccupy"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u672a\u6dfb\u52a0\u6218\u7565\u4f9b\u5e94\u5546\u7684\u4f01\u4e1a")
    public PageList<Org> queryOrgNoOccupy(@RequestBody QueryFilter<Enterprise> queryFilter) {
        return ((EnterpriseManager)this.baseService).queryOrgNoOccupy(queryFilter);
    }

    @PostMapping(value={"/queryAllOrg"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u7ec4\u7ec7\uff08\u4f01\u4e1a\u8868\u8054\u67e5\uff09")
    public PageList<Org> queryAllOrg(@RequestBody QueryFilter<Enterprise> queryFilter) {
        return ((EnterpriseManager)this.baseService).queryOrgNoOccupy(queryFilter);
    }

    @PostMapping(value={"/queryAll"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public PageList<Enterprise> queryAll(@RequestBody QueryFilter<Enterprise> queryFilter) {
        return ((EnterpriseManager)this.baseService).queryByPage(queryFilter);
    }

    @PostMapping(value={"/saveOrUpdateEntity"})
    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e")
    public CommonResult saveOrUpdateEntity(@RequestBody Enterprise entity) {
        ((EnterpriseManager)this.baseService).saveOrUpdateEntity(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/getNoExpertUserByOrg"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u516c\u53f8\u4e0d\u5728\u4e13\u5bb6\u5e93\u7684\u7528\u6237\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public PageList<User> getNoExpertUserByOrg(@ApiParam(name="vo", value="\u67e5\u8be2\u6761\u4ef6vo") @RequestBody BizEnterpriseVo vo) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(vo.getIndex(), vo.getSize()));
        if (BeanUtils.isEmpty((Object)ContextUtil.getCurrentOrgId())) {
            return new PageList();
        }
        queryFilter.addFilter("ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL, FieldRelation.AND, "orgTree");
        LambdaQueryWrapper expertQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)expertQW.select(new SFunction[]{BizExpertDatabase::getAccount}).eq(BizExpertDatabase::getOrgId, (Object)ContextUtil.getCurrentOrgId())).eq(BizModel::getIsDele, (Object)"0");
        List objs = this.expertDatabaseManager.listObjs((Wrapper)expertQW);
        if (BeanUtils.isNotEmpty((Object)objs) && objs.size() > 0) {
            List accounts = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            queryFilter.addFilter("account_", accounts, QueryOP.NOT_IN, FieldRelation.AND, "acc");
        }
        if (BeanUtils.isNotEmpty((Object)vo.getFullName())) {
            queryFilter.addFilter("fullname", (Object)vo.getFullName(), QueryOP.LIKE, FieldRelation.OR, "quick");
        }
        IPage list = this.userService.getOrgUserQuery(queryFilter);
        return new PageList(list);
    }

    @PostMapping(value={"/getNoExpertUserByOrgPlat"})
    @ApiOperation(value="\u83b7\u53d6\u4e0d\u5728\u4e13\u5bb6\u5e93\u7684\u7528\u6237\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public PageList<User> getNoExpertUserByOrgPlat(@ApiParam(name="vo", value="\u67e5\u8be2\u6761\u4ef6vo") @RequestBody BizEnterpriseVo vo) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(vo.getIndex(), vo.getSize()));
        if (BeanUtils.isNotEmpty((Object)vo.getCompanyCode())) {
            ArrayNode orgListByUserId = this.ucFeignService.getOrgsByCodes(vo.getCompanyCode());
            if (BeanUtils.isNotEmpty((Object)orgListByUserId)) {
                String id = orgListByUserId.get(0).get("id").asText();
                queryFilter.addFilter("ORG_ID_", (Object)id, QueryOP.IN, FieldRelation.AND, "orgTree");
                LambdaQueryWrapper expertQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)expertQW.select(new SFunction[]{BizExpertDatabase::getAccount}).in(BizExpertDatabase::getOrgId, new Object[]{id})).eq(BizModel::getIsDele, (Object)"0");
                List objs = this.expertDatabaseManager.listObjs((Wrapper)expertQW);
                if (BeanUtils.isNotEmpty((Object)objs) && objs.size() > 0) {
                    List accounts = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                    queryFilter.addFilter("account_", accounts, QueryOP.NOT_IN, FieldRelation.AND, "acc");
                }
            }
        } else if (BizUtils.isAdmin(this.ucFeignService)) {
            queryFilter.addFilter("ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.IN, FieldRelation.AND, "orgTree");
            LambdaQueryWrapper expertQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)expertQW.select(new SFunction[]{BizExpertDatabase::getAccount}).eq(BizExpertDatabase::getOrgId, (Object)ContextUtil.getCurrentOrgId())).eq(BizModel::getIsDele, (Object)"0");
            List objs = this.expertDatabaseManager.listObjs((Wrapper)expertQW);
            if (BeanUtils.isNotEmpty((Object)objs) && objs.size() > 0) {
                List accounts = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                queryFilter.addFilter("account_", accounts, QueryOP.NOT_IN, FieldRelation.AND, "acc");
            }
        }
        if (BeanUtils.isNotEmpty((Object)vo.getFullName())) {
            queryFilter.addFilter("fullname", (Object)vo.getFullName(), QueryOP.LIKE, FieldRelation.OR, "quick");
        }
        IPage list = this.userService.getOrgUserQuery(queryFilter);
        return new PageList(list);
    }

    @PostMapping(value={"/getUserByOrgPlat"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868-\u5e73\u53f0\u7ba1\u7406", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public PageList<User> getUserByOrgPlat(@ApiParam(name="vo", value="\u67e5\u8be2\u6761\u4ef6vo") @RequestBody BizEnterpriseVo vo) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(vo.getIndex(), vo.getSize()));
        if (BeanUtils.isNotEmpty((Object)vo.getCompanyCode())) {
            ArrayNode orgListByUserId = this.ucFeignService.getOrgsByCodes(vo.getCompanyCode());
            if (BeanUtils.isNotEmpty((Object)orgListByUserId)) {
                String id = orgListByUserId.get(0).get("id").asText();
                queryFilter.addFilter("ORG_ID_", (Object)id, QueryOP.IN, FieldRelation.AND, "orgTree");
            }
        } else if (BizUtils.isAdmin(this.ucFeignService)) {
            queryFilter.addFilter("ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.IN, FieldRelation.AND, "orgTree");
        }
        if (BeanUtils.isNotEmpty((Object)vo.getFullName())) {
            queryFilter.addFilter("fullname", (Object)vo.getFullName(), QueryOP.LIKE, FieldRelation.OR, "quick");
        }
        IPage list = this.userService.getOrgUserQuery(queryFilter);
        return new PageList(list);
    }

    @PostMapping(value={"/getUserByOrg"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public PageList<User> getUserByOrg(@ApiParam(name="vo", value="\u67e5\u8be2\u6761\u4ef6vo") @RequestBody BizEnterpriseVo vo) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(vo.getIndex(), vo.getSize()));
        if (BeanUtils.isEmpty((Object)ContextUtil.getCurrentOrgId())) {
            return new PageList();
        }
        queryFilter.addFilter("ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL, FieldRelation.AND, "orgTree");
        if (BeanUtils.isNotEmpty((Object)vo.getFullName())) {
            queryFilter.addFilter("fullname", (Object)vo.getFullName(), QueryOP.LIKE, FieldRelation.OR, "quick");
        }
        IPage list = this.userService.getOrgUserQuery(queryFilter);
        return new PageList(list);
    }

    @PostMapping(value={"/getUserList"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u542b\u7ec4\u7ec7\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u542b\u7ec4\u7ec7\u4fe1\u606f\uff09")
    public CommonResult<PageList<User>> getUserList(@RequestBody QueryFilter<User> queryFilter) throws Exception {
        PageList result = this.userService.queryOrgUserPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }
}

