/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.job;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.job.model.BaseJob;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoRefundBondJob
extends BaseJob {
    protected Logger logger = LoggerFactory.getLogger(AutoRefundBondJob.class);
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private BizContractManager contractManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private BizRegistrationOrderManager registrationOrderManager;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;

    public void executeJob(JobExecutionContext context) throws Exception {
        System.out.println("-----\u5b9a\u65f6\u9000\u8fd8\u5df2\u7b7e\u8ba2\u5408\u540c\u6210\u4ea4\u4f9b\u5e94\u5546\u7684\u4fdd\u8bc1\u91d1\u63a5\u53e3\u6267\u884c\u5f00\u59cb--\u65f6\u95f4\uff1a" + LocalDateTime.now() + "-----");
        List<UserParticipation> noRefundData = this.userParticipationManager.getNoRefundData();
        if (BeanUtils.isNotEmpty(noRefundData) && noRefundData.size() > 0) {
            for (UserParticipation userPart : noRefundData) {
                MatApproval notice;
                Integer noSignContrCount = this.contractManager.getNoSignContrCount(userPart.getNoticeId(), userPart.getCompanyId());
                if (noSignContrCount != 0 || userPart.getNoticeType() != 1 || !BeanUtils.isNotEmpty((Object)(notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)userPart.getNoticeId())))).getBond()) || notice.getBond().compareTo(BigDecimal.ZERO) <= 0 || BeanUtils.isEmpty((Object)userPart.getRegistrationOrderId())) continue;
                try {
                    this.registrationOrderManager.refundBond(userPart);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u5b9a\u65f6\u9000\u8fd8\u5df2\u7b7e\u8ba2\u5408\u540c\u6210\u4ea4\u4f9b\u5e94\u5546\u7684\u4fdd\u8bc1\u91d1\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage());
                    this.logger.info("-----\u5b9a\u65f6\u9000\u8fd8\u5df2\u7b7e\u8ba2\u5408\u540c\u6210\u4ea4\u4f9b\u5e94\u5546\u7684\u4fdd\u8bc1\u91d1\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage() + "-----");
                }
            }
        }
        this.logger.info("-----\u5b9a\u65f6\u9000\u8fd8\u5df2\u7b7e\u8ba2\u5408\u540c\u6210\u4ea4\u4f9b\u5e94\u5546\u7684\u4fdd\u8bc1\u91d1\u63a5\u53e3\u6267\u884c\u5b8c\u6210--\u65f6\u95f4\uff1a" + LocalDateTime.now() + "-----");
    }
}

