/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.evaluation.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.evaluation.dao.BizEvaluationSystemDao;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemUseOrgManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemUseOrg;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.OrgManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizEvaluationSystemManagerImpl
extends BaseManagerImpl<BizEvaluationSystemDao, BizEvaluationSystem>
implements BizEvaluationSystemManager {
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private BizEvaluationSystemDescriptionManager evaluationSystemDescriptionManager;
    @Autowired
    private BizEvaluationSystemUseOrgManager evaluationSystemUseOrgManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;

    @Override
    public PageList<BizEvaluationSystem> queryAllByPage(QueryFilter<BizEvaluationSystem> queryFilter) {
        IPage<BizEvaluationSystem> result = ((BizEvaluationSystemDao)this.baseMapper).queryAllByPage((IPage<BizEvaluationSystem>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEvaluationSystem>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizEvaluationSystem> pageDetail(QueryFilter<BizEvaluationSystem> queryFilter) {
        IPage<BizEvaluationSystem> result = ((BizEvaluationSystemDao)this.baseMapper).queryAllByPage((IPage<BizEvaluationSystem>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEvaluationSystem>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BizEvaluationSystem temp : records) {
                LambdaQueryWrapper descriptionQW = new LambdaQueryWrapper();
                descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, (Object)temp.getId());
                temp.setDescriptionList(this.evaluationSystemDescriptionManager.list((Wrapper)descriptionQW));
            }
        }
        return new PageList(result);
    }

    @Override
    public PageList<BizEvaluationSystem> queryByPage(QueryFilter<BizEvaluationSystem> queryFilter) {
        BizUtils.addFilterByOrgCodeAndRole(queryFilter, this.ucFeignService, "PREPARED_ORG_ID_");
        IPage<BizEvaluationSystem> result = ((BizEvaluationSystemDao)this.baseMapper).queryAllByPage((IPage<BizEvaluationSystem>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEvaluationSystem>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizEvaluationSystem> queryByUseOrg(QueryFilter<BizEvaluationSystem> queryFilter) {
        List querys = queryFilter.getQuerys();
        String useOrgId = null;
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equals("useOrgId")) continue;
                useOrgId = String.valueOf(qf.getValue());
                qf.setProperty("1");
                qf.setValue((Object)"1");
                break;
            }
        }
        if (BeanUtils.isNotEmpty(useOrgId)) {
            LambdaQueryWrapper useOrgQW = new LambdaQueryWrapper();
            useOrgQW.select(new SFunction[]{BizEvaluationSystemUseOrg::getEvaluationSystemId}).eq(BizEvaluationSystemUseOrg::getOrgId, useOrgId);
            List objList = this.evaluationSystemUseOrgManager.listObjs((Wrapper)useOrgQW);
            if (BeanUtils.isNotEmpty((Object)objList) && objList.size() > 0) {
                List evaSysIds = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                queryFilter.addFilter("ID_", evaSysIds, QueryOP.IN);
            }
        }
        IPage<BizEvaluationSystem> result = ((BizEvaluationSystemDao)this.baseMapper).queryAllByPage((IPage<BizEvaluationSystem>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizEvaluationSystem>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizEvaluationSystem entity) {
        List<BizEvaluationSystemUseOrg> useOrgList;
        List<BizEvaluationSystemDescription> descriptionList;
        boolean isUpdate = false;
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            isUpdate = true;
        }
        super.saveOrUpdate((Object)entity);
        if (isUpdate) {
            LambdaQueryWrapper descriptionQW = new LambdaQueryWrapper();
            descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, (Object)entity.getId());
            this.evaluationSystemDescriptionManager.remove((Wrapper)descriptionQW);
        }
        if (BeanUtils.isNotEmpty(descriptionList = entity.getDescriptionList()) && descriptionList.size() > 0) {
            descriptionList.stream().forEach(s -> s.setEvaluationSystemId(entity.getId()));
            this.evaluationSystemDescriptionManager.saveBatch(descriptionList);
        }
        if (isUpdate) {
            LambdaQueryWrapper useOrgQW = new LambdaQueryWrapper();
            useOrgQW.eq(BizEvaluationSystemUseOrg::getEvaluationSystemId, (Object)entity.getId());
            this.evaluationSystemUseOrgManager.remove((Wrapper)useOrgQW);
        }
        if (BeanUtils.isNotEmpty(useOrgList = entity.getUseOrgList()) && useOrgList.size() > 0) {
            useOrgList.stream().forEach(s -> s.setEvaluationSystemId(entity.getId()));
            this.evaluationSystemUseOrgManager.saveBatch(useOrgList);
        }
    }

    @Override
    public BizEvaluationSystem getDataById(String id) {
        BizEvaluationSystem result = (BizEvaluationSystem)((Object)super.getById((Serializable)((Object)id)));
        result.setDescriptionList(this.evaluationSystemDescriptionManager.selectBySysId(id));
        QueryFilter useOrgQF = QueryFilter.build();
        useOrgQF.addFilter("euo.EVALUATION_SYSTEM_ID_", (Object)id, QueryOP.EQUAL);
        result.setOrgs(this.evaluationSystemUseOrgManager.getUseOrgList((QueryFilter<BizEvaluationSystemUseOrg>)useOrgQF));
        return result;
    }
}

