/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.QuotationTemplateDao;
import com.artfess.cgpt.bidding.manager.QuotationTemplateDetailManager;
import com.artfess.cgpt.bidding.manager.QuotationTemplateManager;
import com.artfess.cgpt.bidding.model.QuotationTemplate;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuotationTemplateManagerImpl
extends BaseManagerImpl<QuotationTemplateDao, QuotationTemplate>
implements QuotationTemplateManager {
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private QuotationTemplateDetailManager quotationTemplateDetailManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;

    @Override
    public PageList<QuotationTemplate> queryAllByPage(QueryFilter<QuotationTemplate> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        IPage<QuotationTemplate> result = ((QuotationTemplateDao)this.baseMapper).queryAllByPage((IPage<QuotationTemplate>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<QuotationTemplate>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (QuotationTemplate data : records) {
                data.setDataQuoteStatus(this.existDataStatus(data));
            }
        }
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateData(QuotationTemplate data) {
        List<QuotationTemplateDetail> detailList = data.getDetailList();
        if (BeanUtils.isEmpty((Object)data.getId())) {
            data.setCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "bjmb_bm"));
        } else {
            this.existData(data);
            LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)detailQW.eq(QuotationTemplateDetail::getTemplateId, (Object)data.getId())).eq(BizModel::getIsDele, (Object)"0");
            this.quotationTemplateDetailManager.remove((Wrapper)detailQW);
        }
        super.saveOrUpdate((Object)data);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.stream().forEach(s -> s.setTemplateId(data.getId()));
        }
        this.quotationTemplateDetailManager.saveOrUpdateBatch(detailList);
    }

    @Override
    public QuotationTemplate dataById(String id) {
        QuotationTemplate result = (QuotationTemplate)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)detailQW.eq(QuotationTemplateDetail::getTemplateId, (Object)id)).ne(BizModel::getIsDele, (Object)"1");
        List detailList = this.quotationTemplateDetailManager.list((Wrapper)detailQW);
        if (BeanUtils.isNotEmpty((Object)detailList)) {
            result.setDetailList(detailList);
        }
        return result;
    }

    @Override
    public void removeByIds(List<String> ids) {
        List quotationTemplates = super.listByIds(ids);
        for (QuotationTemplate data : quotationTemplates) {
            this.existData(data);
        }
        super.removeByIds(ids);
    }

    void existData(QuotationTemplate data) {
        LambdaQueryWrapper matApprovalQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)matApprovalQW.eq(MatApproval::getQuotationTemplate, (Object)data.getId())).eq(BizModel::getIsDele, (Object)"0");
        if (this.matApprovalManager.count((Wrapper)matApprovalQW) > 0) {
            throw new BaseException("\u6a21\u7248\u7f16\u7801\u3010" + data.getCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
        LambdaQueryWrapper projectApprovalQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)projectApprovalQW.eq(ProjectApproval::getQuotationTemplate, (Object)data.getId())).eq(BizModel::getIsDele, (Object)"0");
        if (this.projectApprovalManager.count((Wrapper)projectApprovalQW) > 0) {
            throw new BaseException("\u6a21\u7248\u7f16\u7801\u3010" + data.getCode() + "\u3011\u5df2\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        }
    }

    Integer existDataStatus(QuotationTemplate data) {
        LambdaQueryWrapper matApprovalQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)matApprovalQW.eq(MatApproval::getQuotationTemplate, (Object)data.getId())).eq(BizModel::getIsDele, (Object)"0");
        if (this.matApprovalManager.count((Wrapper)matApprovalQW) > 0) {
            return 1;
        }
        LambdaQueryWrapper projectApprovalQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)projectApprovalQW.eq(ProjectApproval::getQuotationTemplate, (Object)data.getId())).eq(BizModel::getIsDele, (Object)"0");
        if (this.projectApprovalManager.count((Wrapper)projectApprovalQW) > 0) {
            return 1;
        }
        return 0;
    }
}

