/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.sso.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cgpt.sso.dao.SsoSystemDao;
import com.artfess.cgpt.sso.manager.SsoSystemManager;
import com.artfess.cgpt.sso.model.SsoSystem;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.params.org.OrgUserVo;
import com.artfess.uc.params.user.UserVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.gexin.rp.sdk.base.uitls.MD5Util;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SsoSystemManagerImpl
extends BaseManagerImpl<SsoSystemDao, SsoSystem>
implements SsoSystemManager {
    @Autowired
    private UserManager userManager;
    @Autowired
    OrgManager orgService;
    @Autowired
    private JwtTokenHandler jwtTokenHandler;

    @Override
    public SsoSystem getEntityByAkAndSk(String ak, String sk) {
        return ((SsoSystemDao)this.baseMapper).getByAkAndSk(ak, sk);
    }

    @Override
    @Transactional
    public boolean insertSsoSystem(SsoSystem ssoSystem) throws Exception {
        boolean checkFlag = this.checkSameCode(ssoSystem.getSysCode(), ssoSystem.getId());
        if (checkFlag) {
            throw new ApplicationException("\u7cfb\u7edf\u7f16\u7801\u3010" + ssoSystem.getSysCode() + "\u3011\u91cd\u590d\uff01");
        }
        String accessKey = null;
        String secretKey = null;
        try {
            accessKey = EncryptUtil.encrypt((String)MD5Util.getMD5Format((String)(ssoSystem.getSysCode() + "_" + new Random().nextInt(1000))));
            Long time = System.currentTimeMillis();
            secretKey = EncryptUtil.encrypt((String)MD5Util.getMD5Format((String)(accessKey + time)));
        }
        catch (Exception e) {
            throw new ApplicationException("\u7cfb\u7edf\u751f\u6210AK\u4e0eSK\u51fa\u9519\uff01", (Throwable)e);
        }
        ssoSystem.setAccessKey(accessKey);
        ssoSystem.setSecretKey(secretKey);
        int num = ((SsoSystemDao)this.baseMapper).insert((Object)ssoSystem);
        UserVo userVo = new UserVo();
        userVo.setAccount(ssoSystem.getSysCode());
        userVo.setFullname(ssoSystem.getSysName());
        userVo.setPassword(ssoSystem.getSysCode() + "@6921");
        this.userManager.addUser(userVo);
        OrgUserVo orgUserVo = new OrgUserVo();
        orgUserVo.setAccount(ssoSystem.getSysCode());
        orgUserVo.setOrgCode("dsfxt");
        this.orgService.addOrgUser(orgUserVo);
        return num > 0;
    }

    @Override
    @Transactional
    public boolean updateSsoSystem(SsoSystem ssoSystem) {
        boolean checkFlag = this.checkSameCode(ssoSystem.getSysCode(), ssoSystem.getId());
        if (checkFlag) {
            throw new ApplicationException("\u7cfb\u7edf\u7f16\u7801\u3010" + ssoSystem.getSysCode() + "\u3011\u91cd\u590d\uff01");
        }
        SsoSystem old = (SsoSystem)((Object)((SsoSystemDao)this.baseMapper).selectById((Serializable)((Object)ssoSystem.getId())));
        old.setSysName(ssoSystem.getSysName());
        old.setSysCode(ssoSystem.getSysCode());
        old.setCompanyName(ssoSystem.getCompanyName());
        old.setContact(ssoSystem.getContact());
        old.setPhone(ssoSystem.getPhone());
        old.setIsIpAstrict(ssoSystem.getIsIpAstrict());
        old.setIpAddress(ssoSystem.getIpAddress());
        old.setLoginTime(ssoSystem.getLoginTime());
        int num = ((SsoSystemDao)this.baseMapper).updateById((Object)old);
        return num > 0;
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sys_code_", (Object)code);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"id_", (Object)id);
        int num = ((SsoSystemDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num > 0;
    }

    public JsonNode getSystemByAKAndSK(String ak, String sk) {
        Assert.hasText((String)ak, (String)"\u7cfb\u7edf\u8bbf\u95eekey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)sk, (String)"\u7cfb\u7edf\u8bbf\u95ee\u5b89\u5168\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"access_key_", (Object)ak);
        queryWrapper.eq((Object)"secret_key_", (Object)sk);
        List list = ((SsoSystemDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            SsoSystem ssoSystem = (SsoSystem)((Object)list.get(0));
            JsonNode jsonNode = null;
            try {
                jsonNode = JsonUtil.toJsonNode((Object)((Object)ssoSystem));
            }
            catch (IOException e) {
                return null;
            }
            return jsonNode;
        }
        return null;
    }

    public void updateLastLoginTime(String ak, String sk) {
        Assert.hasText((String)ak, (String)"\u7cfb\u7edf\u8bbf\u95eekey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)sk, (String)"\u7cfb\u7edf\u8bbf\u95ee\u5b89\u5168\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"LOGIN_TIME_", (Object)LocalDate.now());
        updateWrapper.eq((Object)"access_key_", (Object)ak);
        updateWrapper.eq((Object)"secret_key_", (Object)sk);
        ((SsoSystemDao)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    @Override
    public String getSysNameByCode(String sysCode) {
        return ((SsoSystemDao)this.baseMapper).getSysNameByCode(sysCode);
    }

    @Override
    public String getCurrentSysCode(HttpServletRequest request) {
        String tokenStr = request.getHeader("authorization");
        String token = tokenStr.substring(tokenStr.indexOf("Bearer") + 7);
        String sysCode = this.jwtTokenHandler.getUsernameFromToken(token);
        return sysCode;
    }
}

