/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchasingApplication/v1/"})
@Api(tags={"\u91c7\u8d2d\u7533\u8bf7"})
@ApiGroup(group={"group_biz"})
public class PurchasingApplicationController
extends BaseController<PurchasingApplicationManager, PurchasingApplication> {
    @Autowired
    UCFeignService ucFeignService;

    @PostMapping(value={"/pageCurOrgData"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u6570\u636e\uff08\u7ba1\u7406\u5458\u67e5\u770b\u6240\u6709\uff09")
    public CommonResult<PageList<PurchasingApplication>> pageCurOrgData(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        BizUtils.addFilterByUserOrgAndRoleBusiness(queryFilter, this.ucFeignService, "PREPARED_ORG_ID_");
        PageList<PurchasingApplication> result = ((PurchasingApplicationManager)this.baseService).curOrgData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/curUserData"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u6570\u636e")
    public CommonResult<PageList<PurchasingApplication>> curUserData(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("PREPARED_USER_ID_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<PurchasingApplication> result = ((PurchasingApplicationManager)this.baseService).curOrgData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/curOrgData"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u6570\u636e")
    public CommonResult<PageList<PurchasingApplication>> curOrgData(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("PREPARED_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        PageList<PurchasingApplication> result = ((PurchasingApplicationManager)this.baseService).curOrgData(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<PurchasingApplication>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        PageList<PurchasingApplication> result = ((PurchasingApplicationManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="M-\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((PurchasingApplicationManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="M-\u6839\u636eID\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<PurchasingApplication> selectOne(@RequestParam(value="id") String id) {
        PurchasingApplication result = ((PurchasingApplicationManager)this.baseService).getDataById(id);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e")
    public CommonResult saveOrUpdate(@RequestBody PurchasingApplication entity) {
        String id = ((PurchasingApplicationManager)this.baseService).saveOrUpdateEntity(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)id);
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="M-\u6839\u636eID\u66f4\u65b0\u72b6\u6001")
    public CommonResult updateStatus(@RequestParam(value="ids") String ids, @RequestParam(value="status") String status) {
        ((PurchasingApplicationManager)this.baseService).updateStatus(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)ids);
    }

    @PostMapping(value={"/modifyStatusById"})
    @ApiOperation(value="M-\u6839\u636eID\u4fee\u6539\u72b6\u6001\uff08\u53ea\u4fee\u6539\u72b6\u6001\uff09")
    public CommonResult modifyStatusById(@RequestParam(value="ids") String ids, @RequestParam(value="status") String status) {
        ((PurchasingApplicationManager)this.baseService).modifyStatusById(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)ids);
    }
}

