/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.receipt.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.receipt.dao.BizReceiptDetailDao;
import com.artfess.cgpt.receipt.manager.BizReceiptDetailManager;
import com.artfess.cgpt.receipt.manager.BizReceiptHandleManager;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import com.artfess.cgpt.receipt.model.BizReceiptHandle;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizReceiptDetailManagerImpl
extends BaseManagerImpl<BizReceiptDetailDao, BizReceiptDetail>
implements BizReceiptDetailManager {
    @Resource
    private BizReceiptHandleManager bizReceiptHandleManager;
    @Resource
    private UCFeignService ucFeignService;
    @Resource
    private BaseContext baseContext;

    @Override
    public List<BizReceiptDetail> getByReceiptId(String receipitId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizReceiptDetail::getReceiptId, (Object)receipitId);
        List list = this.list((Wrapper)wrapper);
        return list;
    }

    @Override
    @Transactional
    public void removeByReceiptId(String receiptIds) {
        List<String> receiptIdList = Arrays.asList(receiptIds.split(","));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizReceiptDetail::getReceiptId, receiptIdList);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public PageList<BizReceiptDetail> queryAllPage(QueryFilter<BizReceiptDetail> queryFilter) {
        IPage<BizReceiptDetail> result = ((BizReceiptDetailDao)this.baseMapper).queryAllByPage((IPage<BizReceiptDetail>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizReceiptDetail>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void removeHandleLog(List<String> ids) {
        List details = this.listByIds(ids);
        for (BizReceiptDetail detail : details) {
            BizReceiptHandle handle = new BizReceiptHandle();
            handle.setNum(detail.getReceiptNum());
            handle.setOldNum(detail.getArrivalNum());
            handle.setReceiptDetailId(detail.getId());
            handle.setOperaterCompanyId(this.baseContext.getCurrentDeptId());
            handle.setOperaterCompanyName(this.baseContext.getCurrentDeptName());
            handle.setOperaterUserId(this.baseContext.getCurrentUserId());
            handle.setOperaterUserName(this.baseContext.getCurrentUserName());
            this.bizReceiptHandleManager.save((Object)handle);
            this.update((Model)detail);
        }
    }

    @Override
    public BizReceiptDetail getDetail(String id) {
        BizReceiptDetail detail = (BizReceiptDetail)((Object)this.getById((Serializable)((Object)id)));
        List<BizReceiptHandle> handles = this.bizReceiptHandleManager.getByDetailId(id);
        detail.setHandles(handles);
        return detail;
    }
}

