/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.dao.ClarifyQuestionsDao;
import com.artfess.cgpt.purchasing.manager.ClarifyAnswerManager;
import com.artfess.cgpt.purchasing.manager.ClarifyQuestionsManager;
import com.artfess.cgpt.purchasing.model.ClarifyQuestions;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClarifyQuestionsManagerImpl
extends BaseManagerImpl<ClarifyQuestionsDao, ClarifyQuestions>
implements ClarifyQuestionsManager {
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ClarifyAnswerManager answerManager;

    @Override
    public PageList<ClarifyQuestions> queryAllByPage(QueryFilter<ClarifyQuestions> queryFilter) {
        IPage<ClarifyQuestions> result = ((ClarifyQuestionsDao)this.baseMapper).queryAllByPage((IPage<ClarifyQuestions>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ClarifyQuestions>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (ClarifyQuestions temp : records) {
                temp.setAccessoryList(this.accessoryService.getAccessoryBySourceId(temp.getId()));
            }
        }
        return new PageList(result);
    }

    @Override
    public PageList<ClarifyQuestions> pageAndAnswer(QueryFilter<ClarifyQuestions> queryFilter) {
        IPage<ClarifyQuestions> result = ((ClarifyQuestionsDao)this.baseMapper).queryAllByPage((IPage<ClarifyQuestions>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<ClarifyQuestions>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (ClarifyQuestions temp : records) {
                temp.setAccessoryList(this.accessoryService.getAccessoryBySourceId(temp.getId()));
                temp.setAnswerList(this.answerManager.getByQuestionId(temp.getId()));
            }
        }
        return new PageList(result);
    }

    @Override
    public void saveOrUpdateEntity(ClarifyQuestions entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateId(ContextUtil.getCurrentUserId());
        entity.setOperateName(ContextUtil.getCurrentUserName());
        IGroup org = ContextUtil.getCurrentGroup();
        entity.setOperateOrgId(org.getGroupId());
        entity.setOperateOrgCode(org.getGroupCode());
        entity.setOperateOrgName(org.getName());
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
    }
}

