/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.receipt.manager.impl;

import cn.hutool.json.JSONUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.receipt.dao.BizReconciliationDao;
import com.artfess.cgpt.receipt.manager.BizReconciliationDetailManager;
import com.artfess.cgpt.receipt.manager.BizReconciliationManager;
import com.artfess.cgpt.receipt.model.BizReconciliation;
import com.artfess.cgpt.receipt.model.BizReconciliationDetail;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizReconciliationManagerImpl
extends BaseManagerImpl<BizReconciliationDao, BizReconciliation>
implements BizReconciliationManager {
    @Value(value="${zfpt.purIsdUrl}")
    private String purIsdUrl;
    @Autowired
    private BizReconciliationDetailManager recDetailManager;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private ForeignCallService foreignCallService;

    @Override
    public BizReconciliation getDetail(String id) {
        BizReconciliation result = (BizReconciliation)((Object)super.getById((Serializable)((Object)id)));
        List<BizReconciliationDetail> detailList = this.recDetailManager.getByPid(id);
        result.setIsdDetail(detailList);
        return result;
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        this.recDetailManager.removeByPid(String.join((CharSequence)",", ids));
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public String saveVo(BizReconciliation entity) {
        List<BizReconciliationDetail> detailList = entity.getIsdDetail();
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            entity.setIsdCreatedate(LocalDateTime.now());
            if (BeanUtils.isEmpty((Object)entity.getIsdCode())) {
                entity.setIsdCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "dzgl_dzdh"));
            }
        } else {
            this.recDetailManager.removeByPid(entity.getId());
            entity.setIsdLastchgdate(LocalDateTime.now());
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(detailList) && detailList.size() > 0) {
            detailList.forEach(s -> s.setRecId(entity.getId()));
            this.recDetailManager.saveBatch(detailList);
        }
        return entity.getId();
    }

    @Override
    @Transactional
    public void updateStatus(String ids, Integer status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper uw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(BizReconciliation::getStatus, (Object)status)).in(BizReconciliation::getId, idList)).set(BizReconciliation::getIsdCreatedate, (Object)LocalDateTime.now());
        if (status == 4 || status == 5) {
            IUser user = ContextUtil.getCurrentUser();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)uw.set(BizReconciliation::getVendorUserId, (Object)user.getUserId())).set(BizReconciliation::getVendorUserAccount, (Object)user.getAccount())).set(BizReconciliation::getVendorUserName, (Object)user.getFullname())).set(BizReconciliation::getVendorPhone, (Object)user.getMobile());
        }
        super.update((Wrapper)uw);
    }

    @Override
    @Transactional
    public void pushToZfpt(List<String> ids) {
        List recList = super.listByIds(ids);
        for (BizReconciliation rec : recList) {
            if (rec.getStatus() != 4) {
                throw new BaseException("\u5bf9\u8d26\u5355\u786e\u8ba4\u540e\u624d\u53ef\u63a8\u9001\uff1a\u5355\u53f7\u3010" + rec.getIsdCode() + "\u3011");
            }
            rec.setIsdDetail(this.recDetailManager.getByPid(rec.getId()));
            ForeignResponseVo recResult = this.foreignCallService.callInterface(this.purIsdUrl, JSONUtil.parseObj((Object)((Object)rec)), 2);
            if (BeanUtils.isEmpty((Object)recResult)) {
                throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u5bf9\u8d26\u5355\u5bfc\u5165\u5931\u8d25");
            }
            if (!recResult.getCode().equals("0")) {
                throw new BaseException("\u8c03\u7528[\u652f\u4ed8\u5e73\u53f0]\u5bf9\u8d26\u5355\u5bfc\u5165\u5931\u8d25:" + recResult.getMsg());
            }
            rec.setSyncStatus(1);
            super.updateById((Object)rec);
        }
    }
}

