/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.utils;

import com.artfess.base.util.FileUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.File;
import java.util.ArrayList;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.entity.params.ExcelExportEntity;
import org.jeecgframework.poi.excel.entity.params.ExcelForEachParams;
import org.jeecgframework.poi.excel.export.styler.IExcelExportStyler;

public class EasyPoiStyle
implements IExcelExportStyler {
    private static final short STRING_FORMAT = (short)BuiltinFormats.getBuiltinFormat((String)"TEXT");
    private static final short INTEGER_FORMAT = (short)BuiltinFormats.getBuiltinFormat((String)"0");
    private static final short FONT_SIZE_TEN = 10;
    private static final short FONT_SIZE_ELEVEN = 11;
    private static final short FONT_SIZE_TWELVE = 12;
    private CellStyle numberCellStyle;
    private CellStyle headerStyle;
    private CellStyle titleStyle;
    private CellStyle styles;

    public EasyPoiStyle(Workbook workbook) {
        this.init(workbook);
    }

    private void init(Workbook workbook) {
        this.headerStyle = this.initHeaderStyle(workbook);
        this.titleStyle = this.initTitleStyle(workbook);
        this.styles = this.initStyles(workbook);
        this.numberCellStyle = this.initNumberStyles(workbook);
    }

    public CellStyle getHeaderStyle(short color) {
        return this.headerStyle;
    }

    public CellStyle getTitleStyle(short color) {
        return this.titleStyle;
    }

    public CellStyle getStyles(boolean parity, ExcelExportEntity entity) {
        if (entity != null && 10 == entity.getType()) {
            return this.numberCellStyle;
        }
        return this.styles;
    }

    public CellStyle getStyles(Cell cell, int dataRow, ExcelExportEntity entity, Object obj, Object data) {
        return this.getStyles(true, entity);
    }

    public CellStyle getTemplateStyles(boolean isSingle, ExcelForEachParams excelForEachParams) {
        return null;
    }

    private CellStyle initHeaderStyle(Workbook workbook) {
        CellStyle style = this.getBaseCellStyle(workbook);
        style.setFont(this.getFont(workbook, (short)12, true));
        return style;
    }

    private CellStyle initTitleStyle(Workbook workbook) {
        CellStyle style = this.getBaseCellStyle(workbook);
        style.setFont(this.getFont(workbook, (short)12, true));
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    private CellStyle initStyles(Workbook workbook) {
        CellStyle style = this.getBaseCellStyle(workbook);
        style.setFont(this.getFont(workbook, (short)10, false));
        style.setDataFormat(STRING_FORMAT);
        return style;
    }

    private CellStyle initNumberStyles(Workbook workbook) {
        CellStyle style = this.getBaseCellStyle(workbook);
        style.setDataFormat(INTEGER_FORMAT);
        return style;
    }

    private CellStyle getBaseCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        return style;
    }

    private Font getFont(Workbook workbook, short size, boolean isBold) {
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setBold(isBold);
        font.setFontHeightInPoints(size);
        return font;
    }

    public static void setExcelStyleSmall(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)8);
        cellStyle.setFont(font);
    }

    public static void setExcelStylePhotos(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
    }

    public static void setExcelStylePhotosOnLine(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleOne(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleTwo(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleRight(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleLeft(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleLeftAlign(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleTitle(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)18);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleTitleOne(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)18);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleTitleNoLine(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)18);
        cellStyle.setFont(font);
    }

    public static void cellStyleTitleNoLineSmall(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
    }

    public static void setExcelStyle(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setExcelStyleNoLine(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setWorkOrderStyleTitle(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)18);
        cellStyle.setFont(font);
    }

    public static void setWorkOrderCellStyle1(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setWorkOrderCellStyle2(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setVerticalAlignment(VerticalAlignment.DISTRIBUTED);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setWorkOrderCellStyle3(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void setWorkOrderCellStyle4(HSSFCellStyle cellStyle, HSSFWorkbook workbook) {
        cellStyle.setVerticalAlignment(VerticalAlignment.DISTRIBUTED);
        cellStyle.setWrapText(true);
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
    }

    public static void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            File file = new File(path);
            Assert.isTrue((boolean)file.exists(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            ArrayList list = new ArrayList();
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("GBK");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir((File)file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void sheetStyleAndValue(HSSFSheet sheet, HSSFCellStyle cellStyle, Integer rowIndex, Integer cellIndex, String value) {
        HSSFCell cell;
        HSSFRow row = sheet.getRow(rowIndex.intValue());
        if (row == null) {
            row = sheet.createRow(rowIndex.intValue());
        }
        if ((cell = row.getCell(cellIndex.intValue())) == null) {
            cell = row.createCell(cellIndex.intValue());
        }
        cell.setCellStyle(cellStyle);
        cell.setCellValue(value);
    }

    public static synchronized void sheetSetHight(HSSFSheet sheet, Integer rowIndex, Integer height) {
        HSSFRow row = sheet.getRow(rowIndex.intValue());
        row.setHeight((short)(height * 20));
    }
}

