/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.BizExpertDatabaseOrg2Manager;
import com.artfess.cgpt.purchasing.manager.BizPurchasingApplicationDetailsManager;
import com.artfess.cgpt.purchasing.manager.BizPurchasingApplicationManager;
import com.artfess.cgpt.purchasing.manager.BizPurchasingProjectDetailsManager;
import com.artfess.cgpt.purchasing.model.BizExpertDatabaseOrg2;
import com.artfess.cgpt.purchasing.model.BizPurchasingApplication;
import com.artfess.cgpt.purchasing.model.BizPurchasingApplicationDetails;
import com.artfess.cgpt.purchasing.model.BizPurchasingProjectDetails;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizPurchasingApplication/v1/"})
@Api(tags={"\u91c7\u8d2d\u7533\u8bf7"})
@ApiGroup(group={"group_biz"})
public class BizPurchasingApplicationController
extends BaseController<BizPurchasingApplicationManager, BizPurchasingApplication> {
    @Autowired
    private BizPurchasingProjectDetailsManager bizPurchasingProjectDetailsManager;
    @Autowired
    private BizExpertDatabaseOrg2Manager BizExpertDatabaseOrg2Manager;
    @Autowired
    private BizPurchasingApplicationDetailsManager bizPurchasingApplicationDetailsManager;
    @Autowired
    private OrgManager orgManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizPurchasingApplication>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizPurchasingApplication> queryFilter) {
        PageList<BizPurchasingApplication> result = ((BizPurchasingApplicationManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((BizPurchasingApplicationManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="S-\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<BizPurchasingApplication> selectOne(@RequestParam String id) {
        BizPurchasingApplication result = (BizPurchasingApplication)((Object)((BizPurchasingApplicationManager)this.baseService).getById((Serializable)((Object)id)));
        QueryWrapper wrapper1 = new QueryWrapper();
        List list1 = this.bizPurchasingProjectDetailsManager.list((Wrapper)wrapper1.eq((Object)"PURCHASING_APPLICATION_ID_", (Object)id));
        QueryWrapper wrapper2 = new QueryWrapper();
        List list2 = this.bizPurchasingApplicationDetailsManager.list((Wrapper)wrapper2.eq((Object)"PURCHASING_APPLICATION_ID_", (Object)id));
        QueryWrapper wrapper3 = new QueryWrapper();
        List list = this.BizExpertDatabaseOrg2Manager.list((Wrapper)wrapper3.eq((Object)"PURCHASING_APPLICATION_ID_", (Object)id));
        ArrayList<String> orgIds = new ArrayList<String>();
        for (BizExpertDatabaseOrg2 bizExpertDatabaseOrg2 : list) {
            orgIds.add(bizExpertDatabaseOrg2.getOrgId());
        }
        QueryWrapper wrapper4 = new QueryWrapper();
        List<Object> orgs = new ArrayList<Org>();
        if (orgIds != null && orgIds.size() > 0) {
            orgs = this.orgManager.list((Wrapper)wrapper4.in((Object)"id_", orgIds));
        }
        result.setDetailsList(list1);
        result.setProjectInfoList(list2);
        result.setOrgList(orgs);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="S-\u65b0\u589e\u6216\u4fee\u6539")
    public CommonResult<BizPurchasingApplication> saveOrUpdate(@RequestBody BizPurchasingApplication entity) {
        List<BizPurchasingProjectDetails> detailsList = entity.getDetailsList();
        List<Org> orgList = entity.getOrgList();
        List<BizPurchasingApplicationDetails> projectInfoList = entity.getProjectInfoList();
        ((BizPurchasingApplicationManager)this.baseService).saveOrUpdate((Object)entity);
        UpdateWrapper wrapper1 = new UpdateWrapper();
        UpdateWrapper wrapper2 = new UpdateWrapper();
        UpdateWrapper wrapper3 = new UpdateWrapper();
        this.bizPurchasingProjectDetailsManager.remove((Wrapper)wrapper1.eq((Object)"PURCHASING_APPLICATION_ID_", (Object)entity.getId()));
        this.BizExpertDatabaseOrg2Manager.remove((Wrapper)wrapper2.eq((Object)"PURCHASING_APPLICATION_ID_", (Object)entity.getId()));
        this.bizPurchasingApplicationDetailsManager.remove((Wrapper)wrapper3.eq((Object)"PURCHASING_APPLICATION_ID_", (Object)entity.getId()));
        if (detailsList != null && detailsList.size() > 0) {
            for (BizPurchasingProjectDetails entity1 : detailsList) {
                entity1.setPurchasingApplicationId(entity.getId());
            }
            this.bizPurchasingProjectDetailsManager.saveBatch(detailsList);
        }
        if (orgList != null && orgList.size() > 0) {
            for (Org entity2 : orgList) {
                BizExpertDatabaseOrg2 bizExpertDatabaseOrg2 = new BizExpertDatabaseOrg2();
                bizExpertDatabaseOrg2.setPurchasingApplicationId(entity.getId());
                bizExpertDatabaseOrg2.setOrgId(entity2.getId());
                this.BizExpertDatabaseOrg2Manager.save((Object)bizExpertDatabaseOrg2);
            }
        }
        if (projectInfoList != null && projectInfoList.size() > 0) {
            for (BizPurchasingApplicationDetails entity3 : projectInfoList) {
                entity3.setPurchasingApplicationId(entity.getId());
            }
        }
        this.bizPurchasingApplicationDetailsManager.saveBatch(projectInfoList);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }
}

