/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.project.controller;

import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.BizExpertDatabaseOrg3Manager;
import com.artfess.cgpt.project.manager.BizProjectApprovalManager;
import com.artfess.cgpt.project.manager.ProjectApprovalMatDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalProDetailsManager;
import com.artfess.cgpt.project.model.BizExpertDatabaseOrg3;
import com.artfess.cgpt.project.model.BizProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalMatDetails;
import com.artfess.cgpt.project.model.ProjectApprovalProDetails;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizProjectApproval/v1/"})
@Api(tags={"\u7269\u6599/\u9879\u76ee\u91c7\u8d2d\u7acb\u9879"})
@ApiGroup(group={"group_biz"})
public class BizProjectApprovalController
extends BaseController<BizProjectApprovalManager, BizProjectApproval> {
    @Autowired
    private BizExpertDatabaseOrg3Manager bizExpertDatabaseOrg3Manager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private SystemConfigFeignService service;
    @Autowired
    private ProjectApprovalMatDetailsManager projectApprovalMatDetailsManager;
    @Autowired
    private ProjectApprovalProDetailsManager projectApprovalProDetailsManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizProjectApproval>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizProjectApproval> queryFilter) {
        PageList<BizProjectApproval> result = ((BizProjectApprovalManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((BizProjectApprovalManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="S-\u6dfb\u52a0\u6216\u4fee\u6539")
    public CommonResult saveOrUpdate(@RequestBody BizProjectApproval entity) {
        UpdateWrapper wrapper1;
        String nextIdByAlias = this.service.getNextIdByAlias("cgpt_zjkgl");
        JSONObject jsonObject = new JSONObject((Object)nextIdByAlias);
        Object value = jsonObject.get((Object)"value");
        String s = value.toString();
        entity.setProjectNumber(s);
        ((BizProjectApprovalManager)this.baseService).saveOrUpdate((Object)entity);
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"PROJECT_APPROVAL_ID_", (Object)entity.getId());
        this.bizExpertDatabaseOrg3Manager.remove((Wrapper)wrapper);
        List<Org> orgList = entity.getOrgList();
        if (orgList != null && orgList.size() > 0) {
            for (Org org : orgList) {
                BizExpertDatabaseOrg3 org3 = new BizExpertDatabaseOrg3();
                org3.setOrgId(org.getId());
                org3.setProjectApprovalId(entity.getId());
                this.bizExpertDatabaseOrg3Manager.save((Object)org3);
            }
        }
        if (entity.getNoticeType().equals("1")) {
            wrapper1 = new UpdateWrapper();
            wrapper1.eq((Object)"NOTICE_ID_", (Object)entity.getId());
            this.projectApprovalMatDetailsManager.remove((Wrapper)wrapper1);
            List<ProjectApprovalMatDetails> matDetailsList = entity.getMatDetailsList();
            for (ProjectApprovalMatDetails model : matDetailsList) {
                model.setNoticeId(entity.getId());
            }
            this.projectApprovalMatDetailsManager.saveBatch(matDetailsList);
        } else if (entity.getNoticeType().equals("2")) {
            wrapper1 = new UpdateWrapper();
            wrapper1.eq((Object)"NOTICE_ID_", (Object)entity.getId());
            this.projectApprovalProDetailsManager.remove((Wrapper)wrapper1);
            List<ProjectApprovalProDetails> proDetailsList = entity.getProDetailsList();
            for (ProjectApprovalProDetails model : proDetailsList) {
                model.setNoticeId(entity.getId());
            }
            this.projectApprovalProDetailsManager.saveBatch(proDetailsList);
        }
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="S-\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<BizProjectApproval> selectOne(@RequestParam String id) {
        QueryWrapper wrapper1;
        BizProjectApproval result = (BizProjectApproval)((Object)((BizProjectApprovalManager)this.baseService).getById((Serializable)((Object)id)));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"PROJECT_APPROVAL_ID_", (Object)id);
        List list = this.bizExpertDatabaseOrg3Manager.list((Wrapper)wrapper);
        ArrayList<String> list1 = new ArrayList<String>();
        for (BizExpertDatabaseOrg3 org3 : list) {
            list1.add(org3.getOrgId());
        }
        List<Object> list2 = new ArrayList<Org>();
        if (list1 != null && list1.size() > 0) {
            QueryWrapper wrapper2 = new QueryWrapper();
            wrapper2.in((Object)"id_", list1);
            list2 = this.orgManager.list((Wrapper)wrapper2);
        }
        result.setOrgList(list2);
        if (result.getNoticeType().equals("1")) {
            wrapper1 = new QueryWrapper();
            wrapper1.eq((Object)"NOTICE_ID_", (Object)result.getId());
            List list3 = this.projectApprovalMatDetailsManager.list((Wrapper)wrapper1);
            result.setMatDetailsList(list3);
        } else if (result.getNoticeType().equals("2")) {
            wrapper1 = new QueryWrapper();
            wrapper1.eq((Object)"NOTICE_ID_", (Object)result.getId());
            List list3 = this.projectApprovalProDetailsManager.list((Wrapper)wrapper1);
            result.setProDetailsList(list3);
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="S-\u4fee\u6539\u53d1\u5e03\u72b6\u6001")
    public CommonResult<BizProjectApproval> updateStatus(@RequestParam String id, @RequestParam String status) {
        UpdateWrapper wrapper = new UpdateWrapper();
        ((UpdateWrapper)wrapper.eq((Object)"id_", (Object)id)).set((Object)"status_", (Object)status);
        ((BizProjectApprovalManager)this.baseService).update((Wrapper)wrapper);
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f");
    }
}

