/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.dao.BizMaterialCategoryDao;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.stereotype.Service;

@Service
public class BizMaterialCategoryManagerImpl
extends BaseManagerImpl<BizMaterialCategoryDao, BizMaterialCategory>
implements BizMaterialCategoryManager {
    @Override
    public List<BizMaterialCategory> selectTree() {
        List<BizMaterialCategory> categories = ((BizMaterialCategoryDao)this.baseMapper).queryAll1();
        List<BizMaterialCategory> collect = categories.stream().filter(BizMaterialCategory2 -> BizMaterialCategory2.getParentId().equals("1")).collect(Collectors.toList());
        for (BizMaterialCategory c : collect) {
            c.setChildren(this.getchildren(c, categories));
        }
        return collect;
    }

    @Override
    public void exportExcelData(QueryFilter<BizMaterialCategory> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u7269\u6599\u5206\u7c7b-\u5bfc\u51fa\u6570\u636e";
        queryFilter.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
        List data = this.list();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, BizMaterialCategory.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    private List<BizMaterialCategory> getchildren(BizMaterialCategory root, List<BizMaterialCategory> list) {
        List<BizMaterialCategory> children = list.stream().filter(category -> category.getParentId().equals(root.getId())).collect(Collectors.toList());
        if (children != null && children.size() > 0) {
            for (BizMaterialCategory c : children) {
                c.setChildren(this.getchildren(c, list));
            }
        }
        return children;
    }
}

