/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizMaterial/v1/"})
@Api(tags={"\u7269\u6599\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class BizMaterialController
extends BaseController<BizMaterialManager, BizMaterial> {
    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizMaterial>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterial> queryFilter) {
        PageList<BizMaterial> result = ((BizMaterialManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="S-\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<BizMaterial> selectOne(@RequestParam String id) {
        BizMaterial result = (BizMaterial)((Object)((BizMaterialManager)this.baseService).getById((Serializable)((Object)id)));
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u6dfb\u52a0\u6216\u4fee\u6539\u7269\u6599")
    public CommonResult save(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody BizMaterial material) {
        String message = "\u64cd\u4f5c\u6210\u529f";
        material.setCreateOrgId(ContextUtil.getCurrentOrgId());
        if (material.getId() != null && material.getId() != "") {
            ((BizMaterialManager)this.baseService).update((Model)material);
        } else {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"mat_material_", (Object)material.getMatMaterial());
            wrapper.eq((Object)"mat_spec_", (Object)material.getMatSpec());
            int count = ((BizMaterialManager)this.baseService).count((Wrapper)wrapper);
            if (count > 0) {
                message = "\u5df2\u5b58\u5728\u76f8\u540c\u89c4\u683c\u7684\u7269\u6599\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
            } else {
                ((BizMaterialManager)this.baseService).save((Object)material);
            }
        }
        return new CommonResult(true, message);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664\u7269\u6599")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((BizMaterialManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/exportExcelData"})
    @ApiOperation(value="M-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981")
    public CommonResult exportExcelData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterial> queryFilter, HttpServletResponse response) throws Exception {
        ((BizMaterialManager)this.baseService).exportExcelData(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }
}

