/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.evaluation.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemUseOrgManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemUseOrg;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizEvaluationSystem/v1/"})
@Api(tags={"\u8bc4\u6807\u4f53\u7cfb\u8868"})
@ApiGroup(group={"group_biz"})
public class BizEvaluationSystemController
extends BaseController<BizEvaluationSystemManager, BizEvaluationSystem> {
    @Autowired
    private BizEvaluationSystemDescriptionManager bizEvaluationSystemDescriptionManager;
    @Autowired
    private BizEvaluationSystemUseOrgManager bizEvaluationSystemUseOrgManager;
    @Autowired
    private OrgManager orgManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizEvaluationSystem>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizEvaluationSystem> queryFilter) {
        PageList<BizEvaluationSystem> result = ((BizEvaluationSystemManager)this.baseService).queryAllByPage(queryFilter);
        List rows = result.getRows();
        for (BizEvaluationSystem system : rows) {
            List<Org> orgs = this.queryOrg(system.getId());
            system.setOrgs(orgs);
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="M-\u6dfb\u52a0\u6216\u4fee\u6539\u8bc4\u6807\u4f53\u7cfb")
    public CommonResult<List<BizEvaluationSystem>> saveSupplierOrg(@RequestBody BizEvaluationSystem entity) {
        String message = "\u64cd\u4f5c\u6210\u529f";
        entity.setIsDele("0");
        if (entity.getEvaluatingMethods().equals("2")) {
            ((BizEvaluationSystemManager)this.baseService).saveOrUpdate((Object)entity);
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.eq((Object)"EVALUATION_SYSTEM_ID_", (Object)entity.getId());
            this.bizEvaluationSystemUseOrgManager.remove((Wrapper)wrapper);
            List<BizEvaluationSystemUseOrg> useOrgList = entity.getUseOrgList();
            for (BizEvaluationSystemUseOrg org : useOrgList) {
                org.setEvaluationSystemId(entity.getId());
            }
            this.bizEvaluationSystemUseOrgManager.saveBatch(useOrgList);
        } else {
            ((BizEvaluationSystemManager)this.baseService).saveOrUpdate((Object)entity);
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.eq((Object)"EVALUATION_SYSTEM_ID_", (Object)entity.getId());
            this.bizEvaluationSystemDescriptionManager.remove((Wrapper)wrapper);
            List<BizEvaluationSystemDescription> descriptionList = entity.getDescriptionList();
            for (BizEvaluationSystemDescription description : descriptionList) {
                description.setEvaluationSystemId(entity.getId());
            }
            this.bizEvaluationSystemDescriptionManager.saveBatch(descriptionList);
            UpdateWrapper wrapper1 = new UpdateWrapper();
            wrapper1.eq((Object)"EVALUATION_SYSTEM_ID_", (Object)entity.getId());
            this.bizEvaluationSystemUseOrgManager.remove((Wrapper)wrapper1);
            List<BizEvaluationSystemUseOrg> useOrgList = entity.getUseOrgList();
            for (BizEvaluationSystemUseOrg org : useOrgList) {
                org.setEvaluationSystemId(entity.getId());
            }
            this.bizEvaluationSystemUseOrgManager.saveBatch(useOrgList);
        }
        return new CommonResult(true, message);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((BizEvaluationSystemManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="S-\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<BizEvaluationSystem> selectOne(@RequestParam String id) {
        BizEvaluationSystem result = (BizEvaluationSystem)((Object)((BizEvaluationSystemManager)this.baseService).getById((Serializable)((Object)id)));
        List<Org> orgs = this.queryOrg(id);
        List<BizEvaluationSystemDescription> list = this.bizEvaluationSystemDescriptionManager.select(id);
        result.setDescriptionList(list);
        result.setOrgs(orgs);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    private List<Org> queryOrg(String id) {
        QueryWrapper wrapper1 = new QueryWrapper();
        wrapper1.eq((Object)"EVALUATION_SYSTEM_ID_", (Object)id);
        List list1 = this.bizEvaluationSystemUseOrgManager.list((Wrapper)wrapper1);
        ArrayList<String> list2 = new ArrayList<String>();
        for (BizEvaluationSystemUseOrg entity : list1) {
            list2.add(entity.getOrgId());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id_", list2);
        List list3 = this.orgManager.list((Wrapper)wrapper);
        return list3;
    }
}

